/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowSystem.onePhaseFlowSystem.pipeFlowSystem;

import neqsim.fluidMechanics.flowLeg.pipeLeg.PipeLeg;
import neqsim.fluidMechanics.flowNode.onePhaseNode.onePhasePipeFlowNode.onePhasePipeFlowNode;
import neqsim.fluidMechanics.flowSolver.onePhaseFlowSolver.onePhasePipeFlowSolver.OnePhaseFixedStaggeredGrid;
import neqsim.fluidMechanics.flowSystem.onePhaseFlowSystem.OnePhaseFlowSystem;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.onePhaseFlowVisualization.pipeFlowVisualization.PipeFlowVisualization;
import neqsim.thermo.system.SystemInterface;

public class PipeFlowSystem
extends OnePhaseFlowSystem {
    private static final long serialVersionUID = 1000L;

    @Override
    public void createSystem() {
        this.thermoSystem.init(0);
        this.thermoSystem.init(1);
        this.flowLeg = new PipeLeg[this.getNumberOfLegs()];
        for (int i = 0; i < this.getNumberOfLegs(); ++i) {
            this.flowLeg[i] = new PipeLeg();
        }
        this.flowNode = new onePhasePipeFlowNode[this.totalNumberOfNodes];
        this.flowNode[0] = new onePhasePipeFlowNode(this.thermoSystem, this.equipmentGeometry[0]);
        this.flowNode[0].initFlowCalc();
        super.createSystem();
        this.setNodes();
    }

    @Override
    public void init() {
        for (int j = 0; j < this.getTotalNumberOfNodes(); ++j) {
            this.flowNode[j].initFlowCalc();
            this.flowNode[j].setVelocityIn(this.flowNode[j].getVelocity());
        }
        for (int k = 0; k < this.getTotalNumberOfNodes() - 1; ++k) {
            this.flowNode[k].setVelocityOut(this.flowNode[k + 1].getVelocityIn());
        }
    }

    @Override
    public void solveSteadyState(int solverType) {
        double[] times = new double[]{0.0};
        this.display = new PipeFlowVisualization(this.getTotalNumberOfNodes(), 1);
        this.getTimeSeries().setTimes(times);
        SystemInterface[] systems = new SystemInterface[]{this.flowNode[0].getBulkSystem()};
        this.getTimeSeries().setInletThermoSystems(systems);
        this.getTimeSeries().setNumberOfTimeStepsInInterval(1);
        double[] outletFlowRates = new double[]{0.0, 0.0};
        this.getTimeSeries().setOutletMolarFlowRate(outletFlowRates);
        this.flowSolver = new OnePhaseFixedStaggeredGrid(this, this.getSystemLength(), this.getTotalNumberOfNodes(), false);
        this.flowSolver.setSolverType(solverType);
        this.flowSolver.solveTDMA();
        this.getTimeSeries().init(this);
        this.display.setNextData(this);
    }

    @Override
    public void solveTransient(int solverType) {
        this.getTimeSeries().init(this);
        this.display = new PipeFlowVisualization(this.getTotalNumberOfNodes(), this.getTimeSeries().getTime().length);
        this.flowSolver.setDynamic(true);
        this.flowSolver.setSolverType(solverType);
        for (int i = 0; i < this.getTimeSeries().getTime().length; ++i) {
            this.getNode(0).setBulkSystem(this.getTimeSeries().getThermoSystem()[i]);
            this.getNode(0).initFlowCalc();
            this.getNode(0).setVelocityIn(this.getNode(0).getVelocity());
            this.flowNode[0].setVelocityOut(this.flowNode[0].getVelocity());
            System.out.println("vel: " + this.flowNode[0].getVelocity());
            this.getSolver().setTimeStep(this.getTimeSeries().getTimeStep()[i]);
            this.display.setNextData(this, this.getTimeSeries().getTime(i));
        }
    }
}

