/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowSolver.twoPhaseFlowSolver.twoPhasePipeFlowSolver;

import Jama.Matrix;
import neqsim.MathLib.generalMath.TDMAsolve;
import neqsim.fluidMechanics.flowSolver.twoPhaseFlowSolver.twoPhasePipeFlowSolver.TwoPhasePipeFlowSolver;
import neqsim.fluidMechanics.flowSystem.FlowSystemInterface;
import neqsim.thermo.ThermodynamicConstantsInterface;

public class TwoPhaseFixedStaggeredGridSolver
extends TwoPhasePipeFlowSolver
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    Matrix diffMatrix;
    double[][] dn;
    int iter = 0;
    Matrix[] diff4Matrix;
    double[][][] xNew;
    protected double[][] oldMass;
    protected double[][] oldComp;
    protected double[][] oldDensity;
    protected double[][] oldVelocity;
    protected double[][][] oldComposition;
    protected double[][] oldInternalEnergy;
    protected double[][] oldImpuls;
    protected double[][] oldEnergy;

    public TwoPhaseFixedStaggeredGridSolver() {
    }

    public TwoPhaseFixedStaggeredGridSolver(FlowSystemInterface pipe, double length, int nodes) {
        super(pipe, length, nodes);
    }

    public TwoPhaseFixedStaggeredGridSolver(FlowSystemInterface pipe, double length, int nodes, boolean dynamic) {
        super(pipe, length, nodes);
        this.dynamic = dynamic;
        this.oldMass = new double[2][nodes];
        this.oldComp = new double[2][nodes];
        this.oldImpuls = new double[2][nodes];
        this.diff4Matrix = new Matrix[pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.oldEnergy = new double[2][nodes];
        this.oldVelocity = new double[2][nodes];
        this.oldDensity = new double[2][nodes];
        this.oldInternalEnergy = new double[2][nodes];
        this.oldComposition = new double[2][pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()][nodes];
        this.numberOfVelocityNodes = nodes;
    }

    @Override
    public TwoPhaseFixedStaggeredGridSolver clone() {
        TwoPhaseFixedStaggeredGridSolver clonedSystem = null;
        try {
            clonedSystem = (TwoPhaseFixedStaggeredGridSolver)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clonedSystem;
    }

    public void initProfiles() {
        double[][][] molDiff = new double[this.numberOfNodes][2][this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.pipe.getNode(0).getBulkSystem().initBeta();
        this.pipe.getNode(0).getBulkSystem().init_x_y();
        this.pipe.getNode(0).initFlowCalc();
        this.pipe.getNode(0).calcFluxes();
        for (int i = 1; i < this.numberOfNodes - 1; ++i) {
            this.pipe.getNode(i).getBulkSystem().initBeta();
            this.pipe.getNode(i).getBulkSystem().init_x_y();
            this.pipe.getNode(i).initFlowCalc();
            this.pipe.getNode(i).calcFluxes();
            double liquidHeatRate = this.pipe.getNode(i).getFluidBoundary().getInterphaseHeatFlux(1) * this.pipe.getNode(i).getInterphaseContactArea() * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(1));
            double gasHeatRate = -this.pipe.getNode(i).getFluidBoundary().getInterphaseHeatFlux(0) * this.pipe.getNode(i).getInterphaseContactArea() * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(0));
            double liquid_dT = liquidHeatRate / this.pipe.getNode(i).getBulkSystem().getPhase(1).getCp();
            double gas_dT = gasHeatRate / this.pipe.getNode(i).getBulkSystem().getPhase(0).getCp();
            this.pipe.getNode(i + 1).getBulkSystem().getPhase(0).setTemperature(this.pipe.getNode(i).getBulkSystem().getPhase(0).getTemperature() + gas_dT);
            this.pipe.getNode(i + 1).getBulkSystem().getPhase(1).setTemperature(this.pipe.getNode(i).getBulkSystem().getPhase(1).getTemperature() + liquid_dT);
            for (int componentNumber = 0; componentNumber < this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents(); ++componentNumber) {
                double liquidMolarRate = this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.pipe.getNode(i).getInterphaseContactArea() * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(1));
                double gasMolarRate = -this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.pipe.getNode(i).getInterphaseContactArea() * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(0));
                molDiff[i][0][componentNumber] = molDiff[i - 1][0][componentNumber] + gasMolarRate;
                molDiff[i][1][componentNumber] = molDiff[i - 1][1][componentNumber] + liquidMolarRate;
                this.pipe.getNode(i + 1).getBulkSystem().getPhases()[0].addMoles(componentNumber, molDiff[i - 1][0][componentNumber]);
                this.pipe.getNode(i + 1).getBulkSystem().getPhases()[1].addMoles(componentNumber, molDiff[i - 1][1][componentNumber]);
            }
        }
        this.pipe.getNode(this.numberOfNodes - 1).init();
        this.pipe.getNode(this.numberOfNodes - 1).calcFluxes();
        this.pipe.getNode(this.numberOfNodes - 1).getBulkSystem().initBeta();
        this.pipe.getNode(this.numberOfNodes - 1).getBulkSystem().init_x_y();
        this.initNodes();
        System.out.println("finisched initializing....");
    }

    public void initMatrix() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
            double enthalpy0 = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass();
            double enthalpy1 = this.pipe.getNode(i).getBulkSystem().getPhases()[1].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[1].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[1].getMolarMass();
            this.solMatrix[0].set(i, 0, this.pipe.getNode(i).getVelocityIn(0).doubleValue());
            this.solMatrix[1].set(i, 0, this.pipe.getNode(i).getVelocityIn(1).doubleValue());
            this.sol3Matrix[0].set(i, 0, enthalpy0);
            this.sol3Matrix[1].set(i, 0, enthalpy1);
            this.solPhaseConsMatrix[0].set(i, 0, this.pipe.getNode(i).getBulkSystem().getPhases()[0].getPhysicalProperties().getDensity());
            this.solPhaseConsMatrix[1].set(i, 0, this.pipe.getNode(i).getPhaseFraction(1));
            for (int phase = 0; phase < 2; ++phase) {
                for (int j = 0; j < this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfComponents(); ++j) {
                    this.solMolFracMatrix[phase][j].set(i, 0, this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getComponents()[j].getx() * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getComponents()[j].getMolarMass() / this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getMolarMass());
                }
            }
        }
    }

    public void initPressure(int phase) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
            this.pipe.getNode(i).getBulkSystem().setPressure(0.8 * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getdPdrho() * this.diffMatrix.get(i, 0) * 1.0E-5 + this.pipe.getNode(i).getBulkSystem().getPressure());
            this.pipe.getNode(i).init();
        }
    }

    public void initVelocity(int phase) {
        int i;
        for (i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).setVelocityIn(phase, this.pipe.getNode(i).getVelocityIn(phase).doubleValue() + 0.8 * (this.solMatrix[phase].get(i, 0) - this.pipe.getNode(i).getVelocityIn(phase).doubleValue()));
        }
        for (i = 0; i < this.numberOfNodes; ++i) {
            double meanVelocity = this.pipe.getNode(i).getVelocityIn(phase).doubleValue();
            this.pipe.getNode(i).setVelocity(phase, meanVelocity);
            this.pipe.getNode(i).init();
        }
    }

    public void initTemperature(int phase) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
            this.pipe.getNode(i).getBulkSystem().setTemperature(this.pipe.getNode(i).getBulkSystem().getTemperature(phase) + 0.8 * this.diffMatrix.get(i, 0) / (this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getCp() / this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getMolarMass()), phase);
            this.pipe.getNode(i).init();
        }
    }

    public void initPhaseFraction(int phase) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).setPhaseFraction(phase, this.pipe.getNode(i).getPhaseFraction(phase) + 0.8 * this.diffMatrix.get(i, 0));
            this.pipe.getNode(i).setPhaseFraction(0, 1.0 - this.pipe.getNode(i).getPhaseFraction(phase));
            this.pipe.getNode(i).init();
        }
    }

    public void initComposition(int phase, int comp) {
        for (int j = 0; j < this.numberOfNodes; ++j) {
            if (this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getx() + this.diffMatrix.get(j, 0) * this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getMolarMass() / this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getMolarMass() > 1.0) {
                this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].setx(1.0);
            } else if (this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getx() + this.diffMatrix.get(j, 0) * this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getMolarMass() / this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getMolarMass() < 0.0) {
                this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].setx(1.0E-30);
            } else {
                this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].setx(this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getx() + this.diffMatrix.get(j, 0) * this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getMolarMass() / this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[comp].getMolarMass());
            }
            double xSum = 0.0;
            for (int i = 0; i < this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1; ++i) {
                xSum += this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[i].getx();
            }
            this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getComponents()[this.pipe.getNode(j).getBulkSystem().getPhases()[phase].getNumberOfComponents() - 1].setx(1.0 - xSum);
            this.pipe.getNode(j).init();
        }
    }

    public void setMassConservationMatrix(int phase) {
        int i;
        if (!this.dynamic) {
            double SU = 0.0;
            this.a[0] = 0.0;
            this.b[0] = 1.0;
            this.c[0] = 0.0;
            this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity();
        } else {
            this.oldMass[phase][0] = 1.0 / this.timeStep * this.pipe.getNode(0).getGeometry().getArea() * this.pipe.getNode(0).getGeometry().getNodeLength();
            this.a[0] = 0.0;
            this.c[0] = 1.0;
            this.b[0] = 1.0;
            this.r[0] = 0.0;
            this.a[0] = -this.a[0];
            this.c[0] = -this.c[0];
        }
        for (i = 1; i < this.numberOfNodes - 1; ++i) {
            double Ae = this.pipe.getNode(i).getArea(phase);
            double Aw = this.pipe.getNode(i - 1).getArea(phase);
            double Fe = this.pipe.getNode(i).getVelocityOut(phase).doubleValue() * Ae;
            double Fw = this.pipe.getNode(i).getVelocityIn(phase).doubleValue() * Aw;
            this.oldMass[phase][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getArea(phase) * this.pipe.getNode(i).getGeometry().getNodeLength() : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldMass[phase][i];
            this.r[i] = this.oldMass[phase][i] * this.oldDensity[phase][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        i = this.numberOfNodes - 1;
        this.oldMass[phase][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getArea(phase) * this.pipe.getNode(i).getGeometry().getNodeLength() : 0.0;
        this.a[i] = 1.0;
        this.c[i] = 0.0;
        this.b[i] = 1.0;
        this.r[i] = 0.0;
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void setPhaseFractionMatrix(int phase) {
        double Fw;
        double Fe;
        double Aw;
        double Ae;
        int i;
        if (!this.dynamic) {
            double SU = 0.0;
            this.a[0] = 0.0;
            this.b[0] = 1.0;
            this.c[0] = 0.0;
            this.r[0] = SU = this.pipe.getNode(0).getPhaseFraction(phase);
        } else {
            this.oldMass[phase][0] = 1.0 / this.timeStep * this.pipe.getNode(0).getGeometry().getArea() * this.pipe.getNode(0).getGeometry().getNodeLength();
            this.a[0] = 0.0;
            this.c[0] = 1.0;
            this.b[0] = 1.0;
            this.r[0] = 0.0;
            this.a[0] = -this.a[0];
            this.c[0] = -this.c[0];
        }
        for (i = 1; i < this.numberOfNodes - 1; ++i) {
            Ae = this.pipe.getNode(i).getGeometry().getArea();
            Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
            Fe = this.pipe.getNode(i).getVelocityOut(phase).doubleValue() * Ae * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity();
            Fw = this.pipe.getNode(i).getVelocityIn(phase).doubleValue() * Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity();
            this.oldMass[phase][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getGeometry().getArea() * this.pipe.getNode(i).getGeometry().getNodeLength() : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldMass[phase][i];
            this.r[i] = this.oldMass[phase][i] * this.oldDensity[phase][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        i = this.numberOfNodes - 1;
        Ae = this.pipe.getNode(i).getGeometry().getArea();
        Aw = this.pipe.getNode(i - 1).getGeometry().getArea();
        Fe = this.pipe.getNode(i).getVelocity(phase) * Ae * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity();
        Fw = this.pipe.getNode(i).getVelocityIn(phase).doubleValue() * Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity();
        this.oldMass[phase][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getGeometry().getArea() * this.pipe.getNode(i).getGeometry().getNodeLength() : 0.0;
        this.a[i] = Math.max(Fw, 0.0);
        this.c[i] = Math.max(-Fe, 0.0);
        this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldMass[phase][i];
        this.r[i] = this.oldMass[phase][i] * this.oldDensity[phase][i];
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void setImpulsMatrixTDMA(int phase) {
        double interfaceFricition;
        double nodeLength;
        double vertposchange;
        double meanVelocity;
        double oldMeanDensity;
        double meanDensity;
        double meanFrik;
        double Amean;
        double Aw;
        double Ae;
        int i;
        double sign = phase == 0 ? 1.0 : -1.0;
        double SU = 0.0;
        double SP = 0.0;
        double Fw = 0.0;
        double Fe = 0.0;
        this.pipe.getNode(0).initFlowCalc();
        this.pipe.getNode(0).init();
        this.pipe.getNode(0).setVelocityIn(phase, this.pipe.getNode(0).getVelocity(phase));
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = this.pipe.getNode(0).getVelocityIn(phase).doubleValue();
        this.a[1] = 0.0;
        this.b[1] = 1.0;
        this.c[1] = 0.0;
        this.r[1] = this.pipe.getNode(0).getVelocityIn(phase).doubleValue();
        for (i = 2; i < this.numberOfNodes - 1; ++i) {
            Ae = this.pipe.getNode(i).getArea(phase);
            Aw = this.pipe.getNode(i - 1).getArea(phase);
            Amean = this.pipe.getNode(i - 1).getArea(phase);
            meanFrik = this.pipe.getNode(i - 1).getWallFrictionFactor(phase);
            meanDensity = this.pipe.getNode(i - 1).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity();
            oldMeanDensity = this.oldDensity[phase][i];
            meanVelocity = this.pipe.getNode(i - 1).getVelocity(phase);
            vertposchange = this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode();
            nodeLength = this.pipe.getNode(i - 1).getGeometry().getNodeLength();
            interfaceFricition = this.pipe.getNode(i - 1).getInterPhaseFrictionFactor();
            SU = -Amean * (this.pipe.getNode(i).getBulkSystem().getPressure() - this.pipe.getNode(i - 1).getBulkSystem().getPressure()) * 100000.0 + Amean * 9.80665 * meanDensity * vertposchange + this.pipe.getNode(i - 1).getWallContactLength(phase) * nodeLength * meanDensity * meanFrik * Math.abs(meanVelocity) * meanVelocity / 8.0 - this.pipe.getNode(i - 1).getInterphaseContactLength(0) * nodeLength * meanDensity * interfaceFricition * Math.abs(this.pipe.getNode(i).getVelocity(0) - this.pipe.getNode(i).getVelocity(1)) * (this.pipe.getNode(i).getVelocity(0) - this.pipe.getNode(i).getVelocity(1)) / 8.0 * sign;
            SP = -this.pipe.getNode(i - 1).getWallContactLength(phase) * nodeLength * meanDensity * meanFrik * meanVelocity / 4.0;
            Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(i - 1).getVelocity(phase);
            Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocity(phase);
            this.oldImpuls[phase][i] = this.dynamic ? 1.0 / this.timeStep * oldMeanDensity * nodeLength * Amean : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldImpuls[phase][i];
            this.r[i] = SU + this.oldImpuls[phase][i] * this.oldVelocity[phase][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        i = this.numberOfNodes - 1;
        Ae = this.pipe.getNode(i - 1).getArea(phase);
        Aw = this.pipe.getNode(i - 1).getArea(phase);
        Amean = this.pipe.getNode(i - 1).getArea(phase);
        meanFrik = this.pipe.getNode(i - 1).getWallFrictionFactor(phase);
        meanDensity = this.pipe.getNode(i - 1).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity();
        oldMeanDensity = this.oldDensity[phase][i];
        meanVelocity = this.pipe.getNode(i - 1).getVelocity(phase);
        vertposchange = this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode();
        nodeLength = this.pipe.getNode(i - 1).getGeometry().getNodeLength();
        interfaceFricition = this.pipe.getNode(i - 1).getInterPhaseFrictionFactor();
        SU = -Amean * (this.pipe.getNode(i).getBulkSystem().getPressure() - this.pipe.getNode(i - 1).getBulkSystem().getPressure()) * 100000.0 - Amean * 9.80665 * meanDensity * vertposchange + this.pipe.getNode(i - 1).getWallContactLength(phase) * nodeLength * meanDensity * meanFrik * Math.abs(meanVelocity) * meanVelocity / 8.0 - this.pipe.getNode(i - 1).getInterphaseContactLength(0) * nodeLength * meanDensity * interfaceFricition * Math.abs(this.pipe.getNode(i).getVelocity(0) - this.pipe.getNode(i).getVelocity(1)) * (this.pipe.getNode(i).getVelocity(0) - this.pipe.getNode(i).getVelocity(1)) / 8.0 * sign;
        SP = -this.pipe.getNode(i - 1).getWallContactLength(phase) * nodeLength * meanDensity * meanFrik * meanVelocity / 4.0;
        Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocityIn(phase).doubleValue();
        Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocity(phase);
        this.oldImpuls[phase][i] = this.dynamic ? 1.0 / this.timeStep * oldMeanDensity * nodeLength * Amean : 0.0;
        this.a[i] = Math.max(Fw, 0.0);
        this.c[i] = Math.max(-Fe, 0.0);
        this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldImpuls[phase][i];
        this.r[i] = SU + this.oldImpuls[phase][i] * this.oldVelocity[phase][i];
        this.a[this.numberOfNodes - 1] = -this.a[this.numberOfNodes - 1];
        this.c[this.numberOfNodes - 1] = -this.c[this.numberOfNodes - 1];
    }

    public void setEnergyMatrixTDMA(int phase) {
        int i;
        double SU;
        double sign = phase == 0 ? 1.0 : -1.0;
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhases()[phase].getEnthalpy() / this.pipe.getNode(0).getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() / this.pipe.getNode(0).getBulkSystem().getPhases()[phase].getMolarMass();
        for (i = 1; i < this.numberOfNodes - 1; ++i) {
            double fe = this.pipe.getNode(i + 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i + 1).getGeometry().getNodeLength());
            double fw = this.pipe.getNode(i - 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i - 1).getGeometry().getNodeLength());
            double Ae = this.pipe.getNode(i).getArea(phase);
            double Aw = this.pipe.getNode(i - 1).getArea(phase);
            double vertposchange = (1.0 - fe) * (this.pipe.getNode(i + 1).getVerticalPositionOfNode() - this.pipe.getNode(i).getVerticalPositionOfNode()) + (1.0 - fw) * (this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode());
            SU = -this.pipe.getNode(i).getArea(phase) * 9.80665 * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getDensity() * this.pipe.getNode(i).getVelocity(phase) * vertposchange + this.pipe.getNode(i).getArea(phase) * 4.0 * 0.02 * (278.0 - this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getTemperature()) / this.pipe.getNode(i).getGeometry().getDiameter() * this.pipe.getNode(i).getGeometry().getNodeLength() + sign * this.pipe.getNode(i).getFluidBoundary().getInterphaseHeatFlux(phase) * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getInterphaseContactLength(phase) * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(phase));
            double SP = 0.0;
            double Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocityIn(phase).doubleValue();
            double Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocityOut(phase).doubleValue();
            this.oldEnergy[phase][i] = this.dynamic ? 1.0 / this.timeStep * this.oldDensity[phase][i] * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getArea(phase) : 0.0;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldEnergy[phase][i];
            this.r[i] = SU + this.oldEnergy[phase][i] * this.oldInternalEnergy[phase][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        i = this.numberOfNodes - 1;
        double fw = this.pipe.getNode(i - 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i - 1).getGeometry().getNodeLength());
        double Ae = this.pipe.getNode(i).getArea(phase);
        double Aw = this.pipe.getNode(i - 1).getArea(phase);
        double vertposchange = (1.0 - fw) * (this.pipe.getNode(i).getVerticalPositionOfNode() - this.pipe.getNode(i - 1).getVerticalPositionOfNode());
        SU = -this.pipe.getNode(i).getArea(phase) * 9.80665 * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getDensity() * this.pipe.getNode(i).getVelocity(phase) * vertposchange + this.pipe.getNode(i).getWallContactLength(phase) / this.pipe.getNode(i).getGeometry().getCircumference() * this.pipe.getNode(i).getArea(phase) * 4.0 * 0.02 * (278.0 - this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getTemperature()) / this.pipe.getNode(i).getGeometry().getDiameter() * this.pipe.getNode(i).getGeometry().getNodeLength() + sign * this.pipe.getNode(i).getFluidBoundary().getInterphaseHeatFlux(phase) * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getInterphaseContactLength(phase) * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(phase));
        double SP = 0.0;
        double Fw = Aw * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocityIn(phase).doubleValue();
        double Fe = Ae * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(i).getVelocity(phase);
        this.oldEnergy[phase][i] = this.dynamic ? 1.0 / this.timeStep * this.oldDensity[phase][i] * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getArea(phase) : 0.0;
        this.a[i] = Math.max(Fw, 0.0);
        this.c[i] = Math.max(-Fe, 0.0);
        this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - SP + this.oldEnergy[phase][i];
        this.r[i] = SU + this.oldEnergy[phase][i] * this.oldInternalEnergy[phase][i];
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void setComponentConservationMatrix2(int phase, int componentNumber) {
        double SU = 0.0;
        double sign = phase == 0 ? 1.0 : 1.0;
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhases()[phase].getComponents()[componentNumber].getx();
        for (int i = 1; i < this.numberOfNodes - 1; ++i) {
            double fe = this.pipe.getNode(i + 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i + 1).getGeometry().getNodeLength());
            double fw = this.pipe.getNode(i - 1).getGeometry().getNodeLength() / (this.pipe.getNode(i).getGeometry().getNodeLength() + this.pipe.getNode(i - 1).getGeometry().getNodeLength());
            double Ae = 1.0 / ((1.0 - fe) / this.pipe.getNode(i).getArea(phase) + fe / this.pipe.getNode(i + 1).getArea(phase));
            double Aw = 1.0 / ((1.0 - fw) / this.pipe.getNode(i).getArea(phase) + fw / this.pipe.getNode(i - 1).getArea(phase));
            double Fe = this.pipe.getNode(i).getVelocityOut(phase).doubleValue() * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getComponents()[componentNumber].getMolarMass() / this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getMolarMass() * Ae;
            double Fw = this.pipe.getNode(i).getVelocityIn(phase).doubleValue() * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getComponents()[componentNumber].getMolarMass() / this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getMolarMass() * Aw;
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) - sign * this.pipe.getNode(i).getArea(phase) * this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) / this.pipe.getNode(i).getVelocity() * this.pipe.getNode(i).getGeometry().getNodeLength();
            this.r[i] = 0.0;
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        this.a[this.numberOfNodes - 1] = -1.0;
        this.b[this.numberOfNodes - 1] = 1.0;
        this.c[this.numberOfNodes - 1] = 0.0;
        SU = this.pipe.getNode(this.numberOfNodes - 2).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(this.numberOfNodes - 2).getVelocityIn(phase).doubleValue() * this.pipe.getNode(this.numberOfNodes - 2).getBulkSystem().getPhases()[phase].getComponents()[componentNumber].getx() / (this.pipe.getNode(this.numberOfNodes - 1).getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * this.pipe.getNode(this.numberOfNodes - 1).getVelocityIn(phase).doubleValue());
        this.r[this.numberOfNodes - 1] = 0.0;
    }

    public void setComponentConservationMatrix(int phase, int componentNumber) {
        int i;
        double sign = phase == 0 ? -1.0 : 1.0;
        double SU = 0.0;
        this.a[0] = 0.0;
        this.b[0] = 1.0;
        this.c[0] = 0.0;
        this.r[0] = SU = this.pipe.getNode(0).getBulkSystem().getPhases()[phase].getComponents()[componentNumber].getx() * this.pipe.getNode(0).getBulkSystem().getPhases()[phase].getComponents()[componentNumber].getMolarMass() / this.pipe.getNode(0).getBulkSystem().getPhases()[phase].getMolarMass();
        for (i = 1; i < this.numberOfNodes - 1; ++i) {
            double Ae = this.pipe.getNode(i).getArea(phase);
            double Aw = this.pipe.getNode(i - 1).getArea(phase);
            double Fe = this.pipe.getNode(i).getVelocityOut(phase).doubleValue() * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getDensity() * Ae;
            double Fw = this.pipe.getNode(i).getVelocityIn(phase).doubleValue() * this.pipe.getNode(i - 1).getBulkSystem().getPhases()[phase].getDensity() * Aw;
            this.oldComp[phase][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getArea(phase) * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getDensity() : 0.0;
            SU = sign * this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getComponents()[componentNumber].getMolarMass() * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getInterphaseContactLength(phase) * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(phase));
            this.a[i] = Math.max(Fw, 0.0);
            this.c[i] = Math.max(-Fe, 0.0);
            this.b[i] = this.a[i] + this.c[i] + (Fe - Fw) + this.oldComp[phase][i];
            this.r[i] = SU + this.oldComp[phase][i] * this.oldComposition[phase][componentNumber][i];
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
        }
        i = this.numberOfNodes - 1;
        SU = sign * this.pipe.getNode(i).getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getComponents()[componentNumber].getMolarMass() * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getInterphaseContactLength(phase) * (this.pipe.getNode(i).getGeometry().getNodeLength() / this.pipe.getNode(i).getVelocity(phase));
        this.oldComp[phase][i] = this.dynamic ? 1.0 / this.timeStep * this.pipe.getNode(i).getArea(phase) * this.pipe.getNode(i).getGeometry().getNodeLength() * this.pipe.getNode(i).getBulkSystem().getPhases()[phase].getDensity() : 0.0;
        this.a[i] = 1.0;
        this.c[i] = 0.0;
        this.b[i] = 1.0;
        this.r[i] = 0.0;
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    public void initFinalResults(int phase) {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.oldVelocity[phase][i] = this.pipe.getNode(i).getVelocityIn().doubleValue();
            this.oldDensity[phase][i] = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getPhysicalProperties().getDensity();
            this.oldInternalEnergy[phase][i] = this.pipe.getNode(i).getBulkSystem().getPhases()[0].getEnthalpy() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfMolesInPhase() / this.pipe.getNode(i).getBulkSystem().getPhases()[0].getMolarMass();
            for (int j = 0; j < this.pipe.getNode(i).getBulkSystem().getPhases()[0].getNumberOfComponents(); ++j) {
                this.oldComposition[phase][j][i] = this.xNew[phase][j][i];
            }
        }
    }

    public void calcFluxes() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).calcFluxes();
        }
    }

    public void initNodes() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.pipe.getNode(i).init();
        }
    }

    @Override
    public void solveTDMA() {
        int iter = 0;
        int iterTop = 0;
        double maxDiff = 1.0E10;
        double diff = 0.0;
        System.out.println("starting...:");
        this.initProfiles();
        this.dn = new double[this.numberOfNodes][this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.xNew = new double[2][this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()][this.numberOfNodes];
        this.initMatrix();
        do {
            double[] d;
            Matrix solOld;
            int phase;
            maxDiff = 0.0;
            ++iterTop;
            iter = 0;
            if (this.solverType >= 5) {
                for (phase = 0; phase < 2; ++phase) {
                    do {
                        ++iter;
                        this.setImpulsMatrixTDMA(phase);
                        solOld = this.solMatrix[phase].copy();
                        d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                        this.solMatrix[phase] = new Matrix(d, 1).transpose();
                        this.solMatrix[phase].print(10, 10);
                        this.diffMatrix = this.solMatrix[phase].minus(solOld);
                        diff = Math.abs(this.diffMatrix.norm1() / this.solMatrix[phase].norm1());
                        if (diff > maxDiff) {
                            maxDiff = diff;
                        }
                        this.initVelocity(phase);
                    } while (diff > 1.0E-10 && iter < 100);
                }
            }
            iter = 0;
            if (this.solverType >= 5) {
                for (phase = 1; phase < 2; ++phase) {
                    do {
                        ++iter;
                        this.setPhaseFractionMatrix(phase);
                        solOld = this.solPhaseConsMatrix[phase].copy();
                        d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                        this.solPhaseConsMatrix[phase] = new Matrix(d, 1).transpose();
                        this.diffMatrix = this.solPhaseConsMatrix[phase].minus(solOld);
                        diff = Math.abs(this.diffMatrix.norm1() / this.solPhaseConsMatrix[phase].norm1());
                        if (diff > maxDiff) {
                            maxDiff = diff;
                        }
                        this.initPhaseFraction(phase);
                    } while (diff > 1.0E-15 && iter < 100);
                }
                phase = 0;
                do {
                    ++iter;
                    this.setMassConservationMatrix(phase);
                    solOld = this.solPhaseConsMatrix[phase].copy();
                    d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                    this.solPhaseConsMatrix[phase] = new Matrix(d, 1).transpose();
                    this.diffMatrix = this.solPhaseConsMatrix[phase].minus(solOld);
                    diff = Math.abs(this.diffMatrix.norm1() / this.solPhaseConsMatrix[phase].norm1());
                    if (diff > maxDiff) {
                        maxDiff = diff;
                    }
                    this.initPressure(phase);
                } while (diff > 1.0E-15 && iter < 100);
            }
            if (this.solverType >= 5) {
                for (phase = 0; phase < 2; ++phase) {
                    iter = 0;
                    do {
                        ++iter;
                        Matrix sol3Old = this.sol3Matrix[phase].copy();
                        this.setEnergyMatrixTDMA(phase);
                        d = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                        this.sol3Matrix[phase] = new Matrix(d, 1).transpose();
                        this.diffMatrix = this.sol3Matrix[phase].minus(sol3Old);
                        diff = Math.abs(this.diffMatrix.norm1() / this.sol3Matrix[phase].norm1());
                        if (diff > maxDiff) {
                            maxDiff = diff;
                        }
                        this.initTemperature(phase);
                    } while (diff > 1.0E-15 && iter < 100);
                }
            }
            if (this.solverType >= 5) {
                double compDiff = 0.0;
                int compIter = 0;
                do {
                    this.calcFluxes();
                    ++compIter;
                    for (int phase2 = 0; phase2 < 2; ++phase2) {
                        iter = 0;
                        for (int p = 0; p < this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents() - 1; ++p) {
                            do {
                                ++iter;
                                this.setComponentConservationMatrix(phase2, p);
                                Matrix solOld2 = this.solMolFracMatrix[phase2][p].copy();
                                this.xNew[phase2][p] = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                                this.solMolFracMatrix[phase2][p] = new Matrix(this.xNew[phase2][p], 1).transpose();
                                this.diffMatrix = this.solMolFracMatrix[phase2][p].minus(solOld2);
                                diff = Math.abs(this.diffMatrix.norm2() / this.solMolFracMatrix[phase2][p].norm2());
                                if (diff > maxDiff) {
                                    maxDiff = diff;
                                }
                                if (diff > compDiff) {
                                    compDiff = diff;
                                }
                                System.out.println("diff molfrac: " + this.diffMatrix.norm2() / this.solMolFracMatrix[phase2][p].norm2());
                                this.initComposition(phase2, p);
                            } while (diff > 1.0E-12 && iter < 10);
                        }
                    }
                } while (compDiff > 1.0E-10 && compIter < 10);
                this.initNodes();
            }
            System.out.println("iter: " + iterTop + " maxdiff " + maxDiff);
        } while (Math.abs(maxDiff) > 1.0E-7 && iterTop < 1);
        for (int phase = 0; phase < 2; ++phase) {
            for (int p = 0; p < this.pipe.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents() - 1; ++p) {
                Matrix dmat = new Matrix(this.xNew[phase][p], 1);
                dmat.print(10, 10);
            }
        }
    }
}

