/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseTwoPhase.stirredCell;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseTwoPhase.interphasePipeFlow.InterphaseStratifiedFlow;

public class InterphaseStirredCellFlow
extends InterphaseStratifiedFlow {
    private static final long serialVersionUID = 1000L;

    public InterphaseStirredCellFlow() {
    }

    public InterphaseStirredCellFlow(FlowNodeInterface node) {
    }

    @Override
    public double calcWallHeatTransferCoefficient(int phase, double prandtlNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber(phase)) < 2000.0) {
            return 3.66 / node.getHydraulicDiameter(phase) * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getConductivity();
        }
        double temp = node.getBulkSystem().getPhases()[phase].getCp() / node.getBulkSystem().getPhases()[phase].getMolarMass() / node.getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * node.getVelocity(phase);
        return 0.5 * this.calcWallFrictionFactor(phase, node) * Math.pow(prandtlNumber, -0.6666666666666666) * temp;
    }

    @Override
    public double calcInterphaseHeatTransferCoefficient(int phase, double prandtlNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber()) < 2000.0) {
            return 3.66 / node.getHydraulicDiameter(phase) * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getConductivity();
        }
        double temp = node.getBulkSystem().getPhases()[phase].getCp() / node.getBulkSystem().getPhases()[phase].getMolarMass() / node.getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * node.getVelocity(phase);
        return 0.5 * this.calcWallFrictionFactor(phase, node) * Math.pow(prandtlNumber, -0.6666666666666666) * temp;
    }

    @Override
    public double calcWallMassTransferCoefficient(int phase, double schmidtNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber()) < 2000.0) {
            return 3.66 / node.getHydraulicDiameter(phase) / schmidtNumber * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getKinematicViscosity();
        }
        double temp = node.getVelocity(phase);
        return 0.5 * this.calcWallFrictionFactor(phase, node) * Math.pow(schmidtNumber, -0.6666666666666666) * temp;
    }

    @Override
    public double calcInterphaseMassTransferCoefficient(int phase, double schmidtNumber, FlowNodeInterface node) {
        double c4;
        double c3;
        double c2;
        double redMassTrans = 0.0;
        double massTrans = 0.0;
        if (phase == 0) {
            c2 = 0.46;
            c3 = 0.68;
            c4 = 0.5;
            redMassTrans = c2 * Math.pow(node.getReynoldsNumber(phase), c3) * Math.pow(schmidtNumber, c4);
            massTrans = redMassTrans * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getKinematicViscosity() / schmidtNumber / node.getGeometry().getDiameter();
        }
        if (phase == 1) {
            c2 = 0.181;
            c3 = 0.72;
            c4 = 0.33;
            redMassTrans = c2 * Math.pow(node.getReynoldsNumber(phase), c3) * Math.pow(schmidtNumber, c4);
            massTrans = redMassTrans * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getKinematicViscosity() / schmidtNumber / node.getGeometry().getDiameter();
        }
        return massTrans;
    }
}

