/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseTwoPhase.interphasePipeFlow;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseTwoPhase.interphasePipeFlow.InterphaseTwoPhasePipeFlow;
import neqsim.thermo.ThermodynamicConstantsInterface;

public class InterphaseStratifiedFlow
extends InterphaseTwoPhasePipeFlow
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;

    public InterphaseStratifiedFlow() {
    }

    public InterphaseStratifiedFlow(FlowNodeInterface node) {
    }

    @Override
    public double calcWallFrictionFactor(int phase, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber(phase)) < 2000.0) {
            return 64.0 / node.getReynoldsNumber(phase);
        }
        return Math.pow(1.0 / (-1.8 * Math.log10(6.9 / node.getReynoldsNumber(phase) + Math.pow(node.getGeometry().getRelativeRoughnes() / 3.7, 1.11))), 2.0);
    }

    @Override
    public double calcInterPhaseFrictionFactor(int phase, FlowNodeInterface node) {
        return (1.0 + 75.0 * node.getPhaseFraction(1)) * this.calcWallFrictionFactor(0, node);
    }

    @Override
    public double calcWallHeatTransferCoefficient(int phase, double prandtlNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber(phase)) < 2000.0) {
            return 3.66 / node.getHydraulicDiameter(phase) * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getConductivity();
        }
        double temp = node.getBulkSystem().getPhases()[phase].getCp() / node.getBulkSystem().getPhases()[phase].getMolarMass() / node.getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * node.getVelocity(phase);
        return 0.5 * this.calcWallFrictionFactor(phase, node) * Math.pow(prandtlNumber, -0.6666666666666666) * temp;
    }

    @Override
    public double calcInterphaseHeatTransferCoefficient(int phase, double prandtlNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber()) < 2000.0) {
            return 3.66 / node.getHydraulicDiameter(phase) * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getConductivity();
        }
        double temp = node.getBulkSystem().getPhases()[phase].getCp() / node.getBulkSystem().getPhases()[phase].getMolarMass() / node.getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getDensity() * node.getVelocity(phase);
        return 0.5 * this.calcWallFrictionFactor(phase, node) * Math.pow(prandtlNumber, -0.6666666666666666) * temp;
    }

    @Override
    public double calcWallMassTransferCoefficient(int phase, double schmidtNumber, FlowNodeInterface node) {
        if (Math.abs(node.getReynoldsNumber()) < 2000.0) {
            return 3.66 / node.getHydraulicDiameter(phase) / schmidtNumber * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getKinematicViscosity();
        }
        double temp = node.getVelocity(phase);
        return 0.5 * this.calcWallFrictionFactor(phase, node) * Math.pow(schmidtNumber, -0.6666666666666666) * temp;
    }

    @Override
    public double calcInterphaseMassTransferCoefficient(int phase, double schmidtNumber, FlowNodeInterface node) {
        double redMassTrans = 0.0;
        double massTrans = 0.0;
        if (phase == 1) {
            redMassTrans = Math.abs(node.getReynoldsNumber(phase)) < 300.0 ? 0.01099 * Math.pow(node.getReynoldsNumber(phase), 0.3955) * Math.pow(schmidtNumber, 0.5) : (Math.abs(node.getReynoldsNumber(phase)) < 1600.0 ? 0.02995 * Math.pow(node.getReynoldsNumber(phase), 0.2134) * Math.pow(schmidtNumber, 0.5) : 9.777E-4 * Math.pow(node.getReynoldsNumber(phase), 0.6804) * Math.pow(schmidtNumber, 0.5));
            massTrans = redMassTrans * Math.pow(Math.pow(node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getKinematicViscosity(), 2.0) / 9.80665, -0.3333333333333333) * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getKinematicViscosity() / schmidtNumber;
        }
        if (phase == 0) {
            if (Math.abs(node.getReynoldsNumber(phase)) < 2300.0) {
                massTrans = 3.66 / node.getHydraulicDiameter(phase) / schmidtNumber * node.getBulkSystem().getPhases()[phase].getPhysicalProperties().getKinematicViscosity();
            } else {
                double temp = node.getVelocity(phase);
                massTrans = 0.5 * this.calcWallFrictionFactor(phase, node) * Math.pow(schmidtNumber, -0.6666666666666666) * temp;
            }
        }
        return massTrans;
    }
}

