/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.dataPresentation.fileHandeling.createTextFile.TextFile;
import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.FluidBoundaryInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.equilibriumFluidBoundary.EquilibriumFluidBoundary;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary.KrishnaStandartFilmModel;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary.reactiveFilmModel.ReactiveKrishnaStandartFilmModel;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.InterphaseTransportCoefficientBaseClass;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.InterphaseTransportCoefficientInterface;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.util.util.DoubleCloneable;

public abstract class FlowNode
implements FlowNodeInterface,
ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    protected double distanceToCenterOfNode = 0.0;
    protected double lengthOfNode = 0.0;
    protected double veticalPositionOfNode = 0.0;
    protected double[] hydraulicDiameter;
    protected double[] reynoldsNumber;
    protected int[] flowDirection;
    protected double[] interphaseContactLength;
    protected double[] wallContactLength;
    protected double[] phaseFraction;
    public double[] molarFlowRate;
    public double[] massFlowRate;
    public double[] volumetricFlowRate;
    protected ThermodynamicOperations operations;
    protected String flowNodeType = null;
    protected FluidBoundaryInterface fluidBoundary = null;
    public SystemInterface bulkSystem;
    protected double inclination = 0.0;
    public DoubleCloneable[] velocityIn;
    public DoubleCloneable[] velocityOut;
    public double[] superficialVelocity;
    public double interphaseContactArea = 0.0;
    public double[] velocity;
    public GeometryDefinitionInterface pipe;
    protected InterphaseTransportCoefficientInterface interphaseTransportCoefficient;
    protected double[] wallFrictionFactor;
    protected double[] interphaseFrictionFactor;
    protected Double[] specifiedFrictionFactor = null;
    protected ThermodynamicOperations phaseOps;

    public FlowNode() {
        this.bulkSystem = null;
        this.pipe = null;
        this.fluidBoundary = null;
        this.interphaseTransportCoefficient = null;
    }

    public FlowNode(SystemInterface system) {
        this.interphaseTransportCoefficient = new InterphaseTransportCoefficientBaseClass(this);
        this.velocityIn = new DoubleCloneable[2];
        this.velocityOut = new DoubleCloneable[2];
        this.velocity = new double[2];
        this.flowDirection = new int[2];
        this.wallFrictionFactor = new double[2];
        this.specifiedFrictionFactor = new Double[2];
        this.superficialVelocity = new double[2];
        this.phaseFraction = new double[2];
        this.hydraulicDiameter = new double[2];
        this.reynoldsNumber = new double[2];
        this.interphaseContactLength = new double[2];
        this.wallContactLength = new double[2];
        this.molarFlowRate = new double[2];
        this.massFlowRate = new double[2];
        this.volumetricFlowRate = new double[2];
        this.interphaseFrictionFactor = new double[2];
        this.velocity[0] = 0.0;
        this.bulkSystem = system.clone();
        if (this.bulkSystem.isChemicalSystem()) {
            this.bulkSystem.chemicalReactionInit();
        }
        this.operations = new ThermodynamicOperations(this.bulkSystem);
        for (int i = 0; i < 2; ++i) {
            this.velocityOut[i] = new DoubleCloneable();
            this.velocityIn[i] = new DoubleCloneable();
            this.flowDirection[i] = 1;
        }
    }

    public FlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        this(system);
        this.pipe = pipe.clone();
    }

    public FlowNode(SystemInterface system, GeometryDefinitionInterface pipe, double lengthOfNode, double distanceToCenterOfNode) {
        this(system, pipe);
        this.lengthOfNode = lengthOfNode;
        this.distanceToCenterOfNode = distanceToCenterOfNode;
    }

    @Override
    public void setFrictionFactorType(int type) {
        if (type == 0) {
            this.interphaseTransportCoefficient = new InterphaseTransportCoefficientBaseClass(this);
        }
        if (type == 1) {
            this.interphaseTransportCoefficient = new InterphaseTransportCoefficientBaseClass(this);
        } else {
            System.out.println("error chhosing friction type");
        }
    }

    @Override
    public void setGeometryDefinitionInterface(GeometryDefinitionInterface pipe) {
        this.pipe = pipe.clone();
    }

    @Override
    public void setDistanceToCenterOfNode(double distanceToCenterOfNode) {
        this.distanceToCenterOfNode = distanceToCenterOfNode;
    }

    @Override
    public InterphaseTransportCoefficientInterface getInterphaseTransportCoefficient() {
        return this.interphaseTransportCoefficient;
    }

    @Override
    public double getDistanceToCenterOfNode() {
        return this.distanceToCenterOfNode;
    }

    @Override
    public double getVerticalPositionOfNode() {
        return this.veticalPositionOfNode;
    }

    @Override
    public void setVerticalPositionOfNode(double veticalPositionOfNode) {
        this.veticalPositionOfNode = veticalPositionOfNode;
    }

    @Override
    public double getSuperficialVelocity(int i) {
        return this.superficialVelocity[i];
    }

    @Override
    public String getFlowNodeType() {
        return this.flowNodeType;
    }

    @Override
    public void setLengthOfNode(double lengthOfNode) {
        this.lengthOfNode = lengthOfNode;
        this.getGeometry().setNodeLength(lengthOfNode);
    }

    @Override
    public double getLengthOfNode() {
        return this.lengthOfNode;
    }

    public FlowNode clone() {
        FlowNode clonedSystem = null;
        try {
            clonedSystem = (FlowNode)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        clonedSystem.bulkSystem = this.bulkSystem.clone();
        clonedSystem.pipe = this.pipe.clone();
        clonedSystem.velocity = new double[2];
        clonedSystem.volumetricFlowRate = new double[2];
        clonedSystem.reynoldsNumber = new double[2];
        clonedSystem.wallFrictionFactor = new double[2];
        clonedSystem.hydraulicDiameter = new double[2];
        clonedSystem.reynoldsNumber = new double[2];
        clonedSystem.interphaseContactLength = new double[2];
        clonedSystem.wallContactLength = new double[2];
        clonedSystem.flowDirection = new int[2];
        clonedSystem.phaseFraction = new double[2];
        clonedSystem.molarFlowRate = new double[2];
        clonedSystem.massFlowRate = new double[2];
        clonedSystem.interphaseFrictionFactor = new double[2];
        clonedSystem.velocityIn = (DoubleCloneable[])this.velocityIn.clone();
        clonedSystem.velocityOut = (DoubleCloneable[])this.velocityOut.clone();
        for (int i = 0; i < 2; ++i) {
            clonedSystem.velocityIn[i] = this.velocityIn[i].clone();
            clonedSystem.velocityOut[i] = this.velocityOut[i].clone();
        }
        System.arraycopy(this.flowDirection, 0, clonedSystem.flowDirection, 0, this.flowDirection.length);
        System.arraycopy(this.wallContactLength, 0, clonedSystem.wallContactLength, 0, this.wallContactLength.length);
        System.arraycopy(this.interphaseFrictionFactor, 0, clonedSystem.interphaseFrictionFactor, 0, this.interphaseFrictionFactor.length);
        System.arraycopy(this.molarFlowRate, 0, clonedSystem.molarFlowRate, 0, this.molarFlowRate.length);
        System.arraycopy(this.massFlowRate, 0, clonedSystem.massFlowRate, 0, this.massFlowRate.length);
        System.arraycopy(this.volumetricFlowRate, 0, clonedSystem.volumetricFlowRate, 0, this.volumetricFlowRate.length);
        System.arraycopy(this.phaseFraction, 0, clonedSystem.phaseFraction, 0, this.phaseFraction.length);
        System.arraycopy(this.velocity, 0, clonedSystem.velocity, 0, this.velocity.length);
        System.arraycopy(this.hydraulicDiameter, 0, clonedSystem.hydraulicDiameter, 0, this.hydraulicDiameter.length);
        System.arraycopy(this.reynoldsNumber, 0, clonedSystem.reynoldsNumber, 0, this.reynoldsNumber.length);
        System.arraycopy(this.wallFrictionFactor, 0, clonedSystem.wallFrictionFactor, 0, this.wallFrictionFactor.length);
        return clonedSystem;
    }

    @Override
    public void init() {
        this.bulkSystem.init(3);
        this.bulkSystem.initPhysicalProperties();
    }

    @Override
    public void initBulkSystem() {
        this.bulkSystem.init(3);
        this.bulkSystem.initPhysicalProperties();
    }

    @Override
    public SystemInterface getBulkSystem() {
        return this.bulkSystem;
    }

    @Override
    public DoubleCloneable getVelocityOut(int i) {
        return this.velocityOut[i];
    }

    @Override
    public DoubleCloneable getVelocityIn(int i) {
        return this.velocityIn[i];
    }

    @Override
    public void setVelocity(int phase, double vel) {
        this.velocity[phase] = vel;
    }

    @Override
    public void setVelocityIn(int phase, double vel) {
        this.velocityIn[phase].set(vel);
    }

    @Override
    public void setVelocityIn(int phase, DoubleCloneable vel) {
        this.velocityIn[phase] = vel;
    }

    @Override
    public void setVelocityOut(int phase, double vel) {
        this.velocityOut[phase].set(vel);
    }

    @Override
    public void setVelocityOut(int phase, DoubleCloneable vel) {
        this.velocityOut[phase] = vel;
    }

    @Override
    public double getVelocity(int phase) {
        return this.velocity[phase];
    }

    @Override
    public void setWallFrictionFactor(int phase, double frictionFactor) {
        if (this.specifiedFrictionFactor[0] == null) {
            this.specifiedFrictionFactor = new Double[2];
        }
        this.specifiedFrictionFactor[phase] = frictionFactor;
    }

    @Override
    public double getWallFrictionFactor(int phase) {
        if (this.specifiedFrictionFactor != null && this.specifiedFrictionFactor[phase] != null) {
            return this.specifiedFrictionFactor[phase];
        }
        return this.wallFrictionFactor[phase];
    }

    @Override
    public double getInterPhaseFrictionFactor() {
        return this.interphaseFrictionFactor[0];
    }

    @Override
    public double getReynoldsNumber(int i) {
        return this.reynoldsNumber[i];
    }

    @Override
    public double getHydraulicDiameter(int i) {
        return this.hydraulicDiameter[i];
    }

    @Override
    public SystemInterface getInterphaseSystem() {
        return this.fluidBoundary.getInterphaseSystem();
    }

    @Override
    public FluidBoundaryInterface getFluidBoundary() {
        return this.fluidBoundary;
    }

    @Override
    public GeometryDefinitionInterface getGeometry() {
        return this.pipe;
    }

    @Override
    public void setInterphaseSystem(SystemInterface interphaseSystem) {
        this.fluidBoundary.setInterphaseSystem(interphaseSystem.clone());
    }

    @Override
    public void setInterphaseModelType(int i) {
        this.fluidBoundary = i == 0 ? new EquilibriumFluidBoundary(this) : (this.bulkSystem.isChemicalSystem() ? new ReactiveKrishnaStandartFilmModel(this) : new KrishnaStandartFilmModel(this));
    }

    @Override
    public void setBulkSystem(SystemInterface bulkSystem) {
        this.bulkSystem = bulkSystem.clone();
        this.phaseOps = new ThermodynamicOperations(this.getBulkSystem());
        this.phaseOps.TPflash();
        this.init();
    }

    @Override
    public FlowNodeInterface getNextNode() {
        return this.clone();
    }

    @Override
    public double getVolumetricFlow() {
        return this.volumetricFlowRate[0];
    }

    @Override
    public void calcFluxes() {
    }

    @Override
    public void setFluxes(double[] dn) {
    }

    @Override
    public double calcSherwoodNumber(double schmidtNumber, int phase) {
        return 0.0;
    }

    @Override
    public double calcNusseltNumber(double prandtlNumber, int phase) {
        return 0.0;
    }

    @Override
    public double getPrandtlNumber(int phase) {
        return this.getBulkSystem().getPhases()[phase].getCp() * this.getBulkSystem().getPhases()[phase].getPhysicalProperties().getViscosity() / this.getBulkSystem().getPhases()[phase].getPhysicalProperties().getConductivity();
    }

    @Override
    public double getSchmidtNumber(int phase, int component1, int component2) {
        return this.getBulkSystem().getPhase(phase).getPhysicalProperties().getDiffusionCoefficient(component1, component2) / this.getBulkSystem().getPhase(phase).getPhysicalProperties().getKinematicViscosity();
    }

    @Override
    public double getEffectiveSchmidtNumber(int phase, int component) {
        this.getBulkSystem().getPhase(phase).getPhysicalProperties().calcEffectiveDiffusionCoefficients();
        return this.getBulkSystem().getPhase(phase).getPhysicalProperties().getKinematicViscosity() / this.getBulkSystem().getPhase(phase).getPhysicalProperties().getEffectiveDiffusionCoefficient(component);
    }

    @Override
    public double calcStantonNumber(double schmidtNumber, int phase) {
        return 0.0;
    }

    @Override
    public double getArea(int i) {
        return this.pipe.getArea() * this.phaseFraction[i];
    }

    @Override
    public void updateMolarFlow() {
    }

    @Override
    public double getPhaseFraction(int phase) {
        return this.phaseFraction[phase];
    }

    @Override
    public double getInterphaseContactArea() {
        return this.interphaseContactArea;
    }

    @Override
    public void setPhaseFraction(int phase, double frac) {
        this.phaseFraction[phase] = frac;
    }

    @Override
    public double getWallContactLength(int phase) {
        return this.wallContactLength[phase];
    }

    @Override
    public double getInterphaseContactLength(int phase) {
        return this.interphaseContactLength[phase];
    }

    @Override
    public double getMassFlowRate(int phase) {
        return this.massFlowRate[phase];
    }

    @Override
    public void increaseMolarRate(double moles) {
    }

    @Override
    public double calcTotalHeatTransferCoefficient(int phase) {
        double prandtlNumber = this.getBulkSystem().getPhases()[phase].getCp() / this.getBulkSystem().getPhases()[phase].getNumberOfMolesInPhase() * this.getBulkSystem().getPhases()[phase].getPhysicalProperties().getViscosity() / this.getBulkSystem().getPhases()[phase].getPhysicalProperties().getConductivity();
        double temp = 1.0 / (1.0 / this.interphaseTransportCoefficient.calcWallHeatTransferCoefficient(phase, prandtlNumber, this) + 1.0 / this.pipe.getWallHeatTransferCoefficient() + 1.0 / this.pipe.getSurroundingEnvironment().getHeatTransferCoefficient());
        return temp;
    }

    @Override
    public void setEnhancementType(int type) {
    }

    @Override
    public void display(String name) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        JDialog dialog = new JDialog((Frame)new JFrame(), "Node-Report");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setSize(screenDimension.width / 2, screenDimension.height / 2);
        Object[] names = new String[]{"", "Phase 1", "Phase 2", "Phase 3", "Unit"};
        Object[][] table = this.createTable(name);
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        Jtab.setRowHeight(dialog.getHeight() / table.length);
        Jtab.setFont(new Font("Serif", 0, dialog.getHeight() / table.length - dialog.getHeight() / table.length / 10));
        dialog.setVisible(true);
    }

    @Override
    public void update() {
    }

    @Override
    public ThermodynamicOperations getOperations() {
        return this.operations;
    }

    public void setOperations(ThermodynamicOperations operations) {
        this.operations = operations;
    }

    @Override
    public double getMolarMassTransferRate(int componentNumber) {
        return this.getFluidBoundary().getInterphaseMolarFlux(componentNumber) * this.interphaseContactArea;
    }

    @Override
    public int getFlowDirection(int i) {
        return this.flowDirection[i];
    }

    @Override
    public void setFlowDirection(int flowDirection, int i) {
        this.flowDirection[i] = flowDirection;
    }

    public String[][] createTable(String name) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        String[][] table = new String[this.bulkSystem.getPhases()[0].getNumberOfComponents() * 10][5];
        table[0][0] = "";
        table[0][1] = "";
        table[0][2] = "";
        table[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test2 = new FieldPosition(0);
        for (int i = 0; i < this.bulkSystem.getNumberOfPhases(); ++i) {
            int j;
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                table[j + 1][0] = this.bulkSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i + 1] = nf.format(this.bulkSystem.getPhase(this.bulkSystem.getPhaseIndex(i)).getComponents()[j].getx(), buf, test2).toString();
                table[j + 1][4] = "[-] bulk";
            }
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                table[j + this.bulkSystem.getPhases()[0].getNumberOfComponents() + 2][0] = this.getInterphaseSystem().getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + this.bulkSystem.getPhases()[0].getNumberOfComponents() + 2][i + 1] = nf.format(this.getInterphaseSystem().getPhase(this.getInterphaseSystem().getPhaseIndex(i)).getComponents()[j].getx(), buf, test2).toString();
                table[j + this.bulkSystem.getPhases()[0].getNumberOfComponents() + 2][4] = "[-] interface";
            }
            for (j = 0; j < this.bulkSystem.getPhases()[0].getNumberOfComponents(); ++j) {
                table[j + 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 3][0] = this.bulkSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 3][i + 1] = nf.format(this.getFluidBoundary().getInterphaseMolarFlux(j), buf, test2).toString();
                table[j + 2 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 3][4] = "[mol/sec*m^2]";
            }
            buf = new StringBuffer();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 5][0] = "Reynolds Number";
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 5][i + 1] = nf.format(this.reynoldsNumber[i], buf, test2).toString();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 5][4] = "[-]";
            buf = new StringBuffer();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 6][0] = "Velocity";
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 6][i + 1] = nf.format(this.velocity[i], buf, test2).toString();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 6][4] = "[m/sec]";
            buf = new StringBuffer();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 7][0] = "Gas Heat Flux";
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 7][i + 1] = nf.format(this.getFluidBoundary().getInterphaseHeatFlux(0), buf, test2).toString();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 7][4] = "[J/sec*m^2]";
            buf = new StringBuffer();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 8][0] = "Pressure";
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 8][i + 1] = Double.toString(this.bulkSystem.getPhase(this.bulkSystem.getPhaseIndex(i)).getPressure());
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 8][4] = "[bar]";
            buf = new StringBuffer();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 9][0] = "Bulk Temperature";
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 9][i + 1] = Double.toString(this.bulkSystem.getPhase(this.bulkSystem.getPhaseIndex(i)).getTemperature());
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 9][4] = "[K]";
            buf = new StringBuffer();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 10][0] = "Interface Temperature";
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 10][i + 1] = Double.toString(this.getInterphaseSystem().getPhase(this.bulkSystem.getPhaseIndex(i)).getTemperature());
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 10][4] = "[K]";
            buf = new StringBuffer();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 11][0] = "Interface Area";
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 11][i + 1] = nf.format(this.getInterphaseContactArea());
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 11][4] = "[m^2]";
            buf = new StringBuffer();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 12][0] = "Inner wall temperature";
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 12][i + 1] = Double.toString(this.pipe.getInnerWallTemperature());
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 12][4] = "K";
            buf = new StringBuffer();
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 13][0] = "Node";
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 13][i + 1] = name;
            table[3 * this.bulkSystem.getPhases()[0].getNumberOfComponents() + 13][4] = "-";
        }
        return table;
    }

    @Override
    public void write(String name, String filename, boolean newfile) {
        String[][] table = this.createTable(name);
        TextFile file = new TextFile();
        if (newfile) {
            file.newFile(filename);
        }
        file.setOutputFileName(filename);
        file.setValues(table);
        file.createFile();
        this.getBulkSystem().write("thermo for " + name, filename, false);
        this.getFluidBoundary().write("boundary for " + name, filename, false);
    }
}

