/*
 * Decompiled with CFR 0.152.
 */
package neqsim.dataPresentation.visAD.visAd2D;

import java.rmi.RemoteException;
import javax.swing.JFrame;
import visad.Data;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.ThingReference;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public class visAdContourPlot {
    private RealType longitude;
    private RealType latitude;
    private RealType temperature;
    private RealTupleType domain_tuple;
    private FunctionType func_domain_range;
    private Set domain_set;
    private FlatField vals_ff;
    private DataReferenceImpl data_ref;
    private DisplayImpl display;
    private ScalarMap latMap;
    private ScalarMap lonMap;
    private ScalarMap tempIsoMap;
    private ScalarMap tempRGBMap;
    int NCOLS = 0;
    int NROWS = 0;
    float[][] set_samples;
    double[][] z_samples;

    public visAdContourPlot(String firstax, String secax, String zax) throws RemoteException, VisADException {
        this.latitude = RealType.getRealType((String)firstax);
        this.longitude = RealType.getRealType((String)secax);
        this.domain_tuple = new RealTupleType(this.latitude, this.longitude);
        this.temperature = RealType.getRealType((String)zax);
        this.func_domain_range = new FunctionType((MathType)this.domain_tuple, (MathType)this.temperature);
    }

    public void setXYvals(double xMin, double xMax, int Nrows, double yMin, double yMax, int NCols) throws RemoteException, VisADException {
        this.NCOLS = NCols;
        this.NROWS = Nrows;
        this.domain_set = new Linear2DSet((MathType)this.domain_tuple, xMin, xMax, this.NROWS, yMin, yMax, this.NCOLS);
        this.set_samples = this.domain_set.getSamples(true);
    }

    public void setZvals(double[][] vals) throws RemoteException, VisADException {
        this.z_samples = vals;
    }

    public void init() throws RemoteException, VisADException {
        float[][] flat_samples = new float[1][this.NCOLS * this.NROWS];
        for (int c = 0; c < this.NCOLS; ++c) {
            for (int r = 0; r < this.NROWS; ++r) {
                flat_samples[0][c * this.NROWS + r] = (float)this.z_samples[c][r];
            }
        }
        this.vals_ff = new FlatField(this.func_domain_range, this.domain_set);
        this.vals_ff.setSamples(flat_samples, false);
        this.display = new DisplayImplJ2D("display1");
        GraphicsModeControl dispGMC = this.display.getGraphicsModeControl();
        dispGMC.setScaleEnable(true);
        this.latMap = new ScalarMap((ScalarType)this.latitude, Display.YAxis);
        this.lonMap = new ScalarMap((ScalarType)this.longitude, Display.XAxis);
        this.tempIsoMap = new ScalarMap((ScalarType)this.temperature, Display.IsoContour);
        this.tempRGBMap = new ScalarMap((ScalarType)this.temperature, Display.RGB);
        this.display.addMap(this.latMap);
        this.display.addMap(this.lonMap);
        this.display.addMap(this.tempIsoMap);
        this.data_ref = new DataReferenceImpl("data_ref");
        this.data_ref.setData((Data)this.vals_ff);
        this.display.addReference((ThingReference)this.data_ref);
        JFrame jframe = new JFrame("VisAD Tutorial example 3_05");
        jframe.getContentPane().add(this.display.getComponent());
        jframe.setSize(500, 500);
        jframe.setVisible(true);
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        visAdContourPlot test2 = new visAdContourPlot("long", "alt", "height");
        test2.setXYvals(0.0, 10.0, 4, 0.0, 10.0, 4);
        double[][] z = new double[][]{{3.0, 2.0, 1.0, 3.0}, {2.0, 6.0, 4.0, 1.0}, {1.0, 3.0, 2.0, 1.0}, {3.0, 2.0, 1.0, 3.0}};
        test2.setZvals(z);
        test2.init();
    }
}

