/*
 * Decompiled with CFR 0.152.
 */
package neqsim.dataPresentation.fileHandeling.createNetCDF.netCDF2D;

import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class NetCdf2D {
    String fileName = "c:/temp/example.nc";
    double[] xvalues = new double[3];
    String xName = "xDefault";
    String yName = "yDefault";
    String zName = "zDefault";
    double[] yvalues = new double[3];
    double[][] yvalues2 = new double[1000][3];
    String[] yName2 = new String[1000];
    NetcdfFileWriter ncfile;
    int yLength = 0;

    public void setOutputFileName(String name) {
        this.fileName = name;
    }

    public void setXvalues(double[] x, String name, String unit) {
        this.xvalues = x;
        this.xName = name;
    }

    public void setYvalues(double[] y, String name, String unit) {
        this.yvalues = y;
        this.yName = name;
        this.yvalues2[this.yLength] = y;
        this.yName2[this.yLength] = name;
        ++this.yLength;
    }

    public void createFile() {
        try {
            this.ncfile = NetcdfFileWriter.createNew((NetcdfFileWriter.Version)NetcdfFileWriter.Version.netcdf3, (String)this.fileName, null);
        }
        catch (IOException e) {
            System.err.println("ERROR creating file");
        }
        Dimension latD = this.ncfile.addDimension(null, this.xName, this.xvalues.length);
        ArrayList<Dimension> lonD = new ArrayList<Dimension>();
        ArrayList<Dimension> dim2 = new ArrayList<Dimension>();
        dim2.add(latD);
        ArrayList<Dimension> tempdim = new ArrayList<Dimension>();
        tempdim.add(latD);
        Variable t = this.ncfile.addVariable(null, latD.getName(), DataType.DOUBLE, tempdim);
        for (int i = 0; i < this.yLength; ++i) {
            lonD.add(this.ncfile.addDimension(null, this.yName2[i], this.yvalues2[i].length));
        }
        try {
            this.ncfile.create();
        }
        catch (IOException e) {
            System.err.println("ERROR creating file");
        }
        try {
            Variable v = this.ncfile.findVariable(latD.getName());
            this.ncfile.write(v, Array.factory((Object)this.xvalues));
            for (int i = 0; i < this.yLength; ++i) {
                v = this.ncfile.findVariable(((Dimension)lonD.get(i)).getName());
                this.ncfile.write(v, Array.factory((Object)this.yvalues2[i]));
            }
        }
        catch (Exception e) {
            System.err.println("ERROR writing file");
        }
        try {
            this.ncfile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("created " + this.fileName + " successfully");
    }

    public static void main(String[] args) {
        double[] x = new double[10000];
        double[] y = new double[10000];
        NetCdf2D test2 = new NetCdf2D();
        test2.setXvalues(x, "time", "sec");
        test2.setYvalues(y, "length", "meter");
        test2.createFile();
    }
}

