/*
 * Decompiled with CFR 0.152.
 */
package neqsim.chemicalReactions.chemicalEquilibriaum;

import Jama.Matrix;
import java.io.Serializable;

public class ChemEq
implements Serializable {
    private static final long serialVersionUID = 1000L;
    int NSPEC = 10;
    int NELE = 3;
    double R = 8.3143;
    double G_min = 0.0;
    double T = 3500.0;
    double P = 51.0;
    double n_t;
    double agemo = 0.0;
    double[] d_n;
    double[] phi = new double[3];
    double[][] A_matrix;
    double[] n_mol;
    double[] chem_ref;
    double[] b_element;
    int NNOT = 4;
    int i;
    int j;
    int k;
    double[] b_cal;
    double[] b_vector;
    double[] second_term;
    double[] chem_pot;
    double u_u;
    double sum;
    double step;
    double[][] matrix;

    public ChemEq() {
        int i = 0;
        while (i < 10) {
            int n = i++;
            this.chem_ref[n] = this.chem_ref[n] + Math.log(this.P);
        }
        this.phi = new double[3];
        this.phi[0] = -9.7851;
        this.phi[1] = -12.969;
        this.phi[2] = -15.222;
        this.j = 0;
        while (this.j < this.NSPEC) {
            this.d_n[this.j] = 0.0;
            ++this.j;
        }
    }

    public ChemEq(double T, double P, double[][] A_matrix, double[] n_mol, double[] chem_ref, double[] b_element) {
        this.T = T;
        this.P = P;
        this.A_matrix = A_matrix;
        this.n_mol = n_mol;
        this.chem_ref = chem_ref;
        this.b_element = b_element;
        this.NSPEC = n_mol.length;
        this.NELE = b_element.length;
        this.NNOT = 4;
        this.b_cal = new double[this.NELE];
        this.b_vector = new double[this.NNOT];
        this.second_term = new double[this.NELE];
        this.chem_pot = new double[this.NSPEC];
        this.matrix = new double[this.NNOT][this.NNOT];
        this.d_n = new double[this.NSPEC];
        int i = 0;
        while (i < n_mol.length) {
            int n = i++;
            chem_ref[n] = chem_ref[n] + Math.log(P);
        }
        this.phi[0] = -9.7851;
        this.phi[1] = -12.969;
        this.phi[2] = -15.222;
        this.j = 0;
        while (this.j < this.NSPEC) {
            this.d_n[this.j] = 0.0;
            ++this.j;
        }
    }

    public ChemEq(double[][] A_matrix) {
        this.A_matrix = A_matrix;
    }

    public ChemEq(double T, double P, double[][] A_matrix) {
        this.T = T;
        this.P = P;
        this.A_matrix = A_matrix;
    }

    public void chemSolve() {
        this.n_t = 0.0;
        this.k = 0;
        while (this.k < this.NSPEC) {
            this.n_t += this.n_mol[this.k];
            ++this.k;
        }
        System.out.println("n_total: " + this.n_t);
        this.i = 0;
        while (this.i < this.NELE) {
            this.second_term[this.i] = 0.0;
            this.b_cal[this.i] = 0.0;
            ++this.i;
        }
        this.i = 0;
        while (this.i < this.NSPEC) {
            this.chem_pot[this.i] = this.chem_ref[this.i] + Math.log(Math.abs(this.n_mol[this.i] / this.n_t));
            System.out.println("chempot: " + this.i + "  = " + this.chem_pot[this.i]);
            ++this.i;
        }
        this.sum = 0.0;
        this.j = 0;
        while (this.j < this.NELE) {
            this.i = 0;
            while (this.i < this.NELE) {
                this.k = 0;
                while (this.k < this.NSPEC) {
                    this.sum += this.A_matrix[this.i][this.k] * this.A_matrix[this.j][this.k] * this.n_mol[this.k];
                    ++this.k;
                }
                this.matrix[this.j][this.i] = this.sum;
                this.sum = 0.0;
                ++this.i;
            }
            this.k = 0;
            while (this.k < this.NSPEC) {
                int n = this.j;
                this.second_term[n] = this.second_term[n] + this.A_matrix[this.j][this.k] * this.n_mol[this.k] * this.chem_pot[this.k];
                ++this.k;
            }
            this.i = 0;
            while (this.i < this.NSPEC) {
                int n = this.j;
                this.b_cal[n] = this.b_cal[n] + this.A_matrix[this.j][this.i] * this.n_mol[this.i];
                ++this.i;
            }
            this.matrix[this.j][this.NELE] = this.b_cal[this.j];
            this.b_vector[this.j] = this.second_term[this.j] + this.b_element[this.j] - this.b_cal[this.j];
            ++this.j;
        }
        this.j = 0;
        while (this.j < this.NELE) {
            this.matrix[this.NELE][this.j] = this.b_cal[this.j];
            ++this.j;
        }
        this.matrix[this.NELE][this.NELE] = 0.0;
        this.b_vector[this.NNOT - 1] = 0.0;
        this.i = 0;
        while (this.i < this.NSPEC) {
            int n = this.NNOT - 1;
            this.b_vector[n] = this.b_vector[n] + this.n_mol[this.i] * this.chem_pot[this.i];
            ++this.i;
        }
        double[][] btest = new double[this.NNOT][1];
        this.i = 0;
        while (this.i < this.NNOT) {
            btest[this.i][0] = this.b_vector[this.i];
            this.j = 0;
            while (this.j < this.NNOT) {
                System.out.println("matrix: " + this.i + " " + this.j + " " + this.matrix[this.i][this.j]);
                ++this.j;
            }
            ++this.i;
        }
        Matrix matrixA = new Matrix(this.matrix);
        Matrix matrixb = new Matrix(btest);
        Matrix solved = matrixA.solve(matrixb);
        solved.print(5, 3);
        this.j = 0;
        while (this.j < this.NELE) {
            this.b_vector[this.j] = solved.get(this.j, 0);
            this.phi[this.j] = solved.get(this.j, 0);
            ++this.j;
        }
        this.u_u = solved.get(this.NELE, 0);
        this.sum = 0.0;
        this.j = 0;
        while (this.j < this.NSPEC) {
            this.k = 0;
            while (this.k < this.NELE) {
                this.sum += this.A_matrix[this.k][this.j] * this.phi[this.k];
                ++this.k;
            }
            this.d_n[this.j] = this.n_mol[this.j] * (this.sum + this.u_u - this.chem_pot[this.j]);
            System.out.println("nj  " + this.j + " " + this.d_n[this.j]);
            this.sum = 0.0;
            ++this.j;
        }
    }

    public double step() {
        int i;
        double[] n_omega = new double[this.NSPEC];
        double[] chem_pot_omega = new double[this.NSPEC];
        double[] chem_pot = new double[this.NSPEC];
        int check = 0;
        double step = 1.0;
        for (i = 0; i < this.NSPEC; ++i) {
            n_omega[i] = this.n_mol[i] + this.d_n[i];
            if (n_omega[i] < 0.0) {
                check = i;
                step = this.innerStep(n_omega, check, step);
                System.out.println("step2 ... " + step);
                return step;
            }
            chem_pot_omega[i] = this.R * this.T * (this.chem_ref[i] + Math.log(n_omega[i] / this.n_t));
            chem_pot[i] = this.R * this.T * (this.chem_ref[i] + Math.log(this.n_mol[i] / this.n_t));
        }
        double G_1 = 0.0;
        for (i = 0; i < this.NSPEC; ++i) {
            G_1 += chem_pot_omega[i] * this.d_n[i];
        }
        if (G_1 > 0.0) {
            double G_0 = 0.0;
            for (i = 0; i < this.NSPEC; ++i) {
                G_0 += chem_pot[i] * this.d_n[i];
            }
            step = G_0 / (G_0 - G_1);
        }
        step = this.innerStep(n_omega, check, step);
        System.out.println("step ... " + step);
        return step;
    }

    public double innerStep(double[] n_omega, int check, double step) {
        if (check > 0) {
            this.agemo = -this.n_mol[this.i] / this.d_n[this.i] * 0.99;
            this.i = check;
            while (this.i < this.NSPEC) {
                n_omega[this.i] = this.n_mol[this.i] + this.d_n[this.i];
                if (n_omega[this.i] < 0.0 && (step = -this.n_mol[this.i] / this.d_n[this.i] * 0.99) < this.agemo) {
                    this.agemo = step;
                }
                ++this.i;
            }
            step = this.agemo;
            if (step > 1.0) {
                step = 1.0;
            }
        }
        return step;
    }

    public void solve(double T, double P, double[] n_mol, double[] chem_ref) {
        this.T = T;
        this.P = P;
        this.i = 0;
        while (this.i < n_mol.length) {
            System.out.println(n_mol[this.i]);
            this.n_mol[this.i] = n_mol[this.i];
            this.chem_ref[this.i] = chem_ref[this.i];
            ++this.i;
        }
        double[][] nAr = new double[n_mol.length][1];
        this.i = 0;
        while (this.i < n_mol.length) {
            nAr[this.i][0] = n_mol[this.i];
            ++this.i;
        }
        Matrix matrixA = new Matrix(this.A_matrix);
        Matrix matrixnAr = new Matrix(nAr);
        Matrix solved = matrixA.times(matrixnAr);
        this.b_element = solved.transpose().getArrayCopy()[0];
        this.NSPEC = n_mol.length;
        this.NELE = this.A_matrix.length;
        this.NNOT = this.NELE + 1;
        this.b_cal = new double[this.NELE];
        this.b_vector = new double[this.NNOT];
        this.second_term = new double[this.NELE];
        this.chem_pot = new double[this.NSPEC];
        this.matrix = new double[this.NNOT][this.NNOT];
        for (int i = 0; i < 10; ++i) {
        }
        this.phi = new double[this.NELE];
        this.phi[0] = -9.7851;
        this.phi[1] = -12.969;
        this.phi[2] = -15.222;
        this.phi[3] = -10.0;
        this.phi[4] = -10.0;
        this.j = 0;
        while (this.j < this.NSPEC) {
            this.d_n[this.j] = 0.0;
            ++this.j;
        }
        System.out.println("HEI" + this.b_element[0]);
        System.out.println("HEI" + this.b_element[1]);
        System.out.println("HEI" + this.b_element[2]);
        System.out.println("HEI" + this.b_element[3]);
        System.out.println("HEI" + this.b_element[4]);
        this.solve();
    }

    public void solve() {
        double error = 0.0;
        double Gibbs = 0.0;
        do {
            error = 0.0;
            this.chemSolve();
            this.i = 0;
            while (this.i < this.NSPEC) {
                System.out.println(this.n_mol[this.i] + "  prove korreksjon  " + this.step * this.d_n[this.i]);
                error += this.d_n[this.i] / this.n_mol[this.i];
                if (Math.abs(this.d_n[this.i] / this.n_mol[this.i]) > 1.0E-5) {
                    this.step = this.step();
                    Gibbs = 0.0;
                    this.i = 0;
                    while (this.i < this.NSPEC) {
                        int n = this.i;
                        this.n_mol[n] = this.n_mol[n] + this.step * this.d_n[this.i];
                        Gibbs += this.n_mol[this.i] * this.chem_pot[this.i];
                        ++this.i;
                    }
                    System.out.println("Gibbs: " + Gibbs);
                    this.solve();
                    return;
                }
                ++this.i;
            }
        } while (error > 5.0E-5);
        this.j = 0;
        while (this.j < this.NSPEC) {
            System.out.println(" SVAR : " + this.n_mol[this.j] + "   " + this.d_n[this.j] / this.n_mol[this.j] + " GIBBS : " + Gibbs);
            ++this.j;
        }
    }
}

