/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.simulation;

import neqsim.PVTsimulation.simulation.BasePVTsimulation;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;

public class SaturationTemperature
extends BasePVTsimulation {
    public SaturationTemperature(SystemInterface tempSystem) {
        super(tempSystem);
    }

    public double calcSaturationTemperature() {
        this.getThermoSystem().isImplementedCompositionDeriativesofFugacity(false);
        do {
            this.getThermoSystem().setTemperature(this.getThermoSystem().getTemperature() - 10.0);
            this.thermoOps.TPflash();
        } while (this.getThermoSystem().getNumberOfPhases() == 1 && this.getThermoSystem().getTemperature() > 30.0);
        do {
            this.getThermoSystem().setTemperature(this.getThermoSystem().getTemperature() + 10.0);
            this.thermoOps.TPflash();
        } while (this.getThermoSystem().getNumberOfPhases() > 1 && this.getThermoSystem().getTemperature() < 1200.0);
        double minTemp = this.getThermoSystem().getTemperature() - 10.0;
        double maxTemp = this.getThermoSystem().getTemperature();
        int iteration = 0;
        do {
            ++iteration;
            this.getThermoSystem().setTemperature((minTemp + maxTemp) / 2.0);
            this.thermoOps.TPflash();
            if (this.getThermoSystem().getNumberOfPhases() > 1) {
                minTemp = this.getThermoSystem().getTemperature();
                continue;
            }
            maxTemp = this.getThermoSystem().getTemperature();
        } while (Math.abs(maxTemp - minTemp) > 1.0E-5 && iteration < 500);
        this.getThermoSystem().setTemperature(maxTemp);
        this.thermoOps.TPflash();
        return this.getThermoSystem().getTemperature();
    }

    @Override
    public void run() {
        super.run();
        this.saturationTemperature = this.calcSaturationTemperature();
    }

    public static void main(String[] args) {
        SystemSrkEos tempSystem = new SystemSrkEos(293.15, 60.0);
        tempSystem.addComponent("nitrogen", 0.34);
        tempSystem.addComponent("CO2", 3.59);
        tempSystem.addComponent("methane", 67.42);
        tempSystem.addComponent("ethane", 9.02);
        tempSystem.addComponent("propane", 4.31);
        tempSystem.addComponent("i-butane", 0.93);
        tempSystem.addComponent("n-butane", 1.71);
        tempSystem.addComponent("i-pentane", 0.74);
        tempSystem.addComponent("n-pentane", 0.85);
        tempSystem.addComponent("n-hexane", 0.38);
        tempSystem.addTBPfraction("C7", 0.5, 0.109, 0.6912);
        tempSystem.addTBPfraction("C8", 0.69, 0.1202, 0.7255);
        tempSystem.addTBPfraction("C9", 0.14, 0.1295, 0.7454);
        tempSystem.addTBPfraction("C10", 0.08, 0.1353, 0.7864);
        tempSystem.setMixingRule(2);
        tempSystem.init(0);
        tempSystem.init(1);
        SaturationTemperature satPresSim = new SaturationTemperature(tempSystem);
        satPresSim.run();
        satPresSim.getThermoSystem().display();
    }
}

