/*
 * Decompiled with CFR 0.152.
 */
package neqsim.MathLib.nonLinearSolver;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.MathLib.nonLinearSolver.newtonRhapson;
import neqsim.thermo.system.SystemInterface;

public class sysNewtonRhapson
implements Serializable {
    private static final long serialVersionUID = 1000L;
    int neq = 0;
    int iter = 0;
    int ic02p = -100;
    int ic03p = -100;
    int testcrit = 0;
    int npCrit = 0;
    double beta = 0.0;
    double ds = 0.0;
    double dTmax = 1.0;
    double dPmax = 1.0;
    double avscp = 0.1;
    double TC1 = 0.0;
    double TC2 = 0.0;
    double PC1 = 0.0;
    double PC2 = 0.0;
    Matrix Jac;
    Matrix fvec;
    Matrix u;
    Matrix uold;
    Matrix Xgij;
    SystemInterface system;
    int numberOfComponents;
    int speceq = 0;
    Matrix a = new Matrix(4, 4);
    Matrix s = new Matrix(1, 4);
    Matrix xg;
    Matrix xcoef;
    newtonRhapson solver;
    boolean etterCP = false;
    boolean etterCP2 = false;

    public sysNewtonRhapson() {
    }

    public sysNewtonRhapson(SystemInterface system, int numberOfPhases, int numberOfComponents) {
        this.system = system;
        this.numberOfComponents = numberOfComponents;
        this.neq = numberOfComponents + 2;
        this.Jac = new Matrix(this.neq, this.neq);
        this.fvec = new Matrix(this.neq, 1);
        this.u = new Matrix(this.neq, 1);
        this.Xgij = new Matrix(this.neq, 4);
        this.setu();
        this.uold = this.u.copy();
        this.findSpecEqInit();
        this.solver = new newtonRhapson();
        this.solver.setOrder(3);
    }

    public void setfvec() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.fvec.set(i, 0, this.u.get(i, 0) + Math.log(this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient() / this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient()));
        }
        double fsum = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            fsum = fsum + this.system.getPhases()[1].getComponents()[i].getx() - this.system.getPhases()[0].getComponents()[i].getx();
        }
        this.fvec.set(this.numberOfComponents, 0, fsum);
        this.fvec.set(this.numberOfComponents + 1, 0, 0.0);
    }

    public void findSpecEqInit() {
        this.speceq = 0;
        int speceqmin = 0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.system.getPhases()[0].getComponents()[i].getTC() > this.system.getPhases()[0].getComponents()[this.speceq].getTC()) {
                this.speceq = this.system.getPhases()[0].getComponents()[i].getComponentNumber();
            }
            if (!(this.system.getPhases()[0].getComponents()[i].getTC() < this.system.getPhases()[0].getComponents()[this.speceq].getTC())) continue;
            speceqmin = this.system.getPhases()[0].getComponents()[i].getComponentNumber();
        }
        this.avscp = (this.system.getPhases()[0].getComponents()[this.speceq].getTC() - this.system.getPhases()[0].getComponents()[speceqmin].getTC()) / 2000.0;
        System.out.println("avscp: " + this.avscp);
        this.dTmax = this.avscp * 3.0;
        this.dPmax = this.avscp * 1.5;
        System.out.println("dTmax: " + this.dTmax + "  dPmax: " + this.dPmax);
    }

    public void findSpecEq() {
        double max = 0.0;
        for (int i = 0; i < this.numberOfComponents + 2; ++i) {
            if (!(Math.abs(this.u.get(i, 0) - this.uold.get(i, 0) / this.uold.get(i, 0)) > max)) continue;
            max = Math.abs(this.u.get(i, 0) - this.uold.get(i, 0) / this.uold.get(i, 0));
        }
    }

    public void setJac() {
        int i;
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double[] dxidlnk = new double[this.numberOfComponents];
        double[] dyidlnk = new double[this.numberOfComponents];
        double tempJ = 0.0;
        int nofc = this.numberOfComponents;
        for (i = 0; i < this.numberOfComponents; ++i) {
            dxidlnk[i] = -this.system.getBeta() * this.system.getPhases()[0].getComponents()[i].getx() * this.system.getPhases()[1].getComponents()[i].getx() / this.system.getPhases()[0].getComponents()[i].getz();
            dyidlnk[i] = this.system.getPhases()[1].getComponents()[i].getx() + this.system.getPhases()[0].getComponents()[i].getK() * dxidlnk[i];
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            for (int j = 0; j < this.numberOfComponents; ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij + this.system.getPhases()[1].getComponents()[i].getdfugdx(j) * dyidlnk[j] - this.system.getPhases()[0].getComponents()[i].getdfugdx(j) * dxidlnk[j];
                this.Jac.set(i, j, tempJ);
            }
            tempJ = this.system.getTemperature() * (this.system.getPhases()[1].getComponents()[i].getdfugdt() - this.system.getPhases()[0].getComponents()[i].getdfugdt());
            this.Jac.set(i, nofc, tempJ);
            tempJ = this.system.getPressure() * (this.system.getPhases()[1].getComponents()[i].getdfugdp() - this.system.getPhases()[0].getComponents()[i].getdfugdp());
            this.Jac.set(i, nofc + 1, tempJ);
            this.Jac.set(nofc, i, dyidlnk[i] - dxidlnk[i]);
        }
        this.Jac.set(nofc + 1, this.speceq, 1.0);
    }

    public void setu() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.u.set(i, 0, Math.log(this.system.getPhases()[0].getComponents()[i].getK()));
        }
        this.u.set(this.numberOfComponents, 0, Math.log(this.system.getTemperature()));
        this.u.set(this.numberOfComponents + 1, 0, Math.log(this.system.getPressure()));
    }

    public void init() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.system.getPhases()[0].getComponents()[i].setK(Math.exp(this.u.get(i, 0)));
            this.system.getPhases()[1].getComponents()[i].setK(Math.exp(this.u.get(i, 0)));
        }
        this.system.setTemperature(Math.exp(this.u.get(this.numberOfComponents, 0)));
        this.system.setPressure(Math.exp(this.u.get(this.numberOfComponents + 1, 0)));
        this.system.calc_x_y();
        this.system.init(3);
    }

    public void calcInc(int np) {
        this.findSpecEq();
        int nofc = this.numberOfComponents;
        this.fvec.timesEquals(0.0);
        this.fvec.set(nofc + 1, 0, 1.0);
        Matrix dxds = this.Jac.solve(this.fvec);
        if (np < 5) {
            double dp = 0.01;
            this.ds = dp / dxds.get(nofc + 1, 0);
            this.Xgij.setMatrix(0, nofc + 1, np - 1, np - 1, this.u);
            dxds.timesEquals(this.ds);
            this.u.plusEquals(dxds);
        } else if (this.iter > 6) {
            this.ds *= 0.5;
            System.out.println("ds > 6");
        } else {
            if (this.iter < 3) {
                this.ds *= 1.5;
            }
            if (this.iter == 3) {
                this.ds *= 1.1;
            }
            if (this.iter == 4) {
                this.ds *= 1.0;
            }
            if (this.iter > 4) {
                this.ds *= 0.5;
            }
            if (Math.abs(this.system.getTemperature() * dxds.get(nofc, 0) * this.ds) > this.dTmax) {
                this.ds = this.sign(this.dTmax / this.system.getTemperature() / Math.abs(dxds.get(nofc, 0)), this.ds);
            }
            if (Math.abs(this.system.getPressure() * dxds.get(nofc + 1, 0) * this.ds) > this.dPmax) {
                this.ds = this.sign(this.dPmax / this.system.getPressure() / Math.abs(dxds.get(nofc + 1, 0)), this.ds);
            }
            if (this.etterCP2) {
                this.etterCP2 = false;
                this.ds = 0.5 * this.ds;
            }
            this.Xgij.setMatrix(0, nofc + 1, 0, 2, this.Xgij.getMatrix(0, nofc + 1, 1, 3));
            this.Xgij.setMatrix(0, nofc + 1, 3, 3, this.u);
            this.s.setMatrix(0, 0, 0, 3, this.Xgij.getMatrix(this.speceq, this.speceq, 0, 3));
            this.calcInc2(np);
        }
    }

    public void calcInc2(int np) {
        int i;
        for (int j = 0; j < this.neq; ++j) {
            this.xg = this.Xgij.getMatrix(j, j, 0, 3);
            for (int i2 = 0; i2 < 4; ++i2) {
                this.a.set(i2, 0, 1.0);
                this.a.set(i2, 1, this.s.get(0, i2));
                this.a.set(i2, 2, this.s.get(0, i2) * this.s.get(0, i2));
                this.a.set(i2, 3, this.a.get(i2, 2) * this.s.get(0, i2));
            }
            this.xcoef = this.a.solve(this.xg.transpose());
            double sny = this.ds + this.s.get(0, 3);
            this.u.set(j, 0, this.xcoef.get(0, 0) + sny * (this.xcoef.get(1, 0) + sny * (this.xcoef.get(2, 0) + sny * this.xcoef.get(3, 0))));
        }
        this.uold = this.u.copy();
        double xlnkmax = 0.0;
        int numb = 0;
        for (i = 0; i < this.numberOfComponents; ++i) {
            if (!(Math.abs(this.u.get(i, 0)) > xlnkmax)) continue;
            xlnkmax = Math.abs(this.u.get(i, 0));
            numb = i;
        }
        if (this.testcrit == -3 && this.ic03p != np) {
            this.etterCP2 = true;
            this.etterCP = true;
            this.ic03p = np;
            this.testcrit = 0;
            this.xg = this.Xgij.getMatrix(numb, numb, 0, 3);
            for (i = 0; i < 4; ++i) {
                this.a.set(i, 0, 1.0);
                this.a.set(i, 1, this.s.get(0, i));
                this.a.set(i, 2, this.s.get(0, i) * this.s.get(0, i));
                this.a.set(i, 3, this.a.get(i, 2) * this.s.get(0, i));
            }
            Matrix xcoef = this.a.solve(this.xg.transpose());
            double[] coefs = new double[]{xcoef.get(3, 0), xcoef.get(2, 0), xcoef.get(1, 0), xcoef.get(0, 0) - this.sign(this.avscp, -this.s.get(0, 3))};
            this.solver.setConstants(coefs);
            double nys = this.solver.solve1order(this.s.get(0, 3));
            this.ds = this.sign(this.s.get(0, 3) - nys, this.ds);
            this.calcInc2(np);
            this.TC2 = Math.exp(this.u.get(this.numberOfComponents, 0));
            this.PC2 = Math.exp(this.u.get(this.numberOfComponents + 1, 0));
            this.system.setTC((this.TC1 + this.TC2) * 0.5);
            this.system.setPC((this.PC1 + this.PC2) * 0.5);
            this.system.setPhaseType(0, 1);
            this.system.setPhaseType(1, 0);
            return;
        }
        if (xlnkmax < this.avscp && this.testcrit != 1 && np != this.ic03p && !this.etterCP) {
            this.testcrit = 1;
            this.xg = this.Xgij.getMatrix(numb, numb, 0, 3);
            for (i = 0; i < 4; ++i) {
                this.a.set(i, 0, 1.0);
                this.a.set(i, 1, this.s.get(0, i));
                this.a.set(i, 2, this.s.get(0, i) * this.s.get(0, i));
                this.a.set(i, 3, this.a.get(i, 2) * this.s.get(0, i));
            }
            Matrix xcoef = this.a.solve(this.xg.transpose());
            double[] coefs = new double[]{xcoef.get(3, 0), xcoef.get(2, 0), xcoef.get(1, 0), xcoef.get(0, 0) - this.sign(this.avscp, this.ds)};
            this.solver.setConstants(coefs);
            double nys = this.solver.solve1order(this.s.get(0, 3));
            this.ds = -nys - this.s.get(0, 3);
            this.npCrit = np;
            this.calcInc2(np);
            this.TC1 = Math.exp(this.u.get(this.numberOfComponents, 0));
            this.PC1 = Math.exp(this.u.get(this.numberOfComponents + 1, 0));
            return;
        }
        if (this.testcrit == 1) {
            this.testcrit = -3;
        }
    }

    public int getNpCrit() {
        return this.npCrit;
    }

    public double sign(double a, double b) {
        a = Math.abs(a);
        b = b >= 0.0 ? 1.0 : -1.0;
        return a * b;
    }

    public void solve(int np) {
        Matrix dx;
        this.iter = 0;
        do {
            ++this.iter;
            this.init();
            this.setfvec();
            this.setJac();
            dx = this.Jac.solve(this.fvec);
            this.u.minusEquals(dx);
            if (this.iter <= 6) continue;
            System.out.println("iter > " + this.iter);
            this.calcInc(np);
            this.solve(np);
            break;
        } while (dx.norm2() / this.u.norm2() > 1.0E-8 && Double.isNaN(dx.norm2()));
        this.init();
    }

    public static void main(String[] args) {
    }
}

