/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.propertyGenerator;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.BaseOperation;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLGApropertyTableGeneratorWaterKeywordFormat
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(OLGApropertyTableGeneratorWaterKeywordFormat.class);
    SystemInterface thermoSystem = null;
    ThermodynamicOperations thermoOps = null;
    double stdPres = 1.01325;
    double stdPresATM = 1.0;
    double stdTemp = 288.15;
    double[] molfracs;
    double[] MW;
    double[] dens;
    String[] components;
    double GOR;
    double GLR;
    double stdGasDens;
    double stdLiqDens;
    double stdWatDens;
    double[] pressures;
    double[] temperatureLOG;
    double[] temperatures;
    double[] pressureLOG = null;
    double[][] ROG = null;
    double[] bubP;
    double[] bubT;
    double[] dewP;
    double[] bubPLOG;
    double[] dewPLOG;
    double[] bubTLOG;
    double[][] ROL;
    double[][] CPG;
    double[][] CPHL;
    double[][] HG;
    double[][] HHL;
    double[][] TCG;
    double[][] TCHL;
    double[][] VISG;
    double[][] VISHL;
    double[][] SIGGHL;
    double[][] SEG;
    double[][] SEHL;
    double[][] RS;
    double TC;
    double PC;
    double TCLOG;
    double PCLOG;
    double RSWTOB;
    double[][][] props;
    int nProps;
    String[] names;
    String[] units;
    String[] namesKeyword;

    public OLGApropertyTableGeneratorWaterKeywordFormat(SystemInterface system) {
        this.thermoSystem = system;
        this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
    }

    public void setPressureRange(double minPressure, double maxPressure, int numberOfSteps) {
        this.pressures = new double[numberOfSteps];
        this.pressureLOG = new double[numberOfSteps];
        double step = (maxPressure - minPressure) / ((double)numberOfSteps * 1.0 - 1.0);
        int i = 0;
        while (i < numberOfSteps) {
            this.pressures[i] = minPressure + (double)i * step;
            this.pressureLOG[i] = this.pressures[i] * 100000.0;
            ++i;
        }
    }

    public void setTemperatureRange(double minTemperature, double maxTemperature, int numberOfSteps) {
        this.temperatures = new double[numberOfSteps];
        this.temperatureLOG = new double[numberOfSteps];
        double step = (maxTemperature - minTemperature) / ((double)numberOfSteps * 1.0 - 1.0);
        int i = 0;
        while (i < numberOfSteps) {
            this.temperatures[i] = minTemperature + (double)i * step;
            this.temperatureLOG[i] = this.temperatures[i] - 273.15;
            ++i;
        }
    }

    public void calcPhaseEnvelope() {
        try {
            this.thermoOps.calcPTphaseEnvelope();
            this.TCLOG = this.thermoSystem.getTC();
            this.PCLOG = this.thermoSystem.getPC() * 0.986923267;
            this.TC = this.thermoSystem.getTC() - 273.15;
            this.PC = this.thermoSystem.getPC() * 100000.0;
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
    }

    public double[] calcBubP(double[] temperatures) {
        double[] bubP = new double[temperatures.length];
        this.bubPLOG = new double[temperatures.length];
        int i = 0;
        while (i < temperatures.length) {
            this.thermoSystem.setTemperature(temperatures[i]);
            try {
                this.thermoOps.bubblePointPressureFlash(false);
                bubP[i] = this.thermoSystem.getPressure();
                this.bubPLOG[i] = bubP[i] * 100000.0;
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                bubP[i] = 0.0;
            }
            ++i;
        }
        return bubP;
    }

    public double[] calcDewP(double[] temperatures) {
        double[] dewP = new double[temperatures.length];
        this.dewPLOG = new double[temperatures.length];
        int i = 0;
        while (i < temperatures.length) {
            this.thermoSystem.setTemperature(temperatures[i]);
            try {
                this.thermoOps.dewPointPressureFlash();
                dewP[i] = this.thermoSystem.getPressure();
                this.dewPLOG[i] = dewP[i] * 100000.0;
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                dewP[i] = 0.0;
            }
            ++i;
        }
        return dewP;
    }

    public double[] calcBubT(double[] pressures) {
        double[] bubT = new double[pressures.length];
        this.bubTLOG = new double[pressures.length];
        int i = 0;
        while (i < pressures.length) {
            this.thermoSystem.setPressure(pressures[i]);
            try {
                this.thermoOps.bubblePointTemperatureFlash();
                bubT[i] = this.thermoSystem.getTemperature();
                this.bubTLOG[i] = bubT[i] - 273.15;
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                bubT[i] = 0.0;
            }
            ++i;
        }
        return bubT;
    }

    public void initCalc() {
        this.molfracs = new double[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        this.MW = new double[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        this.dens = new double[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        this.components = new String[this.thermoSystem.getPhase(0).getNumberOfComponents()];
        int i = 0;
        while (i < this.molfracs.length) {
            this.molfracs[i] = this.thermoSystem.getPhase(0).getComponent(i).getz();
            this.components[i] = this.thermoSystem.getPhase(0).getComponent(i).getComponentName();
            this.MW[i] = this.thermoSystem.getPhase(0).getComponent(i).getMolarMass() * 1000.0;
            this.dens[i] = this.thermoSystem.getPhase(0).getComponent(i).getNormalLiquidDensity();
            ++i;
        }
        this.thermoSystem.setTemperature(this.stdTemp);
        this.thermoSystem.setPressure(this.stdPres);
        this.thermoOps.TPflash();
        this.thermoSystem.initPhysicalProperties();
        this.GOR = this.thermoSystem.getPhase(0).getTotalVolume() / this.thermoSystem.getPhase(1).getTotalVolume();
        this.GLR = this.thermoSystem.getPhase(0).getTotalVolume() / this.thermoSystem.getPhase(1).getTotalVolume();
        this.stdGasDens = this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
        this.stdLiqDens = this.thermoSystem.getPhase(1).getPhysicalProperties().getDensity();
        this.stdWatDens = this.thermoSystem.getPhase(2).getPhysicalProperties().getDensity();
    }

    public void calcRSWTOB() {
        this.thermoSystem.init(0);
        this.thermoSystem.init(1);
        this.RSWTOB = this.thermoSystem.getPhase(0).getComponent("water").getNumberOfmoles() * this.thermoSystem.getPhase(0).getComponent("water").getMolarMass() / (this.thermoSystem.getTotalNumberOfMoles() * this.thermoSystem.getMolarMass());
    }

    @Override
    public void run() {
        logger.info("Start creating arrays");
        this.calcRSWTOB();
        this.nProps = 29;
        this.props = new double[this.nProps][this.pressures.length][this.temperatures.length];
        this.units = new String[this.nProps];
        this.names = new String[this.nProps];
        this.namesKeyword = new String[this.nProps];
        this.calcPhaseEnvelope();
        int i = 0;
        while (i < this.pressures.length) {
            this.thermoSystem.setPressure(this.pressures[i]);
            int j = 0;
            while (j < this.temperatures.length) {
                this.thermoSystem.setTemperature(this.temperatures[j]);
                try {
                    this.thermoOps.TPflash();
                }
                catch (Exception e) {
                    logger.error("error", (Throwable)e);
                }
                this.thermoSystem.init(3);
                this.thermoSystem.initPhysicalProperties();
                int k = 0;
                this.props[k][i][j] = this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
                this.names[k] = "GAS DENSITY";
                this.units[k] = "KG/M3";
                this.namesKeyword[k] = "ROG";
                this.props[++k][i][j] = this.thermoSystem.getPhase(1).getPhysicalProperties().getDensity();
                this.names[k] = "LIQUID DENSITY";
                this.units[k] = "KG/M3";
                this.namesKeyword[k] = "ROHL";
                this.props[++k][i][j] = this.thermoSystem.getPhase(2).getPhysicalProperties().getDensity();
                this.names[k] = "WATER DENSITY";
                this.units[k] = "KG/M3";
                this.namesKeyword[k] = "ROWT";
                this.props[++k][i][j] = this.thermoSystem.getPhase(0).getdrhodP() / 100000.0;
                this.names[k] = "DRHOG/DP";
                this.units[k] = "S2/M2";
                this.namesKeyword[k] = "DROGDP";
                this.props[++k][i][j] = this.thermoSystem.getPhase(1).getdrhodP() / 100000.0;
                this.names[k] = "DRHOL/DP";
                this.units[k] = "S2/M2";
                this.namesKeyword[k] = "DROHLDP";
                this.props[++k][i][j] = this.thermoSystem.getPhase(2).getdrhodP() / 100000.0;
                this.names[k] = "DRHOWAT/DP";
                this.units[k] = "S2/M2";
                this.namesKeyword[k] = "DROWTDP";
                this.props[++k][i][j] = this.thermoSystem.getPhase(0).getdrhodT();
                this.names[k] = "DRHOG/DT";
                this.units[k] = "KG/M3-K";
                this.namesKeyword[k] = "DROGDT";
                this.props[++k][i][j] = this.thermoSystem.getPhase(1).getdrhodT();
                this.names[k] = "DRHOL/DT";
                this.units[k] = "KG/M3-K";
                this.namesKeyword[k] = "DROHLDT";
                this.props[++k][i][j] = this.thermoSystem.getPhase(2).getdrhodT();
                this.names[k] = "DRHOWAT/DT";
                this.units[k] = "KG/M3-K";
                this.namesKeyword[k] = "DROWTDT";
                this.props[++k][i][j] = this.thermoSystem.getPhase(0).getBeta() * this.thermoSystem.getPhase(0).getMolarMass() / this.thermoSystem.getMolarMass();
                this.names[k] = "GAS MASS FRACTION";
                this.units[k] = "-";
                this.namesKeyword[k] = "RS";
                this.props[++k][i][j] = this.thermoSystem.getPhase(0).getComponent("water").getx() * this.thermoSystem.getPhase(0).getComponent("water").getMolarMass() / this.thermoSystem.getPhase(0).getMolarMass();
                this.names[k] = "WATER VAPOR MASS FRACTION";
                this.units[k] = "-";
                this.namesKeyword[k] = "RSW";
                this.props[++k][i][j] = this.thermoSystem.getPhase(0).getPhysicalProperties().getViscosity();
                this.names[k] = "GAS VISCOSITY";
                this.units[k] = "NS/M2";
                this.namesKeyword[k] = "VISG";
                this.props[++k][i][j] = this.thermoSystem.getPhase(1).getPhysicalProperties().getViscosity();
                this.names[k] = "LIQUID VISCOSITY";
                this.units[k] = "NS/M2";
                this.namesKeyword[k] = "VISHL";
                this.props[++k][i][j] = this.thermoSystem.getPhase(2).getPhysicalProperties().getViscosity();
                this.names[k] = "WATER VISCOSITY";
                this.units[k] = "NS/M2";
                this.namesKeyword[k] = "VISWT";
                this.props[++k][i][j] = this.thermoSystem.getPhase(0).getCp() / this.thermoSystem.getPhase(0).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(0).getMolarMass();
                this.names[k] = "GAS HEAT CAPACITY";
                this.units[k] = "J/KG-K";
                this.namesKeyword[k] = "CPG";
                this.props[++k][i][j] = this.thermoSystem.getPhase(1).getCp() / this.thermoSystem.getPhase(1).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(1).getMolarMass();
                this.names[k] = "LIQUID HEAT CAPACITY";
                this.units[k] = "J/KG-K";
                this.namesKeyword[k] = "CPHL";
                this.props[++k][i][j] = this.thermoSystem.getPhase(2).getCp() / this.thermoSystem.getPhase(2).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(2).getMolarMass();
                this.names[k] = "WATER HEAT CAPACITY";
                this.units[k] = "J/KG-K";
                this.namesKeyword[k] = "CPWT";
                this.props[++k][i][j] = this.thermoSystem.getPhase(0).getEnthalpy() / this.thermoSystem.getPhase(0).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(0).getMolarMass();
                this.names[k] = "GAS ENTHALPY";
                this.units[k] = "J/KG";
                this.namesKeyword[k] = "HG";
                this.props[++k][i][j] = this.thermoSystem.getPhase(1).getEnthalpy() / this.thermoSystem.getPhase(1).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(1).getMolarMass();
                this.names[k] = "LIQUID ENTHALPY";
                this.units[k] = "J/KG";
                this.namesKeyword[k] = "HHL";
                this.props[++k][i][j] = this.thermoSystem.getPhase(2).getEnthalpy() / this.thermoSystem.getPhase(2).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(2).getMolarMass();
                this.names[k] = "WATER ENTHALPY";
                this.units[k] = "J/KG";
                this.namesKeyword[k] = "HWT";
                this.props[++k][i][j] = this.thermoSystem.getPhase(0).getPhysicalProperties().getConductivity();
                this.names[k] = "GAS THERMAL CONDUCTIVITY";
                this.units[k] = "W/M-K";
                this.namesKeyword[k] = "TCG";
                this.props[++k][i][j] = this.thermoSystem.getPhase(1).getPhysicalProperties().getConductivity();
                this.names[k] = "LIQUID THERMAL CONDUCTIVITY";
                this.units[k] = "W/M-K";
                this.namesKeyword[k] = "TCHL";
                this.props[++k][i][j] = this.thermoSystem.getPhase(2).getPhysicalProperties().getConductivity();
                this.names[k] = "WATER THERMAL CONDUCTIVITY";
                this.units[k] = "W/M-K";
                this.namesKeyword[k] = "TCWT";
                this.props[++k][i][j] = this.thermoSystem.getInterphaseProperties().getSurfaceTension(0, 1);
                this.names[k] = "VAPOR-LIQUID SURFACE TENSION";
                this.units[k] = "N/M";
                this.namesKeyword[k] = "SIGGHL";
                this.props[++k][i][j] = this.thermoSystem.getInterphaseProperties().getSurfaceTension(0, 2);
                this.names[k] = "VAPOR-WATER SURFACE TENSION";
                this.units[k] = "N/M";
                this.namesKeyword[k] = "SIGGWT";
                this.props[++k][i][j] = this.thermoSystem.getInterphaseProperties().getSurfaceTension(1, 2);
                this.names[k] = "LIQUID-WATER SURFACE TENSION";
                this.units[k] = "N/M";
                this.namesKeyword[k] = "SIGHLWT";
                this.props[++k][i][j] = this.thermoSystem.getPhase(0).getEntropy() / this.thermoSystem.getPhase(0).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(0).getMolarMass();
                this.names[k] = "GAS ENTROPY";
                this.units[k] = "J/KG/K";
                this.namesKeyword[k] = "SEG";
                this.props[++k][i][j] = this.thermoSystem.getPhase(1).getEntropy() / this.thermoSystem.getPhase(1).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(1).getMolarMass();
                this.names[k] = "LIQUID ENTROPY";
                this.units[k] = "J/KG/K";
                this.namesKeyword[k] = "SEHL";
                this.props[++k][i][j] = this.thermoSystem.getPhase(2).getEntropy() / this.thermoSystem.getPhase(2).getNumberOfMolesInPhase() / this.thermoSystem.getPhase(2).getMolarMass();
                this.names[k] = "WATER ENTROPY";
                this.units[k] = "J/KG/K";
                this.namesKeyword[k] = "SEWT";
                ++k;
                ++j;
            }
            ++i;
        }
        this.bubP = this.calcBubP(this.temperatures);
        this.bubT = this.calcBubT(this.temperatures);
        logger.info("Finished creating arrays");
        this.initCalc();
    }

    @Override
    public void displayResult() {
        logger.info("TC " + this.TC + " PC " + this.PC);
        int i = 0;
        while (i < this.pressures.length) {
            this.thermoSystem.setPressure(this.pressures[i]);
            int j = 0;
            while (j < this.temperatures.length) {
                logger.info("pressure " + this.pressureLOG[i] + " temperature " + this.temperatureLOG[j]);
                ++j;
            }
            ++i;
        }
        this.writeOLGAinpFile("");
    }

    public void writeOLGAinpFile(String filename) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("C:/Users/Kjetil Raul/Documents/Master KRB/3phaseTables/testCrazyFluidKeyWaterCPA.tab"), "utf-8"));){
                writer.write("PVTTABLE LABEL = \"NewFluid\",PHASE = THREE,\\\n");
                writer.write("EOS = \"Equation\",\\\n");
                writer.write("COMPONENTS = (");
                int i = 0;
                while (i < this.molfracs.length) {
                    writer.write("\"" + this.components[i] + "\"");
                    if (i < this.molfracs.length - 1) {
                        writer.write(",");
                    }
                    ++i;
                }
                writer.write("),\\\n");
                writer.write("MOLES = (");
                i = 0;
                while (i < this.molfracs.length) {
                    writer.write(String.valueOf(this.molfracs[i]));
                    if (i < this.molfracs.length - 1) {
                        writer.write(",");
                    }
                    ++i;
                }
                writer.write("),\\\n");
                writer.write("MOLWEIGHT = (");
                i = 0;
                while (i < this.molfracs.length) {
                    writer.write(String.valueOf(this.MW[i]));
                    if (i < this.molfracs.length - 1) {
                        writer.write(",");
                    }
                    ++i;
                }
                writer.write(") g/mol,\\\n");
                writer.write("DENSITY = (");
                i = 0;
                while (i < this.molfracs.length) {
                    writer.write(String.valueOf(this.dens[i]));
                    if (i < this.molfracs.length - 1) {
                        writer.write(",");
                    }
                    ++i;
                }
                writer.write(") g/cm3,\\\n");
                writer.write("STDPRESSURE = " + this.stdPresATM + " ATM,\\" + "\n");
                writer.write("STDTEMPERATURE = " + this.stdTemp + " K,\\" + "\n");
                writer.write("GOR = " + this.GOR + " Sm3/Sm3,\\" + "\n");
                writer.write("GLR = " + this.GLR + " Sm3/Sm3,\\" + "\n");
                writer.write("STDGASDENSITY = " + this.stdGasDens + " kg/m3,\\" + "\n");
                writer.write("STDOILDENSITY = " + this.stdLiqDens + " kg/m3,\\" + "\n");
                writer.write("STDWATDENSITY = " + this.stdWatDens + " kg/m3,\\" + "\n");
                writer.write("CRITICALPRESSURE = " + this.PCLOG + " ATM,\\" + "\n");
                writer.write("CRITICALTEMPERATURE = " + this.TCLOG + " K,\\" + "\n");
                writer.write("MESHTYPE = STANDARD,TOTWATERFRACTION = (" + this.RSWTOB + "),\\" + "\n");
                writer.write("PRESSURE = (");
                i = 0;
                while (i < this.pressures.length) {
                    writer.write(String.valueOf(this.pressureLOG[i]));
                    if (i < this.pressures.length - 1) {
                        writer.write(",");
                    }
                    ++i;
                }
                writer.write(") Pa,\\\n");
                writer.write("TEMPERATURE = (");
                i = 0;
                while (i < this.temperatures.length) {
                    writer.write(String.valueOf(this.temperatureLOG[i]));
                    if (i < this.temperatures.length - 1) {
                        writer.write(",");
                    }
                    ++i;
                }
                writer.write(") C,\\\n");
                writer.write("BUBBLEPRESSURES = (");
                i = 0;
                while (i < this.temperatures.length) {
                    writer.write(String.valueOf(this.bubPLOG[i]));
                    if (i < this.temperatures.length - 1) {
                        writer.write(",");
                    }
                    ++i;
                }
                writer.write(") Pa,\\\n");
                writer.write("BUBBLETEMPERATURES = (");
                i = 0;
                while (i < this.pressures.length) {
                    writer.write(String.valueOf(this.bubTLOG[i]));
                    if (i < this.pressures.length - 1) {
                        writer.write(",");
                    }
                    ++i;
                }
                writer.write(") C,\\\n");
                writer.write("COLUMNS = (PT,TM,");
                int k = 0;
                while (k < this.nProps) {
                    writer.write(String.valueOf(this.namesKeyword[k]));
                    if (k < this.nProps - 1) {
                        writer.write(",");
                    }
                    ++k;
                }
                writer.write(")\n");
                i = 0;
                while (i < this.pressures.length) {
                    this.thermoSystem.setPressure(this.pressures[i]);
                    int j = 0;
                    while (j < this.temperatures.length) {
                        this.thermoSystem.setTemperature(this.temperatures[j]);
                        writer.write("PVTTABLE POINT = (");
                        writer.write(String.valueOf(this.pressureLOG[i]) + ",");
                        writer.write(String.valueOf(this.temperatureLOG[j]) + ",");
                        int k2 = 0;
                        while (k2 < this.nProps) {
                            writer.write(String.valueOf(this.props[k2][i][j]));
                            if (k2 < this.nProps - 1) {
                                writer.write(",");
                            }
                            ++k2;
                        }
                        writer.write(")\n");
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

