/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps;

import java.awt.FlowLayout;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import neqsim.dataPresentation.JFreeChart.graph2b;
import neqsim.dataPresentation.fileHandeling.createNetCDF.netCDF2D.NetCdf2D;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.BaseOperation;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps.sysNewtonRhapsonPhaseEnvelope2;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class pTphaseEnvelopeNew
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(pTphaseEnvelopeNew.class);
    graph2b graph2 = null;
    SystemInterface system;
    double[] cricondenTherm = new double[3];
    double[] cricondenBar = new double[3];
    double phaseFraction = 1.0E-10;
    NetCdf2D file1;
    NetCdf2D file2;
    int i;
    int j = 0;
    int nummer = 0;
    int iterations = 0;
    int maxNumberOfIterations = 10000;
    double lowPres = 1.0;
    boolean outputToFile = false;
    JProgressBar monitor;
    JFrame mainFrame;
    String fileName = "c:/file";
    JPanel mainPanel;
    double temp = 0.0;
    double pres = 0.0;
    double[][] points = new double[2][];
    double[] pointsH = new double[10000];
    double[][] pointsH2 = new double[4][];
    double[] pointsV = new double[10000];
    double[][] pointsV2 = new double[4][];
    double[] pointsS = new double[10000];
    double[][] pointsS2 = new double[4][];
    public double[][] points2 = new double[4][];
    int np = 0;
    int speceq = 0;

    public pTphaseEnvelopeNew() {
    }

    public pTphaseEnvelopeNew(SystemInterface system, String name, double phaseFraction, double lowPres) {
        this.system = system;
        this.phaseFraction = phaseFraction;
        this.lowPres = lowPres;
        if (name != null) {
            this.outputToFile = true;
            this.fileName = name;
        }
        this.mainFrame = new JFrame("Progress Bar");
        this.mainPanel = new JPanel();
        this.mainPanel.setSize(200, 100);
        this.mainFrame.getContentPane().setLayout(new FlowLayout());
        this.mainPanel.setLayout(new FlowLayout());
        this.mainFrame.setSize(200, 100);
        this.monitor = new JProgressBar(0, 0);
        this.monitor.setSize(200, 100);
        this.monitor.setStringPainted(true);
        this.mainPanel.add(this.monitor);
        this.mainFrame.getContentPane().add(this.mainPanel);
        this.mainFrame.setVisible(true);
    }

    @Override
    public void run() {
        try {
            this.points[0] = new double[10000];
            this.points[1] = new double[10000];
            this.system.setPressure(this.lowPres);
            ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
            try {
                testOps.bubblePointTemperatureFlash();
            }
            catch (Exception e) {
                e.toString();
                return;
            }
            logger.info("temperature bubT = " + this.system.getTemperature());
            sysNewtonRhapsonPhaseEnvelope2 nonLinSolver = new sysNewtonRhapsonPhaseEnvelope2(this.system);
            nonLinSolver.solve(1);
            nonLinSolver.calcInc(1);
            this.np = 1;
            while (this.np < 5) {
                if (this.np % 5 == 0) {
                    this.monitor.setValue(this.np);
                    this.monitor.setString("Calculated points: " + this.np);
                }
                nonLinSolver.calcInc(this.np);
                nonLinSolver.solve(this.np);
                if (this.system.getTemperature() > this.cricondenTherm[0]) {
                    this.cricondenTherm[1] = this.system.getPressure();
                    this.cricondenTherm[0] = this.system.getTemperature();
                }
                if (this.system.getPressure() > this.cricondenBar[1]) {
                    this.cricondenBar[0] = this.system.getTemperature();
                    this.cricondenBar[1] = this.system.getPressure();
                }
                if (Double.isNaN(this.system.getTemperature()) || Double.isNaN(this.system.getTemperature())) {
                    this.points[0][this.np - 1] = this.points[0][this.np - 3];
                    this.points[1][this.np - 1] = this.points[1][this.np - 3];
                    this.pointsH[this.np - 1] = this.pointsH[this.np - 3];
                    this.pointsV[this.np - 1] = this.pointsV[this.np - 3];
                    this.pointsS[this.np - 1] = this.pointsS[this.np - 3];
                    break;
                }
                this.points[0][this.np - 1] = this.system.getTemperature();
                this.points[1][this.np - 1] = this.system.getPressure();
                this.pointsH[this.np - 1] = this.system.getPhase(1).getEnthalpy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0;
                this.pointsV[this.np - 1] = this.system.getPhase(1).getDensity();
                this.pointsS[this.np - 1] = this.system.getPhase(1).getEntropy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0;
                ++this.np;
            }
            int ncr = nonLinSolver.getNpCrit();
            int ncr2 = this.np - ncr;
            logger.info("ncr: " + ncr + "  ncr2 . " + ncr2);
            this.points2[0] = new double[ncr + 1];
            this.points2[1] = new double[ncr + 1];
            this.pointsH2[0] = new double[ncr + 1];
            this.pointsH2[1] = new double[ncr + 1];
            this.pointsS2[0] = new double[ncr + 1];
            this.pointsS2[1] = new double[ncr + 1];
            this.pointsV2[0] = new double[ncr + 1];
            this.pointsV2[1] = new double[ncr + 1];
            if (ncr2 > 2) {
                this.points2[2] = new double[ncr2 - 2];
                this.points2[3] = new double[ncr2 - 2];
                this.pointsH2[2] = new double[ncr2 - 2];
                this.pointsH2[3] = new double[ncr2 - 2];
                this.pointsV2[2] = new double[ncr2 - 2];
                this.pointsV2[3] = new double[ncr2 - 2];
                this.pointsS2[2] = new double[ncr2 - 2];
                this.pointsS2[3] = new double[ncr2 - 2];
            } else {
                this.points2[2] = new double[0];
                this.points2[3] = new double[0];
                this.pointsH2[2] = new double[0];
                this.pointsH2[3] = new double[0];
                this.pointsV2[2] = new double[0];
                this.pointsV2[3] = new double[0];
                this.pointsS2[2] = new double[0];
                this.pointsS2[3] = new double[0];
            }
            int i = 0;
            while (i < ncr) {
                this.points2[0][i] = this.points[0][i];
                this.points2[1][i] = this.points[1][i];
                this.pointsH2[1][i] = this.points[1][i];
                this.pointsH2[0][i] = this.pointsH[i];
                this.pointsS2[1][i] = this.points[1][i];
                this.pointsS2[0][i] = this.pointsS[i];
                this.pointsV2[1][i] = this.points[1][i];
                this.pointsV2[0][i] = this.pointsV[i];
                ++i;
            }
            this.system.setTemperature(this.system.getTC() + 0.001);
            this.system.setPressure(this.system.getPC() + 0.001);
            this.system.init(3);
            this.points2[0][ncr] = this.system.getTC();
            this.points2[1][ncr] = this.system.getPC();
            this.pointsH2[1][ncr] = this.system.getPC();
            this.pointsH2[0][ncr] = this.system.getPhase(1).getEnthalpy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0;
            this.pointsS2[1][ncr] = this.system.getPC();
            this.pointsS2[0][ncr] = this.system.getPhase(1).getEntropy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0;
            this.pointsV2[1][ncr] = this.system.getPC();
            this.pointsV2[0][ncr] = this.system.getPhase(1).getDensity();
            if (ncr2 > 2) {
                this.points2[2][0] = this.system.getTC();
                this.points2[3][0] = this.system.getPC();
                this.pointsH2[3][0] = this.system.getPC();
                this.pointsH2[2][0] = this.system.getPhase(1).getEnthalpy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0;
                this.pointsS2[3][0] = this.system.getPC();
                this.pointsS2[2][0] = this.system.getPhase(1).getEntropy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0;
                this.pointsV2[3][0] = this.system.getPC();
                this.pointsV2[2][0] = this.system.getPhase(1).getDensity();
                i = 1;
                while (i < ncr2 - 2) {
                    this.points2[2][i] = this.points[0][i + ncr - 1];
                    this.points2[3][i] = this.points[1][i + ncr - 1];
                    this.pointsH2[3][i] = this.points[1][i + ncr - 1];
                    this.pointsH2[2][i] = this.pointsH[i + ncr - 1];
                    this.pointsS2[3][i] = this.points[1][i + ncr - 1];
                    this.pointsS2[2][i] = this.pointsS[i + ncr - 1];
                    this.pointsV2[3][i] = this.points[1][i + ncr - 1];
                    this.pointsV2[2][i] = this.pointsV[i + ncr - 1];
                    ++i;
                }
            }
            this.mainFrame.setVisible(false);
            if (this.outputToFile) {
                String name1 = new String();
                name1 = String.valueOf(this.fileName) + "Dew.nc";
                this.file1 = new NetCdf2D();
                this.file1.setOutputFileName(name1);
                this.file1.setXvalues(this.points2[2], "temp", "sec");
                this.file1.setYvalues(this.points2[3], "pres", "meter");
                this.file1.createFile();
                String name2 = new String();
                name2 = String.valueOf(this.fileName) + "Bub.nc";
                this.file2 = new NetCdf2D();
                this.file2.setOutputFileName(name2);
                this.file2.setXvalues(this.points2[0], "temp", "sec");
                this.file2.setYvalues(this.points2[1], "pres", "meter");
                this.file2.createFile();
            }
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
    }

    @Override
    public void displayResult() {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(1);
        nf.applyPattern("####.#");
        double TC = this.system.getTC();
        double PC = this.system.getPC();
        logger.info("tc : " + TC + "  PC : " + PC);
        String[] navn = new String[]{"bubble point", "dew point", "bubble point", "dew point"};
        String title = "PT-graph  TC=" + String.valueOf(nf.format(TC)) + " PC=" + String.valueOf(nf.format(PC));
        String title3 = "PH-graph  TC=" + String.valueOf(nf.format(TC)) + " PC=" + String.valueOf(nf.format(PC));
        String title4 = "Density-graph  TC=" + String.valueOf(nf.format(TC)) + " PC=" + String.valueOf(nf.format(PC));
        String title5 = "PS-graph  TC=" + String.valueOf(nf.format(TC)) + " PC=" + String.valueOf(nf.format(PC));
        graph2b graph3 = new graph2b(this.pointsH2, navn, title3, "Enthalpy [kJ/kg]", "Pressure [bara]");
        graph3.setVisible(true);
        graph3.saveFigure("c:/temp/NeqSimTempFig4.png");
        graph2b graph4 = new graph2b(this.pointsV2, navn, title4, "Density [kg/m^3]", "Pressure [bara]");
        graph4.setVisible(true);
        graph4.saveFigure("c:/temp/NeqSimTempFig2.png");
        graph2b graph5 = new graph2b(this.pointsS2, navn, title5, "Entropy [kJ/kg*K]", "Pressure [bara]");
        graph5.setVisible(true);
        graph5.saveFigure("c:/temp/NeqSimTempFig3.png");
        this.graph2 = new graph2b(this.points2, navn, title, "Temperature [K]", "Pressure [bara]");
        this.graph2.setVisible(true);
        this.graph2.saveFigure("c:/temp/NeqSimTempFig1.png");
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(1);
        nf.applyPattern("####.#");
        double TC = this.system.getTC();
        double PC = this.system.getPC();
        logger.info("tc : " + TC + "  PC : " + PC);
        String[] navn = new String[]{"bubble point", "dew point", "bubble point", "dew point"};
        String title = "PT-graph. TC=" + String.valueOf(nf.format(TC)) + "K, PC=" + String.valueOf(String.valueOf(nf.format(PC)) + " bara");
        this.graph2 = new graph2b(this.points2, navn, title, "Temperature [K]", "Pressure [bara]");
        return this.graph2.getChart();
    }

    @Override
    public double[][] getPoints(int i) {
        return this.points2;
    }

    @Override
    public double[] get(String name) {
        if (name.equals("bubT")) {
            return this.points2[0];
        }
        if (name.equals("bubP")) {
            return this.points2[1];
        }
        if (name.equals("dewT")) {
            return this.points2[2];
        }
        if (name.equals("dewP")) {
            return this.points2[3];
        }
        if (name.equals("dewH")) {
            return this.pointsH2[2];
        }
        if (name.equals("dewDens")) {
            return this.pointsV2[2];
        }
        if (name.equals("dewS")) {
            return this.pointsS2[2];
        }
        if (name.equals("bubH")) {
            return this.pointsH2[0];
        }
        if (name.equals("bubDens")) {
            return this.pointsV2[0];
        }
        if (name.equals("bubS")) {
            return this.pointsS2[0];
        }
        if (name.equals("cricondentherm")) {
            return this.cricondenTherm;
        }
        if (name.equals("cricondenbar")) {
            return this.cricondenBar;
        }
        return null;
    }

    @Override
    public void createNetCdfFile(String name) {
        this.fileName = name;
    }

    @Override
    public String[][] getResultTable() {
        return null;
    }
}

