/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps;

import Jama.Matrix;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps.pTphaseEnvelope;

public class CricondenThermFlash
extends pTphaseEnvelope {
    private static final long serialVersionUID = 1000L;
    int neq = 0;
    Matrix u;
    Matrix uold;
    Matrix uini;
    SystemInterface system;
    int numberOfComponents;
    int crico = 0;
    double DP = 1.0E-6;
    double funcT;
    double dfuncdT;
    double funcP;
    double dfuncdP;
    double f;
    double f1;
    double dfdp;
    double dfdp1;
    double DDQ;
    double T;
    double P;
    double Tini;
    double Pini;
    double P1;
    int ITER;
    int ITERX;
    int ITERT;
    int ITERP;

    public CricondenThermFlash() {
    }

    public CricondenThermFlash(SystemInterface system, String name, double phaseFraction, double[] cricondenTherm, double[] cricondenThermX, double[] cricondenThermY) {
        this.system = system;
        this.numberOfComponents = system.getPhase(0).getNumberOfComponents();
        this.u = new Matrix(this.numberOfComponents, 1);
        this.cricondenTherm = cricondenTherm;
        this.cricondenThermX = cricondenThermX;
        this.cricondenThermY = cricondenThermY;
        this.bubblePointFirst = false;
    }

    @Override
    public void run() {
        this.T = this.cricondenTherm[0];
        this.P = this.cricondenTherm[1];
        this.Tini = this.T;
        this.Pini = this.P;
        int ii = 0;
        while (ii < this.numberOfComponents) {
            this.u.set(ii, 0, this.cricondenThermY[ii] / this.cricondenThermX[ii]);
            this.system.getPhase(0).getComponent(ii).setK(this.cricondenThermY[ii] / this.cricondenThermX[ii]);
            this.system.getPhase(0).getComponent(ii).setx(this.cricondenThermX[ii]);
            this.system.getPhase(1).getComponent(ii).setx(this.cricondenThermY[ii]);
            this.uini = this.u.copy();
            ++ii;
        }
        this.setNewX();
        int iter = 0;
        while (iter < 1000) {
            int iterP = 0;
            while (iterP <= 1000) {
                this.system.setTemperature(this.T);
                this.system.setPressure(this.P);
                this.init();
                this.funcP();
                this.f = this.funcP;
                this.dfdp = this.dfuncdP;
                this.P1 = this.P + this.DP;
                this.system.setTemperature(this.T);
                this.system.setPressure(this.P1);
                this.init();
                this.funcP();
                this.f1 = this.funcP;
                this.dfdp1 = this.dfuncdP;
                this.DDQ = (this.dfdp1 - this.dfdp) / this.DP;
                if (iterP == 1000) {
                    this.ITERP = -1;
                    break;
                }
                if (Math.abs(this.dfdp / this.DDQ) < 1.0E-7) {
                    this.ITERP = iterP;
                    break;
                }
                if (Math.abs(this.dfdp) < 1.0E-7) {
                    this.ITERP = iterP;
                    break;
                }
                this.P -= this.dfdp / this.DDQ;
                ++iterP;
            }
            int iterT = 0;
            while (iterT <= 10000) {
                this.system.setTemperature(this.T);
                this.system.setPressure(this.P);
                this.uold = this.u.copy();
                this.init();
                this.setNewK();
                double sumK = 0.0;
                int i = 0;
                while (i < this.numberOfComponents) {
                    sumK += (this.uold.get(i, 0) - this.u.get(i, 0)) * (this.uold.get(i, 0) - this.u.get(i, 0));
                    ++i;
                }
                this.setNewX();
                this.init();
                this.funcT();
                if (Math.abs(this.funcT / this.dfuncdT) < 1.0E-7 || sumK <= 1.0E-10) {
                    this.ITERT = iterT;
                    break;
                }
                this.T -= this.funcT / this.dfuncdT;
                if (this.T <= 0.0) {
                    this.T += this.funcP / this.dfuncdT;
                    this.u = this.u.copy();
                    this.setNewX();
                    break;
                }
                if (iterT == 10000) {
                    this.ITERT = -1;
                    break;
                }
                ++iterT;
            }
            this.system.setTemperature(this.T);
            this.system.setPressure(this.P);
            this.init();
            this.funcT();
            this.funcP();
            if (Math.abs(this.dfuncdP) <= 1.0E-7 && Math.abs(this.funcT) <= 1.0E-7 && Math.abs(this.dfuncdT) >= 1.0E-7) {
                this.cricondenTherm[0] = this.T;
                this.cricondenTherm[1] = this.P;
                break;
            }
            if (Math.abs(this.dfuncdP) <= 1.0E-7 && Math.abs(this.funcT) <= 1.0E-7 && Math.abs(this.dfuncdT) <= 1.0E-7) {
                this.T = -1.0;
                this.P = -1.0;
                this.cricondenTherm[0] = this.T;
                this.cricondenTherm[1] = this.P;
                break;
            }
            ++iter;
        }
    }

    public void setNewK() {
        int j = 0;
        while (j < this.numberOfComponents) {
            double kap = this.system.getPhase(0).getComponent(j).getFugacityCoefficient() / this.system.getPhase(1).getComponent(j).getFugacityCoefficient();
            this.system.getPhase(0).getComponents()[j].setK(kap);
            this.u.set(j, 0, kap);
            ++j;
        }
    }

    public void setNewX() {
        double sumx = 0.0;
        double sumy = 0.0;
        double[] xx = new double[this.numberOfComponents];
        double[] yy = new double[this.numberOfComponents];
        int j = 0;
        while (j < this.numberOfComponents) {
            xx[j] = this.system.getPhase(0).getComponents()[j].getz() / (1.0 - this.system.getBeta() + this.system.getBeta() * this.u.get(j, 0));
            yy[j] = this.system.getPhase(1).getComponents()[j].getz() * this.u.get(j, 0) / (1.0 - this.system.getBeta() + this.system.getBeta() * this.u.get(j, 0));
            xx[j] = this.system.getPhase(0).getComponents()[j].getz() / (1.0 - this.system.getBeta() + this.system.getBeta() * this.system.getPhase(0).getComponents()[j].getK());
            yy[j] = this.system.getPhase(1).getComponents()[j].getz() * this.system.getPhase(0).getComponents()[j].getK() / (1.0 - this.system.getBeta() + this.system.getBeta() * this.system.getPhase(0).getComponents()[j].getK());
            sumx += xx[j];
            sumy += yy[j];
            ++j;
        }
        j = 0;
        while (j < this.numberOfComponents) {
            this.system.getPhase(0).getComponents()[j].setx(xx[j] / sumx);
            this.system.getPhase(1).getComponents()[j].setx(yy[j] / sumy);
            xx[j] = this.system.getPhase(0).getComponents()[j].getx();
            yy[j] = this.system.getPhase(1).getComponents()[j].getx();
            ++j;
        }
    }

    public void init() {
        this.system.init(3);
    }

    public void funcT() {
        this.funcT = -1.0;
        this.dfuncdT = 0.0;
        int j = 0;
        while (j < this.numberOfComponents) {
            double xxf = this.system.getPhase(0).getComponent(j).getx();
            double yyf = this.system.getPhase(1).getComponent(j).getx();
            double fugl = this.system.getPhase(0).getComponent(j).getLogFugacityCoefficient();
            double fugv = this.system.getPhase(1).getComponent(j).getLogFugacityCoefficient();
            double fugTl = this.system.getPhase(0).getComponent(j).getdfugdt();
            double fugTv = this.system.getPhase(1).getComponent(j).getdfugdt();
            this.funcT = this.funcT + xxf + xxf * (Math.log(yyf) - Math.log(xxf) + fugv - fugl);
            this.dfuncdT += xxf * (fugTv - fugTl);
            ++j;
        }
    }

    public void funcP() {
        this.funcP = -1.0;
        this.dfuncdP = 0.0;
        int j = 0;
        while (j < this.numberOfComponents) {
            double xx = this.system.getPhase(0).getComponent(j).getx();
            double yy = this.system.getPhase(1).getComponent(j).getx();
            double fugl = this.system.getPhase(0).getComponents()[j].getLogFugacityCoefficient();
            double fugv = this.system.getPhase(1).getComponents()[j].getLogFugacityCoefficient();
            double fugPl = this.system.getPhase(0).getComponents()[j].getdfugdp();
            double fugPv = this.system.getPhase(1).getComponents()[j].getdfugdp();
            this.funcP = this.funcP + xx + xx * (Math.log(yy) - Math.log(xx) + fugv - fugl);
            this.dfuncdP += xx * (fugPv - fugPl);
            ++j;
        }
    }
}

