/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyFlash;
import org.jfree.chart.JFreeChart;

public class constantDutyPressureFlash
extends constantDutyFlash {
    private static final long serialVersionUID = 1000L;

    public constantDutyPressureFlash() {
    }

    public constantDutyPressureFlash(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(0);
        }
        int iterations = 0;
        double deriv = 0.0;
        double funk = 0.0;
        double dkidp = 0.0;
        double dyidp = 0.0;
        double dxidp = 0.0;
        double Pold = 0.0;
        do {
            this.system.init(2);
            ++iterations;
            int i = 0;
            while (i < this.system.getPhases()[0].getNumberOfComponents()) {
                this.system.getPhases()[0].getComponents()[i].setK(this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient() / this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient());
                this.system.getPhases()[1].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getK());
                ++i;
            }
            this.system.calc_x_y_nonorm();
            funk = 0.0;
            deriv = 0.0;
            i = 0;
            while (i < this.system.getPhases()[0].getNumberOfComponents()) {
                dkidp = (this.system.getPhases()[1].getComponents()[i].getdfugdp() - this.system.getPhases()[0].getComponents()[i].getdfugdp()) * this.system.getPhases()[1].getComponents()[i].getK();
                dxidp = -this.system.getPhases()[1].getComponents()[i].getz() * this.system.getBeta() * dkidp / Math.pow(1.0 - this.system.getBeta() + this.system.getBeta() * this.system.getPhases()[1].getComponents()[i].getK(), 2.0);
                dyidp = dkidp * this.system.getPhases()[1].getComponents()[i].getx() + this.system.getPhases()[1].getComponents()[i].getK() * dxidp;
                funk += this.system.getPhases()[0].getComponents()[i].getx() - this.system.getPhases()[1].getComponents()[i].getx();
                deriv += dyidp - dxidp;
                ++i;
            }
            Pold = this.system.getPressure();
            double pres = Math.abs(Pold - 0.5 * funk / deriv);
            this.system.setPressure(pres);
        } while (Math.abs((this.system.getPressure() - Pold) / this.system.getPressure()) > 1.0E-10 && iterations < 300 || iterations < 3);
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.system;
    }
}

