/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WATcalc
extends constantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(WATcalc.class);

    public WATcalc() {
    }

    public WATcalc(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        double sumx = 0.0;
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        int iter = 0;
        double funkOld = 0.0;
        double deltaT = 1.0;
        double[] Ksolid = new double[this.system.getPhase(0).getNumberOfComponents()];
        int i = 0;
        while (i < this.system.getPhase(0).getNumberOfComponents()) {
            this.system.getPhases()[5].getComponent(i).setx(1.0);
            Ksolid[i] = 1.0;
            ++i;
        }
        do {
            ++iter;
            ops.TPflash();
            sumx = 0.0;
            i = 0;
            while (i < this.system.getPhase(0).getNumberOfComponents()) {
                this.system.getPhases()[5].getComponent(i).setx(Ksolid[i] * this.system.getPhase(0).getComponent(i).getx());
                Ksolid[i] = this.system.getPhase(0).getComponent(i).getFugacityCoefficient() / this.system.getPhases()[5].getComponent(i).fugcoef(this.system.getPhases()[5]);
                sumx += Ksolid[i] * this.system.getPhase(0).getComponent(i).getx();
                ++i;
            }
            double funk = sumx - 1.0;
            double dfunkdt = (funk - funkOld) / deltaT;
            funkOld = funk;
            double dT = -funk / dfunkdt;
            double oldTemp = this.system.getTemperature();
            if (iter > 1) {
                this.system.setTemperature(this.system.getTemperature() + dT * (double)iter * 1.0 / (5.0 + (double)iter));
            } else {
                this.system.setTemperature(this.system.getTemperature() - 0.1);
            }
            deltaT = this.system.getTemperature() - oldTemp;
        } while (Math.abs(sumx - 1.0) > 1.0E-8 && iter < 100);
        this.system.setNumberOfPhases(this.system.getNumberOfPhases() + 1);
        this.system.setPhaseIndex(this.system.getNumberOfPhases() - 1, 5);
        this.system.setBeta(this.system.getNumberOfPhases() - 1, 1.0E-10);
        this.system.init(3);
    }

    @Override
    public void printToFile(String name) {
    }
}

