/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import neqsim.thermo.component.ComponentHydrate;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HydrateFormationPressureFlash
extends constantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(HydrateFormationPressureFlash.class);

    public HydrateFormationPressureFlash() {
    }

    public HydrateFormationPressureFlash(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        double olfFug = 0.0;
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        this.system.getPhase(4).getComponent("water").setx(1.0);
        this.system.init(0);
        this.system.init(1);
        int iter = 0;
        do {
            ++iter;
            olfFug = this.system.getPhase(4).getFugacity("water");
            this.setFug();
            ops.TPflash();
            this.system.init(1);
            this.system.getPhase(4).getComponent("water").setx(1.0);
            logger.info("diff " + this.system.getPhase(4).getFugacity("water") / this.system.getPhase(0).getFugacity("water"));
            this.system.setPressure(this.system.getPressure() * (this.system.getPhase(4).getFugacity("water") / this.system.getPhase(0).getFugacity("water")));
            logger.info("pressure " + this.system.getPressure());
        } while (Math.abs((olfFug - this.system.getPhase(4).getFugacity("water")) / olfFug) > 1.0E-8 && iter < 100);
        logger.info("end");
    }

    public void setFug() {
        int j = 0;
        while (j < this.system.getPhase(0).getNumberOfComponents()) {
            int i = 0;
            while (i < this.system.getPhase(0).getNumberOfComponents()) {
                ((ComponentHydrate)this.system.getPhase(4).getComponent(j)).setRefFug(i, this.system.getPhase(0).getFugacity(i));
                ++i;
            }
            ++j;
        }
        this.system.getPhase(4).getComponent("water").fugcoef(this.system.getPhase(4));
        this.system.getPhase(4).getComponent("water").setx(1.0);
    }

    @Override
    public void printToFile(String name) {
    }
}

