/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.PHflash;
import org.jfree.chart.JFreeChart;

public class VHflash
extends Flash {
    private static final long serialVersionUID = 1000L;
    double Hspec = 0.0;
    double Vspec = 0.0;
    Flash pHFlash;

    public VHflash() {
    }

    public VHflash(SystemInterface system, double Hspec, double Vspec) {
        this.system = system;
        this.pHFlash = new PHflash(system, Hspec, 0);
        this.Hspec = Hspec;
        this.Vspec = Vspec;
    }

    @Override
    public void run() {
        double newVol = this.system.getVolume();
        double err = 0.0;
        int iterations = 0;
        double wallHeat = 0.0;
        int i = 0;
        while (i < 1) {
            wallHeat = (double)(0 * i) / 20.0 * 400.0 * 1295.0 * 1000.0 * (293.15 - this.system.getTemperature());
            iterations = 1;
            do {
                this.pHFlash = new PHflash(this.system, this.Hspec + wallHeat, 0);
                this.pHFlash.run();
                newVol = this.system.getVolume();
                err = (newVol - this.Vspec) / this.Vspec;
                if (++iterations < -5) {
                    this.system.setPressure(this.system.getPressure() + err / 10.0);
                    continue;
                }
                this.system.setPressure(this.system.getPressure() - 0.6 / this.system.getdVdPtn() * (newVol - this.Vspec));
            } while (Math.abs(err) > 1.0E-10 && iterations < 1000 || iterations < 7);
            ++i;
        }
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

