/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import Jama.Matrix;
import java.util.ArrayList;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TPmultiflash_1
extends TPflash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TPmultiflash_1.class);
    boolean multiPhaseTest = false;
    double[] dQdbeta;
    double[][] Qmatrix;
    double[] E;
    double Q = 0.0;

    public TPmultiflash_1() {
    }

    public TPmultiflash_1(SystemInterface system) {
        super(system);
    }

    public TPmultiflash_1(SystemInterface system, boolean check) {
        super(system, check);
    }

    public void calcMultiPhaseBeta() {
    }

    public void setXY() {
        int k = 0;
        while (k < this.system.getNumberOfPhases()) {
            int i = 0;
            while (i < this.system.getPhases()[0].getNumberOfComponents()) {
                this.system.getPhases()[k].getComponents()[i].setx(this.system.getPhases()[k].getComponents()[i].getz() / this.E[i] / this.system.getPhases()[k].getComponents()[i].getFugacityCoefficient());
                ++i;
            }
            ++k;
        }
    }

    public void calcE() {
        this.E = new double[this.system.getPhases()[0].getNumberOfComponents()];
        int i = 0;
        while (i < this.system.getPhases()[0].getNumberOfComponents()) {
            int k = 0;
            while (k < this.system.getNumberOfPhases()) {
                int n = i;
                this.E[n] = this.E[n] + this.system.getPhases()[k].getBeta() / this.system.getPhases()[k].getComponents()[i].getFugacityCoefficient();
                ++k;
            }
            ++i;
        }
    }

    public double calcQ() {
        this.Q = 0.0;
        double betaTotal = 0.0;
        this.dQdbeta = new double[this.system.getNumberOfPhases()];
        this.Qmatrix = new double[this.system.getNumberOfPhases()][this.system.getNumberOfPhases()];
        int k = 0;
        while (k < this.system.getNumberOfPhases()) {
            betaTotal += this.system.getPhases()[k].getBeta();
            ++k;
        }
        this.Q = betaTotal;
        this.calcE();
        int i = 0;
        while (i < this.system.getPhases()[0].getNumberOfComponents()) {
            this.Q -= Math.log(this.E[i]) * this.system.getPhases()[0].getComponents()[i].getz();
            ++i;
        }
        k = 0;
        while (k < this.system.getNumberOfPhases()) {
            this.dQdbeta[k] = 1.0;
            int i2 = 0;
            while (i2 < this.system.getPhases()[0].getNumberOfComponents()) {
                int n = k;
                this.dQdbeta[n] = this.dQdbeta[n] - this.system.getPhases()[0].getComponents()[i2].getz() * 1.0 / this.E[i2] / this.system.getPhases()[k].getComponents()[i2].getFugacityCoefficient();
                ++i2;
            }
            ++k;
        }
        i = 0;
        while (i < this.system.getNumberOfPhases()) {
            int j = 0;
            while (j < this.system.getNumberOfPhases()) {
                this.Qmatrix[i][j] = 0.0;
                int k2 = 0;
                while (k2 < this.system.getPhases()[0].getNumberOfComponents()) {
                    double[] dArray = this.Qmatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.system.getPhases()[0].getComponents()[k2].getz() / (this.E[k2] * this.E[k2] * this.system.getPhases()[j].getComponents()[k2].getFugacityCoefficient() * this.system.getPhases()[i].getComponents()[k2].getFugacityCoefficient());
                    ++k2;
                }
                ++j;
            }
            ++i;
        }
        return this.Q;
    }

    public void solveBeta() {
        Matrix ans;
        double[] oldBeta = new double[this.system.getNumberOfPhases()];
        int iter = 1;
        do {
            ++iter;
            int k = 0;
            while (k < this.system.getNumberOfPhases()) {
                oldBeta[k] = this.system.getPhases()[k].getBeta();
                ++k;
            }
            this.calcQ();
            Matrix betaMatrix = new Matrix(oldBeta, 1).transpose();
            Matrix dQM = new Matrix(this.dQdbeta, 1);
            Matrix dQdBM = new Matrix(this.Qmatrix);
            ans = dQdBM.solve(dQM.transpose());
            betaMatrix.minusEquals(ans.times((double)iter / ((double)iter + 20.0)));
            betaMatrix.print(10, 2);
            int k2 = 0;
            while (k2 < this.system.getNumberOfPhases()) {
                this.system.setBeta(k2, betaMatrix.get(k2, 0));
                if (betaMatrix.get(k2, 0) < 0.0) {
                    this.system.setBeta(k2, 1.0E-9);
                }
                if (betaMatrix.get(k2, 0) > 1.0) {
                    this.system.setBeta(k2, 0.999999999);
                }
                ++k2;
            }
            this.calcE();
            this.setXY();
            this.system.init(1);
        } while (ans.norm2() > 1.0E-6);
    }

    @Override
    public void stabilityAnalysis() {
        double[] logWi = new double[this.system.getPhases()[1].getNumberOfComponents()];
        double[][] Wi = new double[this.system.getPhases()[1].getNumberOfComponents()][this.system.getPhases()[0].getNumberOfComponents()];
        double[] sumw = new double[this.system.getPhases()[1].getNumberOfComponents()];
        double err = 0.0;
        double[] oldlogw = new double[this.system.getPhases()[1].getNumberOfComponents()];
        double[] d = new double[this.system.getPhases()[1].getNumberOfComponents()];
        double[][] x = new double[this.system.getPhases()[1].getNumberOfComponents()][this.system.getPhases()[0].getNumberOfComponents()];
        ArrayList<SystemInterface> clonedSystem = new ArrayList<SystemInterface>(1);
        SystemInterface minimumGibbsEnergySystem = this.system.clone();
        int i = 0;
        while (i < this.system.getPhases()[1].getNumberOfComponents()) {
            double numb = 0.0;
            clonedSystem.add(this.system.clone());
            ((SystemInterface)clonedSystem.get(i)).init(0);
            int j = 0;
            while (j < this.system.getPhases()[1].getNumberOfComponents()) {
                numb = i == j ? 1.0 : 0.001;
                ((SystemInterface)clonedSystem.get(i)).getPhases()[1].getComponents()[j].setx(numb);
                ++j;
            }
            ((SystemInterface)clonedSystem.get(i)).init(1);
            ++i;
        }
        this.lowestGibbsEnergyPhase = 0;
        int k = 0;
        while (k < minimumGibbsEnergySystem.getPhases()[1].getNumberOfComponents()) {
            int i2 = 0;
            while (i2 < minimumGibbsEnergySystem.getPhases()[1].getNumberOfComponents()) {
                int n = k;
                sumw[n] = sumw[n] + ((SystemInterface)clonedSystem.get(k)).getPhases()[1].getComponents()[i2].getx();
                ++i2;
            }
            ++k;
        }
        k = 0;
        while (k < minimumGibbsEnergySystem.getPhases()[1].getNumberOfComponents()) {
            int i3 = 0;
            while (i3 < minimumGibbsEnergySystem.getPhases()[1].getNumberOfComponents()) {
                ((SystemInterface)clonedSystem.get(k)).getPhases()[1].getComponents()[i3].setx(((SystemInterface)clonedSystem.get(k)).getPhases()[1].getComponents()[i3].getx() / sumw[0]);
                ++i3;
            }
            d[k] = Math.log(minimumGibbsEnergySystem.getPhases()[this.lowestGibbsEnergyPhase].getComponents()[k].getx()) + Math.log(minimumGibbsEnergySystem.getPhases()[this.lowestGibbsEnergyPhase].getComponents()[k].getFugacityCoefficient());
            ++k;
        }
        int j = 0;
        while (j < minimumGibbsEnergySystem.getPhases()[1].getNumberOfComponents()) {
            logWi[j] = 1.0;
            ++j;
        }
        j = 0;
        while (j < this.system.getPhases()[1].getNumberOfComponents()) {
            int i4;
            do {
                err = 0.0;
                ((SystemInterface)clonedSystem.get(j)).init(1);
                i4 = 0;
                while (i4 < this.system.getPhases()[1].getNumberOfComponents()) {
                    oldlogw[i4] = logWi[i4];
                    logWi[i4] = d[i4] - Math.log(((SystemInterface)clonedSystem.get(j)).getPhases()[1].getComponents()[i4].getFugacityCoefficient());
                    err += Math.abs(logWi[i4] - oldlogw[i4]);
                    Wi[j][i4] = Math.exp(logWi[i4]);
                    ++i4;
                }
                sumw[j] = 0.0;
                i4 = 0;
                while (i4 < this.system.getPhases()[1].getNumberOfComponents()) {
                    int n = j;
                    sumw[n] = sumw[n] + Math.exp(logWi[i4]);
                    ++i4;
                }
                i4 = 0;
                while (i4 < this.system.getPhases()[1].getNumberOfComponents()) {
                    ((SystemInterface)clonedSystem.get(j)).getPhases()[1].getComponents()[i4].setx(Math.exp(logWi[i4]) / sumw[j]);
                    ++i4;
                }
            } while (Math.abs(err) > 1.0E-9);
            this.tm[j] = 1.0;
            i4 = 0;
            while (i4 < this.system.getPhases()[1].getNumberOfComponents()) {
                int n = j;
                this.tm[n] = this.tm[n] - Math.exp(logWi[i4]);
                x[j][i4] = ((SystemInterface)clonedSystem.get(j)).getPhases()[1].getComponents()[i4].getx();
                ++i4;
            }
            logger.info("tm: " + this.tm[j]);
            ++j;
        }
        int unstabcomp = 0;
        int k2 = 0;
        while (k2 < this.system.getPhases()[1].getNumberOfComponents()) {
            if (this.tm[k2] < -1.0E-8 && !Double.isNaN(this.tm[k2])) {
                this.system.addPhase();
                unstabcomp = k2;
                int i5 = 0;
                while (i5 < this.system.getPhases()[1].getNumberOfComponents()) {
                    this.system.getPhases()[2].getComponents()[i5].setx(x[k2][i5]);
                    ++i5;
                }
                this.multiPhaseTest = true;
                this.system.setBeta(this.system.getNumberOfPhases() - 1, this.system.getPhase(0).getComponent(unstabcomp).getz());
                return;
            }
            ++k2;
        }
    }

    @Override
    public void run() {
        logger.info("Starting multiphase-flash....");
        this.stabilityAnalysis();
        this.system.init(1);
        if (this.multiPhaseTest && !this.system.isChemicalSystem()) {
            this.solveBeta();
        }
        double chemdev = 0.0;
        if (this.system.isChemicalSystem()) {
            int phase = 0;
            while (phase < this.system.getNumberOfPhases()) {
                chemdev = 0.0;
                double[] xchem = new double[this.system.getPhases()[phase].getNumberOfComponents()];
                this.i = 0;
                while (this.i < this.system.getPhases()[0].getNumberOfComponents()) {
                    xchem[this.i] = this.system.getPhases()[phase].getComponents()[this.i].getx();
                    ++this.i;
                }
                this.system.init(1);
                this.system.getChemicalReactionOperations().solveChemEq(phase, 1);
                this.i = 0;
                while (this.i < this.system.getPhases()[0].getNumberOfComponents()) {
                    chemdev += Math.abs(xchem[this.i] - this.system.getPhases()[phase].getComponents()[this.i].getx());
                    ++this.i;
                }
                logger.info("chemdev: " + chemdev);
                ++phase;
            }
        }
    }
}

