/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import Jama.Matrix;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolidFlash
extends TPflash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SolidFlash.class);
    boolean multiPhaseTest = false;
    double[] dQdbeta;
    double[][] Qmatrix;
    double[] E;
    double Q = 0.0;
    int solidComponent = 0;
    boolean hasRemovedPhase = false;
    boolean secondTime = false;

    public SolidFlash() {
    }

    public SolidFlash(SystemInterface system) {
        super(system);
    }

    public void setSolidComponent(int i) {
        this.solidComponent = i;
    }

    public SolidFlash(SystemInterface system, boolean check) {
        super(system, check);
    }

    public void calcMultiPhaseBeta() {
    }

    public void setXY() {
        int k = 0;
        while (k < this.system.getNumberOfPhases() - 1) {
            int i = 0;
            while (i < this.system.getPhases()[0].getNumberOfComponents()) {
                this.system.getPhase(k).getComponent(i).setx(this.system.getPhase(0).getComponent(i).getz() / this.E[i] / this.system.getPhase(k).getComponent(i).getFugacityCoefficient());
                ++i;
            }
            this.system.getPhase(k).normalize();
            ++k;
        }
    }

    public void checkX() {
        int k = 0;
        while (k < this.system.getNumberOfPhases() - 1) {
            double x = 0.0;
            int i = 0;
            while (i < this.system.getPhases()[0].getNumberOfComponents()) {
                x += this.system.getPhase(k).getComponent(i).getx();
                ++i;
            }
            if (x < 0.999999) {
                this.system.setBeta(this.system.getNumberOfPhases() - 2, this.system.getBeta(this.system.getNumberOfPhases() - 1));
                this.system.setBeta(0, 1.0 - this.system.getBeta(this.system.getNumberOfPhases() - 1));
                this.system.setNumberOfPhases(this.system.getNumberOfPhases() - 1);
                this.system.setPhaseIndex(this.system.getNumberOfPhases() - 1, 3);
                this.system.init(1);
                this.calcE();
                this.setXY();
                return;
            }
            ++k;
        }
    }

    public void calcE() {
        this.E = new double[this.system.getPhases()[0].getNumberOfComponents()];
        int i = 0;
        while (i < this.system.getPhases()[0].getNumberOfComponents()) {
            this.E[i] = 0.0;
            int k = 0;
            while (k < this.system.getNumberOfPhases() - 1) {
                int n = i;
                this.E[n] = this.E[n] + this.system.getBeta(k) / this.system.getPhase(k).getComponent(i).getFugacityCoefficient();
                ++k;
            }
            ++i;
        }
        this.E[this.solidComponent] = this.system.getPhase(0).getComponent(this.solidComponent).getz() / this.system.getPhases()[3].getComponents()[this.solidComponent].getFugacityCoefficient();
    }

    public double calcQ() {
        this.Q = 0.0;
        double betaTotal = 0.0;
        this.dQdbeta = new double[this.system.getNumberOfPhases() - 1];
        this.Qmatrix = new double[this.system.getNumberOfPhases() - 1][this.system.getNumberOfPhases() - 1];
        int k = 0;
        while (k < this.system.getNumberOfPhases()) {
            betaTotal += this.system.getBeta(k);
            ++k;
        }
        this.Q = betaTotal;
        int i = 0;
        while (i < this.system.getPhases()[0].getNumberOfComponents()) {
            this.Q -= Math.log(this.E[i]) * this.system.getPhase(0).getComponents()[i].getz();
            ++i;
        }
        k = 0;
        while (k < this.system.getNumberOfPhases() - 1) {
            this.dQdbeta[k] = 1.0 - this.system.getPhases()[3].getComponents()[this.solidComponent].getFugacityCoefficient() / this.system.getPhase(k).getComponent(this.solidComponent).getFugacityCoefficient();
            int i2 = 0;
            while (i2 < this.system.getPhases()[0].getNumberOfComponents()) {
                if (i2 != this.solidComponent) {
                    int n = k;
                    this.dQdbeta[n] = this.dQdbeta[n] - this.system.getPhase(0).getComponent(i2).getz() * 1.0 / this.E[i2] / this.system.getPhase(k).getComponent(i2).getFugacityCoefficient();
                }
                ++i2;
            }
            ++k;
        }
        i = 0;
        while (i < this.system.getNumberOfPhases() - 1) {
            this.Qmatrix[i][i] = 1.0E-9;
            int j = 0;
            while (j < this.system.getNumberOfPhases() - 1) {
                if (i != j) {
                    this.Qmatrix[i][j] = 0.0;
                }
                int k2 = 0;
                while (k2 < this.system.getPhases()[0].getNumberOfComponents()) {
                    if (k2 != this.solidComponent) {
                        double[] dArray = this.Qmatrix[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.system.getPhase(0).getComponent(k2).getz() / (this.E[k2] * this.E[k2] * this.system.getPhase(j).getComponent(k2).getFugacityCoefficient() * this.system.getPhase(i).getComponent(k2).getFugacityCoefficient());
                    }
                    ++k2;
                }
                ++j;
            }
            ++i;
        }
        return this.Q;
    }

    public void solveBeta(boolean ideal) {
        double[] oldBeta = new double[this.system.getNumberOfPhases() - 1];
        int iter = 0;
        Matrix ans = new Matrix(this.system.getNumberOfPhases() - 1, 1);
        do {
            if (!ideal) {
                this.system.init(1);
            }
            this.calcE();
            this.calcQ();
            oldBeta = new double[this.system.getNumberOfPhases() - 1];
            ++iter;
            int k = 0;
            while (k < this.system.getNumberOfPhases() - 1) {
                oldBeta[k] = this.system.getBeta(k);
                ++k;
            }
            Matrix betaMatrix = new Matrix(oldBeta, 1).transpose();
            Matrix dQM = new Matrix(this.dQdbeta, 1);
            Matrix dQdBM = new Matrix(this.Qmatrix);
            try {
                ans = dQdBM.solve(dQM.transpose());
            }
            catch (Exception exception) {
                // empty catch block
            }
            betaMatrix.minusEquals(ans.times(((double)iter + 1.0) / (10.0 + (double)iter)));
            int k2 = 0;
            while (k2 < this.system.getNumberOfPhases() - 1) {
                this.system.setBeta(k2, betaMatrix.get(k2, 0));
                if (betaMatrix.get(k2, 0) < 0.0) {
                    this.system.setBeta(k2, 1.0E-9);
                }
                if (betaMatrix.get(k2, 0) > 1.0) {
                    this.system.setBeta(k2, 0.999999999);
                }
                ++k2;
            }
            this.calcSolidBeta();
            if (!this.hasRemovedPhase) {
                int i = 0;
                while (i < this.system.getNumberOfPhases() - 1) {
                    if (Math.abs(this.system.getBeta(i)) < 1.01E-9) {
                        this.system.removePhaseKeepTotalComposition(i);
                        this.hasRemovedPhase = true;
                    }
                    ++i;
                }
            }
            if (!this.hasRemovedPhase || this.secondTime) continue;
            this.secondTime = true;
            this.run();
        } while (ans.norm2() > 1.0E-8 && iter < 100 || iter < 2);
        this.system.init(1);
    }

    public void checkGibbs() {
        double gibbs1 = 0.0;
        double gibbs2 = 0.0;
        int i = 0;
        while (i < this.system.getNumberOfPhases() - 1) {
            this.system.setPhaseType(i, 0);
            this.system.init(1);
            gibbs1 = this.system.getPhase(i).getGibbsEnergy();
            this.system.setPhaseType(i, 1);
            this.system.init(1);
            gibbs2 = this.system.getPhase(i).getGibbsEnergy();
            if (gibbs1 < gibbs2) {
                this.system.setPhaseType(i, 0);
            } else {
                this.system.setPhaseType(i, 1);
            }
            this.system.init(1);
            ++i;
        }
    }

    public void calcSolidBeta() {
        double tempVar = this.system.getPhase(0).getComponents()[this.solidComponent].getz();
        int i = 0;
        while (i < this.system.getNumberOfPhases() - 1) {
            tempVar -= this.system.getBeta(i) * this.system.getPhase(3).getComponent(this.solidComponent).getFugacityCoefficient() / this.system.getPhase(i).getComponent(this.solidComponent).getFugacityCoefficient();
            ++i;
        }
        if (tempVar > 0.0 && tempVar < 1.0) {
            this.system.setBeta(this.system.getNumberOfPhases() - 1, tempVar);
        }
    }

    @Override
    public void run() {
        this.system.setNumberOfPhases(this.system.getNumberOfPhases());
        double oldBeta = 0.0;
        int iter = 0;
        this.system.init(1);
        this.solveBeta(true);
        do {
            ++iter;
            oldBeta = this.system.getBeta(this.system.getNumberOfPhases() - 1);
            this.setXY();
            this.system.init(1);
            if (this.system.getNumberOfPhases() > 1) {
                this.solveBeta(true);
            } else {
                this.system.setBeta(0, 0.9999999999);
                this.system.reset_x_y();
                this.system.init(1);
            }
            this.checkX();
        } while (Math.abs(this.system.getBeta(this.system.getNumberOfPhases() - 1) - oldBeta) > 0.001 && iter <= 20 || iter < 4);
    }
}

