/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.QfuncFlash;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaturateWithWater
extends QfuncFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SaturateWithWater.class);
    Flash tpFlash;

    public SaturateWithWater() {
    }

    public SaturateWithWater(SystemInterface system) {
        this.system = system;
        this.tpFlash = new TPflash(system);
    }

    @Override
    public void run() {
        if (!this.system.getPhase(0).hasComponent("water")) {
            this.system.addComponent("water", this.system.getTotalNumberOfMoles());
            this.system.createDatabase(true);
            this.system.setMixingRule(this.system.getMixingRule());
            if (this.system.doMultiPhaseCheck()) {
                this.system.setMultiPhaseCheck(true);
            }
            this.system.init(0);
        }
        double dn = 1.0;
        int i = 0;
        this.tpFlash = new TPflash(this.system);
        this.tpFlash.run();
        boolean hasAq = false;
        if (this.system.hasPhaseType("aqueous")) {
            hasAq = true;
        }
        double lastdn = 0.0;
        lastdn = this.system.hasPhaseType("aqueous") ? this.system.getPhaseOfType("aqueous").getComponent("water").getNumberOfMolesInPhase() : this.system.getPhase(0).getNumberOfMolesInPhase() / 100.0;
        do {
            ++i;
            if (!hasAq) {
                this.system.addComponent("water", lastdn * 0.5);
                lastdn *= 0.8;
            } else {
                lastdn = this.system.getPhaseOfType("aqueous").getComponent("water").getNumberOfMolesInPhase();
                dn = lastdn / this.system.getNumberOfMoles();
                this.system.addComponent("water", -lastdn);
            }
            this.tpFlash.run();
            hasAq = this.system.hasPhaseType("aqueous");
        } while (i < 50 && Math.abs(dn) > 1.0E-6 || !hasAq && i < 50);
        if (i == 50) {
            logger.error("could not find solution - in water sturate : dn  " + dn);
        }
        this.system.removePhase(this.system.getNumberOfPhases() - 1);
        this.tpFlash.run();
    }

    public static void main(String[] args) {
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(343.15, 150.0);
        testSystem.addComponent("methane", 75.0);
        testSystem.addComponent("ethane", 7.5);
        testSystem.addComponent("propane", 4.0);
        testSystem.addComponent("n-butane", 1.0);
        testSystem.addComponent("i-butane", 0.6);
        testSystem.addComponent("n-hexane", 0.3);
        testSystem.addPlusFraction("C6", 1.3, 0.1003, 0.8232);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(10);
        testSystem.setMultiPhaseCheck(true);
        testSystem.init(0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        try {
            testOps.TPflash();
            testOps.saturateWithWater();
            testSystem.display();
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }
}

