/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.jfree.chart.JFreeChart;

public class PVrefluxflash
extends Flash {
    private static final long serialVersionUID = 1000L;
    Flash tpFlash;
    int refluxPhase = 0;
    double refluxSpec = 0.5;

    public PVrefluxflash() {
    }

    public PVrefluxflash(SystemInterface system, double refluxSpec, int refluxPhase) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.refluxSpec = refluxSpec;
        this.refluxPhase = refluxPhase;
    }

    @Override
    public void run() {
        int iter = 0;
        double f_func = 0.0;
        double f_func_old = 0.0;
        double df_func_dt = 0.0;
        double t_old = 0.0;
        double t_oldold = 0.0;
        this.tpFlash.run();
        double dt = 1.0;
        do {
            ++iter;
            f_func_old = f_func;
            t_oldold = t_old;
            t_old = this.system.getTemperature();
            f_func = this.refluxSpec - (1.0 / this.system.getBeta(this.refluxPhase) - 1.0);
            df_func_dt = (f_func - f_func_old) / (t_old - t_oldold);
            if (iter < 4) {
                if (f_func > 0.0) {
                    this.system.setTemperature(this.system.getTemperature() + 0.1);
                } else if (f_func < 0.0) {
                    this.system.setTemperature(this.system.getTemperature() - 0.1);
                }
            } else {
                dt = f_func / df_func_dt;
                if (Math.abs(dt) > 2.0) {
                    dt = Math.signum(dt) * 2.0;
                }
                this.system.setTemperature(this.system.getTemperature() - dt * (1.0 * (double)iter) / ((double)iter + 50.0));
            }
            this.tpFlash.run();
        } while (Math.abs(dt) > 1.0E-8 && Math.abs(f_func) > 1.0E-6 && iter < 1000);
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

