/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting;

import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.system.SystemSrkTwuCoonParamEos;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting.TwuCoon;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestTwuCoon {
    static Logger logger = LogManager.getLogger(TestTwuCoon.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        String ComponentName = "mercury";
        try {
            TwuCoon function = new TwuCoon();
            double[] guess = new double[]{0.068584, 0.9784, 2.244};
            SystemSrkTwuCoonParamEos testSystem = new SystemSrkTwuCoonParamEos(280.0, 5.0);
            testSystem.addComponent(ComponentName, 100.0);
            testSystem.setMixingRule(2);
            testSystem.createDatabase(true);
            function.setInitialGuess(guess);
            SystemSrkSchwartzentruberEos System2 = new SystemSrkSchwartzentruberEos(280.0, 5.0);
            System2.addComponent(ComponentName, 100.0);
            System2.setMixingRule(2);
            ThermodynamicOperations Ops = new ThermodynamicOperations(System2);
            double Ttp = testSystem.getPhase(0).getComponent(0).getTriplePointTemperature();
            double TC = testSystem.getPhase(0).getComponent(0).getTC();
            int i = 0;
            while (i < 30) {
                double temperature = Ttp + (TC - Ttp) / 30.0 * (double)i;
                System2.setTemperature(temperature);
                Ops.dewPointPressureFlash();
                double pressure = System2.getPressure();
                double[] sample1 = new double[]{temperature};
                double[] standardDeviation1 = new double[]{0.1, 0.1, 0.1};
                double val = Math.log(pressure);
                SampleValue sample = new SampleValue(val, val / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setReference("Perry");
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
                ++i;
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

