/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemRKEos;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting.ClassicAcentricDens;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting.ClassicAcentricFunction;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestClassicAcentricPlusDens {
    static Logger logger = LogManager.getLogger(TestClassicAcentricPlusDens.class);

    public static void main(String[] args) {
        double[] standardDeviation1;
        SystemRKEos testSystem;
        ClassicAcentricFunction function;
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='nitrogen' AND VapourPressure>0 ORDER BY Temperature ASC");
        double[] guess = new double[]{0.04};
        try {
            logger.info("adding....");
            while (!dataSet.next()) {
                function = new ClassicAcentricFunction();
                testSystem = new SystemRKEos(280.0, 0.001);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                double[] standardDeviation12 = new double[]{0.1};
                double val = Double.parseDouble(dataSet.getString("VapourPressure"));
                double stddev = val / 100.0;
                double logVal = Math.log(val);
                SampleValue sample = new SampleValue(logVal, stddev, sample1, standardDeviation12);
                testSystem.init(0);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='nitrogen' AND VapourPressure>0 ORDER BY Temperature ASC");
        try {
            logger.info("adding....");
            while (!dataSet.next()) {
                function = new ClassicAcentricDens(1);
                testSystem = new SystemRKEos(280.0, 0.001);
                testSystem.useVolumeCorrection(false);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("VapourPressure")));
                testSystem.init(0);
                testSystem.setMixingRule(1);
                logger.info("adding2....");
                double dens = Double.parseDouble(dataSet.getString("liquiddensity"));
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(dens, dens / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='nitrogen' AND VapourPressure>0 ORDER BY Temperature ASC");
        try {
            logger.info("adding....");
            while (dataSet.next()) {
                function = new ClassicAcentricDens(0);
                testSystem = new SystemRKEos(280.0, 0.001);
                testSystem.useVolumeCorrection(false);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("VapourPressure")));
                testSystem.init(0);
                testSystem.setMixingRule(1);
                double dens = Double.parseDouble(dataSet.getString("gasdensity"));
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(dens, dens / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        LevenbergMarquardt optim = new LevenbergMarquardt();
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
        optim.writeToTextFile("c:/test.txt");
    }
}

