/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting.IonicInteractionParameterFittingFunction;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting.IonicInteractionParameterFittingFunction_1;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestIonicInteractionParameterFitting {
    static Logger logger = LogManager.getLogger(TestIonicInteractionParameterFitting.class);

    public static void main(String[] args) {
        SampleValue sample;
        double stddev;
        double[] standardDeviation1;
        double[] sample1;
        double pressure;
        double temperature;
        SystemFurstElectrolyteEos testSystem;
        IonicInteractionParameterFittingFunction function;
        int ID;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        double[] guess = new double[]{-1.86849E-4, -6.868943E-4, -2.10224E-5, -2.324934E-4, 5.0E-4};
        ResultSet dataSet = database.getResultSet("SELECT * FROM CO2waterMDEA2 WHERE Temperature<'393.15' AND PressureCO2<'20' AND Reference<>'GPA'");
        try {
            int i = 0;
            while (dataSet.next() && i < 25) {
                ID = Integer.parseInt(dataSet.getString("ID"));
                if (ID > 56 && ID < 64 || ID > 92 && ID < 101 || ID > 123 && ID < 131 || ID == 155 || ID == 29 || ID == 28 || ID == 258) continue;
                ++i;
                function = new IonicInteractionParameterFittingFunction();
                testSystem = new SystemFurstElectrolyteEos(298.15, 1.0);
                testSystem.addComponent("CO2", Double.parseDouble(dataSet.getString("x1")));
                testSystem.addComponent("MDEA", Double.parseDouble(dataSet.getString("x3")));
                testSystem.addComponent("water", Double.parseDouble(dataSet.getString("x2")));
                temperature = Double.parseDouble(dataSet.getString("Temperature"));
                pressure = Double.parseDouble(dataSet.getString("PressureCO2"));
                testSystem.setTemperature(temperature);
                testSystem.setPressure(pressure + 1.0);
                testSystem.chemicalReactionInit();
                testSystem.setMixingRule(4);
                testSystem.init(0);
                sample1 = new double[]{testSystem.getPhase(0).getComponent(0).getNumberOfmoles() / testSystem.getPhase(0).getComponent(1).getNumberOfmoles()};
                standardDeviation1 = new double[]{0.01};
                stddev = pressure;
                sample = new SampleValue(pressure, stddev, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setReference(dataSet.getString("Reference"));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        dataSet = database.getResultSet("SELECT * FROM CO2waterMDEA2 WHERE Temperature<'393.15' AND Pressure<'20' AND Reference<>'GPA'");
        try {
            int i = 0;
            while (dataSet.next() && i < 2) {
                ID = Integer.parseInt(dataSet.getString("ID"));
                if (ID > 56 && ID < 64 || ID > 92 && ID < 101 || ID > 123 && ID < 131 || ID == 155 || ID == 29 || ID == 28 || ID == 258) continue;
                ++i;
                function = new IonicInteractionParameterFittingFunction_1();
                testSystem = new SystemFurstElectrolyteEos(298.15, 1.0);
                testSystem.addComponent("CO2", Double.parseDouble(dataSet.getString("x1")));
                testSystem.addComponent("MDEA", Double.parseDouble(dataSet.getString("x3")));
                testSystem.addComponent("water", Double.parseDouble(dataSet.getString("x2")));
                temperature = Double.parseDouble(dataSet.getString("Temperature"));
                pressure = Double.parseDouble(dataSet.getString("Pressure"));
                testSystem.setTemperature(temperature);
                testSystem.setPressure(pressure);
                testSystem.chemicalReactionInit();
                testSystem.setMixingRule(4);
                testSystem.init(0);
                sample1 = new double[]{testSystem.getPhase(0).getComponent(0).getNumberOfmoles() / testSystem.getPhase(0).getComponent(1).getNumberOfmoles()};
                standardDeviation1 = new double[]{0.01};
                stddev = pressure;
                sample = new SampleValue(pressure, stddev, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setReference(dataSet.getString("Reference"));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToCdfFile("c:/testFit.nc");
        optim.writeToTextFile("c:/testFit.txt");
    }
}

