/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.CPAParameterFittingToSolubilityData;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.CPAParameterFittingToSolubilityData_Vap;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCPAParameterFittingToSolubilityGlycolHC {
    static Logger logger = LogManager.getLogger(TestCPAParameterFittingToSolubilityGlycolHC.class);

    public static void main(String[] args) {
        SampleValue sample;
        double sdev;
        double val;
        double[] standardDeviation1;
        double[] sample1;
        SystemSrkEos testSystem;
        LevenbergMarquardtFunction function;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM hcglycollldata WHERE comp1='n-heptane' AND comp2='MEG' AND reference='Lindboe2002' ORDER BY Temperature,Pressure");
        double[] parameterGuess = new double[]{1924.0, 4938.0};
        try {
            int p = 0;
            logger.info("adding....");
            while (!dataSet.next() && p < 50) {
                ++p;
                function = new CPAParameterFittingToSolubilityData();
                testSystem = new SystemSrkEos(Double.parseDouble(dataSet.getString("temperature")) + 273.15, Double.parseDouble(dataSet.getString("pressure")));
                testSystem.addComponent("n-heptane", 1.0);
                testSystem.addComponent("MEG", 10.0);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                sample1 = new double[]{testSystem.getTemperature()};
                standardDeviation1 = new double[]{0.01};
                val = Double.parseDouble(dataSet.getString("x-glyinhc"));
                sdev = val / 100.0;
                sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        dataSet = database.getResultSet("SELECT * FROM HCGlycolLLdata WHERE comp1='n-heptane' AND comp2='MEG' AND reference='Lindboe2002' ORDER BY Temperature,Pressure");
        try {
            int p = 0;
            logger.info("adding....");
            while (!dataSet.next() && p < 50) {
                ++p;
                function = new CPAParameterFittingToSolubilityData_Vap();
                testSystem = new SystemSrkEos(Double.parseDouble(dataSet.getString("temperature")) + 273.15, Double.parseDouble(dataSet.getString("pressure")));
                testSystem.addComponent("n-heptane", 1.0);
                testSystem.addComponent("MEG", 10.0);
                testSystem.init(0);
                testSystem.setMixingRule(4);
                sample1 = new double[]{testSystem.getTemperature()};
                standardDeviation1 = new double[]{0.01};
                val = Double.parseDouble(dataSet.getString("x-hcinglyc"));
                sdev = val / 100.0;
                sample = new SampleValue(val, sdev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(Double.toString(testSystem.getTemperature()));
                function.setInitialGuess(parameterGuess);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToCdfFile("c:/testFit.nc");
        optim.writeToTextFile("c:/testFit.txt");
    }
}

