/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.phase.PhaseEosInterface;

public class BinaryEosFunction
extends LevenbergMarquardtFunction {
    public BinaryEosFunction() {
        this.params = new double[1];
        this.params[0] = -0.34;
    }

    @Override
    public double calcValue(double[] dependentValues) {
        this.system.setTemperature(dependentValues[0]);
        this.system.setPressure(dependentValues[1]);
        this.thermoOps.TPflash();
        return this.system.getPressure() * this.system.getPhases()[0].getComponents()[0].getx();
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        ((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule().setBinaryInteractionParameter(0, 1, value);
        ((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule().setBinaryInteractionParameter(0, 1, value);
    }

    @Override
    public double getFittingParams(int i) {
        return this.params[i];
    }

    @Override
    public double[] getFittingParams() {
        return this.params;
    }

    @Override
    public int getNumberOfFittingParams() {
        return this.params.length;
    }

    @Override
    public void setFittingParams(double[] value) {
        int i = 0;
        while (i < value.length) {
            this.params[i] = value[i];
            ((PhaseEosInterface)this.system.getPhases()[0]).getMixingRule().setBinaryInteractionParameter(0, 1, value[i]);
            ((PhaseEosInterface)this.system.getPhases()[1]).getMixingRule().setBinaryInteractionParameter(0, 1, value[i]);
            ++i;
        }
    }
}

