/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CO2WaterMDEA;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.parameterFitting.Procede.CO2WaterMDEA.IonicInteractionParameterFittingFunction_CO2;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestIonicInteractionParameterFitting_CO2 {
    static Logger logger = LogManager.getLogger(TestIonicInteractionParameterFitting_CO2.class);

    public static void main(String[] args) {
        SampleValue sample;
        double stddev;
        double[] standardDeviation1;
        double[] sample1;
        SystemFurstElectrolyteEos testSystem;
        double loading;
        double x3;
        double x2;
        double x1;
        double temperature;
        double pressure;
        double ID;
        IonicInteractionParameterFittingFunction_CO2 function;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM CO2WaterMDEA WHERE ID<231");
        double[] guess = new double[]{-1.660156E-4, -6.035675E-4, -6.8587E-6, -2.16497E-4};
        try {
            int i = 0;
            logger.info("adding....");
            while (dataSet.next()) {
                ++i;
                function = new IonicInteractionParameterFittingFunction_CO2();
                function.setInitialGuess(guess);
                ID = Integer.parseInt(dataSet.getString("ID"));
                pressure = Double.parseDouble(dataSet.getString("PressureCO2"));
                temperature = Double.parseDouble(dataSet.getString("Temperature"));
                x1 = Double.parseDouble(dataSet.getString("x1"));
                x2 = Double.parseDouble(dataSet.getString("x2"));
                x3 = Double.parseDouble(dataSet.getString("x3"));
                loading = x1 / x3;
                if (ID > 56.0 && ID < 64.0 || ID > 92.0 && ID < 101.0 || ID > 123.0 && ID < 131.0 || ID == 155.0 || ID == 29.0 || ID == 28.0 || ID == 258.0 || temperature > 400.0) continue;
                testSystem = new SystemFurstElectrolyteEos(temperature, 1.5 * pressure);
                testSystem.addComponent("CO2", x1);
                testSystem.addComponent("MDEA", x3);
                testSystem.addComponent("water", x2);
                logger.info("...........ID............." + ID);
                testSystem.chemicalReactionInit();
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                sample1 = new double[]{loading};
                standardDeviation1 = new double[]{0.1};
                stddev = pressure / 100.0;
                sample = new SampleValue(pressure, stddev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setReference(Double.toString(ID));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        dataSet = database.getResultSet("SELECT * FROM CO2WaterMDEA WHERE ID>230");
        try {
            int i = 0;
            logger.info("adding....");
            while (dataSet.next()) {
                ++i;
                function = new IonicInteractionParameterFittingFunction_CO2(1, 1);
                function.setInitialGuess(guess);
                ID = Integer.parseInt(dataSet.getString("ID"));
                pressure = Double.parseDouble(dataSet.getString("Pressure"));
                temperature = Double.parseDouble(dataSet.getString("Temperature"));
                x1 = Double.parseDouble(dataSet.getString("x1"));
                x2 = Double.parseDouble(dataSet.getString("x2"));
                x3 = Double.parseDouble(dataSet.getString("x3"));
                loading = x1 / x3;
                testSystem = new SystemFurstElectrolyteEos(temperature, pressure);
                testSystem.addComponent("CO2", x1);
                testSystem.addComponent("water", x2);
                testSystem.addComponent("MDEA", x3);
                logger.info("...........ID............." + ID);
                if (ID == 294.0 || ID == 295.0 || ID > 235.0 && ID < 244.0 || ID > 246.0 && ID < 252.0 || ID == 258.0 || ID == 322.0 || ID == 328.0 || ID == 329.0 || ID > 332.0 && ID < 339.0 || temperature > 400.0) continue;
                testSystem.chemicalReactionInit();
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                sample1 = new double[]{loading};
                standardDeviation1 = new double[]{0.1};
                stddev = pressure / 100.0;
                sample = new SampleValue(pressure, stddev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setReference(Double.toString(ID));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        dataSet = database.getResultSet("SELECT * FROM CO2WaterMDEAtest");
        try {
            int i = 0;
            logger.info("adding....");
            while (dataSet.next()) {
                ++i;
                function = new IonicInteractionParameterFittingFunction_CO2();
                function.setInitialGuess(guess);
                ID = Integer.parseInt(dataSet.getString("ID"));
                pressure = Double.parseDouble(dataSet.getString("PressureCO2"));
                temperature = Double.parseDouble(dataSet.getString("Temperature"));
                x1 = Double.parseDouble(dataSet.getString("x1"));
                x2 = Double.parseDouble(dataSet.getString("x2"));
                x3 = Double.parseDouble(dataSet.getString("x3"));
                loading = x1 / x3;
                testSystem = new SystemFurstElectrolyteEos(temperature, 1.5 * pressure);
                testSystem.addComponent("CO2", x1);
                testSystem.addComponent("MDEA", x3);
                testSystem.addComponent("water", x2);
                logger.info("...........ID............." + ID);
                testSystem.chemicalReactionInit();
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                sample1 = new double[]{loading};
                standardDeviation1 = new double[]{0.1};
                stddev = pressure / 100.0;
                sample = new SampleValue(pressure, stddev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setReference(Double.toString(ID));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

