/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CO2Water;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Jamal {
    static Logger logger = LogManager.getLogger(Jamal.class);

    public static void main(String[] args) {
        double temperature = 278.0;
        while (temperature <= 500.0) {
            double x = 1.0E-4;
            SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(temperature, 1.0);
            testSystem.addComponent("CO2", x);
            testSystem.addComponent("water", 1.0 - x);
            testSystem.createDatabase(true);
            testSystem.setMixingRule(4);
            testSystem.init(0);
            testSystem.init(1);
            ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
            try {
                testOps.bubblePointPressureFlash(false);
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            try {
                Throwable e = null;
                Object var10_9 = null;
                try (PrintStream p = new PrintStream(new FileOutputStream("C:/java/NeqSimSource/Patrick.txt", true));){
                    p.println(String.valueOf(temperature) + " " + testSystem.getPressure() * testSystem.getPhase(0).getComponent(0).getx() / x);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (FileNotFoundException e) {
                logger.error("Could not find file");
                logger.error("Could not read from Patrick.txt" + e.getMessage());
            }
            logger.info("Finished");
            temperature += 5.0;
        }
    }
}

