/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.benchmark;

import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TPflash_benchmark_fullcomp {
    static Logger logger = LogManager.getLogger(TPflash_benchmark_fullcomp.class);

    public static void main(String[] args) {
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(268.15, 10.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        testSystem.addComponent("methane", 26.19);
        testSystem.addComponent("propane", 8.27);
        testSystem.addComponent("propane", 7.5);
        testSystem.addComponent("i-butane", 1.83);
        testSystem.addComponent("n-butane", 4.05);
        testSystem.addComponent("iC5", 1.85);
        testSystem.addComponent("n-pentane", 2.45);
        testSystem.addComponent("n-hexane", 40.6);
        testSystem.addTBPfraction("C6", 1.49985, 0.0863, 0.7232);
        testSystem.addTBPfraction("C7", 0.0359864, 0.096, 0.738);
        testSystem.addTBPfraction("C8", 0.939906, 0.107, 0.765);
        testSystem.addTBPfraction("C9", 0.879912, 0.121, 0.781);
        testSystem.addTBPfraction("C10", 0.45, 0.134, 0.792);
        testSystem.setMultiPhaseCheck(true);
        testSystem.setHydrateCheck(true);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(9);
        logger.info("start benchmark TPflash......");
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < 1000000) {
            testOps.TPflash();
            ++i;
        }
        logger.info("Time taken for benchmark flash = " + (System.currentTimeMillis() - time));
        testOps.displayResult();
    }
}

