/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import com.lowagie.text.Anchor;
import com.lowagie.text.FontFactory;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.chemicalReactions.ChemicalReactionOperations;
import neqsim.dataPresentation.fileHandeling.createTextFile.TextFile;
import neqsim.dataPresentation.iTextPDF.PdfCreator;
import neqsim.physicalProperties.interfaceProperties.InterfaceProperties;
import neqsim.physicalProperties.interfaceProperties.InterphasePropertiesInterface;
import neqsim.standards.StandardInterface;
import neqsim.standards.gasQuality.Draft_ISO18453;
import neqsim.standards.gasQuality.Standard_ISO6976;
import neqsim.thermo.characterization.Characterise;
import neqsim.thermo.characterization.PlusCharacterize;
import neqsim.thermo.characterization.WaxCharacterise;
import neqsim.thermo.characterization.WaxModelInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.mixingRule.EosMixingRules;
import neqsim.thermo.phase.PhaseEosInterface;
import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSolid;
import neqsim.thermo.phase.PhaseSolidComplex;
import neqsim.thermo.phase.PhaseWax;
import neqsim.thermo.system.SystemDuanSun;
import neqsim.thermo.system.SystemElectrolyteCPAstatoil;
import neqsim.thermo.system.SystemEos;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.system.SystemGERG2004Eos;
import neqsim.thermo.system.SystemGERGwaterEos;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemPCSAFT;
import neqsim.thermo.system.SystemPrEos;
import neqsim.thermo.system.SystemSrkCPAs;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.system.SystemSrkTwuCoonParamEos;
import neqsim.thermo.system.SystemSrkTwuCoonStatoilEos;
import neqsim.thermo.system.SystemUMRPRUMCEos;
import neqsim.util.database.NeqSimBlobDatabase;
import neqsim.util.database.NeqSimDataBase;
import neqsim.util.database.NeqSimFluidDataBase;
import neqsim.util.exception.InvalidInputException;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import neqsim.util.unit.PressureUnit;
import neqsim.util.unit.RateUnit;
import neqsim.util.unit.TemperatureUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class SystemThermo
implements SystemInterface {
    private static final long serialVersionUID = 1000L;
    private boolean implementedTemperatureDeriativesofFugacity = true;
    private boolean implementedPressureDeriativesofFugacity = true;
    private boolean implementedCompositionDeriativesofFugacity = true;
    protected double criticalTemperature = 0.0;
    protected String[][] resultTable = null;
    boolean isInitialized = false;
    protected String fluidInfo = "No Information Available";
    protected String fluidName = "DefaultName";
    protected String modelName = "Default";
    protected boolean numericDerivatives = false;
    protected boolean allowPhaseShift = true;
    private boolean useTVasIndependentVariables = false;
    protected double criticalPressure = 0.0;
    private double totalNumberOfMoles = 0.0;
    public String componentNameTag = "";
    protected WaxCharacterise waxCharacterisation = null;
    protected double[] beta = new double[6];
    protected int a;
    protected int initType = 3;
    private ArrayList<String> componentNames = new ArrayList();
    protected String[] CapeOpenProperties11 = new String[]{"molecularWeight", "speedOfSound", "jouleThomsonCoefficient", "internalEnergy", "internalEnergy.Dtemperature", "gibbsEnergy", "helmholtzEnergy", "fugacityCoefficient", "logFugacityCoefficient", "logFugacityCoefficient.Dtemperature", "logFugacityCoefficient.Dpressure", "logFugacityCoefficient.Dmoles", "enthalpy", "enthalpy.Dmoles", "enthalpy.Dtemperature", "enthalpy.Dpressure", "entropy", "entropy.Dtemperature", "entropy.Dpressure", "entropy.Dmoles", "heatCapacityCp", "heatCapacityCv", "density", "density.Dtemperature", "density.Dpressure", "density.Dmoles", "volume", "volume.Dpressure", "volume.Dtemperature", "molecularWeight.Dtemperature", "molecularWeight.Dpressure", "molecularWeight.Dmoles", "compressibilityFactor"};
    protected String[] CapeOpenProperties10 = new String[]{"molecularWeight", "speedOfSound", "jouleThomsonCoefficient", "energy", "energy.Dtemperature", "gibbsFreeEnergy", "helmholtzFreeEnergy", "fugacityCoefficient", "logFugacityCoefficient", "logFugacityCoefficient.Dtemperature", "logFugacityCoefficient.Dpressure", "logFugacityCoefficient.Dmoles", "enthalpy", "enthalpy.Dmoles", "enthalpy.Dtemperature", "enthalpy.Dpressure", "entropy", "entropy.Dtemperature", "entropy.Dpressure", "entropy.Dmoles", "heatCapacity", "heatCapacityCv", "density", "density.Dtemperature", "density.Dpressure", "density.Dmoles", "volume", "volume.Dpressure", "volume.Dtemperature", "molecularWeight.Dtemperature", "molecularWeight.Dpressure", "molecularWeight.Dmoles", "compressibilityFactor"};
    protected int numberOfComponents = 0;
    protected int numberOfPhases = 2;
    public int maxNumberOfPhases = 2;
    protected int attractiveTermNumber = 0;
    protected int phase = 2;
    protected int onePhaseType = 1;
    protected int[] phaseType;
    protected int[] phaseIndex;
    protected ChemicalReactionOperations chemicalReactionOperations;
    private int mixingRule;
    protected boolean chemicalSystem;
    protected boolean solidPhaseCheck;
    protected boolean multiPhaseCheck;
    protected boolean hydrateCheck;
    protected boolean checkStability;
    protected PhaseInterface[] phaseArray;
    public Characterise characterization;
    protected StandardInterface standard;
    protected InterphasePropertiesInterface interfaceProp;
    private boolean multiphaseWaxCheck;
    Object pdfDocument;
    private boolean forcePhaseTypes;
    static Logger logger = LogManager.getLogger(SystemThermo.class);

    public SystemThermo() {
        int[] nArray = new int[6];
        nArray[0] = 1;
        this.phaseType = nArray;
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        this.phaseIndex = nArray2;
        this.chemicalReactionOperations = null;
        this.mixingRule = 1;
        this.chemicalSystem = false;
        this.solidPhaseCheck = false;
        this.multiPhaseCheck = false;
        this.hydrateCheck = false;
        this.checkStability = true;
        this.characterization = null;
        this.standard = null;
        this.interfaceProp = null;
        this.multiphaseWaxCheck = false;
        this.pdfDocument = null;
        this.forcePhaseTypes = false;
        this.phaseArray = new PhaseInterface[6];
        this.characterization = new Characterise(this);
        this.interfaceProp = new InterfaceProperties(this);
    }

    public SystemThermo(double T, double P) {
        this();
        if (T < 0.0 || P < 0.0) {
            logger.error("Negative input temperature or pressure");
            InvalidInputException e = new InvalidInputException();
            throw new RuntimeException(e);
        }
        this.beta[0] = 1.0;
        this.beta[1] = 1.0;
        this.beta[2] = 1.0;
        this.beta[3] = 1.0;
        this.beta[4] = 1.0;
        this.beta[5] = 1.0;
    }

    @Override
    public int getNumberOfComponents() {
        return this.getComponentNames().length;
    }

    @Override
    public void clearAll() {
        this.setTotalNumberOfMoles(0.0);
        this.phaseType[0] = 1;
        this.phaseType[1] = 0;
        this.numberOfComponents = 0;
        this.numberOfPhases = 2;
        this.phase = 2;
        this.onePhaseType = 1;
        this.beta[0] = 1.0;
        this.beta[1] = 1.0;
        this.beta[2] = 1.0;
        this.beta[3] = 1.0;
        this.beta[4] = 1.0;
        this.beta[5] = 1.0;
        this.chemicalSystem = false;
        double oldTemp = this.phaseArray[0].getTemperature();
        double oldPres = this.phaseArray[0].getPressure();
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            try {
                this.phaseArray[i] = (PhaseInterface)this.phaseArray[i].getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.error("err " + e.toString());
            }
            this.phaseArray[i].setTemperature(oldTemp);
            this.phaseArray[i].setPressure(oldPres);
            ++i;
        }
    }

    @Override
    public void resetCharacterisation() {
        int numberOfLumpedComps = this.characterization.getLumpingModel().getNumberOfLumpedComponents();
        this.characterization = new Characterise(this);
        this.characterization.getLumpingModel().setNumberOfLumpedComponents(numberOfLumpedComps);
    }

    @Override
    public SystemThermo clone() {
        SystemThermo clonedSystem = null;
        try {
            clonedSystem = (SystemThermo)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        clonedSystem.beta = (double[])this.beta.clone();
        clonedSystem.attractiveTermNumber = this.attractiveTermNumber;
        clonedSystem.phaseType = (int[])this.phaseType.clone();
        clonedSystem.phaseIndex = (int[])this.phaseIndex.clone();
        clonedSystem.componentNames = new ArrayList<String>(this.componentNames);
        clonedSystem.characterization = this.characterization.clone();
        if (clonedSystem.waxCharacterisation != null) {
            clonedSystem.waxCharacterisation = this.waxCharacterisation.clone();
        }
        System.arraycopy(this.beta, 0, clonedSystem.beta, 0, this.beta.length);
        System.arraycopy(this.phaseType, 0, clonedSystem.phaseType, 0, this.phaseType.length);
        System.arraycopy(this.phaseIndex, 0, clonedSystem.phaseIndex, 0, this.phaseIndex.length);
        clonedSystem.phaseArray = (PhaseInterface[])this.phaseArray.clone();
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            clonedSystem.phaseArray[i] = this.phaseArray[i].clone();
            ++i;
        }
        return clonedSystem;
    }

    @Override
    public SystemInterface addFluid(SystemInterface addSystem) {
        boolean addedNewComponent = false;
        int index = -1;
        int i = 0;
        while (i < addSystem.getPhase(0).getNumberOfComponents()) {
            if (!this.getPhase(0).hasComponent(addSystem.getPhase(0).getComponent(i).getComponentName())) {
                index = -1;
                addedNewComponent = true;
            } else {
                index = this.getPhase(0).getComponent(addSystem.getPhase(0).getComponent(i).getComponentName()).getComponentNumber();
            }
            if (index != -1) {
                this.addComponent(index, addSystem.getPhase(0).getComponent(i).getNumberOfmoles());
            } else {
                this.addComponent(addSystem.getComponent(i));
            }
            ++i;
        }
        if (addedNewComponent) {
            this.createDatabase(true);
            this.setMixingRule(this.getMixingRule());
            this.init(0);
        }
        return this;
    }

    @Override
    public void addPhase() {
        ++this.numberOfPhases;
    }

    public void addSolidPhase() {
        if (!this.multiPhaseCheck) {
            this.setMultiPhaseCheck(true);
        }
        this.phaseArray[3] = new PhasePureComponentSolid();
        this.phaseArray[3].setTemperature(this.phaseArray[0].getTemperature());
        this.phaseArray[3].setPressure(this.phaseArray[0].getPressure());
        int i = 0;
        while (i < this.phaseArray[0].getNumberOfComponents()) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.phaseArray[3].addcomponent("default", this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                this.phaseArray[3].getComponent(i).setComponentName(this.getPhase(0).getComponent(i).getName());
                this.phaseArray[3].getComponent(i).setIsPlusFraction(true);
            } else {
                this.phaseArray[3].addcomponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
            }
            ++i;
        }
        ((PhaseSolid)this.phaseArray[3]).setSolidRefFluidPhase(this.phaseArray[0]);
        if (this.getMaxNumberOfPhases() < 4) {
            this.setMaxNumberOfPhases(4);
        }
    }

    public void addHydratePhase2() {
        if (!this.multiPhaseCheck) {
            this.setMultiPhaseCheck(true);
        }
        this.phaseArray[3] = new PhaseHydrate();
        this.phaseArray[3].setTemperature(this.phaseArray[0].getTemperature());
        this.phaseArray[3].setPressure(this.phaseArray[0].getPressure());
        int i = 0;
        while (i < this.phaseArray[0].getNumberOfComponents()) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.phaseArray[3].addcomponent("default", this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                this.phaseArray[3].getComponent("default").setComponentName(this.getPhase(0).getComponent(i).getName());
            } else {
                this.phaseArray[3].addcomponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
            }
            ++i;
        }
        this.numberOfPhases = 4;
        this.setMaxNumberOfPhases(4);
    }

    @Override
    public void addSolidComplexPhase(String type) {
        if (!this.multiPhaseCheck) {
            this.setMultiPhaseCheck(true);
        }
        this.addHydratePhase();
        this.phaseArray[5] = type.equals("wax") ? new PhaseWax() : new PhaseSolidComplex();
        this.phaseArray[5].setTemperature(this.phaseArray[0].getTemperature());
        this.phaseArray[5].setPressure(this.phaseArray[0].getPressure());
        this.phaseArray[5].setPhaseTypeName("wax");
        int i = 0;
        while (i < this.phaseArray[0].getNumberOfComponents()) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.phaseArray[5].addcomponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                this.phaseArray[5].getComponent(i).setIsPlusFraction(true);
            } else {
                this.phaseArray[5].addcomponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
            }
            ++i;
        }
        ((PhaseSolid)this.phaseArray[5]).setSolidRefFluidPhase(this.phaseArray[0]);
        this.numberOfPhases = 6;
        this.setMaxNumberOfPhases(6);
    }

    public void addHydratePhase() {
        int i;
        if (!this.multiPhaseCheck) {
            this.setMultiPhaseCheck(true);
        }
        if (!this.hasSolidPhase()) {
            this.phaseArray[3] = new PhasePureComponentSolid();
            this.phaseArray[3].setTemperature(this.phaseArray[0].getTemperature());
            this.phaseArray[3].setPressure(this.phaseArray[0].getPressure());
            this.phaseArray[3].setPhaseTypeName("solid");
            i = 0;
            while (i < this.phaseArray[0].getNumberOfComponents()) {
                if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                    this.phaseArray[3].addcomponent("default", this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                    this.phaseArray[3].getComponent(i).setComponentName(this.getPhase(0).getComponent(i).getName());
                    this.phaseArray[3].getComponent(i).setIsTBPfraction(true);
                } else {
                    this.phaseArray[3].addcomponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                }
                ++i;
            }
            ((PhaseSolid)this.phaseArray[3]).setSolidRefFluidPhase(this.phaseArray[0]);
        }
        this.phaseArray[4] = new PhaseHydrate(this.getModelName());
        this.phaseArray[4].setTemperature(this.phaseArray[0].getTemperature());
        this.phaseArray[4].setPressure(this.phaseArray[0].getPressure());
        this.phaseArray[4].setPhaseTypeName("hydrate");
        i = 0;
        while (i < this.phaseArray[0].getNumberOfComponents()) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.phaseArray[4].addcomponent("default", this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                this.phaseArray[4].getComponent(i).setComponentName(this.getPhase(0).getComponent(i).getName());
                this.phaseArray[4].getComponent(i).setIsTBPfraction(true);
            } else {
                this.phaseArray[4].addcomponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
            }
            ++i;
        }
        ((PhaseHydrate)this.phaseArray[4]).setSolidRefFluidPhase(this.phaseArray[0]);
        this.numberOfPhases = 5;
        if (this.getMaxNumberOfPhases() < 5) {
            this.setMaxNumberOfPhases(5);
        }
    }

    @Override
    public void setAllComponentsInPhase(int phase) {
        int k = 0;
        while (k < this.numberOfPhases) {
            int i = 0;
            while (i < this.numberOfComponents) {
                if (phase != k) {
                    this.phaseArray[phase].addMoles(i, this.phaseArray[k].getComponents()[i].getNumberOfMolesInPhase() * 0.99);
                    this.phaseArray[k].addMoles(i, -(this.phaseArray[k].getComponents()[i].getNumberOfMolesInPhase() * 0.99));
                    this.phaseArray[k].getComponents()[i].setx(this.phaseArray[k].getComponents()[i].getNumberOfMolesInPhase() / this.phaseArray[k].getNumberOfMolesInPhase());
                }
                ++i;
            }
            ++k;
        }
        this.initBeta();
        this.init(1);
    }

    @Override
    public void removePhase(int specPhase) {
        int i;
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() - this.getPhase(specPhase).getNumberOfMolesInPhase());
        int j = 0;
        while (j < this.numberOfPhases) {
            i = 0;
            while (i < this.numberOfComponents) {
                this.getPhase(j).getComponents()[i].setNumberOfmoles(this.getPhase(j).getComponents()[i].getNumberOfmoles() - this.getPhase(specPhase).getComponents()[i].getNumberOfMolesInPhase());
                ++i;
            }
            ++j;
        }
        ArrayList<PhaseInterface> phaseList = new ArrayList<PhaseInterface>(0);
        i = 0;
        while (i < this.numberOfPhases) {
            if (specPhase != i) {
                phaseList.add(this.phaseArray[this.phaseIndex[i]]);
            }
            ++i;
        }
        i = 0;
        while (i < this.numberOfPhases - 1) {
            if (i >= specPhase) {
                this.phaseIndex[i] = this.phaseIndex[i + 1];
                this.phaseType[i] = this.phaseType[i + 1];
            }
            ++i;
        }
        --this.numberOfPhases;
    }

    @Override
    public void removePhaseKeepTotalComposition(int specPhase) {
        ArrayList<PhaseInterface> phaseList = new ArrayList<PhaseInterface>(0);
        int i = 0;
        while (i < this.numberOfPhases) {
            if (specPhase != i) {
                phaseList.add(this.phaseArray[this.phaseIndex[i]]);
            }
            ++i;
        }
        i = 0;
        while (i < this.numberOfPhases - 1) {
            if (i >= specPhase) {
                this.phaseIndex[i] = this.phaseIndex[i + 1];
                this.phaseType[i] = this.phaseType[i + 1];
            }
            ++i;
        }
        --this.numberOfPhases;
    }

    @Override
    public void replacePhase(int repPhase, PhaseInterface newPhase) {
        int i = 0;
        while (i < 2) {
            this.phaseArray[i] = newPhase.clone();
            ++i;
        }
        this.setTotalNumberOfMoles(newPhase.getNumberOfMolesInPhase());
    }

    @Override
    public SystemInterface phaseToSystem(PhaseInterface newPhase) {
        int i = 0;
        while (i < newPhase.getNumberOfComponents()) {
            newPhase.getComponents()[i].setNumberOfmoles(newPhase.getComponents()[i].getNumberOfMolesInPhase());
            ++i;
        }
        i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            this.phaseArray[i] = newPhase.clone();
            ++i;
        }
        this.setTotalNumberOfMoles(newPhase.getNumberOfMolesInPhase());
        this.init(0);
        this.setNumberOfPhases(1);
        this.setPhaseType(0, newPhase.getPhaseType());
        this.initBeta();
        this.init_x_y();
        this.init(1);
        return this;
    }

    @Override
    public SystemInterface getEmptySystemClone() {
        int phaseNumber = 0;
        SystemThermo newSystem = this.clone();
        int j = 0;
        while (j < this.getMaxNumberOfPhases()) {
            phaseNumber = j;
            int i = 0;
            while (i < this.getPhase(j).getNumberOfComponents()) {
                newSystem.getPhase(j).getComponents()[i].setNumberOfmoles(this.getPhase(phaseNumber).getComponents()[i].getNumberOfMolesInPhase() / 1.0E30);
                newSystem.getPhase(j).getComponents()[i].setNumberOfMolesInPhase(this.getPhase(phaseNumber).getComponents()[i].getNumberOfMolesInPhase() / 1.0E30);
                ++i;
            }
            ++j;
        }
        newSystem.setTotalNumberOfMoles(this.getPhase(phaseNumber).getNumberOfMolesInPhase() / 1.0E30);
        newSystem.init(0);
        return newSystem;
    }

    @Override
    public SystemInterface phaseToSystem(String phaseName) {
        try {
            int j = 0;
            while (j < this.getMaxNumberOfPhases()) {
                if (this.getPhase(j).getPhaseTypeName().equals(phaseName)) {
                    return this.phaseToSystem(j);
                }
                ++j;
            }
        }
        catch (Exception e) {
            logger.error("error....." + this.fluidName + " has no phase .... " + phaseName + " ..... returning phase number 0");
        }
        return this.phaseToSystem(0);
    }

    @Override
    public SystemInterface phaseToSystem(int phaseNumber) {
        SystemThermo newSystem = this.clone();
        int j = 0;
        while (j < this.getMaxNumberOfPhases()) {
            int i = 0;
            while (i < this.getPhase(j).getNumberOfComponents()) {
                newSystem.getPhase(j).getComponent(i).setNumberOfmoles(this.getPhase(phaseNumber).getComponent(i).getNumberOfMolesInPhase());
                newSystem.getPhase(j).getComponent(i).setNumberOfMolesInPhase(this.getPhase(phaseNumber).getComponent(i).getNumberOfMolesInPhase());
                ++i;
            }
            ++j;
        }
        newSystem.setTotalNumberOfMoles(this.getPhase(phaseNumber).getNumberOfMolesInPhase());
        newSystem.init(0);
        newSystem.setNumberOfPhases(1);
        newSystem.setPhaseType(0, this.getPhase(phaseNumber).getPhaseType());
        newSystem.init(1);
        return newSystem;
    }

    @Override
    public SystemInterface phaseToSystem(int phaseNumber1, int phaseNumber2) {
        SystemThermo newSystem = this.clone();
        int j = 0;
        while (j < this.getMaxNumberOfPhases()) {
            int i = 0;
            while (i < this.getPhase(j).getNumberOfComponents()) {
                newSystem.getPhases()[j].getComponents()[i].setNumberOfmoles(this.getPhase(phaseNumber1).getComponents()[i].getNumberOfMolesInPhase() + this.getPhase(phaseNumber2).getComponents()[i].getNumberOfMolesInPhase());
                newSystem.getPhases()[j].getComponents()[i].setNumberOfMolesInPhase(this.getPhase(phaseNumber1).getComponents()[i].getNumberOfMolesInPhase() + this.getPhase(phaseNumber2).getComponents()[i].getNumberOfMolesInPhase());
                ++i;
            }
            ++j;
        }
        newSystem.setTotalNumberOfMoles(this.getPhase(phaseNumber1).getNumberOfMolesInPhase() + this.getPhase(phaseNumber2).getNumberOfMolesInPhase());
        newSystem.init(0);
        newSystem.setNumberOfPhases(1);
        newSystem.init(1);
        return newSystem;
    }

    @Override
    public void setTotalFlowRate(double flowRate, String flowunit) {
        this.init(0);
        this.init(1);
        double density2 = 0.0;
        if (flowunit.equals("Am3/hr") || flowunit.equals("Am3/min") || flowunit.equals("Am3/sec")) {
            this.initPhysicalProperties("density");
        }
        density2 = this.getPhase(0).getDensity("kg/m3");
        RateUnit unit = new RateUnit(flowRate, flowunit, this.getMolarMass(), density2, 0.0);
        double SIval = unit.getSIvalue();
        double totalNumberOfMolesLocal = this.totalNumberOfMoles;
        int i = 0;
        while (i < this.numberOfComponents) {
            if (flowRate < 1.0E-100) {
                this.setEmptyFluid();
            } else if (totalNumberOfMolesLocal > 1.0E-100) {
                this.addComponent(i, SIval / totalNumberOfMolesLocal * this.getPhase(0).getComponent(i).getNumberOfmoles() - this.getPhase(0).getComponent(i).getNumberOfmoles());
            } else {
                this.addComponent(i, SIval);
            }
            ++i;
        }
    }

    @Override
    public double getFlowRate(String flowunit) {
        if (flowunit.equals("kg/sec")) {
            return this.totalNumberOfMoles * this.getMolarMass();
        }
        if (flowunit.equals("kg/min")) {
            return this.totalNumberOfMoles * this.getMolarMass() * 60.0;
        }
        if (flowunit.equals("Sm3/sec")) {
            return this.totalNumberOfMoles * 8.3144621 * 288.15 / 101325.0;
        }
        if (flowunit.equals("Sm3/hr")) {
            return this.totalNumberOfMoles * 3600.0 * 8.3144621 * 288.15 / 101325.0;
        }
        if (flowunit.equals("Sm3/day")) {
            return this.totalNumberOfMoles * 3600.0 * 24.0 * 8.3144621 * 288.15 / 101325.0;
        }
        if (flowunit.equals("MSm3/day")) {
            return this.totalNumberOfMoles * 3600.0 * 24.0 * 8.3144621 * 288.15 / 101325.0 / 1000000.0;
        }
        if (flowunit.equals("kg/hr")) {
            return this.totalNumberOfMoles * this.getMolarMass() * 3600.0;
        }
        if (flowunit.equals("kg/day")) {
            return this.totalNumberOfMoles * this.getMolarMass() * 3600.0 * 24.0;
        }
        if (flowunit.equals("m3/hr")) {
            this.initPhysicalProperties("density");
            return this.totalNumberOfMoles * this.getMolarMass() * 3600.0 / this.getDensity("kg/m3");
        }
        if (flowunit.equals("m3/min")) {
            this.initPhysicalProperties("density");
            return this.totalNumberOfMoles * this.getMolarMass() * 60.0 / this.getDensity("kg/m3");
        }
        if (flowunit.equals("m3/sec")) {
            this.initPhysicalProperties("density");
            return this.totalNumberOfMoles * this.getMolarMass() / this.getDensity("kg/m3");
        }
        if (flowunit.equals("mole/sec")) {
            return this.totalNumberOfMoles;
        }
        if (flowunit.equals("mole/min")) {
            return this.totalNumberOfMoles * 60.0;
        }
        if (flowunit.equals("mole/hr")) {
            return this.totalNumberOfMoles * 3600.0;
        }
        throw new RuntimeException("failed.. unit: " + flowunit + " not suported");
    }

    @Override
    public void changeComponentName(String name, String newName) {
        int i = 0;
        while (i < this.numberOfComponents) {
            if (this.componentNames.get(i).equals(name)) {
                this.componentNames.set(i, newName);
            }
            ++i;
        }
        i = 0;
        while (i < this.maxNumberOfPhases) {
            this.getPhase(i).getComponent(name).setComponentName(newName);
            ++i;
        }
    }

    @Override
    public void addComponent(String componentName, double value, String name, int phase) {
        if (!NeqSimDataBase.hasComponent(componentName)) {
            logger.error("No component with name: " + componentName + " in database");
            return;
        }
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + componentName + "'");
        double molarmass = 0.0;
        double stddens = 0.0;
        double boilp = 0.0;
        try {
            try {
                dataSet.next();
                molarmass = Double.parseDouble(dataSet.getString("molarmass")) / 1000.0;
                stddens = Double.parseDouble(dataSet.getString("stddens"));
                boilp = Double.parseDouble(dataSet.getString("normboil"));
            }
            catch (Exception e) {
                logger.error("failed " + e.toString());
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                dataSet.close();
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
            }
        }
        RateUnit unit = new RateUnit(value, name, molarmass, stddens, boilp);
        double SIval = unit.getSIvalue();
        this.addComponent(componentName, SIval, phase);
    }

    @Override
    public void addSalt(String componentName, double value) {
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM compsalt WHERE SaltName='" + componentName + "'");
        double val1 = 1.0E-20;
        double val2 = 1.0E-20;
        try {
            dataSet.next();
            String name1 = dataSet.getString("ion1").trim();
            String name2 = dataSet.getString("ion2").trim();
            val1 = Double.parseDouble(dataSet.getString("stoc1")) * value;
            val2 = Double.parseDouble(dataSet.getString("stoc2")) * value;
            this.addComponent(name1, val1);
            this.addComponent(name2, val2);
            logger.info("ok adding salts. Ions: " + name1 + ", " + name2);
        }
        catch (Exception e) {
            logger.error("failed " + e.toString());
        }
    }

    @Override
    public void addTBPfraction(String componentName, double numberOfMoles, double molarMass, double density2) {
        if (density2 < 0.0 || molarMass < 0.0) {
            logger.error("Negative input molar mass or density.");
            InvalidInputException e = new InvalidInputException();
            throw new RuntimeException(e);
        }
        SystemInterface refSystem = null;
        double TC = 0.0;
        double PC = 0.0;
        double m = 0.0;
        double TB = 0.0;
        double acs = 0.0;
        double racketZ = 0.0;
        componentName = String.valueOf(componentName.split("_PC")[0]) + "_PC";
        try {
            refSystem = (SystemInterface)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            refSystem.setTemperature(288.15);
            refSystem.setPressure(1.01325);
            refSystem.addComponent("default", 1.0, 273.15, 50.0, 0.1);
            refSystem.init(0);
            refSystem.setNumberOfPhases(1);
            refSystem.setPhaseType(0, "liquid");
            TC = this.characterization.getTBPModel().calcTC(molarMass *= 1000.0, density2);
            PC = this.characterization.getTBPModel().calcPC(molarMass, density2);
            m = this.characterization.getTBPModel().calcm(molarMass, density2);
            acs = this.characterization.getTBPModel().calcAcentricFactor(molarMass, density2);
            TB = this.characterization.getTBPModel().calcTB(molarMass, density2);
            molarMass /= 1000.0;
            int i = 0;
            while (i < refSystem.getNumberOfPhases()) {
                refSystem.getPhase(i).getComponent(0).setComponentName(componentName);
                refSystem.getPhase(i).getComponent(0).setMolarMass(molarMass);
                refSystem.getPhase(i).getComponent(0).setAcentricFactor(acs);
                refSystem.getPhase(i).getComponent(0).setTC(TC);
                refSystem.getPhase(i).getComponent(0).setPC(PC);
                refSystem.getPhase(i).getComponent(0).setComponentType("TBPfraction");
                refSystem.getPhase(i).getComponent(0).setIsTBPfraction(true);
                if (this.characterization.getTBPModel().isCalcm()) {
                    refSystem.getPhase(i).getComponent(0).getAttractiveTerm().setm(m);
                    acs = refSystem.getPhase(i).getComponent(0).getAcentricFactor();
                }
                ++i;
            }
            refSystem.setTemperature(288.15);
            refSystem.setPressure(1.01325);
            refSystem.init(1);
            racketZ = this.characterization.getTBPModel().calcRacketZ(refSystem, molarMass * 1000.0, density2);
            refSystem.getPhase(0).getComponent(0).setRacketZ(racketZ);
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        double critVol = this.characterization.getTBPModel().calcCriticalVolume(molarMass * 1000.0, density2);
        this.addComponent(componentName, numberOfMoles, TC, PC, acs);
        double Kwatson = Math.pow(TB * 1.8, 0.3333333333333333) / density2;
        double CF = Math.pow((12.8 - Kwatson) * (10.0 - Kwatson) / (10.0 * acs), 2.0);
        double acsKeslerLee = acs;
        double cpa = (-0.33886 + 0.02827 * Kwatson - 0.26105 * CF + 0.59332 * acsKeslerLee * CF) * 4.18682 * molarMass * 1000.0;
        double cpb = (-(0.9291 - 1.1543 * Kwatson + 0.0368 * Kwatson * Kwatson) * 1.0E-4 + CF * (4.56 - 9.48 * acsKeslerLee) * 1.0E-4) * 4.18682 * molarMass * 1.8 * 1000.0;
        double cpc = (-1.6658E-7 + CF * (0.536 - 0.6828 * acsKeslerLee) * 1.0E-7) * 4.18682 * molarMass * 1.8 * 1.8 * 1000.0;
        double cpd = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            this.getPhase(i).setAttractiveTerm(this.attractiveTermNumber);
            this.getPhase(i).getComponent(componentName).setMolarMass(molarMass);
            this.getPhase(i).getComponent(componentName).setComponentType("TBPfraction");
            this.getPhase(i).getComponent(componentName).setNormalLiquidDensity(density2);
            this.getPhase(i).getComponent(componentName).setNormalBoilingPoint(TB - 273.15);
            this.getPhase(i).getComponent(componentName).setAcentricFactor(refSystem.getPhase(0).getComponent(0).getAcentricFactor());
            this.getPhase(i).getComponent(componentName).setCriticalVolume(critVol);
            this.getPhase(i).getComponent(componentName).setRacketZ(racketZ);
            this.getPhase(i).getComponent(componentName).setRacketZCPA(racketZ);
            this.getPhase(i).getComponent(componentName).setIsTBPfraction(true);
            this.getPhase(i).getComponent(componentName).setParachorParameter(this.characterization.getTBPModel().calcParachorParameter(molarMass, density2));
            this.getPhase(i).getComponent(componentName).setCriticalViscosity(this.characterization.getTBPModel().calcCriticalViscosity(molarMass * 1000.0, density2));
            this.getPhase(i).getComponent(componentName).setTriplePointTemperature(374.5 + 0.02617 * this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0 - 20172.0 / (this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0));
            this.getPhase(i).getComponent(componentName).setHeatOfFusion(0.5970399212878645 * this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0 * this.getPhase(i).getComponent(componentName).getTriplePointTemperature());
            this.getPhase(i).getComponent(componentName).setIdealGasEnthalpyOfFormation(-1462600.0 * molarMass - 47566.0);
            this.getPhase(i).getComponent(componentName).setCpA(cpa);
            this.getPhase(i).getComponent(componentName).setCpB(cpb);
            this.getPhase(i).getComponent(componentName).setCpC(cpc);
            this.getPhase(i).getComponent(componentName).setCpD(cpd);
            ++i;
        }
    }

    @Override
    public void addTBPfraction(String componentName, double numberOfMoles, double molarMass, double density2, double criticalTemperature, double criticalPressure, double acentricFactor) {
        if (density2 < 0.0 || molarMass < 0.0) {
            logger.error("Negative input molar mass or density.");
            InvalidInputException e = new InvalidInputException();
            throw new RuntimeException(e);
        }
        SystemInterface refSystem = null;
        double TC = 0.0;
        double PC = 0.0;
        double m = 0.0;
        double TB = 0.0;
        double acs = 0.0;
        double racketZ = 0.0;
        componentName = String.valueOf(componentName.split("_PC")[0]) + "_PC";
        try {
            refSystem = (SystemInterface)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            refSystem.setTemperature(288.15);
            refSystem.setPressure(1.01325);
            refSystem.addComponent("default", 1.0, 273.15, 50.0, 0.1);
            refSystem.init(0);
            refSystem.setNumberOfPhases(1);
            refSystem.setPhaseType(0, "liquid");
            TC = criticalTemperature;
            PC = criticalPressure;
            m = this.characterization.getTBPModel().calcm(molarMass *= 1000.0, density2);
            acs = acentricFactor;
            TB = this.characterization.getTBPModel().calcTB(molarMass, density2);
            molarMass /= 1000.0;
            int i = 0;
            while (i < refSystem.getNumberOfPhases()) {
                refSystem.getPhase(i).getComponent(0).setComponentName(componentName);
                refSystem.getPhase(i).getComponent(0).setMolarMass(molarMass);
                refSystem.getPhase(i).getComponent(0).setAcentricFactor(acs);
                refSystem.getPhase(i).getComponent(0).setTC(TC);
                refSystem.getPhase(i).getComponent(0).setPC(PC);
                refSystem.getPhase(i).getComponent(0).setComponentType("TBPfraction");
                refSystem.getPhase(i).getComponent(0).setIsTBPfraction(true);
                if (this.characterization.getTBPModel().isCalcm()) {
                    refSystem.getPhase(i).getComponent(0).getAttractiveTerm().setm(m);
                    acs = refSystem.getPhase(i).getComponent(0).getAcentricFactor();
                }
                ++i;
            }
            refSystem.setTemperature(288.15);
            refSystem.setPressure(1.01325);
            refSystem.init(1);
            racketZ = this.characterization.getTBPModel().calcRacketZ(refSystem, molarMass * 1000.0, density2);
            refSystem.getPhase(0).getComponent(0).setRacketZ(racketZ);
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        double critVol = this.characterization.getTBPModel().calcCriticalVolume(molarMass * 1000.0, density2);
        this.addComponent(componentName, numberOfMoles, TC, PC, acs);
        double Kwatson = Math.pow(TB * 1.8, 0.3333333333333333) / density2;
        double CF = Math.pow((12.8 - Kwatson) * (10.0 - Kwatson) / (10.0 * acs), 2.0);
        double acsKeslerLee = acs;
        double cpa = (-0.33886 + 0.02827 * Kwatson - 0.26105 * CF + 0.59332 * acsKeslerLee * CF) * 4.18682 * molarMass * 1000.0;
        double cpb = (-(0.9291 - 1.1543 * Kwatson + 0.0368 * Kwatson * Kwatson) * 1.0E-4 + CF * (4.56 - 9.48 * acsKeslerLee) * 1.0E-4) * 4.18682 * molarMass * 1.8 * 1000.0;
        double cpc = (-1.6658E-7 + CF * (0.536 - 0.6828 * acsKeslerLee) * 1.0E-7) * 4.18682 * molarMass * 1.8 * 1.8 * 1000.0;
        double cpd = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            this.getPhase(i).setAttractiveTerm(this.attractiveTermNumber);
            this.getPhase(i).getComponent(componentName).setMolarMass(molarMass);
            this.getPhase(i).getComponent(componentName).setComponentType("TBPfraction");
            this.getPhase(i).getComponent(componentName).setNormalLiquidDensity(density2);
            this.getPhase(i).getComponent(componentName).setNormalBoilingPoint(TB - 273.15);
            this.getPhase(i).getComponent(componentName).setAcentricFactor(refSystem.getPhase(0).getComponent(0).getAcentricFactor());
            this.getPhase(i).getComponent(componentName).setCriticalVolume(critVol);
            this.getPhase(i).getComponent(componentName).setRacketZ(racketZ);
            this.getPhase(i).getComponent(componentName).setRacketZCPA(racketZ);
            this.getPhase(i).getComponent(componentName).setIsTBPfraction(true);
            this.getPhase(i).getComponent(componentName).setParachorParameter(this.characterization.getTBPModel().calcParachorParameter(molarMass, density2));
            this.getPhase(i).getComponent(componentName).setCriticalViscosity(this.characterization.getTBPModel().calcCriticalViscosity(molarMass * 1000.0, density2));
            this.getPhase(i).getComponent(componentName).setTriplePointTemperature(374.5 + 0.02617 * this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0 - 20172.0 / (this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0));
            this.getPhase(i).getComponent(componentName).setHeatOfFusion(0.5970399212878645 * this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0 * this.getPhase(i).getComponent(componentName).getTriplePointTemperature());
            this.getPhase(i).getComponent(componentName).setIdealGasEnthalpyOfFormation(-1462600.0 * molarMass - 47566.0);
            this.getPhase(i).getComponent(componentName).setCpA(cpa);
            this.getPhase(i).getComponent(componentName).setCpB(cpb);
            this.getPhase(i).getComponent(componentName).setCpC(cpc);
            this.getPhase(i).getComponent(componentName).setCpD(cpd);
            ++i;
        }
    }

    @Override
    public void addPlusFraction(String componentName, double numberOfMoles, double molarMass, double density2) {
        this.addTBPfraction(componentName, numberOfMoles, molarMass, density2);
        componentName = String.valueOf(componentName) + "_" + "PC";
        int i = 0;
        while (i < this.numberOfPhases) {
            this.getPhase(i).getComponent(componentName).setIsPlusFraction(true);
            this.getPhase(i).getComponent(componentName).setCriticalViscosity(7.9483 * Math.sqrt(1000.0 * this.getPhase(i).getComponent(componentName).getMolarMass()) * Math.pow(this.getPhase(i).getComponent(componentName).getPC(), 0.6666666666666666) / Math.pow(this.getPhase(i).getComponent(componentName).getTC(), 0.16666666666666666) * 1.0E-7);
            ++i;
        }
    }

    @Override
    public void addComponent(String componentName, double value, String name) {
        double boilp;
        double stddens;
        double molarmass;
        block12: {
            if (!NeqSimDataBase.hasComponent(componentName)) {
                logger.error("No component with name: " + componentName + " in database");
                return;
            }
            NeqSimDataBase database = new NeqSimDataBase();
            ResultSet dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + componentName + "'");
            molarmass = 0.0;
            stddens = 0.0;
            boilp = 0.0;
            try {
                try {
                    dataSet.next();
                    molarmass = Double.parseDouble(dataSet.getString("molarmass")) / 1000.0;
                    stddens = Double.parseDouble(dataSet.getString("stddens"));
                    boilp = Double.parseDouble(dataSet.getString("normboil"));
                }
                catch (Exception e) {
                    logger.error("failed " + e.toString());
                    try {
                        dataSet.close();
                    }
                    catch (Exception e2) {
                        logger.error("error", (Throwable)e2);
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    logger.error("error", (Throwable)e);
                }
                throw throwable;
            }
            try {
                dataSet.close();
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
            }
        }
        RateUnit unit = new RateUnit(value, name, molarmass, stddens, boilp);
        double SIval = unit.getSIvalue();
        this.addComponent(componentName, SIval);
    }

    @Override
    public void addComponent(String componentName, double moles, double TC, double PC, double acs) {
        String comNam = componentName;
        if (this.getPhase(0).hasComponent(componentName)) {
            this.addComponent(componentName, moles);
        } else {
            this.addComponent("default", moles);
            comNam = "default";
        }
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            this.getPhase(i).getComponent(comNam).setComponentName(componentName);
            this.getPhase(i).getComponent(componentName).setTC(TC);
            this.getPhase(i).getComponent(componentName).setPC(PC);
            this.getPhase(i).getComponent(componentName).setAcentricFactor(acs);
            ++i;
        }
        if (comNam.equals("default")) {
            this.componentNames.remove("default");
            this.componentNames.add(componentName);
        }
    }

    @Override
    public void addComponent(int componentIndex, double moles) {
        if (componentIndex >= this.getPhase(0).getNumberOfComponents()) {
            logger.error("componentIndex higher than number of components in database");
            return;
        }
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + moles);
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            this.getPhase(i).addMolesChemReac(componentIndex, moles, moles);
            ++i;
        }
    }

    @Override
    public void addComponent(String name) {
        this.addComponent(name, 0.0);
    }

    @Override
    public void addComponent(ComponentInterface inComponent) {
        if (inComponent.isIsTBPfraction()) {
            this.addTBPfraction(inComponent.getComponentName(), inComponent.getNumberOfmoles(), inComponent.getMolarMass(), inComponent.getNormalLiquidDensity());
            String componentName = inComponent.getComponentName();
            this.changeComponentName(String.valueOf(componentName) + "_PC", componentName.replaceFirst("_PC", ""));
            int i = 0;
            while (i < this.numberOfPhases) {
                this.getPhase(i).getComponent(componentName).setAttractiveTerm(inComponent.getAttractiveTermNumber());
                this.getPhase(i).getComponent(componentName).setTC(inComponent.getTC());
                this.getPhase(i).getComponent(componentName).setPC(inComponent.getPC());
                this.getPhase(i).getComponent(componentName).setMolarMass(inComponent.getMolarMass());
                this.getPhase(i).getComponent(componentName).setComponentType("TBPfraction");
                this.getPhase(i).getComponent(componentName).setNormalLiquidDensity(inComponent.getNormalLiquidDensity());
                this.getPhase(i).getComponent(componentName).setNormalBoilingPoint(inComponent.getNormalBoilingPoint());
                this.getPhase(i).getComponent(componentName).setAcentricFactor(inComponent.getAcentricFactor());
                this.getPhase(i).getComponent(componentName).setCriticalVolume(inComponent.getCriticalVolume());
                this.getPhase(i).getComponent(componentName).setRacketZ(inComponent.getRacketZ());
                this.getPhase(i).getComponent(componentName).setRacketZCPA(inComponent.getRacketZCPA());
                this.getPhase(i).getComponent(componentName).setIsTBPfraction(true);
                this.getPhase(i).getComponent(componentName).setParachorParameter(inComponent.getParachorParameter());
                this.getPhase(i).getComponent(componentName).setTriplePointTemperature(inComponent.getTriplePointTemperature());
                this.getPhase(i).getComponent(componentName).setIdealGasEnthalpyOfFormation(inComponent.getIdealGasEnthalpyOfFormation());
                this.getPhase(i).getComponent(componentName).setCpA(inComponent.getCpA());
                this.getPhase(i).getComponent(componentName).setCpB(inComponent.getCpB());
                this.getPhase(i).getComponent(componentName).setCpC(inComponent.getCpC());
                this.getPhase(i).getComponent(componentName).setCpD(inComponent.getCpD());
                ++i;
            }
        } else {
            this.addComponent(inComponent.getComponentName(), inComponent.getNumberOfmoles());
        }
    }

    @Override
    public void addComponent(String componentName, double moles) {
        int i;
        int index = 0;
        boolean addForFirstTime = true;
        int p = 0;
        while (p < this.componentNames.size()) {
            if (this.componentNames.get(p).equals(componentName)) {
                addForFirstTime = false;
                index = p;
            }
            ++p;
        }
        if (!NeqSimDataBase.hasComponent(componentName) && addForFirstTime) {
            return;
        }
        if (addForFirstTime) {
            if (moles < 0.0) {
                logger.error("Negative input number of moles of component: " + componentName);
                InvalidInputException e = new InvalidInputException();
                throw new RuntimeException(e);
            }
            this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + moles);
            this.componentNames.add(componentName);
            i = 0;
            while (i < this.getMaxNumberOfPhases()) {
                this.getPhase(i).addcomponent(componentName, moles, moles, this.numberOfComponents);
                this.getPhase(i).setAttractiveTerm(this.attractiveTermNumber);
                ++i;
            }
            ++this.numberOfComponents;
        } else {
            i = 0;
            while (i < this.getMaxNumberOfPhases()) {
                if (this.getPhase(i).getComponent(componentName).getNumberOfMolesInPhase() + moles < 0.0) {
                    this.init(0);
                    break;
                }
                ++i;
            }
            this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + moles);
            i = 0;
            while (i < this.getMaxNumberOfPhases()) {
                this.getPhase(i).addMolesChemReac(index, moles, moles);
                ++i;
            }
        }
    }

    @Override
    public void addComponent(String componentName, double moles, int phaseNumber) {
        if (!NeqSimDataBase.hasComponent(componentName)) {
            logger.error("No component with name: " + componentName + " in database");
            return;
        }
        int index = 0;
        boolean addForFirstTime = true;
        int p = 0;
        while (p < this.componentNames.size()) {
            if (this.componentNames.get(p).equals(componentName)) {
                addForFirstTime = false;
                index = p;
            }
            ++p;
        }
        if (addForFirstTime) {
            if (moles < 0.0) {
                logger.error("Negative input number of moles.");
                InvalidInputException e = new InvalidInputException();
                throw new RuntimeException(e);
            }
            this.componentNames.add(componentName);
            double k = 1.0;
            this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + moles);
            int i = 0;
            while (i < this.getMaxNumberOfPhases()) {
                k = phaseNumber == i ? 1.0 : 1.0E-30;
                this.getPhase(i).addcomponent(componentName, moles, moles * k, this.numberOfComponents);
                this.getPhase(i).setAttractiveTerm(this.attractiveTermNumber);
                ++i;
            }
            ++this.numberOfComponents;
        } else {
            this.addComponent(index, moles, phaseNumber);
        }
    }

    @Override
    public void addComponent(int index, double moles, int phaseNumber) {
        if (index >= this.getPhase(0).getNumberOfComponents()) {
            logger.error("componentIndex higher than number of components in database");
            return;
        }
        double k = 1.0;
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            k = phaseNumber == i ? 1.0 : 1.0E-30;
            this.phaseArray[this.phaseIndex[i]].addMolesChemReac(index, moles * k, moles);
            ++i;
        }
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + moles);
    }

    @Override
    public void removeComponent(String name) {
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() - this.phaseArray[0].getComponent(name).getNumberOfmoles());
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            this.getPhase(i).removeComponent(name, this.getTotalNumberOfMoles(), this.phaseArray[this.phaseIndex[i]].getComponent(name).getNumberOfMolesInPhase(), this.phaseArray[this.phaseIndex[i]].getComponent(name).getComponentNumber());
            ++i;
        }
        this.componentNames.remove(name);
        --this.numberOfComponents;
    }

    @Override
    public void setEmptyFluid() {
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            this.getPhase(i).setEmptyFluid();
            ++i;
        }
        this.totalNumberOfMoles = 0.0;
    }

    @Override
    @Deprecated
    public void removeMoles() {
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            this.getPhase(i).setEmptyFluid();
            ++i;
        }
        this.totalNumberOfMoles = 0.0;
    }

    @Override
    public final double calcBeta() throws IsNaNException, TooManyIterationsException {
        ComponentInterface[] compArray = this.getPhase(0).getComponents();
        int iterations = 0;
        double tolerance = 1.0E-12;
        double deriv = 0.0;
        double gbeta = 0.0;
        double gtest = 0.0;
        double betal = 0.0;
        double nybeta = 0.0;
        double midler = 0.0;
        double minBeta = tolerance;
        double maxBeta = 1.0 - tolerance;
        double g0 = -1.0;
        double g1 = 1.0;
        nybeta = this.beta[0];
        betal = 1.0 - nybeta;
        int i = 0;
        while (i < this.numberOfComponents) {
            midler = (compArray[i].getK() * compArray[i].getz() - 1.0) / (compArray[i].getK() - 1.0);
            if (midler > minBeta && compArray[i].getK() > 1.0) {
                minBeta = midler;
            }
            if ((midler = (1.0 - compArray[i].getz()) / (1.0 - compArray[i].getK())) < maxBeta && compArray[i].getK() < 1.0) {
                maxBeta = midler;
            }
            g0 += compArray[i].getz() * compArray[i].getK();
            g1 += -compArray[i].getz() / compArray[i].getK();
            ++i;
        }
        if (g0 < 0.0) {
            this.beta[1] = 1.0 - tolerance;
            this.beta[0] = tolerance;
            return this.beta[0];
        }
        if (g1 > 0.0) {
            this.beta[1] = tolerance;
            this.beta[0] = 1.0 - tolerance;
            return this.beta[0];
        }
        nybeta = (minBeta + maxBeta) / 2.0;
        betal = 1.0 - nybeta;
        gtest = 0.0;
        i = 0;
        while (i < this.numberOfComponents) {
            gtest += compArray[i].getz() * (compArray[i].getK() - 1.0) / (1.0 - nybeta + nybeta * compArray[i].getK());
            ++i;
        }
        if (gtest >= 0.0) {
            minBeta = nybeta;
        } else {
            maxBeta = nybeta;
        }
        if (gtest < 0.0) {
            double minold = minBeta;
            minBeta = 1.0 - maxBeta;
            maxBeta = 1.0 - minold;
        }
        iterations = 0;
        double step = 1.0;
        do {
            ++iterations;
            if (gtest >= 0.0) {
                deriv = 0.0;
                gbeta = 0.0;
                i = 0;
                while (i < this.numberOfComponents) {
                    double temp1 = compArray[i].getK() - 1.0;
                    double temp2 = 1.0 + temp1 * nybeta;
                    deriv += -(compArray[i].getz() * temp1 * temp1) / (temp2 * temp2);
                    gbeta += compArray[i].getz() * (compArray[i].getK() - 1.0) / (1.0 + (compArray[i].getK() - 1.0) * nybeta);
                    ++i;
                }
                if (gbeta >= 0.0) {
                    minBeta = nybeta;
                } else {
                    maxBeta = nybeta;
                }
                nybeta -= gbeta / deriv;
                if (nybeta > maxBeta) {
                    nybeta = maxBeta;
                }
                if (!(nybeta < minBeta)) continue;
                nybeta = minBeta;
                continue;
            }
            deriv = 0.0;
            gbeta = 0.0;
            i = 0;
            while (i < this.numberOfComponents) {
                deriv -= compArray[i].getz() * (compArray[i].getK() - 1.0) * (1.0 - compArray[i].getK()) / Math.pow(betal + (1.0 - betal) * compArray[i].getK(), 2.0);
                gbeta += compArray[i].getz() * (compArray[i].getK() - 1.0) / (betal + (-betal + 1.0) * compArray[i].getK());
                ++i;
            }
            if (gbeta < 0.0) {
                minBeta = betal;
            } else {
                maxBeta = betal;
            }
            betal -= gbeta / deriv;
            if (betal > maxBeta) {
                betal = maxBeta;
            }
            if (betal < minBeta) {
                betal = minBeta;
            }
            nybeta = 1.0 - betal;
        } while (Math.abs(step = gbeta / deriv) >= 1.0E-10 && iterations < 300);
        if (nybeta <= tolerance) {
            this.phase = 1;
            nybeta = tolerance;
        } else if (nybeta >= 1.0 - tolerance) {
            this.phase = 0;
            nybeta = 1.0 - tolerance;
        } else {
            this.phase = 2;
        }
        this.beta[0] = nybeta;
        this.beta[1] = 1.0 - nybeta;
        if (iterations >= 300) {
            throw new TooManyIterationsException();
        }
        if (Double.isNaN(this.beta[1])) {
            i = 0;
            while (i < this.numberOfComponents) {
                ++i;
            }
            throw new IsNaNException();
        }
        return this.beta[0];
    }

    @Override
    public final double initBeta() {
        int i = 0;
        while (i < this.numberOfPhases) {
            this.beta[this.phaseIndex[i]] = this.getPhase(i).getNumberOfMolesInPhase() / this.getTotalNumberOfMoles();
            ++i;
        }
        return this.beta[this.phaseIndex[0]];
    }

    @Override
    public double getJouleThomsonCoefficient(String unit) {
        double JTcoef = this.getJouleThomsonCoefficient();
        double conversionFactor = 1.0;
        switch (unit) {
            case "K/bar": {
                conversionFactor = 1.0;
                break;
            }
            case "C/bar": {
                conversionFactor = 1.0;
            }
        }
        return JTcoef * conversionFactor;
    }

    @Override
    public double getJouleThomsonCoefficient() {
        double JTcoef = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            JTcoef += this.getBeta(i) * this.getPhase(i).getJouleThomsonCoefficient();
            ++i;
        }
        return JTcoef;
    }

    @Override
    public double getSoundSpeed(String unit) {
        double refVel = this.getSoundSpeed();
        double conversionFactor = 1.0;
        switch (unit) {
            case "m/s": {
                conversionFactor = 1.0;
                break;
            }
            case "km/hr": {
                conversionFactor = 3.6;
            }
        }
        return refVel * conversionFactor;
    }

    @Override
    public double getSoundSpeed() {
        double soundspeed = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            soundspeed += this.getBeta(i) * this.getPhase(i).getSoundSpeed();
            ++i;
        }
        return soundspeed;
    }

    @Override
    public final void initTotalNumberOfMoles(double change) {
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + change);
        int j = 0;
        while (j < this.numberOfPhases) {
            int i = 0;
            while (i < this.numberOfComponents) {
                this.getPhase(j).getComponents()[i].setNumberOfmoles(this.phaseArray[this.phaseIndex[0]].getComponents()[i].getNumberOfmoles());
                ++i;
            }
            ++j;
        }
    }

    @Override
    public final void init_x_y() {
        int j = 0;
        while (j < this.numberOfPhases) {
            int i = 0;
            while (i < this.numberOfComponents) {
                this.getPhase(j).getComponents()[i].setz(this.getPhase(j).getComponents()[i].getNumberOfmoles() / this.getTotalNumberOfMoles());
                this.getPhase(j).getComponents()[i].setx(this.getPhase(j).getComponents()[i].getNumberOfMolesInPhase() / this.getPhase(j).getNumberOfMolesInPhase());
                ++i;
            }
            this.getPhase(j).normalize();
            ++j;
        }
    }

    @Override
    public final void calc_x_y() {
        int j = 0;
        while (j < this.numberOfPhases) {
            int i = 0;
            while (i < this.numberOfComponents) {
                if (j == 0) {
                    this.getPhase(j).getComponent(i).setx(this.getPhase(0).getComponent(i).getK() * this.getPhase(j).getComponents()[i].getz() / (1.0 - this.beta[this.phaseIndex[0]] + this.beta[this.phaseIndex[0]] * this.getPhase(0).getComponent(i).getK()));
                } else if (j == 1) {
                    this.getPhase(j).getComponent(i).setx(this.getPhase(0).getComponent(i).getz() / (1.0 - this.beta[this.phaseIndex[0]] + this.beta[this.phaseIndex[0]] * this.getPhase(0).getComponent(i).getK()));
                }
                ++i;
            }
            this.getPhase(j).normalize();
            ++j;
        }
    }

    @Override
    public final void calc_x_y_nonorm() {
        int j = 0;
        while (j < this.numberOfPhases) {
            int i = 0;
            while (i < this.numberOfComponents) {
                if (j == 0) {
                    this.getPhase(j).getComponents()[i].setx(this.getPhase(j).getComponents()[i].getK() * this.getPhase(j).getComponents()[i].getz() / (1.0 - this.beta[this.phaseIndex[0]] + this.beta[this.phaseIndex[0]] * this.getPhase(0).getComponents()[i].getK()));
                }
                if (j == 1) {
                    this.getPhase(j).getComponents()[i].setx(this.getPhase(0).getComponents()[i].getz() / (1.0 - this.beta[this.phaseIndex[0]] + this.beta[this.phaseIndex[0]] * this.getPhase(0).getComponents()[i].getK()));
                }
                ++i;
            }
            ++j;
        }
    }

    @Override
    public void reset_x_y() {
        int j = 0;
        while (j < this.numberOfPhases) {
            int i = 0;
            while (i < this.numberOfComponents) {
                this.getPhase(j).getComponents()[i].setx(this.phaseArray[this.phaseIndex[0]].getComponents()[i].getz());
                ++i;
            }
            ++j;
        }
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.numberOfComponents) {
            this.addComponent(this.getPhase(0).getComponent(i).getComponentName(), -this.getPhase(0).getComponent(i).getNumberOfmoles());
            ++i;
        }
    }

    @Override
    public boolean hasSolidPhase() {
        int i = 0;
        while (i < this.numberOfPhases) {
            if (this.getPhase(i).getPhaseTypeName().equals("solid")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void init(int type) {
        this.isInitialized = true;
        if (this.numericDerivatives) {
            this.initNumeric(type);
        } else {
            this.initAnalytic(type);
        }
    }

    @Override
    public void initThermoProperties() {
        this.init(2);
    }

    @Override
    public void initProperties() {
        if (!this.isInitialized) {
            this.init(0);
            this.setNumberOfPhases(1);
        }
        this.initThermoProperties();
        this.initPhysicalProperties();
    }

    @Override
    public void init(int type, int phase) {
        this.isInitialized = true;
        if (this.numericDerivatives) {
            this.initNumeric(type, phase);
        } else {
            this.initAnalytic(type, phase);
        }
    }

    @Override
    public void init() {
        this.init(this.initType);
    }

    public void initAnalytic(int type) {
        int j;
        int i;
        if (type == 0) {
            this.numberOfPhases = this.getMaxNumberOfPhases();
            i = 0;
            while (i < this.getMaxNumberOfPhases()) {
                this.phaseType[i] = 0;
                this.beta[i] = 1.0;
                this.phaseIndex[i] = i;
                ++i;
            }
            this.phaseType[0] = 1;
            i = 0;
            while (i < this.numberOfPhases) {
                if (this.getPhase(i) != null) {
                    this.getPhase(i).init(this.getTotalNumberOfMoles(), this.numberOfComponents, type, this.phaseType[this.phaseIndex[i]], this.beta[this.phaseIndex[i]]);
                }
                ++i;
            }
            this.numberOfPhases = 2;
        }
        if (type == 1) {
            i = 0;
            while (i < this.numberOfPhases) {
                this.getPhase(i).init(this.getTotalNumberOfMoles(), this.numberOfComponents, 1, this.phaseType[this.phaseIndex[i]], this.beta[this.phaseIndex[i]]);
                ++i;
            }
            i = 0;
            while (i < this.numberOfPhases) {
                j = 0;
                while (j < this.numberOfComponents) {
                    this.getPhase(i).getComponents()[j].fugcoef(this.getPhase(i));
                    ++j;
                }
                ++i;
            }
        }
        if (type == 2) {
            i = 0;
            while (i < this.numberOfPhases) {
                this.getPhase(i).init(this.getTotalNumberOfMoles(), this.numberOfComponents, 2, this.phaseType[this.phaseIndex[i]], this.beta[this.phaseIndex[i]]);
                ++i;
            }
            i = 0;
            while (i < this.numberOfPhases) {
                j = 0;
                while (j < this.numberOfComponents) {
                    this.getPhase(i).getComponents()[j].fugcoef(this.getPhase(i));
                    this.getPhase(i).getComponents()[j].logfugcoefdT(this.getPhase(i));
                    this.getPhase(i).getComponents()[j].logfugcoefdP(this.getPhase(i));
                    ++j;
                }
                ++i;
            }
        }
        if (type == 3) {
            i = 0;
            while (i < this.numberOfPhases) {
                this.getPhase(i).init(this.getTotalNumberOfMoles(), this.numberOfComponents, 3, this.phaseType[this.phaseIndex[i]], this.beta[this.phaseIndex[i]]);
                ++i;
            }
            i = 0;
            while (i < this.numberOfPhases) {
                j = 0;
                while (j < this.numberOfComponents) {
                    this.getPhase(i).getComponents()[j].fugcoef(this.getPhase(i));
                    this.getPhase(i).getComponents()[j].logfugcoefdT(this.getPhase(i));
                    this.getPhase(i).getComponents()[j].logfugcoefdP(this.getPhase(i));
                    this.getPhase(i).getComponents()[j].logfugcoefdN(this.getPhase(i));
                    ++j;
                }
                ++i;
            }
        }
        if (type == 4) {
            i = 0;
            while (i < this.numberOfPhases) {
                this.getPhase(i).init(this.getTotalNumberOfMoles(), this.numberOfComponents, 3, this.phaseType[this.phaseIndex[i]], this.beta[this.phaseIndex[i]]);
                ++i;
            }
            i = 0;
            while (i < this.numberOfPhases) {
                j = 0;
                while (j < this.numberOfComponents) {
                    this.getPhase(i).getComponents()[j].fugcoef(this.getPhase(i));
                    this.getPhase(i).getComponents()[j].fugcoefDiffTempNumeric(this.getPhase(i), this.numberOfComponents, this.getPhase(i).getTemperature(), this.getPhase(i).getPressure());
                    this.getPhase(i).getComponents()[j].fugcoefDiffPresNumeric(this.getPhase(i), this.numberOfComponents, this.getPhase(i).getTemperature(), this.getPhase(i).getPressure());
                    ++j;
                }
                ++i;
            }
        }
        i = 1;
        while (i < this.numberOfPhases) {
            if (this.getPhase(i).getPhaseTypeName().equals("gas")) {
                this.getPhase(i).setPhaseTypeName("oil");
            }
            ++i;
        }
    }

    public void initAnalytic(int type, int phase) {
        int j;
        if (type == 0) {
            this.beta[0] = 1.0;
            this.phaseIndex[phase] = phase;
            this.getPhase(phase).init(this.getTotalNumberOfMoles(), this.numberOfComponents, 0, this.phaseType[this.phaseIndex[phase]], this.beta[this.phaseIndex[phase]]);
        } else if (type == 1) {
            this.getPhase(phase).init(this.getTotalNumberOfMoles(), this.numberOfComponents, 1, this.phaseType[this.phaseIndex[phase]], this.beta[this.phaseIndex[phase]]);
            j = 0;
            while (j < this.numberOfComponents) {
                this.getPhase(phase).getComponents()[j].fugcoef(this.getPhase(phase));
                ++j;
            }
        } else if (type == 2) {
            this.getPhase(phase).init(this.getTotalNumberOfMoles(), this.numberOfComponents, 2, this.phaseType[this.phaseIndex[phase]], this.beta[this.phaseIndex[phase]]);
            j = 0;
            while (j < this.numberOfComponents) {
                this.getPhase(phase).getComponents()[j].fugcoef(this.getPhase(phase));
                this.getPhase(phase).getComponents()[j].logfugcoefdT(this.getPhase(phase));
                this.getPhase(phase).getComponents()[j].logfugcoefdP(this.getPhase(phase));
                ++j;
            }
        } else if (type == 3) {
            this.getPhase(phase).init(this.getTotalNumberOfMoles(), this.numberOfComponents, 3, this.phaseType[this.phaseIndex[phase]], this.beta[this.phaseIndex[phase]]);
            j = 0;
            while (j < this.numberOfComponents) {
                this.getPhase(phase).getComponents()[j].fugcoef(this.getPhase(phase));
                this.getPhase(phase).getComponents()[j].logfugcoefdT(this.getPhase(phase));
                this.getPhase(phase).getComponents()[j].logfugcoefdP(this.getPhase(phase));
                this.getPhase(phase).getComponents()[j].logfugcoefdN(this.getPhase(phase));
                ++j;
            }
        }
        int i = 1;
        while (i < this.numberOfPhases) {
            if (this.getPhase(i).getPhaseTypeName().equals("gas")) {
                this.getPhase(i).setPhaseTypeName("oil");
            }
            ++i;
        }
    }

    public void initNumeric(int type) {
        this.initNumeric(type, 1);
    }

    public void initNumeric(int type, int phasen) {
        if (type < 2) {
            this.initAnalytic(type);
        } else if (type >= 2) {
            double[][] gasfug = new double[2][this.getPhases()[0].getNumberOfComponents()];
            double[][] liqfug = new double[2][this.getPhases()[0].getNumberOfComponents()];
            double dt = this.getTemperature() / 1000000.0;
            this.setTemperature(this.getTemperature() + dt);
            this.init(1);
            int i = 0;
            while (i < this.getPhases()[0].getNumberOfComponents()) {
                gasfug[0][i] = Math.log(this.getPhases()[0].getComponents()[i].getFugacityCoefficient());
                liqfug[0][i] = Math.log(this.getPhases()[1].getComponents()[i].getFugacityCoefficient());
                ++i;
            }
            this.setTemperature(this.getTemperature() - 2.0 * dt);
            this.init(1);
            i = 0;
            while (i < this.getPhases()[0].getNumberOfComponents()) {
                gasfug[1][i] = Math.log(this.getPhases()[0].getComponents()[i].getFugacityCoefficient());
                liqfug[1][i] = Math.log(this.getPhases()[1].getComponents()[i].getFugacityCoefficient());
                ++i;
            }
            i = 0;
            while (i < this.getPhases()[0].getNumberOfComponents()) {
                this.getPhase(0).getComponent(i).setdfugdt((gasfug[0][i] - gasfug[1][i]) / (2.0 * dt));
                this.getPhase(1).getComponent(i).setdfugdt((liqfug[0][i] - liqfug[1][i]) / (2.0 * dt));
                ++i;
            }
            this.setTemperature(this.getTemperature() + dt);
            double dp = this.getPressure() / 1000000.0;
            this.setPressure(this.getPressure() + dp);
            this.init(1);
            int i2 = 0;
            while (i2 < this.getPhases()[0].getNumberOfComponents()) {
                gasfug[0][i2] = Math.log(this.getPhases()[0].getComponents()[i2].getFugacityCoefficient());
                liqfug[0][i2] = Math.log(this.getPhases()[1].getComponents()[i2].getFugacityCoefficient());
                ++i2;
            }
            this.setPressure(this.getPressure() - 2.0 * dp);
            this.init(1);
            i2 = 0;
            while (i2 < this.getPhases()[0].getNumberOfComponents()) {
                gasfug[1][i2] = Math.log(this.getPhases()[0].getComponents()[i2].getFugacityCoefficient());
                liqfug[1][i2] = Math.log(this.getPhases()[1].getComponents()[i2].getFugacityCoefficient());
                ++i2;
            }
            i2 = 0;
            while (i2 < this.getPhases()[0].getNumberOfComponents()) {
                this.getPhase(0).getComponent(i2).setdfugdp((gasfug[0][i2] - gasfug[1][i2]) / (2.0 * dp));
                this.getPhase(1).getComponent(i2).setdfugdp((liqfug[0][i2] - liqfug[1][i2]) / (2.0 * dp));
                ++i2;
            }
            this.setPressure(this.getPressure() + dp);
            this.init(1);
            if (type == 3) {
                int phase = 0;
                while (phase < 2) {
                    int k = 0;
                    while (k < this.getPhases()[0].getNumberOfComponents()) {
                        double dn = this.getPhases()[phase].getComponents()[k].getNumberOfMolesInPhase() / 1000000.0;
                        this.addComponent(k, dn, phase);
                        this.init_x_y();
                        this.init(1);
                        int i3 = 0;
                        while (i3 < this.getPhases()[0].getNumberOfComponents()) {
                            liqfug[0][i3] = Math.log(this.getPhases()[phase].getComponents()[i3].getFugacityCoefficient());
                            ++i3;
                        }
                        this.addComponent(k, -2.0 * dn, phase);
                        this.init_x_y();
                        this.init(1);
                        i3 = 0;
                        while (i3 < this.getPhases()[0].getNumberOfComponents()) {
                            liqfug[1][i3] = Math.log(this.getPhases()[phase].getComponents()[i3].getFugacityCoefficient());
                            ++i3;
                        }
                        this.addComponent(k, dn, phase);
                        this.init_x_y();
                        this.init(1);
                        i3 = 0;
                        while (i3 < this.getPhases()[0].getNumberOfComponents()) {
                            this.getPhase(phase).getComponent(k).setdfugdn(i3, (liqfug[0][i3] - liqfug[1][i3]) / (2.0 * dn));
                            this.getPhase(phase).getComponent(k).setdfugdx(i3, (liqfug[0][i3] - liqfug[1][i3]) / (2.0 * dn) * this.getPhase(phase).getNumberOfMolesInPhase());
                            ++i3;
                        }
                        ++k;
                    }
                    ++phase;
                }
            }
        }
    }

    @Override
    public void initNumeric() {
        double[][] gasfug = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][] liqfug = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][] gasnumericDfugdt = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][] liqnumericDfugdt = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][] gasnumericDfugdp = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][] liqnumericDfugdp = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][][] gasnumericDfugdn = new double[2][this.getPhases()[0].getNumberOfComponents()][this.getPhases()[0].getNumberOfComponents()];
        double[][][] liqnumericDfugdn = new double[2][this.getPhases()[0].getNumberOfComponents()][this.getPhases()[0].getNumberOfComponents()];
        double dt = this.getTemperature() / 100000.0;
        this.setTemperature(this.getTemperature() + dt);
        this.init(1);
        int i = 0;
        while (i < this.getPhases()[0].getNumberOfComponents()) {
            gasfug[0][i] = Math.log(this.getPhases()[0].getComponents()[i].getFugacityCoefficient());
            liqfug[0][i] = Math.log(this.getPhases()[1].getComponents()[i].getFugacityCoefficient());
            ++i;
        }
        this.setTemperature(this.getTemperature() - 2.0 * dt);
        this.init(1);
        i = 0;
        while (i < this.getPhases()[0].getNumberOfComponents()) {
            gasfug[1][i] = Math.log(this.getPhases()[0].getComponents()[i].getFugacityCoefficient());
            liqfug[1][i] = Math.log(this.getPhases()[1].getComponents()[i].getFugacityCoefficient());
            gasnumericDfugdt[0][i] = (gasfug[0][i] - gasfug[1][i]) / (2.0 * dt);
            liqnumericDfugdt[0][i] = (liqfug[0][i] - liqfug[1][i]) / (2.0 * dt);
            this.phaseArray[0].getComponents()[i].setdfugdt(gasnumericDfugdt[0][i]);
            this.phaseArray[1].getComponents()[i].setdfugdt(liqnumericDfugdt[0][i]);
            ++i;
        }
        this.setTemperature(this.getTemperature() + dt);
        double dp = this.getPressure() / 100000.0;
        this.setPressure(this.getPressure() + dp);
        this.init(1);
        int i2 = 0;
        while (i2 < this.getPhases()[0].getNumberOfComponents()) {
            gasfug[0][i2] = Math.log(this.getPhases()[0].getComponents()[i2].getFugacityCoefficient());
            liqfug[0][i2] = Math.log(this.getPhases()[1].getComponents()[i2].getFugacityCoefficient());
            ++i2;
        }
        this.setPressure(this.getPressure() - 2.0 * dp);
        this.init(1);
        i2 = 0;
        while (i2 < this.getPhases()[0].getNumberOfComponents()) {
            gasfug[1][i2] = Math.log(this.getPhases()[0].getComponents()[i2].getFugacityCoefficient());
            liqfug[1][i2] = Math.log(this.getPhases()[1].getComponents()[i2].getFugacityCoefficient());
            gasnumericDfugdp[0][i2] = (gasfug[0][i2] - gasfug[1][i2]) / (2.0 * dp);
            liqnumericDfugdp[0][i2] = (liqfug[0][i2] - liqfug[1][i2]) / (2.0 * dp);
            this.phaseArray[0].getComponents()[i2].setdfugdp(gasnumericDfugdp[0][i2]);
            this.phaseArray[1].getComponents()[i2].setdfugdp(liqnumericDfugdp[0][i2]);
            ++i2;
        }
        this.setPressure(this.getPressure() + dp);
        this.init(1);
        int phase = 0;
        while (phase < 2) {
            int k = 0;
            while (k < this.getPhases()[0].getNumberOfComponents()) {
                double dn = this.getPhases()[phase].getComponents()[k].getNumberOfMolesInPhase() / 1000000.0;
                if (dn < 1.0E-12) {
                    dn = 1.0E-12;
                }
                this.addComponent(k, dn, phase);
                this.init_x_y();
                this.init(1);
                int i3 = 0;
                while (i3 < this.getPhases()[0].getNumberOfComponents()) {
                    liqfug[0][i3] = Math.log(this.getPhases()[phase].getComponents()[i3].getFugacityCoefficient());
                    ++i3;
                }
                this.addComponent(k, -2.0 * dn, phase);
                this.init_x_y();
                this.init(1);
                i3 = 0;
                while (i3 < this.getPhases()[0].getNumberOfComponents()) {
                    liqfug[1][i3] = Math.log(this.getPhases()[phase].getComponents()[i3].getFugacityCoefficient());
                    ++i3;
                }
                i3 = 0;
                while (i3 < this.getPhases()[0].getNumberOfComponents()) {
                    if (phase == 0) {
                        gasnumericDfugdn[0][k][i3] = (liqfug[0][i3] - liqfug[1][i3]) / (2.0 * dn);
                        this.phaseArray[0].getComponents()[i3].setdfugdn(k, gasnumericDfugdn[0][k][i3]);
                        this.phaseArray[0].getComponents()[i3].setdfugdx(k, gasnumericDfugdn[0][k][i3] * this.phaseArray[0].getNumberOfMolesInPhase());
                    }
                    if (phase == 1) {
                        liqnumericDfugdn[0][k][i3] = (liqfug[0][i3] - liqfug[1][i3]) / (2.0 * dn);
                        this.phaseArray[1].getComponents()[i3].setdfugdn(k, liqnumericDfugdn[0][k][i3]);
                        this.phaseArray[1].getComponents()[i3].setdfugdx(k, liqnumericDfugdn[0][k][i3] * this.phaseArray[1].getNumberOfMolesInPhase());
                    }
                    ++i3;
                }
                this.addComponent(k, dn, phase);
                this.init_x_y();
                this.init(1);
                ++k;
            }
            ++phase;
        }
    }

    @Override
    public void initPhysicalProperties() {
        int i = 0;
        while (i < this.numberOfPhases) {
            this.getPhase(i).initPhysicalProperties();
            ++i;
        }
        this.calcInterfaceProperties();
    }

    @Override
    public void initPhysicalProperties(String propertyName) {
        int i = 0;
        while (i < this.numberOfPhases) {
            this.getPhase(i).initPhysicalProperties(propertyName);
            ++i;
        }
    }

    @Override
    public void resetPhysicalProperties() {
        int i = 0;
        while (i < this.maxNumberOfPhases) {
            this.getPhase(i).resetPhysicalProperties();
            ++i;
        }
    }

    @Override
    public void initRefPhases() {
        int i = 0;
        while (i < this.numberOfPhases) {
            this.getPhase(i).initRefPhases(false);
            ++i;
        }
    }

    @Override
    public void setPhysicalPropertyModel(int type) {
        int i = 0;
        while (i < this.numberOfPhases) {
            this.getPhase(i).setPhysicalProperties(type);
            ++i;
        }
    }

    @Override
    public void chemicalReactionInit() {
        this.chemicalReactionOperations = new ChemicalReactionOperations(this);
        this.chemicalSystem = this.chemicalReactionOperations.hasRections();
    }

    @Override
    public ChemicalReactionOperations getChemicalReactionOperations() {
        return this.chemicalReactionOperations;
    }

    @Override
    public final PhaseInterface getGasPhase() {
        int phase = 0;
        while (phase < this.numberOfPhases) {
            if (this.phaseArray[this.phaseIndex[phase]].getPhaseType() == 1) {
                return this.phaseArray[phase];
            }
            ++phase;
        }
        logger.info("No gas phase at current state.");
        return null;
    }

    @Override
    public final PhaseInterface getLiquidPhase() {
        int phase = 0;
        while (phase < this.numberOfPhases) {
            if (this.phaseArray[this.phaseIndex[phase]].getPhaseType() == 0) {
                return this.phaseArray[phase];
            }
            ++phase;
        }
        logger.info("No liquid phase at current state.");
        return null;
    }

    @Override
    public final PhaseInterface getPhase(int i) {
        this.getNumberOfPhases();
        return this.phaseArray[this.phaseIndex[i]];
    }

    @Override
    public final boolean isChemicalSystem() {
        return this.chemicalSystem;
    }

    @Override
    public final void isChemicalSystem(boolean temp) {
        this.chemicalSystem = temp;
    }

    public double getAntoineVaporPressure(double temp) {
        return this.phaseArray[0].getAntoineVaporPressure(temp);
    }

    @Override
    public final double getTC() {
        return this.criticalTemperature;
    }

    @Override
    public final double getPC() {
        return this.criticalPressure;
    }

    @Override
    public final void setTC(double TC) {
        this.criticalTemperature = TC;
    }

    @Override
    public final void setPC(double PC) {
        this.criticalPressure = PC;
    }

    @Override
    public final void setMixingRule(int type) {
        this.mixingRule = type;
        if (this.numberOfPhases < 4) {
            this.resetPhysicalProperties();
        }
        int i = 0;
        while (i < this.maxNumberOfPhases) {
            this.getPhase(i).setMixingRule(type);
            this.getPhase(i).initPhysicalProperties();
            ++i;
        }
    }

    public void setMixingRuleGEmodel(String name) {
        int i = 0;
        while (i < this.numberOfPhases) {
            this.getPhase(i).setMixingRuleGEModel(name);
            ++i;
        }
    }

    @Override
    public void setMixingRule(String typename, String GEmodel) {
        this.setMixingRuleGEmodel(GEmodel);
        this.setMixingRule(typename);
    }

    @Override
    public void setMixingRule(String typename) {
        int var = 0;
        var = typename.equals("no") ? 1 : (typename.equals("classic") ? 2 : (typename.equals("HV") ? 4 : (typename.equals("WS") ? 5 : (typename.equals("CPA-Mix") ? 7 : (typename.equals("classic-T") ? 8 : (typename.equals("classic-T-cpa") ? 9 : (typename.equals("classic-Tx-cpa") ? 10 : 1)))))));
        this.setMixingRule(var);
    }

    @Override
    public String[] getComponentNames() {
        ArrayList<String> components = new ArrayList<String>();
        int j = 0;
        while (j < this.numberOfComponents) {
            components.add(this.phaseArray[0].getComponents()[j].getName());
            ++j;
        }
        String[] componentList = new String[components.size()];
        int j2 = 0;
        while (j2 < this.numberOfComponents) {
            componentList[j2] = (String)components.get(j2);
            ++j2;
        }
        return componentList;
    }

    @Override
    public void setNumberOfPhases(int number) {
        this.numberOfPhases = number;
    }

    @Override
    public void useVolumeCorrection(boolean volcor) {
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            this.getPhase(i).useVolumeCorrection(volcor);
            ++i;
        }
    }

    @Override
    public final PhaseInterface[] getPhases() {
        return this.phaseArray;
    }

    @Override
    public double getGibbsEnergy() {
        double gibbsEnergy = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            gibbsEnergy += this.getPhase(i).getGibbsEnergy();
            ++i;
        }
        return gibbsEnergy;
    }

    @Override
    public double getExergy(double temperatureOfSurroundings, String exergyUnit) {
        double refExergy = this.getExergy(temperatureOfSurroundings);
        double conversionFactor = 1.0;
        switch (exergyUnit) {
            case "J": {
                conversionFactor = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
            }
        }
        return refExergy * conversionFactor;
    }

    @Override
    public double getExergy(double temperatureOfSurroundings) {
        double getExergy = this.getEnthalpy() - temperatureOfSurroundings * this.getEntropy();
        return getExergy;
    }

    @Override
    public double getEnthalpy() {
        double enthalpy = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            enthalpy += this.getPhase(i).getEnthalpy();
            ++i;
        }
        return enthalpy;
    }

    @Override
    public double getEnthalpy(String unit) {
        double refEnthalpy = this.getEnthalpy();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J": {
                conversionFactor = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
            }
        }
        return refEnthalpy * conversionFactor;
    }

    @Override
    public double getViscosity() {
        double visc = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            visc += this.beta[this.phaseIndex[i]] * this.getPhase(i).getPhysicalProperties().getViscosity();
            ++i;
        }
        return visc;
    }

    @Override
    public double getViscosity(String unit) {
        double refViscosity = this.getViscosity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg/msec": {
                conversionFactor = 1.0;
                break;
            }
            case "cP": {
                conversionFactor = 1000.0;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return refViscosity * conversionFactor;
    }

    @Override
    public double getKinematicViscosity(String unit) {
        double refViscosity = this.getViscosity("kg/msec") / this.getDensity("kg/m3");
        double conversionFactor = 1.0;
        switch (unit) {
            case "m2/sec": {
                conversionFactor = 1.0;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return refViscosity * conversionFactor;
    }

    @Override
    public double getKinematicViscosity() {
        return this.getViscosity() / this.getDensity();
    }

    @Override
    @Deprecated
    public double getConductivity() {
        double cond = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            cond += this.beta[this.phaseIndex[i]] * this.getPhase(i).getPhysicalProperties().getConductivity();
            ++i;
        }
        return cond;
    }

    @Override
    @Deprecated
    public double getConductivity(String unit) {
        double refConductivity = this.getConductivity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "W/mK": {
                conversionFactor = 1.0;
                break;
            }
            case "W/cmK": {
                conversionFactor = 0.01;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return refConductivity * conversionFactor;
    }

    @Override
    public double getThermalConductivity() {
        double cond = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            cond += this.beta[this.phaseIndex[i]] * this.getPhase(i).getPhysicalProperties().getConductivity();
            ++i;
        }
        return cond;
    }

    @Override
    public double getThermalConductivity(String unit) {
        double refConductivity = this.getConductivity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "W/mK": {
                conversionFactor = 1.0;
                break;
            }
            case "W/cmK": {
                conversionFactor = 0.01;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return refConductivity * conversionFactor;
    }

    @Override
    public double getInternalEnergy() {
        double internalEnergy = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            internalEnergy += this.getPhase(i).getInternalEnergy();
            ++i;
        }
        return internalEnergy;
    }

    @Override
    public double getInternalEnergy(String unit) {
        double refEnthalpy = this.getInternalEnergy();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J": {
                conversionFactor = 1.0;
                break;
            }
            case "J/mole": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
            }
        }
        return refEnthalpy * conversionFactor;
    }

    @Override
    public double getHelmholtzEnergy() {
        double helmholtzEnergy = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            helmholtzEnergy += this.getPhase(i).getHelmholtzEnergy();
            ++i;
        }
        return helmholtzEnergy;
    }

    @Override
    public double getEntropy() {
        double entropy = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            entropy += this.getPhase(i).getEntropy();
            ++i;
        }
        return entropy;
    }

    @Override
    public double getEntropy(String unit) {
        double refEntropy = this.getEntropy();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
            }
        }
        return refEntropy * conversionFactor;
    }

    @Override
    public double getMolarVolume() {
        double volume = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            volume += this.beta[this.phaseIndex[i]] * this.getPhase(i).getMolarVolume();
            ++i;
        }
        return volume;
    }

    @Override
    public double getDensity() {
        double density2 = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            density2 += 100000.0 * (this.getPhase(i).getMolarMass() * this.beta[this.phaseIndex[i]] / this.getPhase(i).getMolarVolume());
            ++i;
        }
        return density2;
    }

    @Override
    public double getDensity(String unit) {
        double density2 = 0.0;
        int i = 0;
        while (i < this.getNumberOfPhases()) {
            density2 += this.getPhase(i).getVolume() / this.getVolume() * this.getPhase(i).getPhysicalProperties().getDensity();
            ++i;
        }
        double refDensity = density2;
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg/m3": {
                conversionFactor = 1.0;
                break;
            }
            case "kg/Sm3": {
                return this.getMolarMass() * 101325.0 / 8.3144621 / 288.15;
            }
            case "mol/m3": {
                conversionFactor = 1.0 / this.getMolarMass();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return refDensity * conversionFactor;
    }

    @Override
    public double getZ() {
        double Z = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            Z += this.beta[this.phaseIndex[i]] * this.getPhase(i).getZ();
            ++i;
        }
        return Z;
    }

    @Override
    public double getMoleFractionsSum() {
        double sumz = 0.0;
        int i = 0;
        while (i < this.phaseArray[0].getNumberOfComponents()) {
            sumz += this.phaseArray[0].getComponent(i).getz();
            ++i;
        }
        return sumz;
    }

    @Override
    public double getMolarMass() {
        double tempVar = 0.0;
        int i = 0;
        while (i < this.phaseArray[0].getNumberOfComponents()) {
            tempVar += this.phaseArray[0].getComponents()[i].getz() * this.phaseArray[0].getComponents()[i].getMolarMass();
            ++i;
        }
        return tempVar;
    }

    @Override
    public double getMolarMass(String unit) {
        double refMolarMass = this.getMolarMass();
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg/mol": {
                conversionFactor = 1.0;
                break;
            }
            case "gr/mol": {
                conversionFactor = 1000.0;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return refMolarMass * conversionFactor;
    }

    @Override
    public void setTemperature(double newTemperature) {
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            this.getPhases()[i].setTemperature(newTemperature);
            ++i;
        }
    }

    @Override
    public void setTemperature(double newTemperature, String unit) {
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            if (unit.equals("K")) {
                this.getPhases()[i].setTemperature(newTemperature);
            } else if (unit.equals("C")) {
                this.getPhases()[i].setTemperature(newTemperature + 273.15);
            } else {
                throw new RuntimeException();
            }
            ++i;
        }
    }

    @Override
    public double getNumberOfMoles() {
        return this.getTotalNumberOfMoles();
    }

    @Override
    public void setPhaseType(int phaseToChange, int newPhaseType) {
        if (this.allowPhaseShift) {
            this.phaseType[this.phaseIndex[phaseToChange]] = newPhaseType;
        }
    }

    @Override
    public void setPhaseType(int phaseToChange, String phaseTypeName) {
        int newPhaseType = 1;
        if (this.allowPhaseShift) {
            newPhaseType = phaseTypeName.equals("gas") || phaseTypeName.equals("vapour") ? 1 : (phaseTypeName.equals("liquid") || phaseTypeName.equals("oil") || phaseTypeName.equals("aqueous") ? 0 : 0);
            this.phaseType[this.phaseIndex[phaseToChange]] = newPhaseType;
        }
    }

    @Override
    public void setPhaseType(String phases, int newPhaseType) {
        if (this.allowPhaseShift && phases.equals("all")) {
            int i = 0;
            while (i < this.getMaxNumberOfPhases()) {
                this.phaseType[i] = newPhaseType;
                ++i;
            }
        }
    }

    @Override
    public void invertPhaseTypes() {
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            this.phaseType[i] = this.phaseType[i] == 0 ? 1 : 0;
            ++i;
        }
    }

    @Override
    public void setPhase(PhaseInterface phase, int numb) {
        double temp = this.phaseArray[numb].getTemperature();
        double pres = this.phaseArray[numb].getPressure();
        this.phaseArray[numb] = phase;
        this.phaseArray[numb].setTemperature(temp);
        this.phaseArray[numb].setPressure(pres);
    }

    @Override
    public void reInitPhaseType() {
        this.phaseType[0] = 1;
        this.phaseType[1] = 0;
        this.phaseType[2] = 0;
        this.phaseType[3] = 0;
    }

    @Override
    public final boolean doSolidPhaseCheck() {
        return this.solidPhaseCheck;
    }

    @Override
    public final void setPressure(double newPressure) {
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            this.phaseArray[i].setPressure(newPressure);
            ++i;
        }
    }

    @Override
    public final void setPressure(double newPressure, String unit) {
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            if (unit.equals("bar") || unit.equals("bara")) {
                this.phaseArray[i].setPressure(newPressure);
            } else if (unit.equals("atm")) {
                this.phaseArray[i].setPressure(newPressure + 0.01325);
            } else if (unit.equals("barg")) {
                this.phaseArray[i].setPressure(newPressure + 1.01325);
            } else {
                throw new RuntimeException("setting new pressure could not be done. Specified unit might not be supported");
            }
            ++i;
        }
    }

    @Override
    public final void setTemperature(double newPressure, int phase) {
        this.getPhase(this.phaseIndex[phase]).setTemperature(newPressure);
    }

    @Override
    public final double getTemperature() {
        return this.phaseArray[0].getTemperature();
    }

    @Override
    public final double getTemperature(String unit) {
        TemperatureUnit presConversion = new TemperatureUnit(this.getTemperature(), "K");
        return presConversion.getValue(unit);
    }

    @Override
    public double getTemperature(int phaseNumber) {
        return this.getPhase(this.phaseIndex[phaseNumber]).getTemperature();
    }

    @Override
    public final double getPressure() {
        return this.phaseArray[0].getPressure();
    }

    @Override
    public final double getPressure(String unit) {
        PressureUnit presConversion = new PressureUnit(this.getPressure(), "bara");
        return presConversion.getValue(unit);
    }

    @Override
    public final double getPressure(int phaseNumber) {
        return this.getPhase(this.phaseIndex[phaseNumber]).getPressure();
    }

    @Override
    public final double getBeta() {
        return this.beta[0];
    }

    @Override
    public final double getBeta(int phase) {
        return this.beta[this.phaseIndex[phase]];
    }

    @Override
    public void setAttractiveTerm(int i) {
        int k = 0;
        while (k < this.getMaxNumberOfPhases()) {
            this.phaseArray[k].setAttractiveTerm(i);
            ++k;
        }
    }

    @Override
    public final int getNumberOfPhases() {
        return this.numberOfPhases;
    }

    @Override
    public final void setBeta(double b) {
        if (b < 0.0) {
            b = 1.0E-12;
        }
        if (b > 1.0) {
            b = 0.999999999999;
        }
        this.beta[0] = b;
        this.beta[1] = 1.0 - b;
    }

    @Override
    public final void setBeta(int phase, double b) {
        if (b < 0.0) {
            b = 1.0E-12;
        }
        if (b > 1.0) {
            b = 0.999999999999;
        }
        this.beta[this.phaseIndex[phase]] = b;
    }

    @Override
    public final double getVolume() {
        double volume = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            volume += this.getPhase(i).getMolarVolume() * this.getPhase(i).getNumberOfMolesInPhase();
            ++i;
        }
        return volume;
    }

    @Override
    public double getVolume(String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "m3": {
                conversionFactor = 1.0;
                break;
            }
            case "m3/kg": {
                conversionFactor = 1.0 / this.getMass("kg");
                break;
            }
            case "litre": {
                conversionFactor = 1000.0;
                break;
            }
            case "m3/mol": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
            }
        }
        return conversionFactor * this.getVolume() / 100000.0;
    }

    @Override
    public double getMass(String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg": {
                conversionFactor = 1.0;
                break;
            }
            case "gr": {
                conversionFactor = 1000.0;
                break;
            }
            case "tons": {
                conversionFactor = 0.001;
            }
        }
        return conversionFactor * this.getTotalNumberOfMoles() * this.getMolarMass();
    }

    @Override
    public double getCorrectedVolume() {
        double volume = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            volume += this.getPhase(i).getMolarMass() / this.getPhase(i).getPhysicalProperties().getDensity() * this.getPhase(i).getNumberOfMolesInPhase();
            ++i;
        }
        return volume;
    }

    @Override
    public double getdVdPtn() {
        double dVdP = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            dVdP += 1.0 / this.getPhase(i).getdPdVTn();
            ++i;
        }
        return dVdP;
    }

    @Override
    public double getdVdTpn() {
        double dVdT = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            dVdT += -this.getPhase(i).getdPdTVn() / this.getPhase(i).getdPdVTn();
            ++i;
        }
        return dVdT;
    }

    @Override
    public double getCp() {
        double cP = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            cP += this.getPhase(i).getCp();
            ++i;
        }
        return cP;
    }

    @Override
    public double getCp(String unit) {
        double refCp = this.getCp();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
            }
        }
        return refCp * conversionFactor;
    }

    @Override
    public double getCv() {
        double cv = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            cv += this.getPhase(i).getCv();
            ++i;
        }
        return cv;
    }

    @Override
    public double getCv(String unit) {
        double refCv = this.getCv();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
            }
        }
        return refCv * conversionFactor;
    }

    @Override
    public double getKappa() {
        return this.getCp() / this.getCv();
    }

    @Override
    public double getGamma() {
        return this.getCp() / this.getCv();
    }

    @Override
    public double getGamma2() {
        double cp0 = this.getCp();
        return cp0 / (cp0 - 8.3144621 * this.totalNumberOfMoles);
    }

    @Override
    public void calcInterfaceProperties() {
        this.interfaceProp.init();
    }

    @Override
    public InterphasePropertiesInterface getInterphaseProperties() {
        return this.interfaceProp;
    }

    @Override
    public double getInterfacialTension(int phase1, int phase2) {
        return this.interfaceProp.getSurfaceTension(phase1, phase2);
    }

    @Override
    public double getInterfacialTension(int phase1, int phase2, String unit) {
        return this.interfaceProp.getSurfaceTension(phase1, phase2, unit);
    }

    @Override
    public double getInterfacialTension(String phase1, String phase2) {
        if (this.hasPhaseType(phase1) && this.hasPhaseType(phase2)) {
            return this.interfaceProp.getSurfaceTension(this.getPhaseNumberOfPhase(phase1), this.getPhaseNumberOfPhase(phase2));
        }
        return Double.NaN;
    }

    public String write() {
        return "";
    }

    @Override
    public void normalizeBeta() {
        double tot = 0.0;
        int i = 0;
        while (i < this.numberOfPhases) {
            tot += this.beta[this.phaseIndex[i]];
            ++i;
        }
        i = 0;
        while (i < this.numberOfPhases) {
            int n = this.phaseIndex[i];
            this.beta[n] = this.beta[n] / tot;
            ++i;
        }
    }

    @Override
    public void display() {
        this.display(this.getFluidName());
    }

    @Override
    public String[][] createTable(String name) {
        String[][] table = new String[this.getPhases()[0].getNumberOfComponents() + 30][7];
        if (this.isInitialized) {
            this.initProperties();
        } else {
            this.init(0);
            this.setNumberOfPhases(1);
            this.initProperties();
        }
        DecimalFormat nf = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(symbols);
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        table[0][0] = "";
        int i = 0;
        while (i < this.getPhases()[0].getNumberOfComponents() + 30) {
            int j = 0;
            while (j < 7) {
                table[i][j] = "";
                ++j;
            }
            ++i;
        }
        table[0][1] = "total";
        i = 0;
        while (i < this.numberOfPhases) {
            table[0][i + 2] = this.getPhase(i).getPhaseTypeName();
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        FieldPosition test2 = new FieldPosition(0);
        int j = 0;
        while (j < this.getPhases()[0].getNumberOfComponents()) {
            buf = new StringBuffer();
            table[j + 1][1] = nf.format(this.getPhase(0).getComponents()[j].getz(), buf, test2).toString();
            ++j;
        }
        buf = new StringBuffer();
        table[this.getPhases()[0].getNumberOfComponents() + 4][1] = nf.format(this.getMolarMass() * 1000.0, buf, test2).toString();
        buf = new StringBuffer();
        table[this.getPhases()[0].getNumberOfComponents() + 9][1] = nf.format(this.getEnthalpy() / (this.getTotalNumberOfMoles() * this.getMolarMass() * 1000.0), buf, test2).toString();
        buf = new StringBuffer();
        table[this.getPhases()[0].getNumberOfComponents() + 10][1] = nf.format(this.getEntropy() / (this.getTotalNumberOfMoles() * this.getMolarMass() * 1000.0), buf, test2).toString();
        int i2 = 0;
        while (i2 < this.numberOfPhases) {
            int j2 = 0;
            while (j2 < this.getPhases()[0].getNumberOfComponents()) {
                table[j2 + 1][0] = this.getPhases()[0].getComponents()[j2].getName();
                buf = new StringBuffer();
                table[j2 + 1][i2 + 2] = nf.format(this.getPhase(i2).getComponents()[j2].getx(), buf, test2).toString();
                table[j2 + 1][6] = "[mole fraction]";
                ++j2;
            }
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 2][0] = "Density";
            table[this.getPhases()[0].getNumberOfComponents() + 2][i2 + 2] = nf.format(this.getPhase(i2).getPhysicalProperties().getDensity(), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 2][6] = "[kg/m^3]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 3][0] = "PhaseFraction";
            table[this.getPhases()[0].getNumberOfComponents() + 3][i2 + 2] = nf.format(this.getPhase(i2).getBeta(), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 3][6] = "[mole fraction]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 4][0] = "MolarMass";
            table[this.getPhases()[0].getNumberOfComponents() + 4][i2 + 2] = nf.format(this.getPhase(i2).getMolarMass() * 1000.0, buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 4][6] = "[kg/kmol]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 5][0] = "Z factor";
            table[this.getPhases()[0].getNumberOfComponents() + 5][i2 + 2] = nf.format(this.getPhase(i2).getZ(), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 5][6] = "[-]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 6][0] = "Heat Capacity (Cp)";
            table[this.getPhases()[0].getNumberOfComponents() + 6][i2 + 2] = nf.format(this.getPhase(i2).getCp() / (this.getPhase(i2).getNumberOfMolesInPhase() * this.getPhase(i2).getMolarMass() * 1000.0), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 6][6] = "[kJ/kg*K]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 7][0] = "Heat Capacity (Cv)";
            table[this.getPhases()[0].getNumberOfComponents() + 7][i2 + 2] = nf.format(this.getPhase(i2).getCv() / (this.getPhase(i2).getNumberOfMolesInPhase() * this.getPhase(i2).getMolarMass() * 1000.0), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 7][6] = "[kJ/kg*K]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 8][0] = "Speed of Sound";
            table[this.getPhases()[0].getNumberOfComponents() + 8][i2 + 2] = nf.format(this.getPhase(i2).getSoundSpeed(), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 8][6] = "[m/sec]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 9][0] = "Enthalpy";
            table[this.getPhases()[0].getNumberOfComponents() + 9][i2 + 2] = nf.format(this.getPhase(i2).getEnthalpy() / (this.getPhase(i2).getNumberOfMolesInPhase() * this.getPhase(i2).getMolarMass() * 1000.0), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 9][6] = "[kJ/kg]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 10][0] = "Entropy";
            table[this.getPhases()[0].getNumberOfComponents() + 10][i2 + 2] = nf.format(this.getPhase(i2).getEntropy() / (this.getPhase(i2).getNumberOfMolesInPhase() * this.getPhase(i2).getMolarMass() * 1000.0), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 10][6] = "[kJ/kg*K]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 11][0] = "JT coefficient";
            table[this.getPhases()[0].getNumberOfComponents() + 11][i2 + 2] = nf.format(this.getPhase(i2).getJouleThomsonCoefficient(), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 11][6] = "[K/bar]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 13][0] = "Viscosity";
            table[this.getPhases()[0].getNumberOfComponents() + 13][i2 + 2] = nf.format(this.getPhase(i2).getPhysicalProperties().getViscosity(), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 13][6] = "[kg/m*sec]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 14][0] = "Conductivity";
            table[this.getPhases()[0].getNumberOfComponents() + 14][i2 + 2] = nf.format(this.getPhase(i2).getPhysicalProperties().getConductivity(), buf, test2).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 14][6] = "[W/m*K]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 15][0] = "SurfaceTension";
            try {
                if (i2 < this.numberOfPhases - 1) {
                    table[this.getPhases()[0].getNumberOfComponents() + 15][2] = nf.format(this.getInterphaseProperties().getSurfaceTension(0, 1), buf, test2).toString();
                    buf = new StringBuffer();
                    table[this.getPhases()[0].getNumberOfComponents() + 15][3] = nf.format(this.getInterphaseProperties().getSurfaceTension(0, 1), buf, test2).toString();
                    buf = new StringBuffer();
                    if (i2 == 1) {
                        table[this.getPhases()[0].getNumberOfComponents() + 17][2] = nf.format(this.getInterphaseProperties().getSurfaceTension(0, 2), buf, test2).toString();
                        buf = new StringBuffer();
                        table[this.getPhases()[0].getNumberOfComponents() + 17][4] = nf.format(this.getInterphaseProperties().getSurfaceTension(0, 2), buf, test2).toString();
                        table[this.getPhases()[0].getNumberOfComponents() + 17][6] = "[N/m]";
                    }
                    if (i2 == 1) {
                        buf = new StringBuffer();
                        table[this.getPhases()[0].getNumberOfComponents() + 16][3] = nf.format(this.getInterphaseProperties().getSurfaceTension(1, 2), buf, test2).toString();
                        buf = new StringBuffer();
                        table[this.getPhases()[0].getNumberOfComponents() + 16][4] = nf.format(this.getInterphaseProperties().getSurfaceTension(1, 2), buf, test2).toString();
                        table[this.getPhases()[0].getNumberOfComponents() + 16][6] = "[N/m]";
                    }
                }
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
            }
            table[this.getPhases()[0].getNumberOfComponents() + 15][6] = "[N/m]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 19][0] = "Pressure";
            table[this.getPhases()[0].getNumberOfComponents() + 19][i2 + 2] = Double.toString(this.getPhase(i2).getPressure());
            table[this.getPhases()[0].getNumberOfComponents() + 19][6] = "[bar]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 20][0] = "Temperature";
            table[this.getPhases()[0].getNumberOfComponents() + 20][i2 + 2] = Double.toString(this.getPhase(i2).getTemperature());
            table[this.getPhases()[0].getNumberOfComponents() + 20][6] = "[K]";
            Double.toString(this.getPhase(i2).getTemperature());
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 22][0] = "Model";
            table[this.getPhases()[0].getNumberOfComponents() + 22][i2 + 2] = this.getModelName();
            table[this.getPhases()[0].getNumberOfComponents() + 22][6] = "-";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 23][0] = "Mixing Rule";
            try {
                table[this.getPhases()[0].getNumberOfComponents() + 23][i2 + 2] = ((PhaseEosInterface)this.getPhase(i2)).getMixingRuleName();
            }
            catch (Exception e) {
                table[this.getPhases()[0].getNumberOfComponents() + 23][i2 + 2] = "?";
            }
            table[this.getPhases()[0].getNumberOfComponents() + 23][6] = "-";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 25][0] = "Stream";
            table[this.getPhases()[0].getNumberOfComponents() + 25][i2 + 2] = name;
            table[this.getPhases()[0].getNumberOfComponents() + 25][6] = "-";
            ++i2;
        }
        this.resultTable = table;
        return table;
    }

    @Override
    public void display(String name) {
        JFrame dialog = new JFrame("System-Report");
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[]{"", "Feed", "Phase 1", "Phase 2", "Phase 3", "Phase 4", "Unit"};
        Object[][] table = this.createTable(name);
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.setSize(screenDimension.width / 2, screenDimension.height / 2);
        Jtab.setRowHeight(dialog.getHeight() / table.length);
        Jtab.setFont(new Font("Serif", 0, dialog.getHeight() / table.length - dialog.getHeight() / table.length / 10));
        dialog.setVisible(true);
    }

    @Override
    public void write(String name, String filename, boolean newfile) {
        String[][] table = this.createTable(name);
        TextFile file = new TextFile();
        if (newfile) {
            file.newFile(filename);
        }
        file.setOutputFileName(filename);
        file.setValues(table);
        file.createFile();
    }

    @Override
    public void resetDatabase() {
        NeqSimDataBase database = null;
        try {
            try {
                database = new NeqSimDataBase();
                if (NeqSimDataBase.createTemporaryTables()) {
                    database.execute("delete FROM comptemp");
                    database.execute("delete FROM intertemp");
                }
            }
            catch (Exception e) {
                logger.error("error in SystemThermo Class...resetDatabase() method");
                logger.error("error in comp");
                logger.error("error", (Throwable)e);
                try {
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception e2) {
                    logger.error("error closing database.....", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception e) {
                logger.error("error closing database.....", (Throwable)e);
            }
        }
    }

    @Override
    public void createDatabase(boolean reset) {
        NeqSimDataBase database = null;
        try {
            try {
                if (reset) {
                    this.resetDatabase();
                }
                database = new NeqSimDataBase();
                String names = new String();
                int k = 0;
                while (k < this.getPhase(0).getNumberOfComponents() - 1) {
                    names = String.valueOf(names) + "'" + this.getComponentNames()[k] + "', ";
                    ++k;
                }
                names = String.valueOf(names) + "'" + this.getComponentNames()[this.getPhase(0).getNumberOfComponents() - 1] + "'";
                if (NeqSimDataBase.createTemporaryTables()) {
                    database.execute("insert into comptemp SELECT * FROM comp WHERE name IN (" + names + ")");
                    database.execute("insert into intertemp SELECT DISTINCT * FROM inter WHERE comp1 IN (" + names + ") AND comp2 IN (" + names + ")");
                    database.execute("delete FROM intertemp WHERE comp1=comp2");
                }
                int phase = 0;
                while (phase < this.maxNumberOfPhases) {
                    this.getPhase(phase).setMixingRuleDefined(false);
                    ++phase;
                }
                int i = 0;
                while (i < this.numberOfComponents) {
                    if (this.getPhase(0).getComponent(i).isIsTBPfraction() || this.getPhase(0).getComponent(i).isIsPlusFraction()) {
                        this.getPhase(0).getComponent(i).insertComponentIntoDatabase("");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error("error in SystemThermo Class...createDatabase() method", (Throwable)e);
                try {
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception e2) {
                    logger.error("error closing database.....", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception e) {
                logger.error("error closing database.....", (Throwable)e);
            }
        }
    }

    @Override
    public final int getPhaseIndex(int index) {
        return this.phaseIndex[index];
    }

    @Override
    public final void setPhaseIndex(int index, int phaseIndex) {
        this.phaseIndex[index] = phaseIndex;
    }

    @Override
    public void setSolidPhaseCheck(boolean solidPhaseCheck) {
        int oldphase = this.numberOfPhases;
        if (!this.solidPhaseCheck) {
            this.addSolidPhase();
        }
        this.solidPhaseCheck = solidPhaseCheck;
        int phase = 0;
        while (phase < this.numberOfPhases) {
            int k = 0;
            while (k < this.getPhases()[0].getNumberOfComponents()) {
                this.getPhase(phase).getComponent(k).setSolidCheck(solidPhaseCheck);
                this.getPhase(3).getComponent(k).setSolidCheck(solidPhaseCheck);
                ++k;
            }
            ++phase;
        }
        this.numberOfPhases = oldphase;
    }

    @Override
    public void setSolidPhaseCheck(String solidComponent) {
        this.init(0);
        int oldphase = this.numberOfPhases;
        if (!this.solidPhaseCheck) {
            this.addSolidPhase();
        }
        this.solidPhaseCheck = true;
        this.init(0);
        int phase = 0;
        while (phase < this.getMaxNumberOfPhases()) {
            try {
                this.getPhase(phase).getComponent(solidComponent).setSolidCheck(true);
                this.getPhase(3).getComponent(solidComponent).setSolidCheck(true);
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
            }
            ++phase;
        }
        this.numberOfPhases = oldphase;
    }

    @Override
    public void setHydrateCheck(boolean hydrateCheck) {
        this.init(0);
        if (hydrateCheck) {
            this.addHydratePhase();
        }
        this.hydrateCheck = hydrateCheck;
        this.init(0);
    }

    @Override
    public boolean doMultiPhaseCheck() {
        return this.multiPhaseCheck;
    }

    @Override
    public void setMultiPhaseCheck(boolean multiPhaseCheck) {
        if (this.getMaxNumberOfPhases() < 3) {
            if (multiPhaseCheck) {
                this.setMaxNumberOfPhases(3);
                this.phaseArray[2] = this.phaseArray[1].clone();
                this.phaseArray[2].resetMixingRule(this.phaseArray[0].getMixingRuleNumber());
                this.phaseArray[2].resetPhysicalProperties();
                this.phaseArray[2].initPhysicalProperties();
            } else {
                this.setMaxNumberOfPhases(2);
            }
        }
        this.multiPhaseCheck = multiPhaseCheck;
    }

    @Override
    public int getInitType() {
        return this.initType;
    }

    @Override
    public void setInitType(int initType) {
        this.initType = initType;
    }

    @Override
    public boolean isNumericDerivatives() {
        return this.numericDerivatives;
    }

    @Override
    public void setNumericDerivatives(boolean numericDerivatives) {
        this.numericDerivatives = numericDerivatives;
    }

    @Override
    public void checkStability(boolean val) {
        this.checkStability = val;
    }

    @Override
    public boolean checkStability() {
        return this.checkStability;
    }

    @Override
    public boolean doHydrateCheck() {
        return this.hydrateCheck;
    }

    @Override
    public void save(String name) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(name));){
                out.writeObject(this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    @Override
    public SystemInterface readObject(int ID) {
        SystemThermo tempSystem;
        block24: {
            ResultSet rs = null;
            tempSystem = null;
            NeqSimBlobDatabase database = new NeqSimBlobDatabase();
            try {
                try {
                    Connection con = database.openConnection();
                    String sqlStr = "SELECT FLUID FROM fluid_blobdb WHERE ID=" + Integer.toString(ID);
                    PreparedStatement ps = con.prepareStatement(sqlStr);
                    rs = ps.executeQuery();
                    if (!rs.next()) break block24;
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (ObjectInputStream ins = new ObjectInputStream(new ByteArrayInputStream(rs.getBytes("FLUID")));){
                        tempSystem = (SystemThermo)ins.readObject();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    logger.error("error", (Throwable)e);
                    try {
                        if (database.getStatement() != null) {
                            database.getStatement().close();
                        }
                        if (database.getConnection() != null) {
                            database.getConnection().close();
                        }
                    }
                    catch (Exception e2) {
                        logger.error("err closing database IN MIX..., e");
                        logger.error("error", (Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception e) {
                    logger.error("err closing database IN MIX..., e");
                    logger.error("error", (Throwable)e);
                }
            }
        }
        return tempSystem;
    }

    @Override
    public void saveFluid(int ID) {
        this.saveObject(ID, "");
    }

    @Override
    public void saveFluid(int ID, String text) {
        this.saveObject(ID, text);
    }

    @Override
    public void saveObject(int ID, String text) {
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ObjectOutputStream out = new ObjectOutputStream(fout);){
                out.writeObject(this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        byte[] byteObject = fout.toByteArray();
        ByteArrayInputStream inpStream = new ByteArrayInputStream(byteObject);
        NeqSimBlobDatabase database = new NeqSimBlobDatabase();
        try {
            try {
                Connection con = database.openConnection();
                PreparedStatement ps = con.prepareStatement("REPLACE INTO fluid_blobdb (ID, FLUID) VALUES (?,?)");
                ps.setInt(1, ID);
                ps.setBlob(2, inpStream);
                ps.executeUpdate();
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                try {
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception e2) {
                    logger.error("err closing database IN MIX...", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception e) {
                logger.error("err closing database IN MIX...", (Throwable)e);
            }
        }
    }

    @Override
    public void saveObjectToFile(String filePath, String fluidName) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filePath, false));){
                out.writeObject(this);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
    }

    @Override
    public SystemInterface readObjectFromFile(String filePath, String fluidName) {
        SystemThermo tempSystem = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ObjectInputStream objectinputstream = new ObjectInputStream(new FileInputStream(filePath));){
                tempSystem = (SystemThermo)objectinputstream.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
        }
        return tempSystem;
    }

    @Override
    public String getMixingRuleName() {
        return ((PhaseEosInterface)this.getPhase(0)).getMixingRule().getMixingRuleName();
    }

    @Override
    public String getFluidInfo() {
        return this.fluidInfo;
    }

    @Override
    public void setFluidInfo(String info) {
        this.fluidInfo = info;
    }

    @Override
    public String getFluidName() {
        return this.fluidName;
    }

    @Override
    public void setFluidName(String fluidName) {
        this.fluidName = fluidName;
    }

    public boolean setLastTBPasPlus() {
        PlusCharacterize temp = new PlusCharacterize(this);
        if (temp.hasPlusFraction()) {
            return false;
        }
        temp.setHeavyTBPtoPlus();
        return true;
    }

    @Override
    public Characterise getCharacterization() {
        return this.characterization;
    }

    @Override
    public void calcKIJ(boolean ok) {
        EosMixingRules.calcEOSInteractionParameters = ok;
        int i = 0;
        while (i < this.numberOfPhases) {
            ((PhaseEosInterface)this.getPhase(i)).getMixingRule().setCalcEOSInteractionParameters(ok);
            ++i;
        }
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public boolean allowPhaseShift() {
        return this.allowPhaseShift;
    }

    @Override
    public void allowPhaseShift(boolean allowPhaseShift) {
        this.allowPhaseShift = allowPhaseShift;
    }

    @Override
    public double getProperty(String prop, String compName, int phase) {
        if (prop.equals("molefraction")) {
            return this.getPhase(phase).getComponent(compName).getx();
        }
        if (prop.equals("fugacitycoefficient")) {
            return this.getPhase(phase).getComponent(compName).getFugacityCoefficient();
        }
        if (prop.equals("logfugdT")) {
            return this.getPhase(phase).getComponent(compName).getdfugdt();
        }
        if (prop.equals("logfugdP")) {
            return this.getPhase(phase).getComponent(compName).getdfugdp();
        }
        return 1.0;
    }

    @Override
    public double getProperty(String prop, int phase) {
        this.initPhysicalProperties();
        if (prop.equals("temperature")) {
            return this.getPhase(phase).getTemperature();
        }
        if (prop.equals("pressure")) {
            return this.getPhase(phase).getPressure();
        }
        if (prop.equals("compressibility")) {
            return this.getPhase(phase).getZ();
        }
        if (prop.equals("density")) {
            return this.getPhase(phase).getPhysicalProperties().getDensity();
        }
        if (prop.equals("beta")) {
            return this.getPhase(phase).getBeta();
        }
        if (prop.equals("enthalpy")) {
            return this.getPhase(phase).getEnthalpy();
        }
        if (prop.equals("entropy")) {
            return this.getPhase(phase).getEntropy();
        }
        if (prop.equals("viscosity")) {
            return this.getPhase(phase).getPhysicalProperties().getViscosity();
        }
        if (prop.equals("conductivity")) {
            return this.getPhase(phase).getPhysicalProperties().getConductivity();
        }
        return 1.0;
    }

    @Override
    public double getProperty(String prop) {
        if (prop.equals("numberOfPhases")) {
            return this.numberOfPhases;
        }
        if (prop.equals("numberOfComponents")) {
            return this.numberOfComponents;
        }
        if (prop.equals("enthalpy")) {
            return this.getEnthalpy();
        }
        if (prop.equals("entropy")) {
            return this.getEntropy();
        }
        if (prop.equals("temperature")) {
            return this.getTemperature();
        }
        if (prop.equals("pressure")) {
            return this.getPressure();
        }
        return 1.0;
    }

    @Override
    public void saveToDataBase() {
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            try {
                int j;
                String sqlString;
                database.execute("delete FROM systemreport");
                int i = 0;
                while (i < this.numberOfComponents) {
                    sqlString = "'" + Integer.toString(i + 1) + "', '" + this.getPhase(0).getComponent(i).getName() + "', " + "'molfrac[-] ', '" + Double.toString(this.getPhase(0).getComponent(i).getz()) + "'";
                    j = 0;
                    while (j < this.numberOfPhases) {
                        sqlString = String.valueOf(sqlString) + ", '" + Double.toString(this.getPhase(j).getComponent(i).getx()) + "'";
                        ++j;
                    }
                    while (j < 3) {
                        ++j;
                        sqlString = String.valueOf(sqlString) + ", '0'";
                    }
                    logger.error(sqlString);
                    database.execute("INSERT INTO systemreport VALUES (" + sqlString + ")");
                    ++i;
                }
                sqlString = "'" + Integer.toString(++i + 1) + "', 'PhaseFraction', " + "'[-]', '1'";
                j = 0;
                while (j < this.numberOfPhases) {
                    sqlString = String.valueOf(sqlString) + ", '" + Double.toString(this.getPhase(j).getBeta()) + "'";
                    ++j;
                }
                while (j < 3) {
                    ++j;
                    sqlString = String.valueOf(sqlString) + ", '0'";
                }
                logger.error(sqlString);
                database.execute("INSERT INTO systemreport VALUES (" + sqlString + ")");
                sqlString = "'" + Integer.toString(++i + 1) + "', 'MolarMass', " + "'kg/mol ', '" + Double.toString(this.getMolarMass()) + "'";
                j = 0;
                while (j < this.numberOfPhases) {
                    sqlString = String.valueOf(sqlString) + ", '" + Double.toString(this.getPhase(j).getMolarMass()) + "'";
                    ++j;
                }
                while (j < 3) {
                    ++j;
                    sqlString = String.valueOf(sqlString) + ", '0'";
                }
                database.execute("INSERT INTO systemreport VALUES (" + sqlString + ")");
                database.getConnection().close();
            }
            catch (Exception e) {
                logger.error("failed " + e.toString());
                try {
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception e2) {
                    logger.error("err closing database IN MIX...", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception e) {
                logger.error("err closing database IN MIX...", (Throwable)e);
            }
        }
    }

    @Override
    public StandardInterface getStandard() {
        return this.standard;
    }

    @Override
    public StandardInterface getStandard(String standardName) {
        this.setStandard(standardName);
        return this.standard;
    }

    @Override
    public void generatePDF() {
        PdfCreator pdfDocument = null;
        pdfDocument = new PdfCreator();
        pdfDocument.getDocument().addTitle("NeqSim Thermo Simulation Report");
        pdfDocument.getDocument().addKeywords("Temperature ");
        pdfDocument.getDocument().open();
        try {
            pdfDocument.getDocument().add(new Paragraph("Properties of fluid: " + this.getFluidName(), FontFactory.getFont("Times-Roman", 12.0f)));
            List list = new List(true, 20.0f);
            list.add(new ListItem("Thermodynamic model: " + this.getModelName()));
            list.add(new ListItem("Mixing rule: " + this.getMixingRuleName()));
            list.add(new ListItem("Number of phases: " + this.getNumberOfPhases()));
            list.add(new ListItem("Status of calculation: ok"));
            pdfDocument.getDocument().add(list);
            Table resTable = new Table(6, this.getPhases()[0].getNumberOfComponents() + 30);
            String[][] tempTable = this.createTable(this.getFluidName());
            int i = 0;
            while (i < this.getPhases()[0].getNumberOfComponents() + 30) {
                int j = 0;
                while (j < 6) {
                    resTable.addCell(tempTable[i][j]);
                    ++j;
                }
                ++i;
            }
            pdfDocument.getDocument().add(resTable);
            Anchor anchor = new Anchor("NeqSim Website", FontFactory.getFont("Helvetica", 12.0f, 4, new Color(0, 0, 255)));
            anchor.setReference("http://www.stud.ntnu.no/~solbraa/neqsim");
            anchor.setName("NeqSim Website");
            pdfDocument.getDocument().add(anchor);
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        pdfDocument.getDocument().close();
        this.pdfDocument = pdfDocument;
    }

    @Override
    public void displayPDF() {
        this.generatePDF();
        ((PdfCreator)this.pdfDocument).openPDF();
    }

    @Override
    public void setStandard(String standardName) {
        this.standard = standardName.equals("ISO1992") ? new Standard_ISO6976() : (standardName.equals("Draft_ISO18453") ? new Draft_ISO18453(this) : new Standard_ISO6976());
    }

    @Override
    public boolean hasPlusFraction() {
        int i = 0;
        while (i < this.numberOfComponents) {
            if (this.getPhase(0).getComponent(i).isIsPlusFraction()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasTBPFraction() {
        int i = 0;
        while (i < this.numberOfComponents) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void tuneModel(String model, double val, int phase) {
        if (model.equals("viscosity")) {
            this.getPhase(phase).getPhysicalProperties().getViscosityModel().tuneModel(val, this.getPhase(phase).getTemperature(), this.getPhase(phase).getPressure());
            int i = 0;
            while (i < this.getMaxNumberOfPhases()) {
                int j = 0;
                while (j < this.numberOfPhases) {
                    this.getPhase(i).getComponent(j).setCriticalViscosity(this.getPhase(phase).getComponent(j).getCriticalViscosity());
                    ++j;
                }
                ++i;
            }
        }
        this.initPhysicalProperties();
    }

    @Override
    public double getHeatOfVaporization() {
        if (this.numberOfPhases < 2) {
            return 0.0;
        }
        return this.getPhase(0).getEnthalpy() / this.getPhase(0).getNumberOfMolesInPhase() - this.getPhase(1).getEnthalpy() / this.getPhase(1).getNumberOfMolesInPhase();
    }

    @Override
    public void readFluid(String fluidName) {
        this.fluidName = fluidName;
        try {
            NeqSimFluidDataBase database = new NeqSimFluidDataBase();
            ResultSet dataSet = null;
            dataSet = database.getResultSet("SELECT * FROM " + fluidName);
            while (dataSet.next()) {
                String componentType = dataSet.getString("ComponentType");
                if (componentType.equals("normal")) {
                    this.addComponent(dataSet.getString("ComponentName"), Double.parseDouble(dataSet.getString("Rate")));
                    continue;
                }
                if (componentType.equals("TBP")) {
                    this.addTBPfraction(dataSet.getString("ComponentName"), Double.parseDouble(dataSet.getString("Rate")), Double.parseDouble(dataSet.getString("MolarMass")) / 1000.0, Double.parseDouble(dataSet.getString("Density")));
                    continue;
                }
                if (componentType.equals("Plus")) {
                    this.addPlusFraction(dataSet.getString("ComponentName"), Double.parseDouble(dataSet.getString("Rate")), Double.parseDouble(dataSet.getString("MolarMass")) / 1000.0, Double.parseDouble(dataSet.getString("Density")));
                    continue;
                }
                logger.error("component type need to be specified for ... " + dataSet.getString("ComponentName"));
            }
        }
        catch (Exception e) {
            String err = e.toString();
            logger.error(err);
        }
    }

    @Override
    public String[][] getResultTable() {
        return this.resultTable;
    }

    @Override
    public SystemInterface setModel(String model) {
        SystemEos tempModel = null;
        try {
            if (model.equals("SRK-EOS")) {
                tempModel = new SystemSrkEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("GERG2004-EOS")) {
                tempModel = new SystemGERG2004Eos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("PrEos") || model.equals("PR-EOS")) {
                tempModel = new SystemPrEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("ScRK-EOS") || model.equals("ScRK-EOS-HV")) {
                tempModel = new SystemSrkSchwartzentruberEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("Electrolyte-ScRK-EOS")) {
                tempModel = new SystemFurstElectrolyteEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("GERG-water-EOS")) {
                tempModel = new SystemGERGwaterEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("CPAs-SRK-EOS")) {
                tempModel = new SystemSrkCPAs(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("CPAs-SRK-EOS-statoil")) {
                tempModel = new SystemSrkCPAstatoil(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("Electrolyte-CPA-EOS-statoil") || model.equals("Electrolyte-CPA-EOS")) {
                tempModel = new SystemElectrolyteCPAstatoil(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("UMR-PRU-EoS")) {
                tempModel = new SystemUMRPRUMCEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("PC-SAFT")) {
                tempModel = new SystemPCSAFT(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("GERG-2008-EoS")) {
                tempModel = new SystemGERG2004Eos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("SRK-TwuCoon-Statoil-EOS") || model.equals("SRK-TwuCoon-EOS")) {
                tempModel = new SystemSrkTwuCoonStatoilEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("SRK-TwuCoon-Param-EOS")) {
                tempModel = new SystemSrkTwuCoonParamEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("Duan-Sun")) {
                tempModel = new SystemDuanSun(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else {
                logger.error("model : " + model + " not defined.....");
            }
            tempModel.useVolumeCorrection(true);
            logger.info("created class " + tempModel);
            int i = 0;
            while (i < this.getPhase(0).getNumberOfComponents()) {
                logger.info("adding " + this.getPhase(0).getComponent(i).getName() + " moles " + this.getPhase(0).getComponent(i).getNumberOfmoles() + " isPlus " + this.getPhase(0).getComponent(i).isIsPlusFraction() + " isTBP " + this.getPhase(0).getComponent(i).isIsTBPfraction());
                if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                    tempModel.addTBPfraction(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getMolarMass(), this.getPhase(0).getComponent(i).getNormalLiquidDensity());
                } else if (this.getPhase(0).getComponent(i).isIsPlusFraction()) {
                    tempModel.addPlusFraction(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getMolarMass(), this.getPhase(0).getComponent(i).getNormalLiquidDensity());
                } else {
                    tempModel.addComponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles());
                }
                ++i;
            }
            logger.info("creatore database ......");
            logger.info("done ... creatore database ......");
            tempModel.createDatabase(true);
            logger.info("done ... set mixing rule ......");
            tempModel.autoSelectMixingRule();
            if (model.equals("Electrolyte-ScRK-EOS")) {
                logger.info("chemical reaction init......");
                tempModel.setMultiPhaseCheck(false);
                tempModel.chemicalReactionInit();
            } else {
                tempModel.setMultiPhaseCheck(true);
            }
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        return tempModel;
    }

    @Override
    public SystemInterface autoSelectModel() {
        if (this.getPhase(0).hasComponent("MDEA") && this.getPhase(0).hasComponent("water") && this.getPhase(0).hasComponent("CO2")) {
            return this.setModel("Electrolyte-ScRK-EOS");
        }
        if (this.getPhase(0).hasComponent("water") || this.getPhase(0).hasComponent("methanol") || this.getPhase(0).hasComponent("MEG") || this.getPhase(0).hasComponent("TEG") || this.getPhase(0).hasComponent("ethanol") || this.getPhase(0).hasComponent("DEG")) {
            if (this.getPhase(0).hasComponent("Na+") || this.getPhase(0).hasComponent("K+") || this.getPhase(0).hasComponent("Br-") || this.getPhase(0).hasComponent("Mg++") || this.getPhase(0).hasComponent("Cl-") || this.getPhase(0).hasComponent("Ca++") || this.getPhase(0).hasComponent("Fe++") || this.getPhase(0).hasComponent("SO4--")) {
                logger.info("model elect");
                return this.setModel("Electrolyte-CPA-EOS-statoil");
            }
            return this.setModel("CPAs-SRK-EOS-statoil");
        }
        if (this.getPhase(0).hasComponent("water")) {
            return this.setModel("ScRK-EOS");
        }
        if (this.getPhase(0).hasComponent("mercury")) {
            return this.setModel("SRK-TwuCoon-Statoil-EOS");
        }
        logger.info("no model");
        return this.setModel("SRK-EOS");
    }

    @Override
    public void autoSelectMixingRule() {
        logger.info("setting mixing rule");
        if (this.modelName.equals("CPAs-SRK-EOS") || this.modelName.equals("CPA-SRK-EOS") || this.modelName.equals("Electrolyte-CPA-EOS-statoil") || this.modelName.equals("CPAs-SRK-EOS-statoil") || this.modelName.equals("Electrolyte-CPA-EOS")) {
            this.setMixingRule(10);
        } else if ((this.modelName.equals("ScRK-EOS-HV") || this.modelName.equals("SRK-EOS") || this.modelName.equals("ScRK-EOS")) && this.getPhase(0).hasComponent("water")) {
            this.setMixingRule(4);
        } else if (this.modelName.equals("PR-EOS")) {
            this.setMixingRule(2);
        } else if (this.modelName.equals("Electrolyte-ScRK-EOS")) {
            this.setMixingRule(4);
        } else if (this.modelName.equals("UMR-PRU-EoS") || this.modelName.equals("UMR-PRU-MC-EoS")) {
            this.setMixingRule("HV", "UNIFAC_UMRPRU");
        } else if (this.modelName.equals("GERG-water-EOS")) {
            this.setMixingRule(8);
        } else if (this.modelName.equals("GERG-2008-EOS")) {
            this.setMixingRule(2);
        } else if (this.modelName.equals("PC-SAFT")) {
            this.setMixingRule(8);
        } else {
            this.setMixingRule(2);
        }
    }

    @Override
    public int getMixingRule() {
        return this.mixingRule;
    }

    @Override
    public ComponentInterface getComponent(String name) {
        return this.getPhase(0).getComponent(name);
    }

    @Override
    public ComponentInterface getComponent(int number) {
        return this.getPhase(0).getComponent(number);
    }

    @Override
    public void orderByDensity() {
        boolean change = false;
        int i = 0;
        while (i < this.getNumberOfPhases()) {
            if (this.getPhase(i).getPhysicalProperties() == null) {
                this.getPhase(i).initPhysicalProperties("density");
            }
            this.getPhase(i).getPhysicalProperties().setPhase(this.getPhase(i));
            ++i;
        }
        block3: do {
            change = false;
            i = 1;
            while (i < this.getNumberOfPhases()) {
                if (i == 4) continue block3;
                try {
                    if (change || this.getPhase(i).getPhysicalProperties() == null) {
                        this.getPhase(i).initPhysicalProperties("density");
                    }
                }
                catch (Exception e) {
                    logger.error("error", (Throwable)e);
                }
                if (this.getPhase(i).getPhysicalProperties().calcDensity() < this.getPhase(i - 1).getPhysicalProperties().calcDensity()) {
                    int tempIndex1 = this.getPhaseIndex(i - 1);
                    int tempIndex2 = this.getPhaseIndex(i);
                    this.setPhaseIndex(i, tempIndex1);
                    this.setPhaseIndex(i - 1, tempIndex2);
                    change = true;
                }
                ++i;
            }
        } while (change);
    }

    @Override
    public void addLiquidToGas(double fraction) {
        int i = 0;
        while (i < this.getPhase(0).getNumberOfComponents()) {
            double change = this.getPhase(1).getComponent(i).getNumberOfMolesInPhase() * fraction;
            this.addComponent(i, change, 0);
            this.addComponent(i, -change, 1);
            ++i;
        }
    }

    @Override
    public void addPhaseFractionToPhase(double fraction, String specification, String fromPhaseName, String toPhaseName) {
        if (!(this.hasPhaseType(fromPhaseName) && this.hasPhaseType(toPhaseName) || fraction < 1.0E-30)) {
            return;
        }
        int phaseNumbFrom = this.getPhaseNumberOfPhase(fromPhaseName);
        int phaseNumbTo = this.getPhaseNumberOfPhase(toPhaseName);
        int i = 0;
        while (i < this.getPhase(0).getNumberOfComponents()) {
            double change = this.getPhase(phaseNumbFrom).getComponent(i).getNumberOfMolesInPhase() * fraction;
            this.addComponent(i, change, phaseNumbTo);
            this.addComponent(i, -change, phaseNumbFrom);
            ++i;
        }
        this.init_x_y();
    }

    @Override
    public void addPhaseFractionToPhase(double fraction, String specification, String specifiedStream, String fromPhaseName, String toPhaseName) {
        double moleFraction = fraction;
        if (!this.hasPhaseType(fromPhaseName) || !this.hasPhaseType(toPhaseName) || fraction < 1.0E-30) {
            return;
        }
        int phaseNumbFrom = this.getPhaseNumberOfPhase(fromPhaseName);
        int phaseNumbTo = this.getPhaseNumberOfPhase(toPhaseName);
        if (specifiedStream.equals("feed")) {
            moleFraction = fraction;
        } else if (specifiedStream.equals("product")) {
            double test2;
            double specFractionTo = this.getPhaseFraction(specification, toPhaseName);
            double moleFractionFrom = this.getMoleFraction(phaseNumbFrom);
            double moleFractionTo = this.getMoleFraction(phaseNumbTo);
            if (specification.equals("volume") || specification.equals("mass")) {
                test2 = fraction * specFractionTo / (fraction * specFractionTo + specFractionTo);
                moleFraction = test2 * moleFractionTo / specFractionTo;
            } else if (specification.equals("mole")) {
                moleFraction = test2 = fraction * moleFractionTo / (fraction * moleFractionTo + moleFractionTo);
            }
            moleFraction = moleFraction * moleFractionTo / moleFractionFrom;
            if (moleFraction > moleFractionFrom) {
                logger.debug("error in addPhaseFractionToPhase()...to low fraction in from phase");
                moleFraction = moleFractionFrom;
            }
        }
        int i = 0;
        while (i < this.getPhase(0).getNumberOfComponents()) {
            double change = 0.0;
            change = this.getPhase(phaseNumbFrom).getComponent(i).getNumberOfMolesInPhase() * moleFraction;
            this.addComponent(i, change, phaseNumbTo);
            this.addComponent(i, -change, phaseNumbFrom);
            ++i;
        }
        this.init_x_y();
    }

    @Override
    public void renameComponent(String oldName, String newName) {
        this.componentNames.set(this.getPhase(0).getComponent(oldName).getComponentNumber(), newName);
        int i = 0;
        while (i < this.maxNumberOfPhases) {
            this.getPhase(i).getComponent(oldName).setComponentName(newName);
            ++i;
        }
    }

    @Override
    public void setComponentNameTag(String nameTag) {
        this.componentNameTag = nameTag;
        int i = 0;
        while (i < this.getPhase(0).getNumberOfComponents()) {
            this.renameComponent(this.componentNames.get(i), String.valueOf(this.componentNames.get(i)) + nameTag);
            ++i;
        }
    }

    @Override
    public void setComponentNameTagOnNormalComponents(String nameTag) {
        this.componentNameTag = nameTag;
        int i = 0;
        while (i < this.getPhase(0).getNumberOfComponents()) {
            if (!this.getPhase(0).getComponent(i).isIsTBPfraction() && !this.getPhase(0).getComponent(i).isIsPlusFraction()) {
                this.renameComponent(this.componentNames.get(i), String.valueOf(this.componentNames.get(i)) + nameTag);
            }
            ++i;
        }
    }

    @Override
    public String getComponentNameTag() {
        return this.componentNameTag;
    }

    @Override
    public void addGasToLiquid(double fraction) {
        int i = 0;
        while (i < this.getPhase(0).getNumberOfComponents()) {
            double change = this.getPhase(0).getComponent(i).getNumberOfMolesInPhase() * fraction;
            this.addComponent(i, -change, 0);
            this.addComponent(i, change, 1);
            ++i;
        }
    }

    @Override
    public double getTotalNumberOfMoles() {
        return this.totalNumberOfMoles;
    }

    @Override
    public void setTotalNumberOfMoles(double totalNumberOfMoles) {
        this.totalNumberOfMoles = totalNumberOfMoles;
    }

    @Override
    public boolean hasPhaseType(String phaseTypeName) {
        int i = 0;
        while (i < this.numberOfPhases) {
            if (this.getPhase(i).getPhaseTypeName().equals(phaseTypeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public PhaseInterface getPhase(String phaseTypeName) {
        int i = 0;
        while (i < this.numberOfPhases) {
            if (this.getPhase(i).getPhaseTypeName().equals(phaseTypeName)) {
                return this.getPhase(i);
            }
            ++i;
        }
        throw new RuntimeException();
    }

    @Override
    public int getPhaseNumberOfPhase(String phaseTypeName) {
        int i = 0;
        while (i < this.numberOfPhases) {
            if (this.getPhase(i).getPhaseTypeName().equals(phaseTypeName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public int getPhaseIndexOfPhase(String phaseTypeName) {
        int i = 0;
        while (i < this.numberOfPhases) {
            if (this.getPhase(i).getPhaseTypeName().equals(phaseTypeName)) {
                return this.phaseIndex[i];
            }
            ++i;
        }
        return this.phaseIndex[0];
    }

    @Override
    public PhaseInterface getPhaseOfType(String phaseName) {
        int i = 0;
        while (i < this.numberOfPhases) {
            if (this.getPhase(i).getPhaseTypeName().equals(phaseName)) {
                return this.getPhase(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public double calcHenrysConstant(String component) {
        if (this.numberOfPhases != 2) {
            logger.error("cant calculated Henrys constant - two phases must be present.");
            return 0.0;
        }
        int compNumb = this.getPhase(this.getPhaseIndex(0)).getComponent(component).getComponentNumber();
        double hc = this.getPhase(this.getPhaseIndex(0)).getFugacity(compNumb) / this.getPhase(this.getPhaseIndex(1)).getComponent(component).getx();
        return hc;
    }

    public boolean useTVasIndependentVariables() {
        return this.useTVasIndependentVariables;
    }

    @Override
    public void setUseTVasIndependentVariables(boolean useTVasIndependentVariables) {
        int i = 0;
        while (i < this.numberOfPhases) {
            this.getPhase(i).setTotalVolume(this.getPhase(i).getVolume());
            this.getPhase(i).setConstantPhaseVolume(useTVasIndependentVariables);
            this.getPhase(i).calcMolarVolume(!useTVasIndependentVariables);
            ++i;
        }
        this.useTVasIndependentVariables = useTVasIndependentVariables;
    }

    @Override
    public void setBmixType(int bmixType) {
        int i = 0;
        while (i < this.getMaxNumberOfPhases()) {
            ((PhaseEosInterface)this.getPhase(i)).getMixingRule().setBmixType(bmixType);
            ++i;
        }
    }

    @Override
    public boolean isImplementedTemperatureDeriativesofFugacity() {
        return this.implementedTemperatureDeriativesofFugacity;
    }

    @Override
    public void setImplementedTemperatureDeriativesofFugacity(boolean implementedTemperatureDeriativesofFugacity) {
        this.implementedTemperatureDeriativesofFugacity = implementedTemperatureDeriativesofFugacity;
    }

    @Override
    public boolean isImplementedPressureDeriativesofFugacity() {
        return this.implementedPressureDeriativesofFugacity;
    }

    @Override
    public void setImplementedPressureDeriativesofFugacity(boolean implementedPressureDeriativesofFugacity) {
        this.implementedPressureDeriativesofFugacity = implementedPressureDeriativesofFugacity;
    }

    @Override
    public boolean isImplementedCompositionDeriativesofFugacity() {
        return this.implementedCompositionDeriativesofFugacity;
    }

    @Override
    public void setImplementedCompositionDeriativesofFugacity(boolean implementedCompositionDeriativesofFugacity) {
        this.implementedCompositionDeriativesofFugacity = implementedCompositionDeriativesofFugacity;
    }

    @Override
    public void deleteFluidPhase(int phase) {
        int i = phase;
        while (i < this.numberOfPhases) {
            this.phaseIndex[i] = this.phaseIndex[i + 1];
            ++i;
        }
        --this.numberOfPhases;
    }

    @Override
    public int getMaxNumberOfPhases() {
        return this.maxNumberOfPhases;
    }

    @Override
    public void setMaxNumberOfPhases(int maxNumberOfPhases) {
        this.maxNumberOfPhases = maxNumberOfPhases;
    }

    @Override
    public void setMolarComposition(double[] molefractions) {
        double totalFlow = this.getTotalNumberOfMoles();
        if (totalFlow < 1.0E-100) {
            logger.error("Total flow can not be 0 when setting molar composition ");
            InvalidInputException e = new InvalidInputException();
            throw new RuntimeException(e);
        }
        double sum = 0.0;
        double[] dArray = molefractions;
        int n = molefractions.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        this.setEmptyFluid();
        int compNumb = 0;
        while (compNumb < this.numberOfComponents) {
            this.addComponent(compNumb, totalFlow * molefractions[compNumb] / sum);
            ++compNumb;
        }
        int i = 0;
        while (i < this.getNumberOfPhases()) {
            this.init(0, i);
            ++i;
        }
    }

    @Override
    public void setMolarCompositionPlus(double[] molefractions) {
        double totalFlow = this.getTotalNumberOfMoles();
        if (totalFlow < 1.0E-100) {
            logger.error("Total flow can not be 0 when setting molar composition ");
            InvalidInputException e = new InvalidInputException();
            throw new RuntimeException(e);
        }
        double sum = 0.0;
        double[] dArray = molefractions;
        int n = molefractions.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        this.setEmptyFluid();
        int compNumb = 0;
        while (compNumb < this.numberOfComponents - this.getCharacterization().getLumpingModel().getNumberOfLumpedComponents()) {
            this.addComponent(compNumb, totalFlow * molefractions[compNumb] / sum);
            ++compNumb;
        }
        int ii = 0;
        int compNumb2 = this.numberOfComponents - this.getCharacterization().getLumpingModel().getNumberOfLumpedComponents();
        while (compNumb2 < this.numberOfComponents) {
            this.addComponent(compNumb2, totalFlow * this.getCharacterization().getLumpingModel().getFractionOfHeavyEnd(ii++) * molefractions[this.numberOfComponents - this.getCharacterization().getLumpingModel().getNumberOfLumpedComponents()] / sum);
            ++compNumb2;
        }
        int i = 0;
        while (i < this.getNumberOfPhases()) {
            this.init(0, i);
            ++i;
        }
    }

    @Override
    public void setMolarCompositionOfPlusFluid(double[] molefractions) {
        double totalFlow = this.getTotalNumberOfMoles();
        if (totalFlow < 1.0E-100) {
            logger.error("Total flow can not be 0 when setting molar composition ");
            InvalidInputException e = new InvalidInputException();
            throw new RuntimeException(e);
        }
        double sum = 0.0;
        double[] dArray = molefractions;
        int n = molefractions.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        this.setEmptyFluid();
        int compNumb = 0;
        compNumb = 0;
        while (compNumb < molefractions.length - 1) {
            this.addComponent(compNumb, totalFlow * molefractions[compNumb] / sum);
            ++compNumb;
        }
        int j = 0;
        while (j < this.getCharacterization().getLumpingModel().getNumberOfLumpedComponents() - 1) {
            ++compNumb;
            ++j;
        }
        int i = 0;
        while (i < this.getNumberOfPhases()) {
            this.init(0, i);
            ++i;
        }
    }

    @Override
    public void setMolarFlowRates(double[] moles) {
        this.setEmptyFluid();
        int compNumb = 0;
        while (compNumb < this.numberOfComponents) {
            this.addComponent(compNumb, moles[compNumb]);
            ++compNumb;
        }
        int i = 0;
        while (i < this.getNumberOfPhases()) {
            this.init(0, i);
            ++i;
        }
    }

    @Override
    public double[] getMolarRate() {
        double[] comp = new double[this.getPhase(0).getNumberOfComponents()];
        int compNumb = 0;
        while (compNumb < this.numberOfComponents) {
            comp[compNumb] = this.getPhase(0).getComponent(compNumb).getNumberOfmoles();
            ++compNumb;
        }
        return comp;
    }

    @Override
    public double[] getMolarComposition() {
        double[] comp = new double[this.getPhase(0).getNumberOfComponents()];
        int compNumb = 0;
        while (compNumb < this.numberOfComponents) {
            comp[compNumb] = this.getPhase(0).getComponent(compNumb).getz();
            ++compNumb;
        }
        return comp;
    }

    @Override
    public boolean isMultiphaseWaxCheck() {
        return this.multiphaseWaxCheck;
    }

    @Override
    public void setMultiphaseWaxCheck(boolean multiphaseWaxCheck) {
        this.multiphaseWaxCheck = multiphaseWaxCheck;
    }

    @Override
    public String[] getCompIDs() {
        String[] ids = new String[this.numberOfComponents];
        int compNumb = 0;
        while (compNumb < this.numberOfComponents) {
            ids[compNumb] = Integer.toString(this.getPhase(0).getComponent(compNumb).getIndex());
            ++compNumb;
        }
        return ids;
    }

    @Override
    public String[] getCompFormulaes() {
        String[] formula = new String[this.numberOfComponents];
        int compNumb = 0;
        while (compNumb < this.numberOfComponents) {
            formula[compNumb] = this.getPhase(0).getComponent(compNumb).getFormulae();
            ++compNumb;
        }
        return formula;
    }

    @Override
    public String[] getCompNames() {
        String[] names = new String[this.numberOfComponents];
        int compNumb = 0;
        while (compNumb < this.numberOfComponents) {
            names[compNumb] = this.getPhase(0).getComponent(compNumb).getComponentName();
            ++compNumb;
        }
        return names;
    }

    @Override
    public double[] getNormalBoilingPointTemperatures() {
        double[] bt = new double[this.numberOfComponents];
        int compNumb = 0;
        while (compNumb < this.numberOfComponents) {
            bt[compNumb] = this.getPhase(0).getComponent(compNumb).getNormalBoilingPoint() + 273.15;
            ++compNumb;
        }
        return bt;
    }

    @Override
    public String[] getCapeOpenProperties11() {
        return this.CapeOpenProperties11;
    }

    @Override
    public String[] getCapeOpenProperties10() {
        return this.CapeOpenProperties10;
    }

    @Override
    public double[] getMolecularWeights() {
        double[] mm = new double[this.numberOfComponents];
        int compNumb = 0;
        while (compNumb < this.numberOfComponents) {
            mm[compNumb] = this.getPhase(0).getComponent(compNumb).getMolarMass() * 1000.0;
            ++compNumb;
        }
        return mm;
    }

    @Override
    public String[] getCASNumbers() {
        String[] names = new String[this.numberOfComponents];
        int compNumb = 0;
        while (compNumb < this.numberOfComponents) {
            names[compNumb] = this.getPhase(0).getComponent(compNumb).getCASnumber();
            ++compNumb;
        }
        return names;
    }

    @Override
    public int getNumberOfOilFractionComponents() {
        int number = 0;
        int i = 0;
        while (i < this.getPhase(0).getNumberOfComponents()) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction() || this.getPhase(0).getComponent(i).isIsPlusFraction()) {
                ++number;
            }
            ++i;
        }
        return number;
    }

    @Override
    public int[] getOilFractionIDs() {
        int numb = this.getNumberOfOilFractionComponents();
        int[] IDs = new int[numb];
        int i = 0;
        while (i < numb) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction() || this.getPhase(0).getComponent(i).isIsPlusFraction()) {
                IDs[i] = this.getPhase(0).getComponent(i).getIndex();
            }
            ++i;
        }
        return IDs;
    }

    @Override
    public boolean setHeavyTBPfractionAsPlusFraction() {
        int compNumber = 0;
        double molarMass = 0.0;
        boolean foundTBP = false;
        int i = 0;
        while (i < this.numberOfComponents) {
            if ((this.getPhase(0).getComponent(i).isIsTBPfraction() || this.getPhase(0).getComponent(i).isIsPlusFraction()) && this.getPhase(0).getComponent(i).getMolarMass() > molarMass) {
                molarMass = this.getPhase(0).getComponent(i).getMolarMass();
                compNumber = i;
                foundTBP = true;
            }
            ++i;
        }
        if (foundTBP) {
            i = 0;
            while (i < this.maxNumberOfPhases) {
                this.getPhase(0).getComponent(compNumber).setIsPlusFraction(true);
                ++i;
            }
        }
        return foundTBP;
    }

    @Override
    public double[] getOilFractionNormalBoilingPoints() {
        int numb = this.getNumberOfOilFractionComponents();
        int[] indexes = this.getOilFractionIDs();
        double[] temp = new double[numb];
        int i = 0;
        while (i < numb) {
            temp[i] = this.getPhase(0).getComponentWithIndex(indexes[i]).getNormalBoilingPoint();
            ++i;
        }
        return temp;
    }

    @Override
    public double[] getOilFractionLiquidDensityAt25C() {
        int numb = this.getNumberOfOilFractionComponents();
        int[] indexes = this.getOilFractionIDs();
        double[] temp = new double[numb];
        int i = 0;
        while (i < numb) {
            temp[i] = this.getPhase(0).getComponentWithIndex(indexes[i]).getNormalLiquidDensity();
            ++i;
        }
        return temp;
    }

    @Override
    public double[] getOilFractionMolecularMass() {
        int numb = this.getNumberOfOilFractionComponents();
        int[] indexes = this.getOilFractionIDs();
        double[] temp = new double[numb];
        int i = 0;
        while (i < numb) {
            temp[i] = this.getPhase(0).getComponentWithIndex(indexes[i]).getMolarMass();
            ++i;
        }
        return temp;
    }

    @Override
    public PhaseInterface getLowestGibbsEnergyPhase() {
        if (this.getPhase(0).getGibbsEnergy() < this.getPhase(1).getGibbsEnergy()) {
            return this.getPhase(0);
        }
        return this.getPhase(1);
    }

    @Override
    public double getWtFraction(int phaseNumber) {
        return this.getPhase(phaseNumber).getWtFraction(this);
    }

    @Override
    public double getVolumeFraction(int phaseNumber) {
        return this.getPhase(phaseNumber).getVolume() / this.getVolume();
    }

    @Override
    public final double getPhaseFraction(String phaseTypeName, String unit) {
        int phaseNumber = this.getPhaseNumberOfPhase(phaseTypeName);
        switch (unit) {
            case "mole": {
                return this.getBeta(phaseNumber);
            }
            case "volume": {
                return this.getVolumeFraction(phaseNumber);
            }
            case "mass": {
                this.initPhysicalProperties("density");
                return this.getVolumeFraction(phaseNumber) * this.getPhase(phaseNumber).getDensity("kg/m3") / this.getDensity("kg/m3");
            }
        }
        return this.getBeta(phaseNumber);
    }

    @Override
    public double getCorrectedVolumeFraction(int phaseNumber) {
        return this.getPhase(phaseNumber).getCorrectedVolume() / this.getCorrectedVolume();
    }

    @Override
    public double getMoleFraction(int phaseNumber) {
        return this.getPhase(phaseNumber).getBeta();
    }

    @Override
    public void isImplementedCompositionDeriativesofFugacity(boolean isImpl) {
        this.implementedCompositionDeriativesofFugacity = isImpl;
    }

    @Override
    public void addCapeOpenProperty(String propertyName) {
        String[] tempString = new String[this.CapeOpenProperties11.length + 1];
        System.arraycopy(this.CapeOpenProperties11, 0, tempString, 0, this.CapeOpenProperties11.length);
        tempString[this.CapeOpenProperties11.length] = propertyName;
        this.CapeOpenProperties11 = tempString;
        tempString = new String[this.CapeOpenProperties10.length + 1];
        System.arraycopy(this.CapeOpenProperties10, 0, tempString, 0, this.CapeOpenProperties10.length);
        tempString[this.CapeOpenProperties10.length] = propertyName;
        this.CapeOpenProperties10 = tempString;
    }

    @Override
    public WaxCharacterise getWaxCharacterisation() {
        return this.waxCharacterisation;
    }

    @Override
    public WaxModelInterface getWaxModel() {
        if (this.waxCharacterisation == null) {
            this.waxCharacterisation = new WaxCharacterise(this);
        }
        return this.waxCharacterisation.getModel();
    }

    @Override
    public void setComponentNames(String[] componentNames) {
        int i = 0;
        while (i < componentNames.length) {
            this.componentNames.set(i, componentNames[i]);
            ++i;
        }
    }

    @Override
    public double getLiquidVolume() {
        double totFlow = 0.0;
        int kj = 0;
        while (kj < this.numberOfPhases) {
            if (!this.getPhase(kj).getPhaseTypeName().equals("gas")) {
                totFlow += this.getPhase(kj).getVolume();
            }
            ++kj;
        }
        return totFlow;
    }

    @Override
    public boolean isForcePhaseTypes() {
        return this.forcePhaseTypes;
    }

    @Override
    public void setForcePhaseTypes(boolean forcePhaseTypes) {
        this.forcePhaseTypes = forcePhaseTypes;
    }
}

