/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePrEos;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemPrEos;

public class SystemPrGassemEos
extends SystemPrEos {
    private static final long serialVersionUID = 1000L;

    public SystemPrGassemEos() {
        this.modelName = "PR-Gassem-EOS";
        this.attractiveTermNumber = 8;
        int i = 0;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(298.15);
            this.phaseArray[i].setPressure(1.0);
            ++i;
        }
    }

    public SystemPrGassemEos(double T, double P) {
        super(T, P);
        this.modelName = "PR-Gassem-EOS";
        this.attractiveTermNumber = 8;
        int i = 0;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
            ++i;
        }
    }

    public SystemPrGassemEos(double T, double P, boolean solidCheck) {
        this(T, P);
        this.modelName = "PR-Gassem-EOS";
        this.attractiveTermNumber = 8;
        this.numberOfPhases = 5;
        this.maxNumberOfPhases = 5;
        this.solidPhaseCheck = solidCheck;
        int i = 0;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
            ++i;
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemPrGassemEos clone() {
        SystemPrGassemEos clonedSystem = null;
        try {
            clonedSystem = (SystemPrGassemEos)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedSystem;
    }
}

