/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseKentEisenberg;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.system.SystemEos;

public class SystemKentEisenberg
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemKentEisenberg() {
        this.modelName = "Kent Eisenberg-model";
        this.attractiveTermNumber = 0;
        this.phaseArray[0] = new PhaseSrkEos();
        int i = 1;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhaseKentEisenberg();
            ++i;
        }
    }

    public SystemKentEisenberg(double T, double P) {
        super(T, P);
        this.attractiveTermNumber = 0;
        this.modelName = "Kent Eisenberg-model";
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        int i = 1;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhaseKentEisenberg();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
            ++i;
        }
    }

    public SystemKentEisenberg(double T, double P, boolean solidCheck) {
        this(T, P);
        this.attractiveTermNumber = 0;
        this.numberOfPhases = 4;
        this.maxNumberOfPhases = 4;
        this.modelName = "Kent Eisenberg-model";
        this.solidPhaseCheck = solidCheck;
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        int i = 1;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhaseKentEisenberg();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
            ++i;
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemKentEisenberg clone() {
        SystemKentEisenberg clonedSystem = null;
        try {
            clonedSystem = (SystemKentEisenberg)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedSystem;
    }
}

