/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseDesmukhMather;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.system.SystemEos;

public class SystemDesmukhMather
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemDesmukhMather() {
        this.modelName = "Desmukh-Mather-model";
        this.attractiveTermNumber = 0;
        this.phaseArray[0] = new PhaseSrkEos();
        int i = 1;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhaseDesmukhMather();
            ++i;
        }
    }

    public SystemDesmukhMather(double T, double P) {
        super(T, P);
        this.attractiveTermNumber = 0;
        this.modelName = "Desmukh-Mather-model";
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        int i = 1;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhaseDesmukhMather();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
            ++i;
        }
    }

    public SystemDesmukhMather(double T, double P, boolean solidCheck) {
        this(T, P);
        this.attractiveTermNumber = 0;
        this.numberOfPhases = 4;
        this.maxNumberOfPhases = 4;
        this.modelName = "Desmukh-Mather-model";
        this.solidPhaseCheck = solidCheck;
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        int i = 1;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhaseDesmukhMather();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
            ++i;
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemDesmukhMather clone() {
        SystemDesmukhMather clonedSystem = null;
        try {
            clonedSystem = (SystemDesmukhMather)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedSystem;
    }
}

