/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentCPAInterface;
import neqsim.thermo.component.ComponentSrkCPA;
import neqsim.thermo.mixingRule.CPAMixing;
import neqsim.thermo.mixingRule.CPAMixingInterface;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.simple.SimpleMatrix;

public class PhaseSrkCPA
extends PhaseSrkEos
implements PhaseCPAInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PhaseSrkCPA.class);
    public CPAMixing cpaSelect = new CPAMixing();
    public CPAMixingInterface cpamix;
    double gcpavv = 0.0;
    double gcpavvv = 0.0;
    double gcpa = 0.0;
    double hcpatot = 1.0;
    double FCPA = 0.0;
    double dFCPAdTdV;
    double dFCPAdTdT = 0.0;
    double dFCPAdT = 0.0;
    double dFCPAdV = 0.0;
    double dFCPAdVdV = 0.0;
    double dFCPAdVdVdV = 0.0;
    double gcpav = 0.0;
    double tempTotVol = 0.0;
    private double[] dFdNtemp = new double[]{0.0, 0.0};
    int cpaon = 1;
    int oldTotalNumberOfAccociationSites = 0;
    int totalNumberOfAccociationSites = 0;
    int[][][] selfAccociationScheme = null;
    int[][][][] crossAccociationScheme = null;
    int[] activeAccosComp = null;
    private double[] lngi;
    int[] moleculeNumber = null;
    int[] assSiteNumber = null;
    private double[][] gvector = null;
    private double[][] delta = null;
    private double[][] deltaNog = null;
    private double[][] deltadT = null;
    private double[][] deltadTdT = null;
    double[][][] Klkni = null;
    private SimpleMatrix KlkTVMatrix = null;
    private SimpleMatrix KlkTTMatrix = null;
    private SimpleMatrix KlkTMatrix = null;
    private SimpleMatrix udotTimesmMatrix = null;
    private SimpleMatrix mVector = null;
    private SimpleMatrix udotMatrix = null;
    private SimpleMatrix uMatrix = null;
    private SimpleMatrix QMatksiksiksi = null;
    private SimpleMatrix KlkVVVMatrix = null;
    private SimpleMatrix KlkVVMatrix = null;
    private SimpleMatrix udotTimesmiMatrix = null;
    private SimpleMatrix ksiMatrix = null;
    private SimpleMatrix KlkMatrix = null;
    private SimpleMatrix hessianMatrix = null;
    private SimpleMatrix hessianInvers = null;
    private SimpleMatrix KlkVMatrix = null;
    private DMatrixRMaj corr2Matrix = null;
    private DMatrixRMaj corr3Matrix = null;
    private DMatrixRMaj corr4Matrix = null;

    public double[] getdFdNtemp() {
        return this.dFdNtemp;
    }

    public PhaseSrkCPA() {
        this.thermoPropertyModelName = "SRK-CPA-EoS";
    }

    @Override
    public PhaseSrkCPA clone() {
        PhaseSrkCPA clonedPhase = null;
        try {
            clonedPhase = (PhaseSrkCPA)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        if (this.activeAccosComp != null) {
            clonedPhase.activeAccosComp = (int[])this.activeAccosComp.clone();
            System.arraycopy(this.activeAccosComp, 0, clonedPhase.activeAccosComp, 0, this.activeAccosComp.length);
        }
        return clonedPhase;
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        boolean changedAssosiationStatus = false;
        if (type == 0) {
            int j;
            this.activeAccosComp = new int[numberOfComponents];
            int i = 0;
            while (i < numberOfComponents) {
                if (this.componentArray[i].getNumberOfmoles() < 1.0E-50) {
                    this.componentArray[i].setNumberOfAssociationSites(0);
                    if (this.activeAccosComp[i] == 1) {
                        this.activeAccosComp[i] = 0;
                        changedAssosiationStatus = true;
                    }
                } else if (this.activeAccosComp[i] == 0) {
                    changedAssosiationStatus = true;
                    this.activeAccosComp[i] = 1;
                }
                ++i;
            }
            if (changedAssosiationStatus || this.lngi == null) {
                this.setTotalNumberOfAccociationSites(0);
                this.selfAccociationScheme = new int[numberOfComponents][0][0];
                this.crossAccociationScheme = new int[numberOfComponents][numberOfComponents][0][0];
                i = 0;
                while (i < numberOfComponents) {
                    if (this.componentArray[i].getNumberOfmoles() < 1.0E-50) {
                        this.componentArray[i].setNumberOfAssociationSites(0);
                    } else {
                        this.componentArray[i].setNumberOfAssociationSites(this.componentArray[i].getOrginalNumberOfAssociationSites());
                        this.setTotalNumberOfAccociationSites(this.getTotalNumberOfAccociationSites() + this.componentArray[i].getNumberOfAssociationSites());
                        this.selfAccociationScheme[i] = this.cpaSelect.setAssociationScheme(i, this);
                        j = 0;
                        while (j < numberOfComponents) {
                            this.crossAccociationScheme[i][j] = this.cpaSelect.setCrossAssociationScheme(i, j, this);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < numberOfComponents) {
                j = 0;
                while (j < this.componentArray[i].getNumberOfAssociationSites()) {
                    ((ComponentSrkCPA)this.componentArray[i]).setXsite(j, 1.0);
                    ((ComponentSrkCPA)this.componentArray[i]).setXsitedV(j, 0.0);
                    ((ComponentSrkCPA)this.componentArray[i]).setXsitedT(j, 0.0);
                    ++j;
                }
                ++i;
            }
            if (changedAssosiationStatus || this.lngi == null || this.mVector == null) {
                this.lngi = new double[numberOfComponents];
                this.mVector = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.KlkMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkVVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkVVVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.hessianMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkTMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkTTMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.KlkTVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
                this.corr2Matrix = new DMatrixRMaj(this.getTotalNumberOfAccociationSites(), 1);
                this.corr3Matrix = new DMatrixRMaj(this.getTotalNumberOfAccociationSites(), 1);
                this.corr4Matrix = new DMatrixRMaj(this.getTotalNumberOfAccociationSites(), 1);
                this.Klkni = new double[numberOfComponents][this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
                this.ksiMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.uMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.udotMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.moleculeNumber = new int[this.getTotalNumberOfAccociationSites()];
                this.assSiteNumber = new int[this.getTotalNumberOfAccociationSites()];
                this.gvector = new double[this.getTotalNumberOfAccociationSites()][1];
                this.udotTimesmMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.delta = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
                this.deltaNog = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
                this.deltadT = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
                this.deltadTdT = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
                this.QMatksiksiksi = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
                this.udotTimesmiMatrix = new SimpleMatrix(numberOfComponents, this.getTotalNumberOfAccociationSites());
                this.oldTotalNumberOfAccociationSites = this.getTotalNumberOfAccociationSites();
                int temp = 0;
                int i2 = 0;
                while (i2 < numberOfComponents) {
                    int j2 = 0;
                    while (j2 < this.componentArray[i2].getNumberOfAssociationSites()) {
                        this.moleculeNumber[temp + j2] = i2;
                        this.assSiteNumber[temp + j2] = j2;
                        ++j2;
                    }
                    temp += this.componentArray[i2].getNumberOfAssociationSites();
                    ++i2;
                }
            }
        }
        if (this.cpamix == null) {
            this.cpamix = this.cpaSelect.getMixingRule(1, this);
        }
        if (type > 0) {
            this.calcDelta();
        }
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        if (type > 0 && this.isConstantPhaseVolume()) {
            this.solveX();
            super.init(totalNumberOfMoles, numberOfComponents, 1, phase, beta);
            this.gcpa = this.calc_g();
            this.gcpav = this.calc_lngV();
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
        }
        if (type > 0) {
            this.hcpatot = this.calc_hCPA();
        }
        if (type > 1) {
            this.initCPAMatrix(type);
        }
    }

    public void initCPAMatrix(int type) {
        double tempVar2;
        int j;
        if (this.totalNumberOfAccociationSites == 0) {
            this.FCPA = 0.0;
            this.dFCPAdTdV = 0.0;
            this.dFCPAdTdT = 0.0;
            this.dFCPAdT = 0.0;
            this.dFCPAdV = 0.0;
            this.dFCPAdVdV = 0.0;
            this.dFCPAdVdVdV = 0.0;
            return;
        }
        int temp = 0;
        int i = 0;
        while (i < this.numberOfComponents) {
            j = 0;
            while (j < this.componentArray[i].getNumberOfAssociationSites()) {
                double tempVar1 = this.ksiMatrix.get(temp + j, 0);
                tempVar2 = this.udotMatrix.get(temp + j, 0);
                this.uMatrix.set(temp + j, 0, Math.log(tempVar1) - tempVar1 + 1.0);
                this.gvector[temp + j][0] = this.mVector.get(temp + j, 0) * tempVar2;
                if (this.moleculeNumber[temp + j] == i) {
                    this.udotTimesmiMatrix.set(i, temp + j, tempVar2);
                } else {
                    this.udotTimesmiMatrix.set(i, temp + j, 0.0);
                }
                ++j;
            }
            temp += this.componentArray[i].getNumberOfAssociationSites();
            ++i;
        }
        if (type > 2) {
            int p = 0;
            while (p < this.numberOfComponents) {
                this.lngi[p] = ((ComponentSrkCPA)this.componentArray[p]).calc_lngi(this);
                ++p;
            }
        }
        i = 0;
        while (i < this.totalNumberOfAccociationSites) {
            j = i;
            while (j < this.totalNumberOfAccociationSites) {
                this.delta[i][j] = this.deltaNog[i][j] * this.gcpa;
                this.delta[j][i] = this.delta[i][j];
                if (type > 1) {
                    this.deltadT[i][j] = this.cpamix.calcDeltadT(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                    this.deltadT[j][i] = this.deltadT[i][j];
                    this.deltadTdT[i][j] = this.cpamix.calcDeltadTdT(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                    this.deltadTdT[j][i] = this.deltadTdT[i][j];
                }
                ++j;
            }
            ++i;
        }
        double totalVolume = this.getTotalVolume();
        double totalVolume2 = totalVolume * totalVolume;
        double totalVolume3 = totalVolume2 * totalVolume;
        double gdv1 = this.getGcpav() - 1.0 / totalVolume;
        double gdv2 = gdv1 * gdv1;
        double gdv3 = gdv2 * gdv1;
        double Klk = 0.0;
        double tempKsiRead = 0.0;
        int i2 = 0;
        while (i2 < this.totalNumberOfAccociationSites) {
            int j2 = i2;
            while (j2 < this.totalNumberOfAccociationSites) {
                Klk = this.KlkMatrix.get(i2, j2);
                double tempVar = Klk * gdv1;
                this.KlkVMatrix.set(i2, j2, tempVar);
                this.KlkVMatrix.set(j2, i2, tempVar);
                tempVar = Klk * gdv2 + Klk * (this.gcpavv + 1.0 / totalVolume2);
                this.KlkVVMatrix.set(i2, j2, tempVar);
                this.KlkVVMatrix.set(j2, i2, tempVar);
                tempVar = Klk * gdv3 + 3.0 * Klk * (this.gcpav - 1.0 / totalVolume) * (this.gcpavv + 1.0 / totalVolume2) + Klk * (this.gcpavvv - 2.0 / totalVolume3);
                this.KlkVVVMatrix.set(i2, j2, tempVar);
                this.KlkVVVMatrix.set(j2, i2, tempVar);
                if (type > 1) {
                    tempVar = this.deltadT[i2][j2] / this.delta[i2][j2];
                    if (Math.abs(tempVar) > 1.0E-50) {
                        double tempVardT = this.deltadTdT[i2][j2] / this.delta[i2][j2] - this.deltadT[i2][j2] * this.deltadT[i2][j2] / (this.delta[i2][j2] * this.delta[i2][j2]);
                        tempVar2 = Klk * tempVar;
                        this.KlkTMatrix.set(i2, j2, tempVar2);
                        this.KlkTMatrix.set(j2, i2, tempVar2);
                        tempVar2 = Klk * tempVar * (this.gcpav - 1.0 / totalVolume);
                        this.KlkTVMatrix.set(i2, j2, tempVar2);
                        this.KlkTVMatrix.set(j2, i2, tempVar2);
                        tempVar2 = Klk * (tempVar * tempVar + tempVardT);
                        this.KlkTTMatrix.set(i2, j2, tempVar2);
                        this.KlkTTMatrix.set(j2, i2, tempVar2);
                    }
                    if (type > 2) {
                        int p = 0;
                        while (p < this.numberOfComponents) {
                            double t1 = 0.0;
                            double t2 = 0.0;
                            if (this.moleculeNumber[i2] == p) {
                                t1 = 1.0 / this.mVector.get(i2, 0);
                            }
                            if (this.moleculeNumber[j2] == p) {
                                t2 = 1.0 / this.mVector.get(j2, 0);
                            }
                            this.Klkni[p][i2][j2] = Klk * (t1 + t2 + this.lngi[p]);
                            this.Klkni[p][j2][i2] = this.Klkni[p][i2][j2];
                            ++p;
                        }
                    }
                }
                ++j2;
            }
            tempKsiRead = this.ksiMatrix.get(i2, 0);
            this.QMatksiksiksi.set(i2, 0, 2.0 * this.mVector.get(i2, 0) / (tempKsiRead * tempKsiRead * tempKsiRead));
            ++i2;
        }
        SimpleMatrix ksiMatrixTranspose = (SimpleMatrix)this.ksiMatrix.transpose();
        SimpleMatrix KlkVMatrixksi = this.KlkVMatrix.mult(this.ksiMatrix);
        SimpleMatrix XV = this.hessianInvers.mult(KlkVMatrixksi);
        SimpleMatrix XVtranspose = (SimpleMatrix)XV.transpose();
        this.FCPA = ((SimpleMatrix)this.mVector.transpose()).mult(this.uMatrix.minus((SimpleMatrix)this.ksiMatrix.elementMult(this.udotMatrix).scale(0.5))).get(0, 0);
        this.dFCPAdV = ksiMatrixTranspose.mult(KlkVMatrixksi).get(0, 0) * -0.5;
        SimpleMatrix KlkVVMatrixTImesKsi = this.KlkVVMatrix.mult(this.ksiMatrix);
        this.dFCPAdVdV = ((SimpleMatrix)ksiMatrixTranspose.mult(KlkVVMatrixTImesKsi).scale(-0.5)).minus(((SimpleMatrix)KlkVMatrixksi.transpose()).mult(XV)).get(0, 0);
        SimpleMatrix QVVV = ksiMatrixTranspose.mult(this.KlkVVVMatrix.mult(this.ksiMatrix));
        SimpleMatrix QVVksi = (SimpleMatrix)KlkVVMatrixTImesKsi.scale(-1.0);
        SimpleMatrix QksiVksi = (SimpleMatrix)this.KlkVMatrix.scale(-1.0);
        this.dFCPAdVdVdV = -0.5 * QVVV.get(0, 0) + ((SimpleMatrix)QVVksi.transpose()).mult(XV).get(0, 0) * 3.0 + XVtranspose.mult(QksiVksi.mult(XV)).get(0, 0) * 3.0 + XVtranspose.mult(this.QMatksiksiksi.mult(XVtranspose)).mult(XV).get(0, 0);
        if (type == 1) {
            return;
        }
        temp = 0;
        int p = 0;
        while (p < this.numberOfComponents) {
            int kk = 0;
            while (kk < this.getComponent(p).getNumberOfAssociationSites()) {
                ((ComponentCPAInterface)this.getComponent(p)).setXsitedV(kk, XV.get(temp + kk, 0));
                ++kk;
            }
            temp += this.getComponent(p).getNumberOfAssociationSites();
            ++p;
        }
        SimpleMatrix KlkTMatrixTImesKsi = this.KlkTMatrix.mult(this.ksiMatrix);
        SimpleMatrix tempMatrix2 = ksiMatrixTranspose.mult(KlkTMatrixTImesKsi);
        this.dFCPAdT = tempMatrix2.get(0, 0) * -0.5;
        SimpleMatrix XT = this.hessianInvers.mult(KlkTMatrixTImesKsi);
        SimpleMatrix tempMatrixTT = ((SimpleMatrix)ksiMatrixTranspose.mult(this.KlkTTMatrix.mult(this.ksiMatrix)).scale(-0.5)).minus(((SimpleMatrix)KlkTMatrixTImesKsi.transpose()).mult(XT));
        this.dFCPAdTdT = tempMatrixTT.get(0, 0);
        SimpleMatrix tempMatrixTV = ((SimpleMatrix)ksiMatrixTranspose.mult(this.KlkTVMatrix.mult(this.ksiMatrix)).scale(-0.5)).minus(((SimpleMatrix)KlkTMatrixTImesKsi.transpose()).mult(XV));
        this.dFCPAdTdV = tempMatrixTV.get(0, 0);
        temp = 0;
        int p2 = 0;
        while (p2 < this.numberOfComponents) {
            int kk = 0;
            while (kk < this.getComponent(p2).getNumberOfAssociationSites()) {
                ((ComponentCPAInterface)this.getComponent(p2)).setXsitedT(kk, XT.get(temp + kk, 0));
                ++kk;
            }
            temp += this.getComponent(p2).getNumberOfAssociationSites();
            ++p2;
        }
        if (type == 2) {
            return;
        }
        p2 = 0;
        while (p2 < this.numberOfComponents) {
            SimpleMatrix KiMatrix = new SimpleMatrix(this.Klkni[p2]);
            SimpleMatrix tempMatrix4 = KiMatrix.mult(this.ksiMatrix);
            SimpleMatrix tempMatrix5 = ((SimpleMatrix)((SimpleMatrix)this.udotTimesmiMatrix.extractVector(true, p2)).transpose()).minus(tempMatrix4);
            SimpleMatrix tempMatrix6 = this.hessianInvers.mult(tempMatrix5);
            int temp2 = 0;
            int compp = 0;
            while (compp < this.numberOfComponents) {
                int kk = 0;
                while (kk < this.getComponent(compp).getNumberOfAssociationSites()) {
                    ((ComponentCPAInterface)this.getComponent(compp)).setXsitedni(kk, p2, -1.0 * tempMatrix6.get(temp2 + kk, 0));
                    ++kk;
                }
                temp2 += this.getComponent(compp).getNumberOfAssociationSites();
                ++compp;
            }
            ++p2;
        }
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.cpamix = this.cpaSelect.getMixingRule(1, this);
    }

    public void calcDelta() {
        int i = 0;
        while (i < this.getTotalNumberOfAccociationSites()) {
            int j = i;
            while (j < this.getTotalNumberOfAccociationSites()) {
                this.deltaNog[i][j] = this.cpamix.calcDeltaNog(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                this.deltaNog[j][i] = this.deltaNog[i][j];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(componentName, moles, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentSrkCPA(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public double getF() {
        return super.getF() + (double)this.cpaon * this.FCPA();
    }

    @Override
    public double dFdT() {
        return super.dFdT() + (double)this.cpaon * this.dFCPAdT();
    }

    @Override
    public double dFdTdV() {
        return super.dFdTdV() + (double)this.cpaon * this.dFCPAdTdV();
    }

    @Override
    public double dFdV() {
        double dv2 = this.dFCPAdV();
        return super.dFdV() + (double)this.cpaon * dv2;
    }

    @Override
    public double dFdVdV() {
        return super.dFdVdV() + (double)this.cpaon * this.dFCPAdVdV();
    }

    @Override
    public double dFdVdVdV() {
        return super.dFdVdVdV() + (double)this.cpaon * this.dFCPAdVdVdV();
    }

    @Override
    public double dFdTdT() {
        return super.dFdTdT() + (double)this.cpaon * this.dFCPAdTdT();
    }

    public double FCPA() {
        return this.FCPA;
    }

    public double dFCPAdV() {
        return this.dFCPAdV;
    }

    public double dFCPAdVdV() {
        return this.dFCPAdVdV;
    }

    public double dFCPAdVdVdV() {
        return this.dFCPAdVdVdV;
    }

    public double dFCPAdT() {
        return this.dFCPAdT;
    }

    public double dFCPAdTdT() {
        return this.dFCPAdTdT;
    }

    public double dFCPAdTdV() {
        return this.dFCPAdTdV;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phasetype) throws IsNaNException, TooManyIterationsException {
        double BonVold;
        double BonV;
        double d = BonV = phasetype == 0 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 1.0E-8;
        }
        if (BonV >= 1.0) {
            BonV = 0.9999;
        }
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        do {
            ++iterations;
            this.gcpa = this.calc_g();
            if (this.gcpa < 0.0) {
                this.setMolarVolume(1.0 / Btemp / this.numberOfMolesInPhase);
                this.gcpa = this.calc_g();
            }
            this.gcpav = this.calc_lngV();
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            if (this.totalNumberOfAccociationSites > 0) {
                this.solveX();
            }
            this.initCPAMatrix(1);
            double BonV2 = BonV * BonV;
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / BonV2 * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / (BonV2 * BonV) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Btemp * Btemp / (BonV2 * BonV2) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += 0.5 * d1;
            } else {
                if (d1 > d2) {
                    return this.molarVolumeChangePhase(pressure, temperature, A, B, phasetype);
                }
                BonV += 0.5 * d1;
            }
            if (Math.abs((BonV - BonVold) / BonV) > 0.1) {
                BonV = BonVold + 0.1 * (BonV - BonVold);
            }
            if (BonV < 0.0) {
                if (iterations < 10) {
                    BonV = (BonVold + BonV) / 2.0;
                } else {
                    return this.molarVolumeChangePhase(pressure, temperature, A, B, phasetype);
                }
            }
            if (BonV >= 1.0) {
                if (iterations < 10) {
                    BonV = (BonVold + BonV) / 2.0;
                } else {
                    return this.molarVolumeChangePhase(pressure, temperature, A, B, phasetype);
                }
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while ((Math.abs((BonV - BonVold) / BonV) > 1.0E-10 || Math.abs(h) > 1.0E-12) && iterations < 100);
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException();
        }
        this.dFdNtemp = this.calcdFdNtemp();
        return this.getMolarVolume();
    }

    double[] calcdFdNtemp() {
        double tot1 = 0.0;
        double tot2 = 0.0;
        double tot3 = 0.0;
        double tot4 = 0.0;
        int k = 0;
        while (k < this.getNumberOfComponents()) {
            tot2 = 0.0;
            tot3 = 0.0;
            int i = 0;
            while (i < this.getComponent(k).getNumberOfAssociationSites()) {
                tot2 -= 1.0 * ((ComponentSrkCPA)this.getComponent(k)).getXsitedV()[i];
                tot3 += (1.0 - ((ComponentSrkCPA)this.getComponent(k)).getXsite()[i]) * 1.0;
                ++i;
            }
            tot1 += 0.5 * tot2 * this.getComponent(k).getNumberOfMolesInPhase();
            tot4 += 0.5 * this.getComponent(k).getNumberOfMolesInPhase() * tot3;
            ++k;
        }
        return new double[]{-tot1, -tot4};
    }

    public double calc_hCPA() {
        double htot = 0.0;
        double tot = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            htot = 0.0;
            int j = 0;
            while (j < this.componentArray[i].getNumberOfAssociationSites()) {
                htot += 1.0 - ((ComponentSrkCPA)this.componentArray[i]).getXsite()[j];
                ++j;
            }
            tot += this.componentArray[i].getNumberOfMolesInPhase() * htot;
            ++i;
        }
        return tot;
    }

    public double calc_g() {
        this.tempTotVol = this.getMolarVolume();
        double temp = 1.0 - this.getb() / 4.0 / this.tempTotVol;
        return (2.0 - this.getb() / 4.0 / this.tempTotVol) / (2.0 * temp * temp * temp);
    }

    public double calc_lngV() {
        this.tempTotVol = this.getMolarVolume();
        return 1.0 / (2.0 - this.getB() / (4.0 * this.tempTotVol)) * this.getB() / (4.0 * this.tempTotVol * this.tempTotVol) - 3.0 / (1.0 - this.getB() / (4.0 * this.tempTotVol)) * this.getB() / (4.0 * this.tempTotVol * this.tempTotVol);
    }

    public double calc_lngVV() {
        this.tempTotVol = this.getMolarVolume();
        return 2.0 * (640.0 * Math.pow(this.tempTotVol, 3.0) - 216.0 * this.getB() * this.tempTotVol * this.tempTotVol + 24.0 * Math.pow(this.getB(), 2.0) * this.tempTotVol - Math.pow(this.getB(), 3.0)) * this.getB() / (this.tempTotVol * this.tempTotVol) / Math.pow(8.0 * this.tempTotVol - this.getB(), 2.0) / Math.pow(4.0 * this.tempTotVol - this.getB(), 2.0);
    }

    public double calc_lngVVV() {
        this.tempTotVol = this.getMolarVolume();
        return 4.0 * (Math.pow(this.getB(), 5.0) + 17664.0 * Math.pow(this.tempTotVol, 4.0) * this.getB() - 4192.0 * Math.pow(this.tempTotVol, 3.0) * Math.pow(this.getB(), 2.0) + 528.0 * Math.pow(this.getB(), 3.0) * this.tempTotVol * this.tempTotVol - 36.0 * this.tempTotVol * Math.pow(this.getB(), 4.0) - 30720.0 * Math.pow(this.tempTotVol, 5.0)) * this.getB() / Math.pow(this.tempTotVol, 3.0) / Math.pow(-8.0 * this.tempTotVol + this.getB(), 3.0) / Math.pow(-4.0 * this.tempTotVol + this.getB(), 3.0);
    }

    public void calcXsitedV() {
        if (this.getTotalNumberOfAccociationSites() > 0) {
            this.initCPAMatrix(1);
        }
    }

    public boolean solveX() {
        double tempVari;
        if (this.totalNumberOfAccociationSites == 0) {
            return true;
        }
        boolean solvedX = this.solveX2(15);
        DMatrixRMaj mVectorMat = (DMatrixRMaj)this.mVector.getMatrix();
        DMatrixRMaj ksiMatrixMat = (DMatrixRMaj)this.ksiMatrix.getMatrix();
        int temp = 0;
        int iter = 0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.componentArray[i].getNumberOfAssociationSites()) {
                mVectorMat.unsafe_set(temp + j, 0, this.componentArray[i].getNumberOfMolesInPhase());
                ++j;
            }
            temp += this.componentArray[i].getNumberOfAssociationSites();
            ++i;
        }
        DMatrixRMaj mat1 = (DMatrixRMaj)this.KlkMatrix.getMatrix();
        double Klk = 0.0;
        double totvolume = this.getTotalVolume();
        int i2 = 0;
        while (i2 < this.getTotalNumberOfAccociationSites()) {
            tempVari = mVectorMat.unsafe_get(i2, 0);
            int j = i2;
            while (j < this.getTotalNumberOfAccociationSites()) {
                double tempVarj = mVectorMat.unsafe_get(j, 0);
                Klk = tempVari * tempVarj / totvolume * this.delta[i2][j];
                mat1.unsafe_set(i2, j, Klk);
                mat1.unsafe_set(j, i2, Klk);
                ++j;
            }
            ++i2;
        }
        boolean solved = true;
        do {
            double temp1;
            solved = true;
            ++iter;
            temp = 0;
            double ksi = 0.0;
            int i3 = 0;
            while (i3 < this.numberOfComponents) {
                temp1 = this.componentArray[i3].getNumberOfMolesInPhase();
                int j = 0;
                while (j < this.componentArray[i3].getNumberOfAssociationSites()) {
                    ksi = ((ComponentSrkCPA)this.componentArray[i3]).getXsite()[j];
                    ksiMatrixMat.unsafe_set(temp + j, 0, ksi);
                    tempVari = 1.0 / ksi - 1.0;
                    this.udotMatrix.set(temp + j, 0, tempVari);
                    this.udotTimesmMatrix.set(temp + j, 0, temp1 * tempVari);
                    ++j;
                }
                temp += this.componentArray[i3].getNumberOfAssociationSites();
                ++i3;
            }
            int i4 = 0;
            while (i4 < this.getTotalNumberOfAccociationSites()) {
                temp1 = mVectorMat.unsafe_get(i4, 0);
                double temp2 = this.ksiMatrix.get(i4, 0);
                int j = i4;
                while (j < this.getTotalNumberOfAccociationSites()) {
                    boolean krondelt = false;
                    if (i4 == j) {
                        krondelt = true;
                    }
                    tempVari = -temp1 / (temp2 * temp2) * (double)krondelt - mat1.unsafe_get(i4, j);
                    this.hessianMatrix.set(i4, j, tempVari);
                    this.hessianMatrix.set(j, i4, tempVari);
                    ++j;
                }
                ++i4;
            }
            try {
                this.hessianInvers = (SimpleMatrix)this.hessianMatrix.invert();
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                return false;
            }
            if (solvedX) {
                return true;
            }
            DMatrixRMaj mat2 = (DMatrixRMaj)this.ksiMatrix.getMatrix();
            CommonOps_DDRM.mult(mat1, mat2, this.corr2Matrix);
            CommonOps_DDRM.subtract(this.udotTimesmMatrix.getDDRM(), this.corr2Matrix, this.corr3Matrix);
            CommonOps_DDRM.mult(this.hessianInvers.getDDRM(), this.corr3Matrix, this.corr4Matrix);
            temp = 0;
            int i5 = 0;
            while (i5 < this.numberOfComponents) {
                int j = 0;
                while (j < this.componentArray[i5].getNumberOfAssociationSites()) {
                    double newX = this.ksiMatrix.get(temp + j, 0) - this.corr4Matrix.unsafe_get(temp + j, 0);
                    if (newX < 0.0) {
                        newX = 1.0E-10;
                        solved = false;
                    }
                    ((ComponentCPAInterface)this.componentArray[i5]).setXsite(j, newX);
                    ++j;
                }
                temp += this.componentArray[i5].getNumberOfAssociationSites();
                ++i5;
            }
        } while ((NormOps_DDRM.normF(this.corr4Matrix) > 1.0E-12 || !solved) && iter < 100);
        return true;
    }

    public boolean solveX2(int maxIter) {
        double err = 0.0;
        double totalVolume = this.getTotalVolume();
        int iter = 0;
        double old = 0.0;
        double neeval = 0.0;
        do {
            ++iter;
            err = 0.0;
            int i = 0;
            while (i < this.totalNumberOfAccociationSites) {
                old = ((ComponentSrkCPA)this.componentArray[this.moleculeNumber[i]]).getXsite()[this.assSiteNumber[i]];
                neeval = 0.0;
                int j = 0;
                while (j < this.totalNumberOfAccociationSites) {
                    neeval += this.componentArray[this.moleculeNumber[j]].getNumberOfMolesInPhase() * this.delta[i][j] * ((ComponentSrkCPA)this.componentArray[this.moleculeNumber[j]]).getXsite()[this.assSiteNumber[j]];
                    ++j;
                }
                neeval = 1.0 / (1.0 + 1.0 / totalVolume * neeval);
                ((ComponentSrkCPA)this.componentArray[this.moleculeNumber[i]]).setXsite(this.assSiteNumber[i], neeval);
                err += Math.abs((old - neeval) / neeval);
                ++i;
            }
        } while (Math.abs(err) > 1.0E-12 && iter < maxIter);
        return Math.abs(err) < 1.0E-12;
    }

    @Override
    public double getHcpatot() {
        return this.hcpatot;
    }

    public void setHcpatot(double hcpatot) {
        this.hcpatot = hcpatot;
    }

    @Override
    public double getGcpa() {
        return this.gcpa;
    }

    public double calcRootVolFinder(int phase) {
        double BonV;
        double solvedBonVHigh = 0.0;
        double solvedBonVlow = 1.0;
        double oldh = 1.0;
        double BonVold = BonV = 0.9999999999;
        double Btemp = 0.0;
        double h = 1.0;
        Btemp = this.getB();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int i = 0;
        while (i < 2000) {
            BonVold = BonV;
            BonV = 1.0 - ((double)i + 1.0E-6) * 1.0 / 2000.0;
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = this.pressure * this.getMolarVolume() / (8.3144621 * this.temperature);
            this.gcpa = this.calc_g();
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            while (!this.solveX()) {
            }
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - this.pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * this.temperature);
            if (Math.signum(h) * Math.signum(oldh) < 0.0 && i > 2) {
                if (solvedBonVlow < 0.001) {
                    solvedBonVlow = (BonV + BonVold) / 2.0;
                    if (phase == 1) {
                        break;
                    }
                } else {
                    solvedBonVHigh = (BonV + BonVold) / 2.0;
                    if (phase == 0) break;
                }
            }
            solvedBonVHigh = (BonV + BonVold) / 2.0;
            oldh = h;
            ++i;
        }
        if (solvedBonVlow < 0.001) {
            solvedBonVlow = solvedBonVHigh;
        }
        if (phase == 1) {
            return solvedBonVlow;
        }
        return solvedBonVHigh;
    }

    public double molarVolumeChangePhase(double pressure, double temperature, double A, double B, int phasetype) throws IsNaNException, TooManyIterationsException {
        double BonV;
        double d = BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 1.0E-8;
        }
        if (BonV >= 1.0) {
            BonV = 0.9999;
        }
        double BonVold = BonV;
        double Btemp = 0.0;
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.calcDelta();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        do {
            ++iterations;
            this.gcpa = this.calc_g();
            if (this.gcpa < 0.0) {
                this.setMolarVolume(1.0 / Btemp / this.numberOfMolesInPhase);
                this.gcpa = this.calc_g();
            }
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            this.solveX();
            this.initCPAMatrix(1);
            double BonV2 = BonV * BonV;
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / BonV2 * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / (BonV2 * BonV) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Btemp * Btemp / (BonV2 * BonV2) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += 0.5 * d1;
            } else if (d1 > d2) {
                BonV += d2;
                double hnew = h + d2 * dh;
                if (Math.abs(hnew) > Math.abs(h)) {
                    BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            } else {
                BonV += 0.5 * d1;
            }
            if (Math.abs((BonV - BonVold) / BonVold) > 0.1) {
                BonV = BonVold + 0.1 * (BonV - BonVold);
            }
            if (BonV > 1.1) {
                if (iterations < 3) {
                    BonV = (BonVold + BonV) / 2.0;
                } else {
                    double d3 = BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            }
            if (BonV < 0.0) {
                BonV = iterations < 3 ? Math.abs(BonVold + BonV) / 2.0 : (phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621));
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((BonV - BonVold) / BonV) > 1.0E-10 && iterations < 100);
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException();
        }
        return this.getMolarVolume();
    }

    @Override
    public double getGcpav() {
        return this.gcpav;
    }

    public void setGcpav(double gcpav) {
        this.gcpav = gcpav;
    }

    @Override
    public CPAMixingInterface getCpamix() {
        return this.cpamix;
    }

    @Override
    public double calcPressure() {
        this.gcpa = this.calc_g();
        this.setGcpav(this.calc_lngV());
        this.gcpavv = this.calc_lngVV();
        this.gcpavvv = this.calc_lngVVV();
        this.solveX();
        this.hcpatot = this.calc_hCPA();
        this.initCPAMatrix(1);
        return super.calcPressure();
    }

    @Override
    public int getCrossAssosiationScheme(int comp1, int comp2, int site1, int site2) {
        if (comp1 == comp2) {
            return this.selfAccociationScheme[comp1][site1][site2];
        }
        return this.crossAccociationScheme[comp1][comp2][site1][site2];
    }

    public double[][] croeneckerProduct(double[][] a, double[][] b) {
        int aLength = a.length;
        int aCols = a[0].length;
        int bLength = b.length;
        int bCols = b[0].length;
        double[][] result = new double[aLength * bLength][aCols * bCols];
        int z = 0;
        while (z < aLength) {
            int i = 0;
            while (i < aCols) {
                int j = 0;
                while (j < bLength) {
                    int k = 0;
                    while (k < bCols) {
                        result[j + z * bLength][k + i * bCols] = a[z][i] * b[j][k];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++z;
        }
        return result;
    }

    @Override
    public int getTotalNumberOfAccociationSites() {
        return this.totalNumberOfAccociationSites;
    }

    @Override
    public void setTotalNumberOfAccociationSites(int totalNumberOfAccociationSites) {
        this.totalNumberOfAccociationSites = totalNumberOfAccociationSites;
    }

    public void initOld2(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        if (type == 0) {
            this.setTotalNumberOfAccociationSites(0);
            this.selfAccociationScheme = new int[numberOfComponents][0][0];
            this.crossAccociationScheme = new int[numberOfComponents][numberOfComponents][0][0];
            int i = 0;
            while (i < numberOfComponents) {
                if (this.componentArray[i].getNumberOfmoles() < 1.0E-50) {
                    this.componentArray[i].setNumberOfAssociationSites(0);
                } else {
                    this.componentArray[i].setNumberOfAssociationSites(this.componentArray[i].getOrginalNumberOfAssociationSites());
                    this.setTotalNumberOfAccociationSites(this.getTotalNumberOfAccociationSites() + this.componentArray[i].getNumberOfAssociationSites());
                    this.selfAccociationScheme[i] = this.cpaSelect.setAssociationScheme(i, this);
                    int j = 0;
                    while (j < numberOfComponents) {
                        this.crossAccociationScheme[i][j] = this.cpaSelect.setCrossAssociationScheme(i, j, this);
                        ++j;
                    }
                }
                ++i;
            }
            this.mVector = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
            this.KlkMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
            this.KlkVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
            this.KlkVVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
            this.KlkVVVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
            this.hessianMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
            this.KlkTMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
            this.KlkTTMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
            this.KlkTVMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), this.getTotalNumberOfAccociationSites());
            this.corr2Matrix = new DMatrixRMaj(this.getTotalNumberOfAccociationSites(), 1);
            this.corr3Matrix = new DMatrixRMaj(this.getTotalNumberOfAccociationSites(), 1);
            this.corr4Matrix = new DMatrixRMaj(this.getTotalNumberOfAccociationSites(), 1);
            this.Klkni = new double[numberOfComponents][this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
            this.ksiMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
            this.uMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
            this.udotMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
            this.moleculeNumber = new int[this.getTotalNumberOfAccociationSites()];
            this.assSiteNumber = new int[this.getTotalNumberOfAccociationSites()];
            this.gvector = new double[this.getTotalNumberOfAccociationSites()][1];
            this.udotTimesmMatrix = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
            this.delta = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
            this.deltaNog = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
            this.deltadT = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
            this.deltadTdT = new double[this.getTotalNumberOfAccociationSites()][this.getTotalNumberOfAccociationSites()];
            this.QMatksiksiksi = new SimpleMatrix(this.getTotalNumberOfAccociationSites(), 1);
            this.udotTimesmiMatrix = new SimpleMatrix(this.getNumberOfComponents(), this.getTotalNumberOfAccociationSites());
            this.oldTotalNumberOfAccociationSites = this.getTotalNumberOfAccociationSites();
            int temp = 0;
            int i2 = 0;
            while (i2 < numberOfComponents) {
                int j = 0;
                while (j < this.componentArray[i2].getNumberOfAssociationSites()) {
                    this.moleculeNumber[temp + j] = i2;
                    this.assSiteNumber[temp + j] = j;
                    ++j;
                }
                temp += this.componentArray[i2].getNumberOfAssociationSites();
                ++i2;
            }
        }
        if (this.cpamix == null) {
            this.cpamix = this.cpaSelect.getMixingRule(1, this);
        }
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        if (type > 0 && this.isConstantPhaseVolume()) {
            this.calcDelta();
            this.solveX();
            super.init(totalNumberOfMoles, numberOfComponents, 1, phase, beta);
            this.gcpa = this.calc_g();
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
        }
        if (type > 0) {
            this.hcpatot = this.calc_hCPA();
        }
        if (type > 1) {
            this.initCPAMatrix(type);
        }
    }

    @Override
    public double molarVolume2(double pressure, double temperature, double A, double B, int phase) throws IsNaNException, TooManyIterationsException {
        this.Z = phase == 0 ? 1.0 : 1.0E-5;
        this.setMolarVolume(this.Z * 8.3144621 * temperature / pressure);
        int iterations = 0;
        double err = 0.0;
        double dErrdV = 0.0;
        double deltaV = 0.0;
        do {
            A = this.calcA(this, temperature, pressure, this.numberOfComponents);
            B = this.calcB(this, temperature, pressure, this.numberOfComponents);
            double dFdV = this.dFdV();
            double dFdVdV = this.dFdVdV();
            err = -8.3144621 * temperature * dFdV + 8.3144621 * temperature / this.getMolarVolume() - pressure;
            dErrdV = -8.3144621 * temperature * dFdVdV - 8.3144621 * temperature * this.numberOfMolesInPhase / Math.pow(this.getVolume(), 2.0);
            deltaV = -err / dErrdV;
            this.setMolarVolume(this.getMolarVolume() + deltaV / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
            if (!(this.Z < 0.0)) continue;
            this.Z = 1.0E-6;
            this.setMolarVolume(this.Z * 8.3144621 * temperature / pressure);
        } while (Math.abs(err) > 1.0E-8 || iterations < 100);
        return this.getMolarVolume();
    }

    public void initCPAMatrixOld(int type) {
        int j;
        if (this.getTotalNumberOfAccociationSites() == 0) {
            this.FCPA = 0.0;
            this.dFCPAdTdV = 0.0;
            this.dFCPAdTdT = 0.0;
            this.dFCPAdT = 0.0;
            this.dFCPAdV = 0.0;
            this.dFCPAdVdV = 0.0;
            this.dFCPAdVdVdV = 0.0;
            return;
        }
        int temp = 0;
        int i = 0;
        while (i < this.numberOfComponents) {
            j = 0;
            while (j < this.componentArray[i].getNumberOfAssociationSites()) {
                this.uMatrix.set(temp + j, 0, Math.log(this.ksiMatrix.get(temp + j, 0)) - this.ksiMatrix.get(temp + j, 0) + 1.0);
                this.gvector[temp + j][0] = this.mVector.get(temp + j, 0) * this.udotMatrix.get(temp + j, 0);
                ++j;
            }
            temp += this.componentArray[i].getNumberOfAssociationSites();
            ++i;
        }
        i = 0;
        while (i < this.getNumberOfComponents()) {
            j = 0;
            while (j < this.getTotalNumberOfAccociationSites()) {
                if (this.moleculeNumber[j] == i) {
                    this.udotTimesmiMatrix.set(i, j, this.udotMatrix.get(j, 0));
                } else {
                    this.udotTimesmiMatrix.set(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.getTotalNumberOfAccociationSites()) {
            j = i;
            while (j < this.getTotalNumberOfAccociationSites()) {
                this.delta[i][j] = this.deltaNog[i][j] * this.getGcpa();
                this.delta[j][i] = this.delta[i][j];
                if (type > 1) {
                    this.deltadT[i][j] = this.cpamix.calcDeltadT(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                    this.deltadT[j][i] = this.deltadT[i][j];
                    this.deltadTdT[i][j] = this.cpamix.calcDeltadTdT(this.assSiteNumber[i], this.assSiteNumber[j], this.moleculeNumber[i], this.moleculeNumber[j], this, this.getTemperature(), this.getPressure(), this.numberOfComponents);
                    this.deltadTdT[j][i] = this.deltadTdT[i][j];
                }
                ++j;
            }
            ++i;
        }
        double totalVolume = this.getTotalVolume();
        double totalVolume2 = totalVolume * totalVolume;
        double totalVolume3 = totalVolume2 * totalVolume;
        double gdv1 = this.getGcpav() - 1.0 / totalVolume;
        double gdv2 = gdv1 * gdv1;
        double gdv3 = gdv2 * gdv1;
        int i2 = 0;
        while (i2 < this.getTotalNumberOfAccociationSites()) {
            int j2 = i2;
            while (j2 < this.getTotalNumberOfAccociationSites()) {
                this.KlkVMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * gdv1);
                this.KlkVMatrix.set(j2, i2, this.KlkVMatrix.get(i2, j2));
                this.KlkVVMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * gdv2 + this.KlkMatrix.get(i2, j2) * (this.gcpavv + 1.0 / totalVolume / totalVolume));
                this.KlkVVMatrix.set(j2, i2, this.KlkVVMatrix.get(i2, j2));
                this.KlkVVVMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * gdv3 + 3.0 * this.KlkMatrix.get(i2, j2) * (this.getGcpav() - 1.0 / totalVolume) * (this.gcpavv + 1.0 / totalVolume2) + this.KlkMatrix.get(i2, j2) * (this.gcpavvv - 2.0 / totalVolume3));
                this.KlkVVVMatrix.set(j2, i2, this.KlkVVVMatrix.get(i2, j2));
                if (type > 1) {
                    double tempVar = this.deltadT[i2][j2] / this.delta[i2][j2];
                    double tempVardT = this.deltadTdT[i2][j2] / this.delta[i2][j2] - this.deltadT[i2][j2] * this.deltadT[i2][j2] / (this.delta[i2][j2] * this.delta[i2][j2]);
                    if (!Double.isNaN(tempVar)) {
                        this.KlkTMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * tempVar);
                        this.KlkTMatrix.set(j2, i2, this.KlkTMatrix.get(i2, j2));
                        this.KlkTVMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * tempVar * (this.gcpav - 1.0 / totalVolume));
                        this.KlkTVMatrix.set(j2, i2, this.KlkTVMatrix.get(i2, j2));
                        this.KlkTTMatrix.set(i2, j2, this.KlkMatrix.get(i2, j2) * (tempVar * tempVar + tempVardT));
                        this.KlkTTMatrix.set(j2, i2, this.KlkTTMatrix.get(i2, j2));
                    }
                    if (type > 2) {
                        int p = 0;
                        while (p < this.numberOfComponents) {
                            double t1 = 0.0;
                            double t2 = 0.0;
                            if (this.moleculeNumber[i2] == p) {
                                t1 = 1.0 / this.mVector.get(i2, 0);
                            }
                            if (this.moleculeNumber[j2] == p) {
                                t2 = 1.0 / this.mVector.get(j2, 0);
                            }
                            this.Klkni[p][i2][j2] = this.KlkMatrix.get(i2, j2) * (t1 + t2 + ((ComponentSrkCPA)this.getComponent(p)).calc_lngi(this));
                            this.Klkni[p][j2][i2] = this.Klkni[p][i2][j2];
                            ++p;
                        }
                    }
                }
                ++j2;
            }
            this.QMatksiksiksi.set(i2, 0, 2.0 * this.mVector.get(i2, 0) / (this.ksiMatrix.get(i2, 0) * this.ksiMatrix.get(i2, 0) * this.ksiMatrix.get(i2, 0)));
            ++i2;
        }
        SimpleMatrix ksiMatrixTranspose = (SimpleMatrix)this.ksiMatrix.transpose();
        SimpleMatrix KlkVMatrixksi = this.KlkVMatrix.mult(this.ksiMatrix);
        SimpleMatrix XV = this.hessianInvers.mult(KlkVMatrixksi);
        SimpleMatrix XVtranspose = (SimpleMatrix)XV.transpose();
        SimpleMatrix QCPA = ((SimpleMatrix)this.mVector.transpose()).mult(this.uMatrix.minus((SimpleMatrix)this.ksiMatrix.elementMult(this.udotMatrix).scale(0.5)));
        this.FCPA = QCPA.get(0, 0);
        SimpleMatrix tempMatrix = (SimpleMatrix)ksiMatrixTranspose.mult(KlkVMatrixksi).scale(-0.5);
        this.dFCPAdV = tempMatrix.get(0, 0);
        SimpleMatrix KlkVVMatrixTImesKsi = this.KlkVVMatrix.mult(this.ksiMatrix);
        SimpleMatrix tempMatrixVV = ((SimpleMatrix)ksiMatrixTranspose.mult(KlkVVMatrixTImesKsi).scale(-0.5)).minus(((SimpleMatrix)KlkVMatrixksi.transpose()).mult(XV));
        this.dFCPAdVdV = tempMatrixVV.get(0, 0);
        SimpleMatrix QVVV = (SimpleMatrix)ksiMatrixTranspose.mult(this.KlkVVVMatrix.mult(this.ksiMatrix)).scale(-0.5);
        SimpleMatrix QVVksi = (SimpleMatrix)KlkVVMatrixTImesKsi.scale(-1.0);
        SimpleMatrix QksiVksi = (SimpleMatrix)this.KlkVMatrix.scale(-1.0);
        SimpleMatrix mat1 = (SimpleMatrix)((SimpleMatrix)QVVksi.transpose()).mult(XV).scale(3.0);
        SimpleMatrix mat2 = (SimpleMatrix)XVtranspose.mult(QksiVksi.mult(XV)).scale(3.0);
        SimpleMatrix mat4 = XVtranspose.mult(this.QMatksiksiksi.mult(XVtranspose)).mult(XV);
        SimpleMatrix dFCPAdVdVdVMatrix = QVVV.plus(mat1).plus(mat2).plus(mat2).plus(mat4);
        this.dFCPAdVdVdV = dFCPAdVdVdVMatrix.get(0, 0);
        temp = 0;
        if (type == 1) {
            return;
        }
        int p = 0;
        while (p < this.numberOfComponents) {
            int kk = 0;
            while (kk < this.getComponent(p).getNumberOfAssociationSites()) {
                ((ComponentCPAInterface)this.getComponent(p)).setXsitedV(kk, XV.get(temp + kk, 0));
                ++kk;
            }
            temp += this.getComponent(p).getNumberOfAssociationSites();
            ++p;
        }
        SimpleMatrix KlkTMatrixTImesKsi = this.KlkTMatrix.mult(this.ksiMatrix);
        SimpleMatrix tempMatrix2 = (SimpleMatrix)ksiMatrixTranspose.mult(KlkTMatrixTImesKsi).scale(-0.5);
        this.dFCPAdT = tempMatrix2.get(0, 0);
        SimpleMatrix XT = this.hessianInvers.mult(KlkTMatrixTImesKsi);
        SimpleMatrix tempMatrixTT = ((SimpleMatrix)ksiMatrixTranspose.mult(this.KlkTTMatrix.mult(this.ksiMatrix)).scale(-0.5)).minus(((SimpleMatrix)KlkTMatrixTImesKsi.transpose()).mult(XT));
        this.dFCPAdTdT = tempMatrixTT.get(0, 0);
        SimpleMatrix tempMatrixTV = ((SimpleMatrix)ksiMatrixTranspose.mult(this.KlkTVMatrix.mult(this.ksiMatrix)).scale(-0.5)).minus(((SimpleMatrix)KlkTMatrixTImesKsi.transpose()).mult(XV));
        this.dFCPAdTdV = tempMatrixTV.get(0, 0);
        temp = 0;
        int p2 = 0;
        while (p2 < this.numberOfComponents) {
            int kk = 0;
            while (kk < this.getComponent(p2).getNumberOfAssociationSites()) {
                ((ComponentCPAInterface)this.getComponent(p2)).setXsitedT(kk, XT.get(temp + kk, 0));
                ++kk;
            }
            temp += this.getComponent(p2).getNumberOfAssociationSites();
            ++p2;
        }
        if (type == 2) {
            return;
        }
        p2 = 0;
        while (p2 < this.numberOfComponents) {
            SimpleMatrix KiMatrix = new SimpleMatrix(this.Klkni[p2]);
            SimpleMatrix tempMatrix4 = KiMatrix.mult(this.ksiMatrix);
            SimpleMatrix tempMatrix5 = ((SimpleMatrix)((SimpleMatrix)this.udotTimesmiMatrix.extractVector(true, p2)).transpose()).minus(tempMatrix4);
            SimpleMatrix tempMatrix6 = this.hessianInvers.mult(tempMatrix5);
            int temp2 = 0;
            int compp = 0;
            while (compp < this.numberOfComponents) {
                int kk = 0;
                while (kk < this.getComponent(compp).getNumberOfAssociationSites()) {
                    ((ComponentCPAInterface)this.getComponent(compp)).setXsitedni(kk, p2, -1.0 * tempMatrix6.get(temp2 + kk, 0));
                    ++kk;
                }
                temp2 += this.getComponent(compp).getNumberOfAssociationSites();
                ++compp;
            }
            ++p2;
        }
    }

    public boolean solveXOld() {
        if (this.getTotalNumberOfAccociationSites() == 0) {
            return true;
        }
        boolean solvedX = this.solveX2(5);
        DMatrixRMaj mat1 = (DMatrixRMaj)this.KlkMatrix.getMatrix();
        DMatrixRMaj mat2 = (DMatrixRMaj)this.ksiMatrix.getMatrix();
        int temp = 0;
        int iter = 0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.componentArray[i].getNumberOfAssociationSites()) {
                this.mVector.set(temp + j, 0, this.componentArray[i].getNumberOfMolesInPhase());
                ++j;
            }
            temp += this.componentArray[i].getNumberOfAssociationSites();
            ++i;
        }
        double Klk = 0.0;
        double totalVolume = this.getTotalVolume();
        int i2 = 0;
        while (i2 < this.getTotalNumberOfAccociationSites()) {
            int j = i2;
            while (j < this.getTotalNumberOfAccociationSites()) {
                Klk = this.mVector.get(i2, 0) * this.mVector.get(j, 0) / totalVolume * this.delta[i2][j];
                this.KlkMatrix.set(i2, j, Klk);
                this.KlkMatrix.set(j, i2, Klk);
                ++j;
            }
            ++i2;
        }
        boolean solved = true;
        do {
            int j;
            solved = true;
            ++iter;
            temp = 0;
            int i3 = 0;
            while (i3 < this.numberOfComponents) {
                j = 0;
                while (j < this.componentArray[i3].getNumberOfAssociationSites()) {
                    this.ksiMatrix.set(temp + j, 0, ((ComponentSrkCPA)this.componentArray[i3]).getXsite()[j]);
                    this.udotMatrix.set(temp + j, 0, 1.0 / this.ksiMatrix.get(temp + j, 0) - 1.0);
                    this.udotTimesmMatrix.set(temp + j, 0, this.mVector.get(temp + j, 0) * this.udotMatrix.get(temp + j, 0));
                    ++j;
                }
                temp += this.componentArray[i3].getNumberOfAssociationSites();
                ++i3;
            }
            i3 = 0;
            while (i3 < this.getTotalNumberOfAccociationSites()) {
                j = i3;
                while (j < this.getTotalNumberOfAccociationSites()) {
                    boolean krondelt = false;
                    if (i3 == j) {
                        krondelt = true;
                    }
                    this.hessianMatrix.set(i3, j, -this.mVector.get(i3, 0) / (this.ksiMatrix.get(i3, 0) * this.ksiMatrix.get(i3, 0)) * (double)krondelt - this.KlkMatrix.get(i3, j));
                    this.hessianMatrix.set(j, i3, this.hessianMatrix.get(i3, j));
                    ++j;
                }
                ++i3;
            }
            try {
                this.hessianInvers = (SimpleMatrix)this.hessianMatrix.invert();
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                return false;
            }
            CommonOps_DDRM.mult(mat1, mat2, this.corr2Matrix);
            CommonOps_DDRM.subtract(this.udotTimesmMatrix.getDDRM(), this.corr2Matrix, this.corr3Matrix);
            CommonOps_DDRM.mult(this.hessianInvers.getDDRM(), this.corr3Matrix, this.corr4Matrix);
            temp = 0;
            i3 = 0;
            while (i3 < this.numberOfComponents) {
                j = 0;
                while (j < this.componentArray[i3].getNumberOfAssociationSites()) {
                    double newX = this.ksiMatrix.get(temp + j, 0) - this.corr4Matrix.unsafe_get(temp + j, 0);
                    if (newX < 0.0) {
                        newX = 1.0E-10;
                        solved = false;
                    }
                    ((ComponentCPAInterface)this.componentArray[i3]).setXsite(j, newX);
                    ++j;
                }
                temp += this.componentArray[i3].getNumberOfAssociationSites();
                ++i3;
            }
        } while ((NormOps_DDRM.normF(this.corr4Matrix) > 1.0E-12 || !solved) && iter < 100);
        return true;
    }

    public boolean solveX2Old(int maxIter) {
        double err = 0.0;
        int iter = 0;
        double old = 0.0;
        double neeval = 0.0;
        double totalVolume = this.getTotalVolume();
        do {
            ++iter;
            err = 0.0;
            int i = 0;
            while (i < this.getTotalNumberOfAccociationSites()) {
                old = ((ComponentSrkCPA)this.getComponent(this.moleculeNumber[i])).getXsite()[this.assSiteNumber[i]];
                neeval = 0.0;
                int j = 0;
                while (j < this.getTotalNumberOfAccociationSites()) {
                    neeval += this.getComponent(this.moleculeNumber[j]).getNumberOfMolesInPhase() * this.delta[i][j] * ((ComponentSrkCPA)this.getComponent(this.moleculeNumber[j])).getXsite()[this.assSiteNumber[j]];
                    ++j;
                }
                neeval = 1.0 / (1.0 + 1.0 / totalVolume * neeval);
                ((ComponentCPAInterface)this.getComponent(this.moleculeNumber[i])).setXsite(this.assSiteNumber[i], neeval);
                err += Math.abs((old - neeval) / neeval);
                ++i;
            }
        } while (Math.abs(err) > 1.0E-10 && iter < maxIter);
        return false;
    }

    public double molarVolumeOld(double pressure, double temperature, double A, double B, int phasetype) throws IsNaNException, TooManyIterationsException {
        double BonVold;
        double BonV;
        double d = BonV = phasetype == 0 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 1.0E-8;
        }
        if (BonV >= 1.0) {
            BonV = 0.9999;
        }
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        double Btemp = this.getB();
        if (Btemp < 0.0) {
            logger.info("b negative in volume calc");
        }
        this.calcDelta();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        do {
            ++iterations;
            this.gcpa = this.calc_g();
            if (this.gcpa < 0.0) {
                this.setMolarVolume(1.0 / Btemp / this.numberOfMolesInPhase);
                this.gcpa = this.calc_g();
            }
            this.setGcpav(this.calc_lngV());
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
            if (this.getTotalNumberOfAccociationSites() > 0) {
                this.solveX();
            }
            this.initCPAMatrix(1);
            double BonV2 = BonV * BonV;
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / BonV2 * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / (BonV2 * BonV) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Btemp * Btemp / (BonV2 * BonV2) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += 0.5 * d1;
            } else if (d1 > d2) {
                BonV += d2;
                double hnew = h + d2 * dh;
                if (Math.abs(hnew) > Math.abs(h)) {
                    BonV = phasetype == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            } else {
                BonV += 0.5 * d1;
            }
            if (Math.abs((BonV - BonVold) / BonVold) > 0.1) {
                BonV = BonVold + 0.1 * (BonV - BonVold);
            }
            if (BonV > 0.9999) {
                if (iterations < 3) {
                    BonV = (BonVold + BonV) / 2.0;
                }
            } else if (BonV < 0.0 && iterations < 3) {
                BonV = Math.abs(BonVold + BonV) / 2.0;
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while ((Math.abs((BonV - BonVold) / BonV) > 1.0E-10 || Math.abs(h) > 1.0E-12) && iterations < 100);
        Math.abs(h);
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException();
        }
        return this.getMolarVolume();
    }
}

