/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentCPAInterface;
import neqsim.thermo.component.ComponentSrkCPA;
import neqsim.thermo.mixingRule.CPAMixing;
import neqsim.thermo.mixingRule.CPAMixingInterface;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhasePrEos;

public class PhasePrCPA
extends PhasePrEos
implements PhaseCPAInterface {
    private static final long serialVersionUID = 1000L;
    int totalNumberOfAccociationSites = 0;
    public CPAMixing cpaSelect = new CPAMixing();
    public CPAMixingInterface cpamix = this.cpaSelect.getMixingRule(1);
    double hcpatot = 1.0;
    double hcpatotdT = 0.0;
    double hcpatotdTdT = 0.0;
    double gcpav = 1.0;
    double lngcpa = 0.0;
    double lngcpav = 1.0;
    double gcpavv = 1.0;
    double gcpavvv = 1.0;
    double gcpa = 1.0;
    int cpaon = 1;
    int[][][] selfAccociationScheme = null;
    int[][][][] crossAccociationScheme = null;

    @Override
    public PhasePrCPA clone() {
        PhasePrCPA clonedPhase = null;
        try {
            clonedPhase = (PhasePrCPA)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedPhase;
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        boolean Xsolved = true;
        int totiter = 0;
        do {
            super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
            ++totiter;
            if (this.cpaon != 1) continue;
            Xsolved = this.solveX();
            this.hcpatot = this.calc_hCPA();
            this.gcpa = this.calc_g();
            this.lngcpa = Math.log(this.gcpa);
            this.gcpav = this.calc_lngV();
            this.gcpavv = this.calc_lngVV();
            this.gcpavvv = this.calc_lngVVV();
        } while (!Xsolved && totiter < 5);
        if (type > 1) {
            this.hcpatotdT = this.calc_hCPAdT();
            this.hcpatotdTdT = this.calc_hCPAdTdT();
        }
        if (type == 0) {
            this.selfAccociationScheme = new int[numberOfComponents][0][0];
            this.crossAccociationScheme = new int[numberOfComponents][numberOfComponents][0][0];
            int i = 0;
            while (i < numberOfComponents) {
                this.selfAccociationScheme[i] = this.cpaSelect.setAssociationScheme(i, this);
                int j = 0;
                while (j < numberOfComponents) {
                    this.crossAccociationScheme[i][j] = this.cpaSelect.setCrossAssociationScheme(i, j, this);
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(componentName, moles, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentSrkCPA(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public double getF() {
        return super.getF() + (double)this.cpaon * this.FCPA();
    }

    @Override
    public double dFdT() {
        return super.dFdT() + (double)this.cpaon * this.dFCPAdT();
    }

    @Override
    public double dFdTdV() {
        return super.dFdTdV();
    }

    @Override
    public double dFdV() {
        double dv2 = this.dFCPAdV();
        return super.dFdV() + (double)this.cpaon * dv2;
    }

    @Override
    public double dFdVdV() {
        return super.dFdVdV() + (double)this.cpaon * this.dFCPAdVdV();
    }

    @Override
    public double dFdVdVdV() {
        return super.dFdVdVdV() + (double)this.cpaon * this.dFCPAdVdVdV();
    }

    @Override
    public double dFdTdT() {
        return super.dFdTdT() + (double)this.cpaon * this.dFCPAdTdT();
    }

    public double FCPA() {
        double tot = 0.0;
        double ans = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            tot = 0.0;
            int j = 0;
            while (j < this.getComponent(i).getNumberOfAssociationSites()) {
                double xai = ((ComponentSrkCPA)this.getComponent(i)).getXsite()[j];
                tot += Math.log(xai) - 0.5 * xai + 0.5;
                ++j;
            }
            ans += this.getComponent(i).getNumberOfMolesInPhase() * tot;
            ++i;
        }
        return ans;
    }

    public double dFCPAdV() {
        return 1.0 / (2.0 * this.getTotalVolume()) * (1.0 - this.getTotalVolume() * this.gcpav) * this.hcpatot;
    }

    public double dFCPAdVdV() {
        return -1.0 / this.getTotalVolume() * this.dFCPAdV() + this.hcpatot / (2.0 * this.getTotalVolume()) * (-this.gcpav - this.getTotalVolume() * this.gcpavv);
    }

    public double dFCPAdVdVdV() {
        return -1.0 / this.getTotalVolume() * this.dFCPAdVdV() + 1.0 / Math.pow(this.getTotalVolume(), 2.0) * this.dFCPAdV() - this.hcpatot / (2.0 * Math.pow(this.getTotalVolume(), 2.0)) * (-this.gcpav - this.getTotalVolume() * this.gcpavv) + this.hcpatot / (2.0 * this.getTotalVolume()) * (-2.0 * this.gcpavv - this.getTotalVolume() * this.gcpavvv);
    }

    public double dFCPAdT() {
        return -0.5 * this.hcpatotdT;
    }

    public double dFCPAdTdT() {
        return -0.5 * this.hcpatotdTdT;
    }

    public double calc_hCPA() {
        double htot = 0.0;
        double tot = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            htot = 0.0;
            int j = 0;
            while (j < this.getComponent(i).getNumberOfAssociationSites()) {
                htot += 1.0 - ((ComponentSrkCPA)this.getComponent(i)).getXsite()[j];
                ++j;
            }
            tot += this.getComponent(i).getNumberOfMolesInPhase() * htot;
            ++i;
        }
        return tot;
    }

    public double calc_hCPAdT() {
        double htot = 0.0;
        double tot = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int k = 0;
            while (k < this.numberOfComponents) {
                htot = 0.0;
                int j = 0;
                while (j < this.getComponent(i).getNumberOfAssociationSites()) {
                    int l = 0;
                    while (l < this.getComponent(k).getNumberOfAssociationSites()) {
                        htot += ((ComponentSrkCPA)this.getComponent(i)).getXsite()[j] * ((ComponentSrkCPA)this.getComponent(k)).getXsite()[l] * this.cpamix.calcDeltadT(j, l, i, k, this, this.temperature, this.pressure, this.numberOfComponents);
                        ++l;
                    }
                    ++j;
                }
                tot += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(k).getNumberOfMolesInPhase() * htot;
                ++k;
            }
            ++i;
        }
        return tot / this.getTotalVolume();
    }

    public double calc_hCPAdTdT() {
        double htot = 0.0;
        double tot = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int k = 0;
            while (k < this.numberOfComponents) {
                htot = 0.0;
                int j = 0;
                while (j < this.getComponent(i).getNumberOfAssociationSites()) {
                    int l = 0;
                    while (l < this.getComponent(k).getNumberOfAssociationSites()) {
                        htot += ((ComponentSrkCPA)this.getComponent(i)).getXsite()[j] * ((ComponentSrkCPA)this.getComponent(k)).getXsite()[l] * this.cpamix.calcDeltadTdT(j, l, i, k, this, this.temperature, this.pressure, this.numberOfComponents);
                        ++l;
                    }
                    ++j;
                }
                tot += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(k).getNumberOfMolesInPhase() * htot;
                ++k;
            }
            ++i;
        }
        return tot / this.getTotalVolume();
    }

    public double calc_g() {
        double g = (2.0 - this.getb() / 4.0 / this.getMolarVolume()) / (2.0 * Math.pow(1.0 - this.getb() / 4.0 / this.getMolarVolume(), 3.0));
        return g;
    }

    public double calc_lngni(int comp) {
        return 0.0;
    }

    public double calc_lngV() {
        double gv = 0.0;
        double gv2 = 0.0;
        gv = -2.0 * this.getB() * (10.0 * this.getTotalVolume() - this.getB()) / this.getTotalVolume() / ((8.0 * this.getTotalVolume() - this.getB()) * (4.0 * this.getTotalVolume() - this.getB()));
        return gv;
    }

    public double calc_lngVV() {
        double gvv = 0.0;
        gvv = 2.0 * (640.0 * Math.pow(this.getTotalVolume(), 3.0) - 216.0 * this.getB() * this.getTotalVolume() * this.getTotalVolume() + 24.0 * Math.pow(this.getB(), 2.0) * this.getTotalVolume() - Math.pow(this.getB(), 3.0)) * this.getB() / (this.getTotalVolume() * this.getTotalVolume()) / Math.pow(8.0 * this.getTotalVolume() - this.getB(), 2.0) / Math.pow(4.0 * this.getTotalVolume() - this.getB(), 2.0);
        return gvv;
    }

    public double calc_lngVVV() {
        double gvvv = 0.0;
        gvvv = 4.0 * (Math.pow(this.getB(), 5.0) + 17664.0 * Math.pow(this.getTotalVolume(), 4.0) * this.getB() - 4192.0 * Math.pow(this.getTotalVolume(), 3.0) * Math.pow(this.getB(), 2.0) + 528.0 * Math.pow(this.getB(), 3.0) * this.getTotalVolume() * this.getTotalVolume() - 36.0 * this.getTotalVolume() * Math.pow(this.getB(), 4.0) - 30720.0 * Math.pow(this.getTotalVolume(), 5.0)) * this.getB() / Math.pow(this.getTotalVolume(), 3.0) / Math.pow(-8.0 * this.getTotalVolume() + this.getB(), 3.0) / Math.pow(-4.0 * this.getTotalVolume() + this.getB(), 3.0);
        return gvvv;
    }

    public boolean solveX() {
        double err = 0.0;
        int iter = 0;
        try {
            this.molarVolume(this.pressure, this.temperature, this.getA(), this.getB(), this.phaseType);
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
        }
        do {
            ++iter;
            err = 0.0;
            int i = 0;
            while (i < this.numberOfComponents) {
                int j = 0;
                while (j < this.getComponent(i).getNumberOfAssociationSites()) {
                    double old = ((ComponentSrkCPA)this.getComponent(i)).getXsite()[j];
                    double neeval = this.cpamix.calcXi(this.selfAccociationScheme, this.crossAccociationScheme, j, i, this, this.temperature, this.pressure, this.numberOfComponents);
                    ((ComponentCPAInterface)this.getComponent(i)).setXsite(j, neeval);
                    err += Math.abs((old - neeval) / neeval);
                    ++j;
                }
                ++i;
            }
        } while (Math.abs(err) > 1.0E-10 && iter < 100);
        return iter < 3;
    }

    @Override
    public double getHcpatot() {
        return this.hcpatot;
    }

    public void setHcpatot(double hcpatot) {
        this.hcpatot = hcpatot;
    }

    @Override
    public double getGcpa() {
        return this.gcpa;
    }

    @Override
    public double getGcpav() {
        return this.gcpav;
    }

    @Override
    public CPAMixingInterface getCpamix() {
        return this.cpamix;
    }

    @Override
    public int getCrossAssosiationScheme(int comp1, int comp2, int site1, int site2) {
        if (comp1 == comp2) {
            return this.selfAccociationScheme[comp1][site1][site2];
        }
        return this.crossAccociationScheme[comp1][comp2][site1][site2];
    }

    @Override
    public int getTotalNumberOfAccociationSites() {
        return this.totalNumberOfAccociationSites;
    }

    @Override
    public void setTotalNumberOfAccociationSites(int totalNumberOfAccociationSites) {
        this.totalNumberOfAccociationSites = totalNumberOfAccociationSites;
    }
}

