/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentGERG2004;
import neqsim.thermo.phase.PhaseEos;
import neqsim.thermo.util.JNI.GERG2004EOS;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public class PhaseGERG2004Eos
extends PhaseEos {
    private static final long serialVersionUID = 1000L;
    private GERG2004EOS gergEOS = new GERG2004EOS();
    double[] xFracGERG = new double[18];
    int IPHASE = 0;
    boolean okVolume = true;
    double enthalpy = 0.0;
    double entropy = 0.0;
    double gibbsEnergy = 0.0;
    double CpGERG = 0.0;
    double CvGERG = 0.0;
    double internalEnery = 0.0;
    double JTcoef = 0.0;

    public PhaseGERG2004Eos() {
        this.thermoPropertyModelName = "GERG-EoS 2008";
    }

    @Override
    public PhaseGERG2004Eos clone() {
        PhaseGERG2004Eos clonedPhase = null;
        try {
            clonedPhase = (PhaseGERG2004Eos)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedPhase;
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentGERG2004(componentName, moles, molesInPhase, compNumber);
    }

    public void setxFracGERG() {
        int j = 0;
        while (j < this.gergEOS.getNameList().length) {
            this.xFracGERG[j] = this.hasComponent(this.gergEOS.getNameList()[j]) ? this.getComponent(this.gergEOS.getNameList()[j]).getx() : 0.0;
            ++j;
        }
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        this.IPHASE = phase == 0 ? -1 : -2;
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        this.setxFracGERG();
        if (!this.okVolume) {
            this.IPHASE = phase == 0 ? -2 : -1;
            super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        }
        if (type >= 1) {
            double[] temp = new double[18];
            temp = GERG2004EOS.SPHIOTPX(this.temperature, this.pressure / 10.0, this.xFracGERG[0], this.xFracGERG[1], this.xFracGERG[2], this.xFracGERG[3], this.xFracGERG[4], this.xFracGERG[5], this.xFracGERG[6], this.xFracGERG[7], this.xFracGERG[8], this.xFracGERG[9], this.xFracGERG[10], this.xFracGERG[11], this.xFracGERG[12], this.xFracGERG[13], this.xFracGERG[14], this.xFracGERG[15], this.xFracGERG[16], this.xFracGERG[17], this.IPHASE);
            int j = 0;
            while (j < this.gergEOS.getNameList().length) {
                if (this.hasComponent(this.gergEOS.getNameList()[j])) {
                    if (temp[j] == -1111.0) {
                        this.IPHASE = -2;
                    }
                    if (temp[j] == -2222.0) {
                        this.IPHASE = -1;
                    }
                }
                ++j;
            }
            temp = GERG2004EOS.SPHIOTPX(this.temperature, this.pressure / 10.0, this.xFracGERG[0], this.xFracGERG[1], this.xFracGERG[2], this.xFracGERG[3], this.xFracGERG[4], this.xFracGERG[5], this.xFracGERG[6], this.xFracGERG[7], this.xFracGERG[8], this.xFracGERG[9], this.xFracGERG[10], this.xFracGERG[11], this.xFracGERG[12], this.xFracGERG[13], this.xFracGERG[14], this.xFracGERG[15], this.xFracGERG[16], this.xFracGERG[17], this.IPHASE);
            j = 0;
            while (j < this.gergEOS.getNameList().length) {
                if (this.hasComponent(this.gergEOS.getNameList()[j])) {
                    this.getComponent(this.gergEOS.getNameList()[j]).setFugacityCoefficient(temp[j]);
                }
                ++j;
            }
            double[] alloTPX = new double[17];
            alloTPX = GERG2004EOS.SALLOTPX(this.temperature, this.pressure / 10.0, this.xFracGERG[0], this.xFracGERG[1], this.xFracGERG[2], this.xFracGERG[3], this.xFracGERG[4], this.xFracGERG[5], this.xFracGERG[6], this.xFracGERG[7], this.xFracGERG[8], this.xFracGERG[9], this.xFracGERG[10], this.xFracGERG[11], this.xFracGERG[12], this.xFracGERG[13], this.xFracGERG[14], this.xFracGERG[15], this.xFracGERG[16], this.xFracGERG[17], this.IPHASE);
            this.gibbsEnergy = alloTPX[10];
            this.internalEnery = alloTPX[9];
            this.enthalpy = alloTPX[2];
            this.entropy = alloTPX[3];
            this.CpGERG = alloTPX[4];
            this.CvGERG = alloTPX[5];
            super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        }
    }

    @Override
    public double getGibbsEnergy() {
        return this.gibbsEnergy;
    }

    @Override
    public double getJouleThomsonCoefficient() {
        return this.JTcoef;
    }

    @Override
    public double getEnthalpy() {
        return this.enthalpy;
    }

    @Override
    public double getEntropy() {
        return this.entropy;
    }

    @Override
    public double getInternalEnergy() {
        return this.internalEnery;
    }

    @Override
    public double getCp() {
        return this.CpGERG;
    }

    @Override
    public double getCv() {
        return this.CvGERG;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phase) throws IsNaNException, TooManyIterationsException {
        double temp = GERG2004EOS.ZOTPX(temperature, pressure / 10.0, this.xFracGERG[0], this.xFracGERG[1], this.xFracGERG[2], this.xFracGERG[3], this.xFracGERG[4], this.xFracGERG[5], this.xFracGERG[6], this.xFracGERG[7], this.xFracGERG[8], this.xFracGERG[9], this.xFracGERG[10], this.xFracGERG[11], this.xFracGERG[12], this.xFracGERG[13], this.xFracGERG[14], this.xFracGERG[15], this.xFracGERG[16], this.xFracGERG[17], this.IPHASE) * 8.314 * temperature / pressure;
        temp = GERG2004EOS.ZOTPX(temperature, pressure / 10.0, this.xFracGERG[0], this.xFracGERG[1], this.xFracGERG[2], this.xFracGERG[3], this.xFracGERG[4], this.xFracGERG[5], this.xFracGERG[6], this.xFracGERG[7], this.xFracGERG[8], this.xFracGERG[9], this.xFracGERG[10], this.xFracGERG[11], this.xFracGERG[12], this.xFracGERG[13], this.xFracGERG[14], this.xFracGERG[15], this.xFracGERG[16], this.xFracGERG[17], this.IPHASE) * 8.314 * temperature / pressure;
        this.okVolume = !(Math.abs(2222.0 + temp) < 0.1) && !(Math.abs(1111.0 + temp) < 0.1);
        return temp;
    }
}

