/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentGeDuanSun;
import neqsim.thermo.phase.PhaseGE;
import neqsim.thermo.phase.PhaseInterface;

public class PhaseDuanSun
extends PhaseGE {
    private static final long serialVersionUID = 1000L;
    double[][] alpha;
    String[][] mixRule;
    double[][] intparam;
    double[][] Dij;
    double GE = 0.0;

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentGeDuanSun(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.alpha = this.mixSelect.getNRTLalpha();
        this.Dij = this.mixSelect.getNRTLDij();
    }

    @Override
    public void setAlpha(double[][] alpha) {
        int i = 0;
        while (i < alpha.length) {
            System.arraycopy(alpha[i], 0, this.alpha[i], 0, alpha[0].length);
            ++i;
        }
    }

    @Override
    public void setDij(double[][] Dij) {
        int i = 0;
        while (i < Dij.length) {
            System.arraycopy(Dij[i], 0, this.Dij[i], 0, Dij[0].length);
            ++i;
        }
    }

    @Override
    public double getExessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.GE = 0.0;
        double salinity = 0.0;
        int i = 0;
        while (i < numberOfComponents) {
            if (phase.getComponents()[i].isIsIon()) {
                salinity += phase.getComponents()[i].getNumberOfMolesInPhase() / (phase.getComponent("water").getNumberOfMolesInPhase() * phase.getComponent("water").getMolarMass());
            }
            ++i;
        }
        i = 0;
        while (i < numberOfComponents) {
            this.GE += phase.getComponents()[i].getx() * Math.log(((ComponentGeDuanSun)this.componentArray[i]).getGammaPitzer(phase, numberOfComponents, temperature, pressure, phasetype, salinity));
            ++i;
        }
        return 8.3144621 * temperature * this.numberOfMolesInPhase * this.GE;
    }

    @Override
    public double getGibbsEnergy() {
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * (this.GE + Math.log(this.pressure));
    }

    @Override
    public double getExessGibbsEnergy() {
        return this.GE;
    }
}

