/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentDesmukhMather;
import neqsim.thermo.component.ComponentGEInterface;
import neqsim.thermo.phase.PhaseGE;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseDesmukhMather
extends PhaseGE {
    private static final long serialVersionUID = 1000L;
    double GE = 0.0;
    double[][] aij;
    double[][] bij;
    static Logger logger = LogManager.getLogger(PhaseDesmukhMather.class);

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentDesmukhMather(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, initType, phase, beta);
        if (initType != 0) {
            this.phaseTypeName = phase == 0 ? "liquid" : "gas";
        }
        this.setMolarVolume(9.8E-4 * this.getMolarMass() * 100000.0);
        this.Z = this.pressure * this.getMolarVolume() / (8.3144621 * this.temperature);
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.aij = new double[this.numberOfComponents][this.numberOfComponents];
        this.bij = new double[this.numberOfComponents][this.numberOfComponents];
        NeqSimDataBase database = new NeqSimDataBase();
        int k = 0;
        while (k < this.getNumberOfComponents()) {
            String component_name = this.getComponents()[k].getComponentName();
            int l = k;
            while (l < this.getNumberOfComponents()) {
                try {
                    if (k == l) {
                        if (this.getComponents()[l].getComponentName().equals("MDEA") && this.getComponents()[k].getComponentName().equals("MDEA")) {
                            this.aij[k][l] = -0.0828487;
                            this.aij[l][k] = this.aij[k][l];
                        }
                    } else {
                        int templ = l;
                        int tempk = k;
                        ResultSet dataSet = database.getResultSet("SELECT * FROM inter WHERE (comp1='" + component_name + "' AND comp2='" + this.getComponents()[l].getComponentName() + "') OR (comp1='" + this.getComponents()[l].getComponentName() + "' AND comp2='" + component_name + "')");
                        dataSet.next();
                        if (dataSet.getString("comp1").trim().equals(this.getComponents()[l].getComponentName())) {
                            templ = k;
                            tempk = l;
                        }
                        this.aij[k][l] = Double.parseDouble(dataSet.getString("aijDesMath"));
                        this.bij[k][l] = Double.parseDouble(dataSet.getString("bijDesMath"));
                        this.aij[l][k] = this.aij[k][l];
                        this.bij[l][k] = this.bij[k][l];
                        dataSet.close();
                    }
                }
                catch (Exception e) {
                    String err = e.toString();
                    logger.info("comp names " + component_name);
                    logger.error(err);
                }
                ++l;
            }
            ++k;
        }
    }

    public void setAij(double[][] alpha) {
        int i = 0;
        while (i < alpha.length) {
            System.arraycopy(this.aij[i], 0, this.aij[i], 0, alpha[0].length);
            ++i;
        }
    }

    public void setBij(double[][] Dij) {
        int i = 0;
        while (i < Dij.length) {
            System.arraycopy(this.bij[i], 0, this.bij[i], 0, Dij[0].length);
            ++i;
        }
    }

    public double getBetaDesMatij(int i, int j) {
        return this.aij[i][j] + this.bij[i][j] * this.temperature;
    }

    public double getAij(int i, int j) {
        return this.aij[i][j];
    }

    public double getBij(int i, int j) {
        return this.bij[i][j];
    }

    @Override
    public double getExessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.GE = 0.0;
        int i = 0;
        while (i < numberOfComponents) {
            this.GE += phase.getComponents()[i].getx() * Math.log(((ComponentDesmukhMather)this.componentArray[i]).getGamma(phase, numberOfComponents, temperature, pressure, phasetype));
            ++i;
        }
        return 8.3144621 * temperature * this.numberOfMolesInPhase * this.GE;
    }

    @Override
    public double getGibbsEnergy() {
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * (this.GE + Math.log(this.pressure));
    }

    @Override
    public double getExessGibbsEnergy() {
        return this.GE;
    }

    @Override
    public double getActivityCoefficient(int k, int p) {
        return ((ComponentGEInterface)this.getComponent(k)).getGamma();
    }

    @Override
    public double getActivityCoefficient(int k) {
        return ((ComponentGEInterface)this.getComponent(k)).getGamma();
    }

    public double getIonicStrength() {
        double ionStrength = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            ionStrength += this.getComponent(i).getMolality(this) * Math.pow(this.getComponent(i).getIonicCharge(), 2.0);
            ++i;
        }
        return 0.5 * ionStrength;
    }

    public double getSolventWeight() {
        double moles = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            if (this.getComponent(i).getReferenceStateType().equals("solvent")) {
                moles += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getMolarMass();
            }
            ++i;
        }
        return moles;
    }

    public double getSolventDensity() {
        double moles = 0.0;
        return 1020.0;
    }

    public double getSolventMolarMass() {
        double molesMass = 0.0;
        double moles = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            if (this.getComponent(i).getReferenceStateType().equals("solvent")) {
                molesMass += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getMolarMass();
                moles = this.getComponent(i).getNumberOfMolesInPhase();
            }
            ++i;
        }
        return molesMass / moles;
    }
}

