/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.Phase;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public class PhaseDefault
extends Phase {
    private static final long serialVersionUID = 1000L;
    protected ComponentInterface defComponent = null;

    public PhaseDefault() {
    }

    public PhaseDefault(ComponentInterface comp) {
        this.defComponent = comp;
    }

    public void setComponentType(ComponentInterface comp) {
        this.defComponent = comp;
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(moles);
        try {
            this.componentArray[compNumber] = (ComponentInterface)this.defComponent.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error("err " + e.toString());
        }
        this.componentArray[compNumber].createComponent(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phase) throws IsNaNException, TooManyIterationsException {
        return 1.0;
    }

    @Override
    public void resetMixingRule(int type) {
    }

    @Override
    public double getMolarVolume() {
        return 1.0;
    }

    @Override
    public double getGibbsEnergy() {
        double val = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            val += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getLogFugacityCoefficient();
            ++i;
        }
        return 8.3144621 * this.temperature * (val + Math.log(this.pressure) * this.numberOfMolesInPhase);
    }
}

