/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentCPAInterface;
import neqsim.thermo.component.ComponentPCSAFT;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentPCSAFTa
extends ComponentPCSAFT
implements ComponentCPAInterface {
    private static final long serialVersionUID = 1000L;
    int cpaon = 1;
    private double[][] xsitedni = new double[0][0];
    double[] xsite = new double[0];
    double[] xsiteOld = new double[0];
    double[] xsitedV = new double[0];
    double[] xsitedT = new double[0];

    public ComponentPCSAFTa() {
    }

    public ComponentPCSAFTa(double moles) {
        super(moles);
    }

    public ComponentPCSAFTa(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.xsite = new double[this.numberOfAssociationSites];
        this.xsitedV = new double[this.numberOfAssociationSites];
        this.xsiteOld = new double[this.numberOfAssociationSites];
        this.xsitedT = new double[this.numberOfAssociationSites];
        if (this.numberOfAssociationSites != 0 && this.cpaon == 1) {
            int j = 0;
            while (j < this.getNumberOfAssociationSites()) {
                this.setXsite(j, 1.0);
                this.setXsiteOld(j, 1.0);
                this.setXsitedV(j, 0.0);
                this.setXsitedT(j, 0.0);
                ++j;
            }
        }
    }

    public ComponentPCSAFTa(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
        this.xsite = new double[this.numberOfAssociationSites];
        this.xsitedV = new double[this.numberOfAssociationSites];
        this.xsiteOld = new double[this.numberOfAssociationSites];
        this.xsitedT = new double[this.numberOfAssociationSites];
        if (this.numberOfAssociationSites != 0 && this.cpaon == 1) {
            int j = 0;
            while (j < this.getNumberOfAssociationSites()) {
                this.setXsite(j, 1.0);
                this.setXsiteOld(j, 1.0);
                this.setXsitedV(j, 0.0);
                this.setXsitedT(j, 0.0);
                ++j;
            }
        }
    }

    @Override
    public ComponentPCSAFTa clone() {
        ComponentPCSAFTa clonedComponent = null;
        try {
            clonedComponent = (ComponentPCSAFTa)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        clonedComponent.xsite = (double[])this.xsite.clone();
        System.arraycopy(this.xsite, 0, clonedComponent.xsite, 0, this.xsite.length);
        clonedComponent.xsiteOld = (double[])this.xsiteOld.clone();
        System.arraycopy(this.xsiteOld, 0, clonedComponent.xsiteOld, 0, this.xsiteOld.length);
        clonedComponent.xsitedV = (double[])this.xsitedV.clone();
        System.arraycopy(this.xsitedV, 0, clonedComponent.xsitedV, 0, this.xsitedV.length);
        clonedComponent.xsitedT = (double[])this.xsitedT.clone();
        System.arraycopy(this.xsitedT, 0, clonedComponent.xsitedT, 0, this.xsitedT.length);
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double Fsup = super.dFdN(phase, numberOfComponents, temperature, pressure);
        double Fcpa = 0.0;
        Fcpa = this.dFCPAdN(phase, numberOfComponents, temperature, pressure);
        return Fsup + (double)this.cpaon * Fcpa;
    }

    @Override
    public double dFdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdT(phase, numberOfComponents, temperature, pressure);
    }

    @Override
    public double dFdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdV(phase, numberOfComponents, temperature, pressure);
    }

    @Override
    public double dFdNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdN(j, phase, numberOfComponents, temperature, pressure);
    }

    public double dFCPAdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double xi = 0.0;
        int i = 0;
        while (i < this.numberOfAssociationSites) {
            xi += Math.log(this.xsite[i]);
            ++i;
        }
        return xi - ((PhaseCPAInterface)phase).getHcpatot() / 2.0 * this.dlogghsSAFTdi;
    }

    public double dFCPAdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double xi = this.dFCPAdNdXidXdV(phase);
        double xi2 = -((PhaseCPAInterface)phase).getHcpatot() / 2.0 * this.calc_lngidV(phase);
        return xi + xi2;
    }

    public double calc_lngidV(PhaseInterface phase) {
        return 0.0;
    }

    @Override
    public double dFCPAdVdXi(int site, PhaseInterface phase) {
        return 1.0 / (2.0 * phase.getTotalVolume()) * (1.0 - phase.getTotalVolume() * ((PhaseCPAInterface)phase).getGcpav()) * this.getNumberOfMolesInPhase();
    }

    @Override
    public double dFCPAdNdXi(int site, PhaseInterface phase) {
        double xi = 1.0 / this.xsite[site];
        return xi + this.getNumberOfMolesInPhase() / 2.0 * this.calc_lngi(phase);
    }

    @Override
    public double dFCPAdXidXj(int sitei, int sitej, int compj, PhaseInterface phase) {
        return 0.0;
    }

    @Override
    public double dFCPAdXi(int site, PhaseInterface phase) {
        return 0.0;
    }

    public double calc_lngi(PhaseInterface phase) {
        return 0.0;
    }

    public double dFCPAdNdXidXdV(PhaseInterface phase) {
        double temp = 0.0;
        int i = 0;
        while (i < this.numberOfAssociationSites) {
            temp += this.dFCPAdNdXi(i, phase) * this.getXsitedV()[i];
            ++i;
        }
        return temp;
    }

    @Override
    public double[] getXsite() {
        return this.xsite;
    }

    public void setXsite(double[] xsite) {
        this.xsite = xsite;
    }

    @Override
    public void setXsite(int i, double xsite) {
        this.xsite[i] = xsite;
    }

    @Override
    public double[] getXsitedV() {
        return this.xsitedV;
    }

    @Override
    public void setXsitedV(int i, double xsitedV) {
        this.xsitedV[i] = xsitedV;
    }

    @Override
    public double[] getXsiteOld() {
        return this.xsiteOld;
    }

    public void setXsiteOld(double[] xsiteOld) {
        this.xsiteOld = xsiteOld;
    }

    @Override
    public void setXsiteOld(int i, double xsiteOld) {
        this.xsiteOld[i] = xsiteOld;
    }

    @Override
    public double[] getXsitedT() {
        return this.xsitedT;
    }

    @Override
    public void setXsitedT(int i, double xsitedT) {
        this.xsitedT[i] = xsitedT;
    }

    @Override
    public double[] getXsitedTdT() {
        return null;
    }

    @Override
    public void setXsitedTdT(int i, double xsitedT) {
    }

    @Override
    public void setXsitedni(int xnumb, int compnumb, double val) {
        this.xsitedni[xnumb][compnumb] = val;
    }
}

