/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentGeNRTL;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentKentEisenberg
extends ComponentGeNRTL {
    private static final long serialVersionUID = 1000L;

    public ComponentKentEisenberg() {
    }

    public ComponentKentEisenberg(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        double gamma = 1.0;
        if (this.referenceStateType.equals("solvent")) {
            this.fugacityCoefficient = gamma * this.getAntoineVaporPressure(phase.getTemperature()) / phase.getPressure();
            this.gammaRefCor = gamma;
        } else {
            double activinf = 1.0;
            this.fugacityCoefficient = this.ionicCharge == 0 ? activinf * this.getHenryCoef(phase.getTemperature()) / phase.getPressure() : 1.0E8;
            this.gammaRefCor = activinf;
        }
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        return this.fugacityCoefficient;
    }
}

