/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import neqsim.thermo.atomElement.UNIFACgroup;
import neqsim.thermo.component.ComponentGEUnifac;
import neqsim.thermo.phase.PhaseGEUnifac;
import neqsim.thermo.phase.PhaseGEUnifacUMRPRU;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentGEUnifacUMRPRU
extends ComponentGEUnifac {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ComponentGEUnifacUMRPRU.class);
    int numberOfUnifacSubGroups = 139;
    double[][] aij = null;
    double[][] aijdT = null;
    double[][] aijdTdT = null;
    double[][] tempExpaij = null;
    double oldTemperature = -10.0;
    double old2Temperature = -10.0;
    static double VCommontemp = 0.0;
    static double FCommontemp = 0.0;
    double[] sum2Comp = null;
    double[] sum2Mix = null;
    double[] sum2CompdT = null;
    double[] sum2CompdTdT = null;
    double[] sum2MixdT = null;
    double[] sum2MixdTdT = null;

    public ComponentGEUnifacUMRPRU() {
    }

    public ComponentGEUnifacUMRPRU(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        if (component_name.contains("_PC")) {
            double number = this.getMolarMass() / 0.014;
            int intNumb = (int)Math.round(number) - 2;
            this.unifacGroups.clear();
            this.unifacGroups.add(new UNIFACgroup(1, 2));
            this.unifacGroups.add(new UNIFACgroup(2, intNumb));
            this.unifacGroupsArray = this.unifacGroups.toArray(this.unifacGroupsArray);
            int i = 0;
            while (i < this.getNumberOfUNIFACgroups()) {
                this.getUnifacGroup(i).calcXComp(this);
                ++i;
            }
            i = 0;
            while (i < this.getNumberOfUNIFACgroups()) {
                this.getUnifacGroup(i).calcQComp(this);
                ++i;
            }
            return;
        }
        try {
            NeqSimDataBase database = new NeqSimDataBase();
            ResultSet dataSet = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM unifaccompumrpru WHERE Name='" + component_name + "'");
                dataSet.next();
            }
            catch (Exception e) {
                dataSet.close();
                dataSet = database.getResultSet("SELECT * FROM unifaccompumrpru WHERE Name='" + component_name + "'");
                dataSet.next();
                logger.error("Something went wrong. Closing database.", (Throwable)e);
            }
            this.unifacGroups.clear();
            int p = 1;
            while (p < this.numberOfUnifacSubGroups) {
                int temp = Integer.parseInt(dataSet.getString("sub" + Integer.toString(p)));
                if (temp > 0) {
                    this.unifacGroups.add(new UNIFACgroup(p, temp));
                }
                ++p;
            }
            dataSet.close();
            database.getConnection().close();
        }
        catch (Exception e) {
            String err = e.toString();
            logger.error(err);
        }
        this.unifacGroupsArray = this.unifacGroups.toArray(this.unifacGroupsArray);
        int i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            this.getUnifacGroup(i).calcXComp(this);
            ++i;
        }
        i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            this.getUnifacGroup(i).calcQComp(this);
            ++i;
        }
    }

    public void calcTempExpaij(PhaseInterface phase) {
        if (this.tempExpaij == null) {
            this.tempExpaij = new double[this.getNumberOfUNIFACgroups()][this.getNumberOfUNIFACgroups()];
            this.sum2Comp = new double[this.getNumberOfUNIFACgroups()];
            this.sum2Mix = new double[this.getNumberOfUNIFACgroups()];
            this.sum2CompdT = new double[this.getNumberOfUNIFACgroups()];
            this.sum2MixdT = new double[this.getNumberOfUNIFACgroups()];
            this.sum2CompdTdT = new double[this.getNumberOfUNIFACgroups()];
            this.sum2MixdTdT = new double[this.getNumberOfUNIFACgroups()];
        }
        int i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            int j = 0;
            while (j < this.getNumberOfUNIFACgroups()) {
                this.tempExpaij[i][j] = Math.exp(-1.0 / phase.getTemperature() * this.getaij(this.getUnifacGroup(i).getGroupIndex(), this.getUnifacGroup(j).getGroupIndex()));
                ++j;
            }
            ++i;
        }
    }

    public void calcSum2Comp() {
        UNIFACgroup[] unifacGroupsLocal = this.getUnifacGroups();
        int i = 0;
        while (i < unifacGroupsLocal.length) {
            this.sum2Comp[i] = 0.0;
            this.sum2Mix[i] = 0.0;
            int j = 0;
            while (j < unifacGroupsLocal.length) {
                int n = i;
                this.sum2Comp[n] = this.sum2Comp[n] + unifacGroupsLocal[j].getQComp() * this.tempExpaij[j][i];
                int n2 = i;
                this.sum2Mix[n2] = this.sum2Mix[n2] + unifacGroupsLocal[j].getQMix() * this.tempExpaij[j][i];
                ++j;
            }
            ++i;
        }
    }

    public void calcSum2CompdTdT(PhaseInterface phase) {
        double tempSqared = phase.getTemperature() * phase.getTemperature();
        double temp3pow = tempSqared * phase.getTemperature();
        UNIFACgroup[] unifacGroupsLocal = this.getUnifacGroups();
        int i = 0;
        while (i < unifacGroupsLocal.length) {
            this.sum2CompdT[i] = 0.0;
            this.sum2CompdTdT[i] = 0.0;
            this.sum2MixdT[i] = 0.0;
            this.sum2MixdTdT[i] = 0.0;
            int j = 0;
            while (j < unifacGroupsLocal.length) {
                double tempVar2 = this.getaij(unifacGroupsLocal[j].getGroupIndex(), unifacGroupsLocal[i].getGroupIndex());
                double tempVar = this.getaijdT(unifacGroupsLocal[j].getGroupIndex(), unifacGroupsLocal[i].getGroupIndex());
                double Xsum2CompdT = unifacGroupsLocal[j].getQComp() * (tempVar2 / tempSqared - tempVar / phase.getTemperature()) * this.tempExpaij[j][i];
                int n = i;
                this.sum2CompdT[n] = this.sum2CompdT[n] + Xsum2CompdT;
                double der = tempVar / tempSqared - 2.0 * tempVar2 / temp3pow - this.getaijdTdT(unifacGroupsLocal[j].getGroupIndex(), unifacGroupsLocal[i].getGroupIndex()) / phase.getTemperature() + tempVar / tempSqared;
                int n2 = i;
                this.sum2CompdTdT[n2] = this.sum2CompdTdT[n2] + ((tempVar2 / tempSqared - tempVar / phase.getTemperature()) * Xsum2CompdT + der * unifacGroupsLocal[j].getQComp() * this.tempExpaij[j][i]);
                double Xsum2MixdT = unifacGroupsLocal[j].getQMix() * (tempVar2 / tempSqared - tempVar / phase.getTemperature()) * this.tempExpaij[j][i];
                int n3 = i;
                this.sum2MixdT[n3] = this.sum2MixdT[n3] + Xsum2MixdT;
                int n4 = i;
                this.sum2MixdTdT[n4] = this.sum2MixdTdT[n4] + ((tempVar2 / tempSqared - tempVar / phase.getTemperature()) * Xsum2MixdT + der * unifacGroupsLocal[j].getQMix() * this.tempExpaij[j][i]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void calclnGammak(int k, PhaseInterface phase) {
        double sum1Comp = 0.0;
        double sum1Mix = 0.0;
        double sum3Comp = 0.0;
        double sum3Mix = 0.0;
        UNIFACgroup[] unifacGroupsLocal = this.getUnifacGroups();
        int i = 0;
        while (i < unifacGroupsLocal.length) {
            sum1Comp += unifacGroupsLocal[i].getQComp() * this.tempExpaij[i][k];
            sum1Mix += unifacGroupsLocal[i].getQMix() * this.tempExpaij[i][k];
            sum3Comp += unifacGroupsLocal[i].getQComp() * this.tempExpaij[k][i] / this.sum2Comp[i];
            sum3Mix += unifacGroupsLocal[i].getQMix() * this.tempExpaij[k][i] / this.sum2Mix[i];
            ++i;
        }
        double tempGammaComp = unifacGroupsLocal[k].getQ() * (1.0 - Math.log(sum1Comp) - sum3Comp);
        double tempGammaMix = unifacGroupsLocal[k].getQ() * (1.0 - Math.log(sum1Mix) - sum3Mix);
        this.getUnifacGroup(k).setLnGammaComp(tempGammaComp);
        this.getUnifacGroup(k).setLnGammaMix(tempGammaMix);
    }

    public void calclnGammakdn(int k, PhaseInterface phase, int derCompNumb) {
        double sum1Mix = 0.0;
        double sum1Mixdn = 0.0;
        double sum3Mix = 0.0;
        UNIFACgroup[] unifacGroupsLocal = this.getUnifacGroups();
        int i = 0;
        while (i < unifacGroupsLocal.length) {
            sum1Mix += unifacGroupsLocal[i].getQMix() * this.tempExpaij[i][k];
            sum1Mixdn += unifacGroupsLocal[i].QMixdN[derCompNumb] * this.tempExpaij[i][k];
            double sum2Mixdn = 0.0;
            int j = 0;
            while (j < unifacGroupsLocal.length) {
                sum2Mixdn += unifacGroupsLocal[j].QMixdN[derCompNumb] * this.tempExpaij[j][i];
                ++j;
            }
            sum3Mix += (unifacGroupsLocal[i].QMixdN[derCompNumb] * this.tempExpaij[k][i] * this.sum2Mix[i] - unifacGroupsLocal[i].getQMix() * this.tempExpaij[k][i] * sum2Mixdn) / (this.sum2Mix[i] * this.sum2Mix[i]);
            ++i;
        }
        double tempGammaMix = unifacGroupsLocal[k].getQ() * (-sum1Mixdn / sum1Mix - sum3Mix);
        unifacGroupsLocal[k].setLnGammaMixdn(tempGammaMix, derCompNumb);
    }

    public void calclnGammakdTdT(int k, PhaseInterface phase) {
        double sum1Comp = 0.0;
        double sum1CompdT = 0.0;
        double sum1CompdTdT = 0.0;
        double sum1Mix = 0.0;
        double sum1MixdT = 0.0;
        double sum1MixdTdT = 0.0;
        double sum3Comp = 0.0;
        double sum3CompdT = 0.0;
        double sum3Mix = 0.0;
        double sum3MixdT = 0.0;
        double tempSqared = phase.getTemperature() * phase.getTemperature();
        double temp3pow = tempSqared * phase.getTemperature();
        UNIFACgroup[] unifacGroupsLocal = this.getUnifacGroups();
        int i = 0;
        while (i < unifacGroupsLocal.length) {
            double tempVar1 = this.getaij(unifacGroupsLocal[i].getGroupIndex(), unifacGroupsLocal[k].getGroupIndex());
            double tempVar2 = this.getaij(unifacGroupsLocal[k].getGroupIndex(), unifacGroupsLocal[i].getGroupIndex());
            double tempVar1dT = this.getaijdT(unifacGroupsLocal[i].getGroupIndex(), unifacGroupsLocal[k].getGroupIndex());
            double tempVar2dT = this.getaijdT(unifacGroupsLocal[k].getGroupIndex(), unifacGroupsLocal[i].getGroupIndex());
            sum1Comp += unifacGroupsLocal[i].getQComp() * this.tempExpaij[i][k];
            double Xsum1CompdT = unifacGroupsLocal[i].getQComp() * (tempVar1 / tempSqared - tempVar1dT / phase.getTemperature()) * this.tempExpaij[i][k];
            sum1CompdT += Xsum1CompdT;
            double der = tempVar1dT / tempSqared - 2.0 * tempVar1 / temp3pow - this.getaijdTdT(unifacGroupsLocal[i].getGroupIndex(), unifacGroupsLocal[k].getGroupIndex()) / phase.getTemperature() + tempVar1dT / tempSqared;
            sum1CompdTdT += (tempVar1 / tempSqared - tempVar1dT / phase.getTemperature()) * Xsum1CompdT + der * unifacGroupsLocal[i].getQComp() * this.tempExpaij[i][k];
            sum1Mix += unifacGroupsLocal[i].getQMix() * this.tempExpaij[i][k];
            double Xsum1MixdT = unifacGroupsLocal[i].getQMix() * (tempVar1 / tempSqared - tempVar1dT / phase.getTemperature()) * this.tempExpaij[i][k];
            sum1MixdT += Xsum1MixdT;
            sum1MixdTdT += (tempVar1 / tempSqared - tempVar1dT / phase.getTemperature()) * Xsum1MixdT + der * unifacGroupsLocal[i].getQMix() * this.tempExpaij[i][k];
            double vComp = unifacGroupsLocal[i].getQComp() * this.tempExpaij[k][i];
            double vdTComp = unifacGroupsLocal[i].getQComp() * (tempVar2 / tempSqared - tempVar2dT / phase.getTemperature()) * this.tempExpaij[k][i];
            der = tempVar2dT / tempSqared - 2.0 * tempVar2 / temp3pow - this.getaijdTdT(unifacGroupsLocal[k].getGroupIndex(), this.getUnifacGroup(i).getGroupIndex()) / phase.getTemperature() + tempVar2dT / tempSqared;
            double vdTdTComp = (tempVar2 / tempSqared - tempVar2dT / phase.getTemperature()) * vdTComp + der * this.getUnifacGroup(i).getQComp() * this.tempExpaij[k][i];
            double vMix = unifacGroupsLocal[i].getQMix() * this.tempExpaij[k][i];
            double vdTMix = unifacGroupsLocal[i].getQMix() * (tempVar2 / tempSqared - tempVar2dT / phase.getTemperature()) * this.tempExpaij[k][i];
            double vdTdTMix = (tempVar2 / tempSqared - tempVar2dT / phase.getTemperature()) * vdTMix + der * unifacGroupsLocal[i].getQMix() * this.tempExpaij[k][i];
            sum3Comp += vdTComp / this.sum2Comp[i] - vComp / Math.pow(this.sum2Comp[i], 2.0) * this.sum2CompdT[i];
            sum3Mix += vdTMix / this.sum2Mix[i] - vMix / Math.pow(this.sum2Mix[i], 2.0) * this.sum2MixdT[i];
            double sum2Comp2 = this.sum2Comp[i] * this.sum2Comp[i];
            sum3CompdT += vdTdTComp / this.sum2Comp[i] - vdTComp / sum2Comp2 * this.sum2CompdT[i] - vdTComp / sum2Comp2 * this.sum2CompdT[i] + 2.0 * vComp / (sum2Comp2 * this.sum2Comp[i]) * this.sum2CompdT[i] * this.sum2CompdT[i] - vComp / sum2Comp2 * this.sum2CompdTdT[i];
            double sum2Mix2 = this.sum2Mix[i] * this.sum2Mix[i];
            sum3MixdT += vdTdTMix / this.sum2Mix[i] - vdTMix / sum2Mix2 * this.sum2MixdT[i] - vdTMix / sum2Mix2 * this.sum2MixdT[i] + 2.0 * vMix / (sum2Mix2 * this.sum2Mix[i]) * this.sum2MixdT[i] * this.sum2MixdT[i] - vMix / sum2Mix2 * this.sum2MixdTdT[i];
            ++i;
        }
        double tempGammaComp = unifacGroupsLocal[k].getQ() * (-1.0 / sum1Comp * sum1CompdT - sum3Comp);
        double tempGammaMix = unifacGroupsLocal[k].getQ() * (-1.0 / sum1Mix * sum1MixdT - sum3Mix);
        unifacGroupsLocal[k].setLnGammaCompdT(tempGammaComp);
        unifacGroupsLocal[k].setLnGammaMixdT(tempGammaMix);
        double tempGammaCompdT = unifacGroupsLocal[k].getQ() * (-1.0 / sum1Comp * sum1CompdTdT + 1.0 / (sum1Comp * sum1Comp) * sum1CompdT * sum1CompdT - sum3CompdT);
        double tempGammaMixdT = unifacGroupsLocal[k].getQ() * (-1.0 / sum1Mix * sum1MixdTdT + 1.0 / (sum1Mix * sum1Mix) * sum1MixdT * sum1MixdT - sum3MixdT);
        unifacGroupsLocal[k].setLnGammaCompdTdT(tempGammaCompdT);
        unifacGroupsLocal[k].setLnGammaMixdTdT(tempGammaMixdT);
    }

    public void commonInit(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        VCommontemp = 0.0;
        FCommontemp = 0.0;
        ComponentGEUnifac[] compArray = (ComponentGEUnifac[])phase.getcomponentArray();
        int j = 0;
        while (j < numberOfComponents) {
            VCommontemp += compArray[j].getx() * compArray[j].getR();
            FCommontemp += compArray[j].getQ() * compArray[j].getx();
            ++j;
        }
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        int initType = phase.getInitType();
        this.gamma = 1.0;
        this.lngamma = 0.0;
        this.dlngammadt = 0.0;
        this.dlngammadtdt = 0.0;
        ComponentGEUnifac[] compArray = (ComponentGEUnifac[])phase.getcomponentArray();
        if (this.getx() < 1.0E-100) {
            return this.gamma;
        }
        double V = this.getx() * this.getR() / VCommontemp;
        double F = this.getx() * this.getQ() / FCommontemp;
        double lngammaCombinational = -5.0 * this.getQ() * (Math.log(V / F) + 1.0 - V / F);
        int i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            this.getUnifacGroup(i).setQMix(((PhaseGEUnifacUMRPRU)phase).getQmix(this.getUnifacGroup(i).getGroupName()));
            ++i;
        }
        if (Math.abs(temperature - this.oldTemperature) > 1.0E-10) {
            this.calcUnifacGroupParams(phase);
            this.calcTempExpaij(phase);
        }
        double lngammaResidual = 0.0;
        this.calcSum2Comp();
        i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            this.calclnGammak(i, phase);
            lngammaResidual += (double)this.getUnifacGroup(i).getN() * (this.getUnifacGroup(i).getLnGammaMix() - this.getUnifacGroup(i).getLnGammaComp());
            ++i;
        }
        this.lngamma = lngammaResidual + lngammaCombinational;
        if (Double.isNaN(this.lngamma)) {
            logger.error("gamma NaN......");
            this.lngamma = 0.0;
            this.gamma = 1.0;
            this.dlngammadt = 0.0;
            this.dlngammadtdt = 0.0;
            return this.gamma;
        }
        this.gamma = Math.exp(this.lngamma);
        if (this.gamma < 1.0E-10) {
            this.gamma = 1.0;
        }
        if (initType > 1) {
            if (Math.abs(temperature - this.old2Temperature) > 1.0E-10) {
                this.calcUnifacGroupParamsdT(phase);
            }
            this.calcSum2CompdTdT(phase);
            i = 0;
            while (i < this.getNumberOfUNIFACgroups()) {
                this.calclnGammakdTdT(i, phase);
                ++i;
            }
            double lngammaResidualdT = 0.0;
            double lngammaResidualdTdT = 0.0;
            i = 0;
            while (i < this.getNumberOfUNIFACgroups()) {
                lngammaResidualdT += (double)this.getUnifacGroup(i).getN() * (this.getUnifacGroup(i).getLnGammaMixdT() - this.getUnifacGroup(i).getLnGammaCompdT());
                lngammaResidualdTdT += (double)this.getUnifacGroup(i).getN() * (this.getUnifacGroup(i).getLnGammaMixdTdT() - this.getUnifacGroup(i).getLnGammaCompdTdT());
                ++i;
            }
            this.dlngammadt = lngammaResidualdT;
            this.dlngammadtdt = lngammaResidualdTdT;
            if (Double.isNaN(this.dlngammadt)) {
                this.dlngammadt = 0.0;
            }
            if (Double.isNaN(this.dlngammadtdt)) {
                this.dlngammadtdt = 0.0;
            }
            this.old2Temperature = phase.getTemperature();
        }
        if (initType > 2) {
            this.dlngammadn = new double[numberOfComponents];
            int ii = 0;
            while (ii < this.getNumberOfUNIFACgroups()) {
                this.getUnifacGroup(ii).setQMixdN(((PhaseGEUnifacUMRPRU)phase).getQmixdN(this.getUnifacGroup(ii).getGroupName()));
                ++ii;
            }
            i = 0;
            while (i < phase.getNumberOfComponents()) {
                double lngammaResidualdn = 0.0;
                double lngammaCombinationaldn = -5.0 * this.getQ() / compArray[i].getNumberOfMolesInPhase() * (V / F - 1.0) * (V / (this.getx() * this.getR()) * compArray[i].getx() * compArray[i].getR() - F / (this.getx() * this.getQ()) * compArray[i].getx() * compArray[i].getQ());
                int ii2 = 0;
                while (ii2 < this.getNumberOfUNIFACgroups()) {
                    this.calclnGammakdn(ii2, phase, i);
                    lngammaResidualdn += (double)this.getUnifacGroup(ii2).getN() * this.getUnifacGroup(ii2).getLnGammaMixdn(i);
                    ++ii2;
                }
                double dlnGammadn = lngammaCombinationaldn + lngammaResidualdn;
                if (Double.isNaN(dlnGammadn)) {
                    dlnGammadn = 0.0;
                }
                this.setlnGammadn(i, dlnGammadn);
                ++i;
            }
        }
        this.oldTemperature = temperature;
        return this.gamma;
    }

    public void calcUnifacGroupParams(PhaseInterface phase) {
        if (this.aij == null) {
            this.aij = new double[this.getNumberOfUNIFACgroups()][this.getNumberOfUNIFACgroups()];
        }
        int i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            int j = 0;
            while (j < this.getNumberOfUNIFACgroups()) {
                this.aij[i][j] = this.calcaij(phase, i, j);
                ++j;
            }
            ++i;
        }
    }

    public void calcUnifacGroupParamsdT(PhaseInterface phase) {
        if (this.aijdT == null) {
            this.aijdT = new double[this.getNumberOfUNIFACgroups()][this.getNumberOfUNIFACgroups()];
            this.aijdTdT = new double[this.getNumberOfUNIFACgroups()][this.getNumberOfUNIFACgroups()];
        }
        int i = 0;
        while (i < this.getNumberOfUNIFACgroups()) {
            int j = 0;
            while (j < this.getNumberOfUNIFACgroups()) {
                this.aijdT[i][j] = this.calcaijdT(phase, i, j);
                this.aijdTdT[i][j] = this.calcaijdTdT(phase, i, j);
                ++j;
            }
            ++i;
        }
    }

    public void calcGammaNumericalDerivatives(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        phase.setInitType(1);
        int i = 0;
        while (i < phase.getNumberOfComponents()) {
            double dn = this.getNumberOfMolesInPhase() / 1000000.0;
            phase.addMoles(this.getComponentNumber(), dn);
            this.x = this.getNumberOfmoles() / this.getNumberOfMolesInPhase();
            this.getGamma(phase, numberOfComponents, temperature, pressure, phasetype);
            double oldGamma = this.lngamma;
            phase.addMoles(this.getComponentNumber(), dn);
            this.x = this.getNumberOfmoles() / this.getNumberOfMolesInPhase();
            this.getGamma(phase, numberOfComponents, temperature, pressure, phasetype);
            double dlnGammadn = (oldGamma - this.lngamma) / dn;
            this.setlnGammadn(i, dlnGammadn);
            ++i;
        }
    }

    public double getaij(int i, int j) {
        return this.aij[i][j];
    }

    public double getaijdT(int i, int j) {
        return this.aijdT[i][j];
    }

    public double getaijdTdT(int i, int j) {
        return this.aijdTdT[i][j];
    }

    public double calcaij(PhaseInterface phase, int i, int j) {
        double temp = phase.getTemperature() - 298.15;
        return ((PhaseGEUnifac)phase).getAij(i, j) + ((PhaseGEUnifac)phase).getBij(i, j) * temp + ((PhaseGEUnifac)phase).getCij(i, j) * temp * temp;
    }

    public double calcaijdT(PhaseInterface phase, int i, int j) {
        return ((PhaseGEUnifac)phase).getBij(i, j) + 2.0 * ((PhaseGEUnifac)phase).getCij(i, j) * (phase.getTemperature() - 298.15);
    }

    public double calcaijdTdT(PhaseInterface phase, int i, int j) {
        return 2.0 * ((PhaseGEUnifac)phase).getCij(i, j);
    }
}

