/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.ComponentGeNRTL;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentGENRTLmodifiedHV
extends ComponentGeNRTL {
    private static final long serialVersionUID = 1000L;

    public ComponentGENRTLmodifiedHV() {
    }

    public ComponentGENRTLmodifiedHV(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype, double[][] HValpha, double[][] HVgij, double[][] intparam, String[][] mixRule) {
        double[][] HVgijT = new double[numberOfComponents][numberOfComponents];
        return this.getGamma(phase, numberOfComponents, temperature, pressure, phasetype, HValpha, HVgij, HVgijT, intparam, mixRule);
    }

    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype, double[][] HValpha, double[][] HVgij, double[][] HVgijT, double[][] intparam, String[][] mixRule) {
        int type = phase.getInitType();
        double A = 0.0;
        double B = 0.0;
        double C = 0.0;
        double D = 0.0;
        double E = 0.0;
        double F = 0.0;
        double ny = 0.0;
        double tau = 0.0;
        double tau2 = 0.0;
        double G = 0.0;
        double G2 = 0.0;
        double alpha = 0.0;
        double Dij = 0.0;
        double Djj = 0.0;
        double Dji = 0.0;
        double Dii = 0.0;
        double DijT = 0.0;
        double DjjT = 0.0;
        double DjiT = 0.0;
        double DiiT = 0.0;
        double gij = 0.0;
        double gjj = 0.0;
        double gji = 0.0;
        double gii = 0.0;
        double F2T = 0.0;
        double tot2 = 0.0;
        double dAdT = 0.0;
        double dBdT = 0.0;
        double dCdT = 0.0;
        double dCdTdT = 0.0;
        double dDdT = 0.0;
        double dDdTdT = 0.0;
        double dBdTdT = 0.0;
        double dAdTdT = 0.0;
        double dtaudt = 0.0;
        double dtaudtdt = 0.0;
        double dtau2dt = 0.0;
        double dtau2dtdt = 0.0;
        double dGdt = 0.0;
        double dG2dt = 0.0;
        double dGdtdt = 0.0;
        double dG2dtdt = 0.0;
        double[][] Gmatrix = new double[numberOfComponents][numberOfComponents];
        double[][] tauMatrix = new double[numberOfComponents][numberOfComponents];
        this.dlngammadn = new double[numberOfComponents];
        ComponentEosInterface[] comp_Array = (ComponentEosInterface[])phase.getcomponentArray();
        double dA2dTetter = 0.0;
        double dA2dTdTetter = 0.0;
        double dA3dTetter = 0.0;
        double dA3dTdTetter = 0.0;
        double dA4dTetter = 0.0;
        double dA4dTdTetter = 0.0;
        double dA5dTetter = 0.0;
        double dA5dTdTetter = 0.0;
        double dA6dTetter = 0.0;
        double dA6dTdTetter = 0.0;
        F = 0.0;
        double dFdT = 0.0;
        dBdT = 0.0;
        dAdT = 0.0;
        dDdT = 0.0;
        A = 0.0;
        B = 0.0;
        this.dlngammadt = 0.0;
        dA2dTetter = 0.0;
        dA3dTetter = 0.0;
        dA4dTetter = 0.0;
        dA5dTetter = 0.0;
        dA6dTetter = 0.0;
        double dA2dT = 0.0;
        double dA2dTdT = 0.0;
        double dA3dT = 0.0;
        double dA3dTdT = 0.0;
        double dA4dT = 0.0;
        double dA4dTdT = 0.0;
        double dA5dT = 0.0;
        double dA5dTdT = 0.0;
        double dA6dT = 0.0;
        double dA6dTdT = 0.0;
        double deltaEOS = 1.0 / (comp_Array[0].getDeltaEosParameters()[1] - comp_Array[0].getDeltaEosParameters()[0]) * Math.log((1.0 + comp_Array[0].getDeltaEosParameters()[1]) / (1.0 + comp_Array[0].getDeltaEosParameters()[0]));
        int j = 0;
        while (j < numberOfComponents) {
            double dgijdtdt;
            double dgijdt;
            double dgiidt;
            if (mixRule[j][this.componentNumber].trim().equals("HV")) {
                Dij = HVgij[this.componentNumber][j];
                Dji = HVgij[j][this.componentNumber];
                DijT = HVgijT[this.componentNumber][j];
                DjiT = HVgijT[j][this.componentNumber];
                alpha = HValpha[j][this.componentNumber];
                tau = Dji / temperature + DjiT;
                dtaudt = -Dji / (temperature * temperature);
                dtaudtdt = 2.0 * Dji / (temperature * temperature * temperature);
                tau2 = Dij / temperature + DijT;
                dtau2dt = -Dij / (temperature * temperature);
                dtau2dtdt = 2.0 * Dij / (temperature * temperature * temperature);
            } else {
                gii = -deltaEOS * comp_Array[this.componentNumber].aT(temperature) / comp_Array[this.componentNumber].getb();
                dgiidt = -deltaEOS * comp_Array[this.componentNumber].diffaT(temperature) / comp_Array[this.componentNumber].getb();
                double dgiidtdt = -deltaEOS * comp_Array[this.componentNumber].diffdiffaT(temperature) / comp_Array[this.componentNumber].getb();
                gjj = -deltaEOS * comp_Array[j].aT(temperature) / comp_Array[j].getb();
                double dgjjdt = -deltaEOS * comp_Array[j].diffaT(temperature) / comp_Array[j].getb();
                double dgjjdtdt = -deltaEOS * comp_Array[j].diffdiffaT(temperature) / comp_Array[j].getb();
                gij = -2.0 * Math.sqrt(comp_Array[this.componentNumber].getb() * comp_Array[j].getb()) / (comp_Array[this.componentNumber].getb() + comp_Array[j].getb()) * Math.pow(gii * gjj, 0.5) * (1.0 - intparam[j][this.componentNumber]);
                gji = -2.0 * Math.sqrt(comp_Array[j].getb() * comp_Array[this.componentNumber].getb()) / (comp_Array[j].getb() + comp_Array[this.componentNumber].getb()) * Math.sqrt(gii * gjj) * (1.0 - intparam[j][this.componentNumber]);
                alpha = 0.0;
                tau = (gji - gii) / (8.3144621 * temperature);
                tau2 = (gij - gjj) / (8.3144621 * temperature);
                if (phase.getInitType() > 1) {
                    dgijdt = -2.0 * Math.sqrt(comp_Array[this.componentNumber].getb() * comp_Array[j].getb()) / (comp_Array[this.componentNumber].getb() + comp_Array[j].getb()) * 1.0 / Math.sqrt(gii * gjj) * (1.0 - intparam[j][this.componentNumber]) * (dgiidt * gjj + dgjjdt * gii) * 0.5;
                    dgijdtdt = -2.0 * Math.sqrt(comp_Array[this.componentNumber].getb() * comp_Array[j].getb()) / (comp_Array[this.componentNumber].getb() + comp_Array[j].getb()) * (1.0 / Math.pow(gii * gjj, 1.5) * (1.0 - intparam[j][this.componentNumber]) * Math.pow(dgiidt * gjj + dgjjdt * gii, 2.0) * 0.5 * -0.5 + 1.0 / Math.sqrt(gii * gjj) * (1.0 - intparam[j][this.componentNumber]) * (dgiidtdt * gjj + dgiidt * dgjjdt + dgjjdtdt * gii + dgjjdt * dgiidt) * 0.5);
                    double dgjidt = -2.0 * Math.sqrt(comp_Array[j].getb() * comp_Array[this.componentNumber].getb()) / (comp_Array[j].getb() + comp_Array[this.componentNumber].getb()) * 1.0 / Math.sqrt(gii * gjj) * (1.0 - intparam[j][this.componentNumber]) * (dgiidt * gjj + dgjjdt * gii) * 0.5;
                    double dgjidtdt = -2.0 * Math.pow(comp_Array[j].getb() * comp_Array[this.componentNumber].getb(), 0.5) / (comp_Array[j].getb() + comp_Array[this.componentNumber].getb()) * (1.0 / Math.pow(gii * gjj, 1.5) * (1.0 - intparam[j][this.componentNumber]) * Math.pow(dgiidt * gjj + dgjjdt * gii, 2.0) * 0.5 * -0.5 + 1.0 / Math.sqrt(gii * gjj) * (1.0 - intparam[j][this.componentNumber]) * (dgiidtdt * gjj + dgiidt * dgjjdt + dgjjdtdt * gii + dgjjdt * dgiidt) * 0.5);
                    dtaudt = -dgiidt / (8.3144621 * temperature) + gii / (8.3144621 * temperature * temperature) + dgjidt / (8.3144621 * temperature) - gji / (8.3144621 * temperature * temperature);
                    dtaudtdt = -dgiidtdt / (8.3144621 * temperature) + dgiidt / (8.3144621 * temperature * temperature) + dgiidt / (8.3144621 * temperature * temperature) - 2.0 * gii / (8.3144621 * temperature * temperature * temperature) + dgjidtdt / (8.3144621 * temperature) - dgjidt / (8.3144621 * temperature * temperature) - dgjidt / (8.3144621 * temperature * temperature) + 2.0 * gji / (8.3144621 * temperature * temperature * temperature);
                    dtau2dt = -dgjjdt / (8.3144621 * temperature) + gjj / (8.3144621 * temperature * temperature) + dgijdt / (8.3144621 * temperature) - gij / (8.3144621 * temperature * temperature);
                    dtau2dtdt = -dgjjdtdt / (8.3144621 * temperature) + dgjjdt / (8.3144621 * temperature * temperature) + dgjjdt / (8.3144621 * temperature * temperature) - 2.0 * gjj / (8.3144621 * temperature * temperature * temperature) + dgijdtdt / (8.3144621 * temperature) - dgijdt / (8.3144621 * temperature * temperature) - dgijdt / (8.3144621 * temperature * temperature) + 2.0 * gij / (8.3144621 * temperature * temperature * temperature);
                }
            }
            G = comp_Array[j].getb() * Math.exp(-alpha * tau);
            dGdt = dtaudt * -alpha * G;
            dGdtdt = dtaudtdt * -alpha * G + dtaudt * -alpha * dGdt;
            G2 = comp_Array[this.componentNumber].getb() * Math.exp(-alpha * tau2);
            dG2dt = dtau2dt * -alpha * G2;
            dG2dtdt = dtau2dtdt * -alpha * G2 + dtau2dt * -alpha * dG2dt;
            A += tau * G * comp_Array[j].getx();
            B += G * comp_Array[j].getx();
            E = G2 * comp_Array[j].getx();
            if (phase.getInitType() > 1) {
                dAdT = dAdT + comp_Array[j].getx() * dGdt * tau + comp_Array[j].getx() * G * dtaudt;
                dAdTdT = dAdTdT + comp_Array[j].getx() * dGdtdt * tau + comp_Array[j].getx() * dGdt * dtaudt + comp_Array[j].getx() * dGdt * dtaudt + comp_Array[j].getx() * G * dtaudtdt;
                dA2dT = comp_Array[j].getx() * dG2dt * tau2 + comp_Array[j].getx() * G2 * dtau2dt;
                dA2dTdT = comp_Array[j].getx() * dG2dtdt * tau2 + comp_Array[j].getx() * dG2dt * dtau2dt + comp_Array[j].getx() * dG2dt * dtau2dt + comp_Array[j].getx() * G2 * dtau2dtdt;
                dA3dT = tau2 * G2 * comp_Array[j].getx();
                dA3dTdT = dtau2dt * G2 * comp_Array[j].getx() + tau2 * dG2dt * comp_Array[j].getx();
                dA4dT = 2.0 * comp_Array[j].getx() * G2;
                dA4dTdT = 2.0 * comp_Array[j].getx() * dG2dt;
                dA5dT = comp_Array[j].getx() * dG2dt;
                dA5dTdT = comp_Array[j].getx() * dG2dtdt;
                dA6dT = comp_Array[j].getx() * G2;
                dA6dTdT = comp_Array[j].getx() * dG2dt;
                dBdT += dGdt * comp_Array[j].getx();
                dBdTdT += dGdtdt * comp_Array[j].getx();
            }
            double dEdT = dG2dt * comp_Array[j].getx();
            C = 0.0;
            D = 0.0;
            dCdT = 0.0;
            dCdTdT = 0.0;
            dDdT = 0.0;
            dDdTdT = 0.0;
            int l = 0;
            while (l < numberOfComponents) {
                if (mixRule[l][j].equals("HV")) {
                    Dij = HVgij[l][j];
                    DijT = HVgijT[l][j];
                    alpha = HValpha[l][j];
                    tau = Dij / temperature + DijT;
                    dtaudt = -Dij / (temperature * temperature);
                    dtaudtdt = 2.0 * Dij / (temperature * temperature * temperature);
                } else {
                    gjj = -deltaEOS * comp_Array[j].aT(temperature) / comp_Array[j].getb();
                    gii = -deltaEOS * comp_Array[l].aT(temperature) / comp_Array[l].getb();
                    gij = -2.0 * Math.sqrt(comp_Array[l].getb() * comp_Array[j].getb()) / (comp_Array[l].getb() + comp_Array[j].getb()) * Math.sqrt(gii * gjj) * (1.0 - intparam[l][j]);
                    tau = (gij - gjj) / (8.3144621 * temperature);
                    if (phase.getInitType() > 1) {
                        double dgjjdt = -deltaEOS * comp_Array[j].diffaT(temperature) / comp_Array[j].getb();
                        double dgjjdtdt = -deltaEOS * comp_Array[j].diffdiffaT(temperature) / comp_Array[j].getb();
                        double dgiidt2 = -deltaEOS * comp_Array[l].diffaT(temperature) / comp_Array[l].getb();
                        double dgiidtdt = -deltaEOS * comp_Array[l].diffdiffaT(temperature) / comp_Array[l].getb();
                        dgijdt = -2.0 * Math.sqrt(comp_Array[l].getb() * comp_Array[j].getb()) / (comp_Array[l].getb() + comp_Array[j].getb()) * 1.0 / Math.sqrt(gii * gjj) * (1.0 - intparam[l][j]) * (dgiidt2 * gjj + dgjjdt * gii) * 0.5;
                        dgijdtdt = -2.0 * Math.pow(comp_Array[l].getb() * comp_Array[j].getb(), 0.5) / (comp_Array[l].getb() + comp_Array[j].getb()) * (1.0 / Math.pow(gii * gjj, 1.5) * (1.0 - intparam[l][j]) * Math.pow(dgiidt2 * gjj + dgjjdt * gii, 2.0) * 0.5 * -0.5 + 1.0 / Math.sqrt(gii * gjj) * (1.0 - intparam[l][j]) * (dgiidtdt * gjj + dgiidt2 * dgjjdt + dgjjdtdt * gii + dgjjdt * dgiidt2) * 0.5);
                        alpha = 0.0;
                        dtaudt = -dgjjdt / (8.3144621 * temperature) + gjj / (8.3144621 * temperature * temperature) + dgijdt / (8.3144621 * temperature) - gij / (8.3144621 * temperature * temperature);
                        dtaudtdt = -dgjjdtdt / (8.3144621 * temperature) + dgjjdt / (8.3144621 * temperature * temperature) + dgjjdt / (8.3144621 * temperature * temperature) - 2.0 * dgjjdt / (8.3144621 * temperature * temperature * temperature) + dgijdtdt / (8.3144621 * temperature) - dgijdt / (8.3144621 * temperature * temperature) - dgijdt / (8.3144621 * temperature * temperature) + 2.0 * gij / (8.3144621 * temperature * temperature * temperature);
                    }
                }
                G = comp_Array[l].getb() * Math.exp(-alpha * tau);
                dGdt = dtaudt * -alpha * G;
                Gmatrix[l][j] = G;
                tauMatrix[l][j] = tau;
                C += G * comp_Array[l].getx();
                D += G * tau * comp_Array[l].getx();
                if (phase.getInitType() > 1) {
                    dCdT += dGdt * comp_Array[l].getx();
                    dCdTdT += dGdtdt * comp_Array[l].getx();
                    dDdT += comp_Array[l].getx() * dGdt * tau + comp_Array[l].getx() * G * dtaudt;
                    dDdTdT += comp_Array[l].getx() * dGdtdt * tau + comp_Array[l].getx() * dGdt * dtaudt + comp_Array[l].getx() * dGdt * dtaudt + comp_Array[l].getx() * G * dtaudtdt;
                }
                ++l;
            }
            if (phase.getInitType() > 1) {
                dA2dTetter += dA2dT / C;
                dA2dTdTetter += dA2dTdT / C - dA2dT / Math.pow(C, 2.0) * dCdT;
                dA3dTetter += dA3dT * dCdT / (C * C);
                dA3dTdTetter += dA3dTdT * dCdT / (C * C) + dA3dT * dCdTdT / (C * C) - 2.0 * dA3dT * dCdT * dCdT / (C * C * C);
                dA4dTetter += dA4dT * dCdT * D / (C * C * C);
                dA4dTdTetter += dA4dTdT * dCdT * D / (C * C * C) + dA4dT * dCdTdT * D / (C * C * C) + dA4dT * dCdT * dDdT / (C * C * C) - 3.0 * dA4dT * dCdT * D / (C * C * C * C) * dCdT;
                dA5dTetter += dA5dT * D / (C * C);
                dA5dTdTetter += dA5dTdT * D / (C * C) + dA5dT * dDdT / (C * C) - 2.0 * dA5dT * D / (C * C) * dCdT;
                dA6dTetter += dA6dT * dDdT / (C * C);
                dA6dTdTetter += dA6dTdT * dDdT / (C * C) + dA6dT * dDdTdT / (C * C) - 2.0 * dA6dT * dDdT / (C * C * C) * dCdT;
            }
            if (mixRule[this.componentNumber][j].equals("HV")) {
                tau2 = HVgij[this.componentNumber][j] / temperature + HVgijT[this.componentNumber][j];
                dtau2dt = -HVgij[this.componentNumber][j] / (temperature * temperature);
            } else {
                gii = -deltaEOS * comp_Array[this.componentNumber].aT(temperature) / comp_Array[this.componentNumber].getb();
                dgiidt = -deltaEOS * comp_Array[this.componentNumber].diffaT(temperature) / comp_Array[this.componentNumber].getb();
                gjj = -deltaEOS * comp_Array[j].aT(temperature) / comp_Array[j].getb();
                double dgjjdt = -deltaEOS * comp_Array[j].diffaT(temperature) / comp_Array[j].getb();
                gij = -2.0 * Math.pow(comp_Array[this.componentNumber].getb() * comp_Array[j].getb(), 0.5) / (comp_Array[this.componentNumber].getb() + comp_Array[j].getb()) * Math.pow(gii * gjj, 0.5) * (1.0 - intparam[this.componentNumber][j]);
                tau2 = (gij - gjj) / (8.3144621 * temperature);
                double dgijdt2 = -2.0 * Math.sqrt(comp_Array[this.componentNumber].getb() * comp_Array[j].getb()) / (comp_Array[this.componentNumber].getb() + comp_Array[j].getb()) * 1.0 / Math.sqrt(gii * gjj) * (1.0 - intparam[this.componentNumber][j]) * (dgiidt * gjj + dgjjdt * gii) * 0.5;
                dtau2dt = -dgjjdt / (8.3144621 * temperature) + gjj / (8.3144621 * temperature * temperature) + dgijdt2 / (8.3144621 * temperature) - gij / (8.3144621 * temperature * temperature);
            }
            F += E / C * (tau2 - D / C);
            dFdT += (dEdT / C - E / (C * C) * dCdT) * (tau2 - D / C) + E / C * (dtau2dt - (dDdT / C - D / (C * C) * dCdT));
            ++j;
        }
        this.lngamma = A / B + F;
        if (phase.getInitType() > 1) {
            this.dlngammadt = dAdT / B - A / (B * B) * dBdT + dA2dTetter - dA3dTetter + dA4dTetter - dA5dTetter - dA6dTetter;
            this.dlngammadtdt = dAdTdT / B - dBdT * dAdT / Math.pow(B, 2.0) - dAdT / (B * B) * dBdT + 2.0 * dBdT * A / Math.pow(B, 3.0) * dBdT - A / (B * B) * dBdTdT + 0.0 * dA2dTdTetter - 0.0 * dA3dTdTetter + 0.0 * dA4dTdTetter - 0.0 * dA5dTdTetter - 0.0 * dA6dTdTetter;
        }
        this.gamma = Math.exp(this.lngamma);
        if (type == 3) {
            double dAdn = 0.0;
            double dBdn = 0.0;
            double Etemp = 0.0;
            double dEdn = 0.0;
            double Ctemp = 0.0;
            double Dtemp = 0.0;
            double Ftemp = 0.0;
            double Gtemp = 0.0;
            int p = 0;
            while (p < numberOfComponents) {
                dAdn = tauMatrix[p][this.componentNumber] * Gmatrix[p][this.componentNumber];
                dBdn = Gmatrix[p][this.componentNumber];
                dEdn = Gmatrix[this.componentNumber][p] * tauMatrix[this.componentNumber][p];
                Dtemp = 0.0;
                Ctemp = 0.0;
                Etemp = 0.0;
                Ftemp = 0.0;
                Gtemp = 0.0;
                double nt = 0.0;
                int f = 0;
                while (f < numberOfComponents) {
                    nt += comp_Array[f].getNumberOfMolesInPhase();
                    Ctemp += comp_Array[f].getx() * Gmatrix[f][p];
                    Etemp += comp_Array[f].getx() * Gmatrix[f][p] * tauMatrix[f][p];
                    double sum = 0.0;
                    double sum2 = 0.0;
                    int g = 0;
                    while (g < numberOfComponents) {
                        sum += comp_Array[g].getx() * Gmatrix[g][f];
                        sum2 += comp_Array[g].getx() * Gmatrix[g][f] * tauMatrix[g][f];
                        ++g;
                    }
                    Dtemp += Gmatrix[p][f] * Gmatrix[this.componentNumber][f] * tauMatrix[this.componentNumber][f] * comp_Array[f].getx() / (sum * sum);
                    Ftemp += comp_Array[f].getx() * Gmatrix[p][f] * sum2 * Gmatrix[this.componentNumber][f] / (sum * sum * sum);
                    Gtemp += comp_Array[f].getx() * Gmatrix[p][f] * tauMatrix[p][f] * Gmatrix[this.componentNumber][f] / (sum * sum);
                    ++f;
                }
                this.dlngammadn[p] = dAdn / B - A / (B * B) * dBdn + dEdn / Ctemp - Dtemp - Etemp * Gmatrix[this.componentNumber][p] / (Ctemp * Ctemp) + 2.0 * Ftemp - Gtemp;
                int n = p++;
                this.dlngammadn[n] = this.dlngammadn[n] / nt;
            }
        }
        return this.gamma;
    }
}

