/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.Component;
import neqsim.thermo.component.ComponentGEInterface;
import neqsim.thermo.phase.PhaseGE;
import neqsim.thermo.phase.PhaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class ComponentGE
extends Component
implements ComponentGEInterface {
    private static final long serialVersionUID = 1000L;
    protected double gamma = 0.0;
    protected double gammaRefCor = 0.0;
    protected double lngamma = 0.0;
    protected double dlngammadt = 0.0;
    protected double dlngammadp = 0.0;
    protected double dlngammadtdt = 0.0;
    protected double[] dlngammadn;
    static Logger logger = LogManager.getLogger(ComponentGE.class);

    public ComponentGE() {
    }

    public ComponentGE(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        logger.info("fug coef " + this.gamma * this.getAntoineVaporPressure(phase.getTemperature()) / phase.getPressure());
        if (this.referenceStateType.equals("solvent")) {
            this.fugacityCoefficient = this.gamma * this.getAntoineVaporPressure(phase.getTemperature()) / phase.getPressure();
            this.gammaRefCor = this.gamma;
        } else {
            double activinf = 1.0;
            if (phase.hasComponent("water")) {
                int waternumb = phase.getComponent("water").getComponentNumber();
                activinf = this.gamma / ((PhaseGE)phase).getActivityCoefficientInfDilWater(this.componentNumber, waternumb);
            } else {
                activinf = this.gamma / ((PhaseGE)phase).getActivityCoefficientInfDil(this.componentNumber);
            }
            this.fugacityCoefficient = activinf * this.getHenryCoef(phase.getTemperature()) / phase.getPressure();
            this.gammaRefCor = activinf;
        }
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        return this.fugacityCoefficient;
    }

    public double fugcoefDiffPres(PhaseInterface phase) {
        this.dfugdp = this.referenceStateType.equals("solvent") ? 0.0 : 0.0;
        return this.dfugdp;
    }

    public double fugcoefDiffTemp(PhaseInterface phase) {
        double temperature = phase.getTemperature();
        if (this.referenceStateType.equals("solvent")) {
            this.dfugdt = this.dlngammadt + 1.0 / this.getAntoineVaporPressure(temperature) * this.getAntoineVaporPressuredT(temperature);
            logger.info("check this dfug dt - antoine");
        } else {
            this.dfugdt = this.dlngammadt + this.getHenryCoefdT(temperature);
        }
        return this.dfugdt;
    }

    @Override
    public double getGamma() {
        return this.gamma;
    }

    @Override
    public double getlnGamma() {
        return this.lngamma;
    }

    @Override
    public double getlnGammadt() {
        return this.dlngammadt;
    }

    @Override
    public double getlnGammadtdt() {
        return this.dlngammadtdt;
    }

    @Override
    public double getlnGammadn(int k) {
        return this.dlngammadn[k];
    }

    @Override
    public void setlnGammadn(int k, double val) {
        this.dlngammadn[k] = val;
    }

    @Override
    public double getGammaRefCor() {
        return this.gammaRefCor;
    }
}

