/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.ComponentSrk;
import neqsim.thermo.phase.PhaseCSPsrkEos;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentCSPsrk
extends ComponentSrk {
    private static final long serialVersionUID = 1000L;
    double f_scale_mix_i = 0.0;
    double h_scale_mix_i = 0.0;
    PhaseCSPsrkEos refPhaseBWRS = null;

    public ComponentCSPsrk() {
    }

    public ComponentCSPsrk(double moles) {
        super(moles);
    }

    public ComponentCSPsrk(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    public ComponentCSPsrk(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentCSPsrk clone() {
        ComponentCSPsrk clonedComponent = null;
        try {
            clonedComponent = (ComponentCSPsrk)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
        this.h_scale_mix_i = this.Bi / (this.refPhaseBWRS.getRefBWRSPhase().getB() / this.refPhaseBWRS.getRefBWRSPhase().getNumberOfMolesInPhase());
        double termfi1 = this.Ai / this.refPhaseBWRS.getA();
        double termfi2 = this.h_scale_mix_i / this.refPhaseBWRS.getH_scale_mix();
        double termfi3 = ((ComponentEosInterface)this.refPhaseBWRS.getRefBWRSPhase().getComponent(0)).getaDiffT() / ((ComponentEosInterface)this.refPhaseBWRS.getRefBWRSPhase().getComponent(0)).getaT() * this.refPhaseBWRS.getRefBWRSPhase().getTemperature() / this.refPhaseBWRS.getNumberOfMolesInPhase();
        double termfi4 = 1.0 - ((ComponentEosInterface)this.refPhaseBWRS.getRefBWRSPhase().getComponent(0)).getaDiffT() / ((ComponentEosInterface)this.refPhaseBWRS.getRefBWRSPhase().getComponent(0)).getaT() * this.refPhaseBWRS.getRefBWRSPhase().getTemperature();
        this.f_scale_mix_i = (termfi1 - termfi2 - termfi3) / termfi4 * this.refPhaseBWRS.getF_scale_mix();
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponentphases, double temperature, double pressure) {
        double term1 = this.f_scale_mix_i * this.refPhaseBWRS.getRefBWRSPhase().getF() / this.refPhaseBWRS.getRefBWRSPhase().getNumberOfMolesInPhase() * this.refPhaseBWRS.getRefBWRSPhase().getTemperature() / temperature;
        double term2 = this.refPhaseBWRS.getF_scale_mix() * (this.refPhaseBWRS.getRefBWRSPhase().dFdT() / this.refPhaseBWRS.getRefBWRSPhase().getNumberOfMolesInPhase() * (1.0 / this.refPhaseBWRS.getNumberOfMolesInPhase() - this.f_scale_mix_i / this.refPhaseBWRS.getF_scale_mix()) * this.refPhaseBWRS.getRefBWRSPhase().getTemperature() + this.refPhaseBWRS.getRefBWRSPhase().dFdV() / this.refPhaseBWRS.getRefBWRSPhase().getNumberOfMolesInPhase() * (-1.0 * this.h_scale_mix_i / this.refPhaseBWRS.getH_scale_mix() * this.refPhaseBWRS.getRefBWRSPhase().getMolarVolume())) * this.refPhaseBWRS.getRefBWRSPhase().getTemperature() / temperature / this.refPhaseBWRS.getRefBWRSPhase().getNumberOfMolesInPhase();
        double term3 = this.refPhaseBWRS.getF_scale_mix() * this.refPhaseBWRS.getRefBWRSPhase().getF() * 1.0 / temperature * 1.0 / this.refPhaseBWRS.getRefBWRSPhase().getNumberOfMolesInPhase() * (1.0 / this.refPhaseBWRS.getNumberOfMolesInPhase() - this.f_scale_mix_i / this.refPhaseBWRS.getF_scale_mix()) * this.refPhaseBWRS.getRefBWRSPhase().getTemperature();
        return term1 + term2 + term3;
    }

    public double getF_scale_mix_i() {
        return this.f_scale_mix_i;
    }

    public void setF_scale_mix_i(double f_scale_mix_i) {
        this.f_scale_mix_i = f_scale_mix_i;
    }

    public double getH_scale_mix_i() {
        return this.h_scale_mix_i;
    }

    public void setH_scale_mix_i(double h_scale_mix_i) {
        this.h_scale_mix_i = h_scale_mix_i;
    }

    public PhaseCSPsrkEos getRefPhaseBWRS() {
        return this.refPhaseBWRS;
    }

    public void setRefPhaseBWRS(PhaseCSPsrkEos refPhaseBWRS) {
        this.refPhaseBWRS = refPhaseBWRS;
    }
}

