/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import neqsim.thermo.atomElement.Element;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import neqsim.util.unit.RateUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class Component
implements ComponentInterface {
    private static final long serialVersionUID = 1000L;
    double[] surfTensInfluenceParam = new double[]{0.28367, -0.05164, -0.81594, 1.0681, -1.1147};
    protected int index;
    protected int componentNumber;
    protected int attractiveTermNumber = 0;
    protected int numberOfAssociationSites = 0;
    protected double logFugacityCoefficient = 0.0;
    protected double associationVolume = 0.0;
    protected double associationEnergy = 0.0;
    protected double aCPA = 0.0;
    protected double bCPA = 0.0;
    protected double mCPA = 0.0;
    protected double srkacentricFactor = 0.0;
    protected String componentName = "default";
    protected String referenceStateType = "solvent";
    protected String associationScheme = "0";
    protected String antoineLiqVapPresType = null;
    private String formulae = "";
    private String CASnumber = "";
    protected Element elements = null;
    protected boolean isTBPfraction = false;
    protected boolean isPlusFraction = false;
    protected boolean isNormalComponent = true;
    protected boolean isIon = false;
    private boolean isHydrateFormer = false;
    private boolean waxFormer = false;
    private String componentType = "Component";
    protected double qPure = 0.0;
    protected double voli = 1.0;
    protected int calcActivity = 1;
    protected boolean solidCheck = false;
    protected double dqPuredT = 0.0;
    protected double dqPuredTdT = 0.0;
    private double racketZCPA = 0.0;
    private double criticalCompressibilityFactor = 0.0;
    private double volumeCorrectionConst = 0.0;
    private double volumeCorrectionT = 0.0;
    private double volumeCorrectionT_CPA = 0.0;
    protected double criticalPressure;
    protected double criticalTemperature;
    protected double molarMass;
    protected double acentricFactor;
    protected double numberOfMoles = 0.0;
    protected double numberOfMolesInPhase = 0.0;
    protected double normalLiquidDensity = 0.0;
    protected double reducedPressure;
    protected double reducedTemperature;
    protected double fugacityCoefficient;
    protected double debyeDipoleMoment = 0.0;
    protected double viscosityCorrectionFactor = 0.0;
    protected double criticalVolume = 0.0;
    protected double racketZ = 0.0;
    protected double gibbsEnergyOfFormation = 0.0;
    protected double criticalViscosity = 0.0;
    protected double referencePotential = 0.0;
    protected double viscosityFrictionK = 1.0;
    protected int liquidViscosityModel = 0;
    protected int ionicCharge = 0;
    private double referenceEnthalpy = 0.0;
    protected double parachorParameter = 0.0;
    protected double normalBoilingPoint = 0.0;
    protected double sphericalCoreRadius = 0.384;
    protected double standardDensity = 0.0;
    protected double AntoineASolid = 0.0;
    protected double AntoineBSolid = 0.0;
    protected double AntoineCSolid = 0.0;
    protected double[] liquidViscosityParameter = new double[4];
    protected double[] liquidConductivityParameter = new double[3];
    protected double[] henryCoefParameter = new double[4];
    protected double[] dielectricParameter = new double[5];
    protected double[] schwartzentruberParams = new double[3];
    protected double[] matiascopemanParams = new double[3];
    protected double[] matiascopemanParamsPR = new double[3];
    protected double[] TwuCoonParams = new double[3];
    protected double[] matiascopemanSolidParams = new double[3];
    protected double lennardJonesMolecularDiameter = 0.0;
    protected double lennardJonesEnergyParameter = 0.0;
    protected double stokesCationicDiameter = 0.0;
    protected double paulingAnionicDiameter = 0.0;
    protected double K;
    protected double z;
    protected double x = 0.0;
    private int orginalNumberOfAssociationSites = 0;
    protected double dfugdt = 0.1;
    protected double dfugdp = 0.1;
    protected double[] dfugdn = new double[100];
    public double[] dfugdx = new double[100];
    double AntoineA = 0.0;
    double AntoineB = 0.0;
    double AntoineC = 0.0;
    double AntoineD = 0.0;
    double AntoineE = 0.0;
    private double CpA = 100.0;
    private double CpB = 0.0;
    private double CpC = 0.0;
    private double CpD = 0.0;
    private double CpE = 0.0;
    private double[] CpSolid = new double[5];
    private double[] CpLiquid = new double[5];
    private double heatOfFusion = 0.0;
    double triplePointDensity = 10.0;
    double triplePointPressure = 0.0;
    private double triplePointTemperature = 1000.0;
    double meltingPointTemperature = 110.0;
    private double idealGasEnthalpyOfFormation = 0.0;
    double idealGasGibsEnergyOfFormation = 0.0;
    double idealGasAbsoluteEntropy = 0.0;
    double Hsub = 0.0;
    double[] solidDensityCoefs = new double[5];
    double[] liquidDensityCoefs = new double[5];
    double[] heatOfVaporizationCoefs = new double[5];
    protected double mSAFTi = 0.0;
    protected double sigmaSAFTi = 0.0;
    protected double epsikSAFT = 0.0;
    private double associationVolumeSAFT;
    private double associationEnergySAFT = 0.0;
    static Logger logger = LogManager.getLogger(Component.class);

    public Component() {
    }

    public Component(int number, double moles) {
        this.numberOfMoles = moles;
    }

    public Component(double moles) {
        this.numberOfMoles = moles;
    }

    public Component(int number, double TC, double PC, double M, double a, double moles) {
        this.criticalPressure = PC;
        this.criticalTemperature = TC;
        this.molarMass = M;
        this.acentricFactor = a;
        this.numberOfMoles = moles;
    }

    public Component(String component_name, double moles, double molesInPhase, int compnumber) {
        this.createComponent(component_name, moles, molesInPhase, compnumber);
    }

    @Override
    public void insertComponentIntoDatabase(String databaseName) {
        databaseName = "comptemp";
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            try {
                int isW = 0;
                if (this.isWaxFormer()) {
                    isW = 1;
                }
                if (NeqSimDataBase.createTemporaryTables()) {
                    database.execute("insert into comptemp VALUES (" + (1000 + this.componentNumber) + ", '" + this.componentName + "', '00-00-0','" + this.getComponentType() + "', " + (1000 + this.componentNumber) + ", 'HC', " + this.molarMass * 1000.0 + ", " + this.normalLiquidDensity + ", " + (this.getTC() - 273.15) + ", " + this.getPC() + ", " + this.getAcentricFactor() + "," + (this.getNormalBoilingPoint() - 273.15) + ", 39.948, 74.9, 'Classic', 0, " + this.getCpA() + ", " + this.getCpB() + ", " + this.getCpC() + ", " + this.getCpD() + ", " + this.getCpE() + ", 'log', 5.2012, 1936.281, -20.143, -1.23303, 1000, 1.8, 0.076, 0.0, 0.0, 2.52, 809.1, 0, 3, -24.71, 4210, 0.0453, -3.38e-005, -229000, -19.2905, 29814.5, -0.019678, 0.000132, -3.11e-007, 0, 'solvent', 0, 0, 0, 0, 0.0789, -1.16, 0, -0.384, 0.00525, -6.37e-006, 207, " + this.getHeatOfFusion() + ", 1000, 0.00611, " + this.getTriplePointTemperature() + ", " + this.getMeltingPointTemperature() + ", -242000, 189, 53, -0.00784, 0, 0, 0, 5.46, 0.305, 647, 0.081, 0, 52100000, 0.32, -0.212, 0.258, 0, 0.999, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, '0', 0, 0, 0, 0,0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 'no', " + this.getmSAFTi() + ", " + this.getSigmaSAFTi() * 1.0E10 + ", " + this.getEpsikSAFT() + ", 0, 0,0,0,0,0," + isW + ",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)");
                }
                this.index = 1000 + this.componentNumber;
                this.CASnumber = "00-00-0";
            }
            catch (Exception e) {
                logger.error("error in inserting to database", (Throwable)e);
                try {
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception e2) {
                    logger.error("error closing database.....", (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception e) {
                logger.error("error closing database.....", (Throwable)e);
            }
        }
    }

    @Override
    public void createComponent(String component_name, double moles, double molesInPhase, int compnumber) {
        block36: {
            this.componentName = component_name;
            this.numberOfMoles = moles;
            this.numberOfMolesInPhase = molesInPhase;
            NeqSimDataBase database = new NeqSimDataBase();
            ResultSet dataSet = null;
            try {
                try {
                    if (!component_name.equals("default")) {
                        try {
                            dataSet = NeqSimDataBase.createTemporaryTables() ? database.getResultSet("SELECT * FROM comptemp WHERE name='" + component_name + "'") : database.getResultSet("SELECT * FROM comp WHERE name='" + component_name + "'");
                            dataSet.next();
                            dataSet.getString("ID");
                        }
                        catch (Exception e) {
                            try {
                                dataSet.close();
                                dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + component_name + "'");
                                dataSet.next();
                            }
                            catch (Exception e2) {
                                throw new RuntimeException(e2);
                            }
                        }
                        this.setComponentType(dataSet.getString("comptype"));
                        this.setCASnumber(dataSet.getString("CASnumber"));
                        this.index = Integer.parseInt(dataSet.getString("compindex"));
                        this.setFormulae(dataSet.getString("FORMULA").trim());
                        this.molarMass = Double.parseDouble(dataSet.getString("molarmass")) / 1000.0;
                        this.normalLiquidDensity = Double.parseDouble(dataSet.getString("liqdens"));
                        this.criticalTemperature = Double.parseDouble(dataSet.getString("TC")) + 273.15;
                        this.criticalPressure = Double.parseDouble(dataSet.getString("PC"));
                        this.acentricFactor = Double.parseDouble(dataSet.getString("acsfact"));
                        this.criticalVolume = Double.parseDouble(dataSet.getString("critvol"));
                        this.criticalCompressibilityFactor = this.criticalPressure * this.criticalVolume / 8.3144621 / this.criticalTemperature / 10.0;
                        this.referenceEnthalpy = Double.parseDouble(dataSet.getString("Href"));
                        this.setCpA(dataSet.getDouble("CPA"));
                        this.setCpB(dataSet.getDouble("CPB"));
                        this.setCpC(dataSet.getDouble("CPC"));
                        this.setCpD(dataSet.getDouble("CPD"));
                        this.setCpE(dataSet.getDouble("CPE"));
                        this.CpSolid[0] = Double.parseDouble(dataSet.getString("CPsolid1"));
                        this.CpSolid[1] = Double.parseDouble(dataSet.getString("CPsolid2"));
                        this.CpSolid[2] = Double.parseDouble(dataSet.getString("CPsolid3"));
                        this.CpSolid[3] = Double.parseDouble(dataSet.getString("CPsolid4"));
                        this.CpSolid[4] = Double.parseDouble(dataSet.getString("CPsolid5"));
                        this.CpLiquid[0] = Double.parseDouble(dataSet.getString("CPliquid1"));
                        this.CpLiquid[1] = Double.parseDouble(dataSet.getString("CPliquid2"));
                        this.CpLiquid[2] = Double.parseDouble(dataSet.getString("CPliquid3"));
                        this.CpLiquid[3] = Double.parseDouble(dataSet.getString("CPliquid4"));
                        this.CpLiquid[4] = Double.parseDouble(dataSet.getString("CPliquid5"));
                        this.antoineLiqVapPresType = dataSet.getString("AntoineVapPresLiqType");
                        this.AntoineA = Double.parseDouble(dataSet.getString("ANTOINEA"));
                        this.AntoineB = Double.parseDouble(dataSet.getString("ANTOINEB"));
                        this.AntoineC = Double.parseDouble(dataSet.getString("ANTOINEC"));
                        this.AntoineD = Double.parseDouble(dataSet.getString("ANTOINED"));
                        this.AntoineE = Double.parseDouble(dataSet.getString("ANTOINEE"));
                        if (this.AntoineA == 0.0) {
                            this.AntoineA = 1.0;
                            this.AntoineB = this.getNormalBoilingPoint();
                        }
                        this.AntoineASolid = Double.parseDouble(dataSet.getString("ANTOINESolidA"));
                        this.AntoineBSolid = Double.parseDouble(dataSet.getString("ANTOINESolidB"));
                        this.AntoineCSolid = Double.parseDouble(dataSet.getString("ANTOINESolidC"));
                        this.debyeDipoleMoment = Double.parseDouble(dataSet.getString("dipolemoment"));
                        this.normalBoilingPoint = Double.parseDouble(dataSet.getString("normboil"));
                        this.standardDensity = Double.parseDouble(dataSet.getString("stddens"));
                        this.viscosityCorrectionFactor = Double.parseDouble(dataSet.getString("viscfact"));
                        this.racketZ = Double.parseDouble(dataSet.getString("racketZ"));
                        this.lennardJonesMolecularDiameter = Double.parseDouble(dataSet.getString("LJdiameter"));
                        this.lennardJonesEnergyParameter = Double.parseDouble(dataSet.getString("LJeps"));
                        this.sphericalCoreRadius = Double.parseDouble(dataSet.getString("SphericalCoreRadius"));
                        this.liquidViscosityModel = Integer.parseInt(dataSet.getString("liqviscmodel"));
                        this.liquidViscosityParameter[0] = Double.parseDouble(dataSet.getString("liqvisc1"));
                        this.liquidViscosityParameter[1] = Double.parseDouble(dataSet.getString("liqvisc2"));
                        this.liquidViscosityParameter[2] = Double.parseDouble(dataSet.getString("liqvisc3"));
                        this.liquidViscosityParameter[3] = Double.parseDouble(dataSet.getString("liqvisc4"));
                        this.gibbsEnergyOfFormation = Double.parseDouble(dataSet.getString("gibbsEnergyOfFormation"));
                        this.dielectricParameter[0] = Double.parseDouble(dataSet.getString("dielectricParameter1"));
                        this.dielectricParameter[1] = Double.parseDouble(dataSet.getString("dielectricParameter2"));
                        this.dielectricParameter[2] = Double.parseDouble(dataSet.getString("dielectricParameter3"));
                        this.dielectricParameter[3] = Double.parseDouble(dataSet.getString("dielectricParameter4"));
                        this.dielectricParameter[4] = Double.parseDouble(dataSet.getString("dielectricParameter5"));
                        this.ionicCharge = Integer.parseInt(dataSet.getString("ionicCharge"));
                        this.referenceStateType = dataSet.getString("referenceStateType").trim();
                        this.henryCoefParameter[0] = Double.parseDouble(dataSet.getString("HenryCoef1"));
                        this.henryCoefParameter[1] = Double.parseDouble(dataSet.getString("HenryCoef2"));
                        this.henryCoefParameter[2] = Double.parseDouble(dataSet.getString("HenryCoef3"));
                        this.henryCoefParameter[3] = Double.parseDouble(dataSet.getString("HenryCoef4"));
                        this.schwartzentruberParams[0] = Double.parseDouble(dataSet.getString("schwartzentruber1"));
                        this.schwartzentruberParams[1] = Double.parseDouble(dataSet.getString("schwartzentruber2"));
                        this.schwartzentruberParams[2] = Double.parseDouble(dataSet.getString("schwartzentruber3"));
                        this.matiascopemanParams[0] = Double.parseDouble(dataSet.getString("MC1"));
                        this.matiascopemanParams[1] = Double.parseDouble(dataSet.getString("MC2"));
                        this.matiascopemanParams[2] = Double.parseDouble(dataSet.getString("MC3"));
                        this.matiascopemanParamsPR[0] = Double.parseDouble(dataSet.getString("MCPR1"));
                        this.matiascopemanParamsPR[1] = Double.parseDouble(dataSet.getString("MCPR2"));
                        this.matiascopemanParamsPR[2] = Double.parseDouble(dataSet.getString("MCPR3"));
                        this.matiascopemanSolidParams[0] = Double.parseDouble(dataSet.getString("MC1Solid"));
                        this.matiascopemanSolidParams[1] = Double.parseDouble(dataSet.getString("MC2Solid"));
                        this.matiascopemanSolidParams[2] = Double.parseDouble(dataSet.getString("MC3Solid"));
                        this.TwuCoonParams[0] = Double.parseDouble(dataSet.getString("TwuCoon1"));
                        this.TwuCoonParams[1] = Double.parseDouble(dataSet.getString("TwuCoon2"));
                        this.TwuCoonParams[2] = Double.parseDouble(dataSet.getString("TwuCoon3"));
                        this.liquidConductivityParameter[0] = Double.parseDouble(dataSet.getString("liquidConductivity1"));
                        this.liquidConductivityParameter[1] = Double.parseDouble(dataSet.getString("liquidConductivity2"));
                        this.liquidConductivityParameter[2] = Double.parseDouble(dataSet.getString("liquidConductivity3"));
                        this.parachorParameter = this.getClass().getName().equals("neqsim.thermo.component.ComponentSrkCPA") || this.getClass().getName().equals("neqsim.thermo.component.ComponentSrkCPAs") ? Double.parseDouble(dataSet.getString("PARACHOR_CPA")) : Double.parseDouble(dataSet.getString("parachor"));
                        this.setHeatOfFusion(Double.parseDouble(dataSet.getString("heatOfFusion")));
                        this.triplePointDensity = Double.parseDouble(dataSet.getString("triplePointDensity"));
                        this.triplePointPressure = Double.parseDouble(dataSet.getString("triplePointPressure"));
                        this.setTriplePointTemperature(Double.parseDouble(dataSet.getString("triplePointTemperature")));
                        this.meltingPointTemperature = Double.parseDouble(dataSet.getString("meltingPointTemperature"));
                        this.Hsub = Double.parseDouble(dataSet.getString("Hsub"));
                        this.setIdealGasEnthalpyOfFormation(Double.parseDouble(dataSet.getString("EnthalpyOfFormation")));
                        this.idealGasGibsEnergyOfFormation = this.gibbsEnergyOfFormation;
                        this.idealGasAbsoluteEntropy = Double.parseDouble(dataSet.getString("AbsoluteEntropy"));
                        int i = 0;
                        while (i < 5) {
                            this.solidDensityCoefs[i] = Double.parseDouble(dataSet.getString("solidDensityCoefs" + (i + 1)));
                            ++i;
                        }
                        i = 0;
                        while (i < 5) {
                            this.liquidDensityCoefs[i] = Double.parseDouble(dataSet.getString("liquidDensityCoefs" + (i + 1)));
                            ++i;
                        }
                        i = 0;
                        while (i < 5) {
                            this.heatOfVaporizationCoefs[i] = Double.parseDouble(dataSet.getString("heatOfVaporizationCoefs" + (i + 1)));
                            ++i;
                        }
                        this.orginalNumberOfAssociationSites = this.numberOfAssociationSites = Integer.parseInt(dataSet.getString("associationsites"));
                        this.associationScheme = dataSet.getString("associationscheme");
                        this.associationEnergy = Double.parseDouble(dataSet.getString("associationenergy"));
                        this.calcActivity = Integer.parseInt(dataSet.getString("calcActivity"));
                        this.setRacketZCPA(Double.parseDouble(dataSet.getString("racketZCPA")));
                        this.setVolumeCorrectionT_CPA(Double.parseDouble(dataSet.getString("volcorrCPA_T")));
                        this.volumeCorrectionT = Double.parseDouble(dataSet.getString("volcorrSRK_T"));
                        if (this.getClass().getName().equals("neqsim.thermo.component.ComponentPrCPA")) {
                            this.associationVolume = Double.parseDouble(dataSet.getString("associationboundingvolume_PR"));
                            this.aCPA = Double.parseDouble(dataSet.getString("aCPA_PR"));
                            this.bCPA = Double.parseDouble(dataSet.getString("bCPA_PR"));
                            this.mCPA = Double.parseDouble(dataSet.getString("mCPA_PR"));
                        } else {
                            this.associationVolume = Double.parseDouble(dataSet.getString("associationboundingvolume_SRK"));
                            this.aCPA = Double.parseDouble(dataSet.getString("aCPA_SRK"));
                            this.bCPA = Double.parseDouble(dataSet.getString("bCPA_SRK"));
                            this.mCPA = Double.parseDouble(dataSet.getString("mCPA_SRK"));
                        }
                        this.criticalViscosity = Double.parseDouble(dataSet.getString("criticalViscosity"));
                        if (this.criticalViscosity < 1.0E-20) {
                            this.criticalViscosity = 7.9483 * Math.sqrt(1000.0 * this.molarMass) * Math.pow(this.criticalPressure, 0.6666666666666666) / Math.pow(this.criticalTemperature, 0.16666666666666666) * 1.0E-7;
                        }
                        this.mSAFTi = Double.parseDouble(dataSet.getString("mSAFT"));
                        this.sigmaSAFTi = Double.parseDouble(dataSet.getString("sigmaSAFT")) / 1.0E10;
                        this.epsikSAFT = Double.parseDouble(dataSet.getString("epsikSAFT"));
                        this.setAssociationVolumeSAFT(Double.parseDouble(dataSet.getString("associationboundingvolume_PCSAFT")));
                        this.setAssociationEnergySAFT(Double.parseDouble(dataSet.getString("associationenergy_PCSAFT")));
                        if (Math.abs(this.criticalViscosity) < 1.0E-12) {
                            this.criticalViscosity = 7.9483 * Math.sqrt(this.molarMass * 1000.0) * Math.pow(this.criticalPressure, 0.6666666666666666) / Math.pow(this.criticalTemperature, 0.16666666666666666) * 1.0E-7;
                        }
                        if (this.normalLiquidDensity == 0.0) {
                            this.normalLiquidDensity = this.molarMass / (0.285 * Math.pow(this.criticalVolume, 1.048)) * 1000.0;
                        }
                        if (dataSet.getString("HydrateFormer").equals("yes")) {
                            this.setIsHydrateFormer(true);
                        } else {
                            this.setIsHydrateFormer(false);
                        }
                        this.waxFormer = Integer.parseInt(dataSet.getString("waxformer")) == 1;
                    }
                    this.componentNumber = compnumber;
                }
                catch (Exception e) {
                    logger.error("error in comp", (Throwable)e);
                    try {
                        if (dataSet != null) {
                            dataSet.close();
                        }
                        if (database.getStatement() != null) {
                            database.getStatement().close();
                        }
                        if (database.getConnection() != null) {
                            database.getConnection().close();
                        }
                        break block36;
                    }
                    catch (Exception e2) {
                        logger.error("error closing database.....", (Throwable)e2);
                    }
                    break block36;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception e) {
                    logger.error("error closing database.....", (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception e) {
                logger.error("error closing database.....", (Throwable)e);
            }
        }
        this.srkacentricFactor = this.acentricFactor;
        this.stokesCationicDiameter = this.lennardJonesMolecularDiameter;
        this.paulingAnionicDiameter = this.lennardJonesMolecularDiameter;
    }

    @Override
    public Component clone() {
        Component clonedComponent = null;
        try {
            clonedComponent = (Component)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedComponent;
    }

    @Override
    public void addMolesChemReac(double dn) {
        this.numberOfMoles += dn;
        this.numberOfMolesInPhase += dn;
        if (this.numberOfMoles < 0.0) {
            this.numberOfMoles = 0.0;
        }
        if (this.numberOfMolesInPhase < 0.0) {
            this.numberOfMolesInPhase = 0.0;
        }
    }

    @Override
    public void addMolesChemReac(double dn, double totdn) {
        this.numberOfMoles += totdn;
        this.numberOfMolesInPhase += dn;
        if (this.numberOfMoles < 0.0) {
            this.numberOfMoles = 0.0;
        }
        if (this.numberOfMolesInPhase < 0.0) {
            this.numberOfMolesInPhase = 0.0;
        }
    }

    @Override
    public void addMoles(double dn) {
        this.numberOfMolesInPhase += dn;
        if (this.numberOfMolesInPhase < 0.0) {
            this.numberOfMolesInPhase = 0.0;
        }
    }

    @Override
    public void setProperties(ComponentInterface component) {
        this.x = component.getx();
        this.z = component.getz();
        this.numberOfMolesInPhase = component.getNumberOfMolesInPhase();
        this.numberOfMoles = component.getNumberOfmoles();
        this.K = component.getK();
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        if (type == 0) {
            this.z = this.numberOfMoles / totalNumberOfMoles;
            this.K = Math.exp(Math.log(this.criticalPressure / pressure) + 5.373 * (1.0 + this.srkacentricFactor) * (1.0 - this.criticalTemperature / temperature));
            this.x = this.z;
        }
        this.numberOfMolesInPhase = totalNumberOfMoles * this.x * beta;
        this.numberOfMoles = totalNumberOfMoles * this.z;
        this.z = this.numberOfMoles / totalNumberOfMoles;
    }

    @Override
    public Element getElements() {
        if (this.elements == null) {
            this.elements = new Element(this.componentName);
        }
        return this.elements;
    }

    @Override
    public void Finit(PhaseInterface phase, double temp, double pres, double totMoles, double beta, int numberOfComponents, int type) {
    }

    @Override
    public final double getx() {
        return this.x;
    }

    @Override
    public final double getz() {
        return this.z;
    }

    @Override
    public final void setz(double z) {
        this.z = z;
    }

    @Override
    public final double getReferencePotential() {
        return this.referencePotential;
    }

    @Override
    public final void setReferencePotential(double ref) {
        this.referencePotential = ref;
    }

    @Override
    public final double getK() {
        return this.K;
    }

    @Override
    public final double getHeatOfFusion() {
        return this.heatOfFusion;
    }

    @Override
    public double getHeatOfVapourization(double temp) {
        return this.heatOfVaporizationCoefs[0] + this.heatOfVaporizationCoefs[1] * temp + this.heatOfVaporizationCoefs[2] * temp * temp + this.heatOfVaporizationCoefs[3] * temp * temp * temp * this.heatOfVaporizationCoefs[4] * temp * temp * temp * temp;
    }

    @Override
    public final double getTripplePointDensity() {
        return this.triplePointDensity;
    }

    @Override
    public final double getTriplePointPressure() {
        return this.triplePointPressure;
    }

    @Override
    public final double getTriplePointTemperature() {
        return this.triplePointTemperature;
    }

    @Override
    public final double getMeltingPointTemperature() {
        return this.meltingPointTemperature;
    }

    @Override
    public final double getIdealGasEnthalpyOfFormation() {
        return this.idealGasEnthalpyOfFormation;
    }

    @Override
    public final double getIdealGasGibsEnergyOfFormation() {
        return this.idealGasGibsEnergyOfFormation;
    }

    @Override
    public final double getIdealGasAbsoluteEntropy() {
        return this.idealGasAbsoluteEntropy;
    }

    @Override
    public final double getTC() {
        return this.criticalTemperature;
    }

    @Override
    public final void setTC(double val) {
        this.criticalTemperature = val;
    }

    @Override
    public final void setPC(double val) {
        this.criticalPressure = val;
    }

    @Override
    public final String getComponentName() {
        return this.componentName;
    }

    @Override
    public final String getReferenceStateType() {
        return this.referenceStateType;
    }

    @Override
    public final double getPC() {
        return this.criticalPressure;
    }

    @Override
    public double getGibbsEnergyOfFormation() {
        return this.gibbsEnergyOfFormation;
    }

    @Override
    public double getDiElectricConstant(double temperature) {
        return this.dielectricParameter[0] + this.dielectricParameter[1] / temperature + this.dielectricParameter[2] * temperature + this.dielectricParameter[3] * temperature * temperature + this.dielectricParameter[4] * Math.pow(temperature, 3.0);
    }

    @Override
    public double getDiElectricConstantdT(double temperature) {
        return -this.dielectricParameter[1] / Math.pow(temperature, 2.0) + this.dielectricParameter[2] + 2.0 * this.dielectricParameter[3] * temperature + 3.0 * this.dielectricParameter[4] * Math.pow(temperature, 2.0);
    }

    @Override
    public double getDiElectricConstantdTdT(double temperature) {
        return 2.0 * this.dielectricParameter[1] / Math.pow(temperature, 3.0) + 2.0 * this.dielectricParameter[3] + 6.0 * this.dielectricParameter[4] * Math.pow(temperature, 1.0);
    }

    @Override
    public double getDebyeDipoleMoment() {
        return this.debyeDipoleMoment;
    }

    @Override
    public final double getIonicCharge() {
        return this.ionicCharge;
    }

    @Override
    public final void setViscosityAssociationFactor(double val) {
        this.viscosityCorrectionFactor = val;
    }

    @Override
    public final double getRacketZ() {
        return this.racketZ;
    }

    @Override
    public double getVolumeCorrectionConst() {
        return this.volumeCorrectionConst;
    }

    @Override
    public double getNormalLiquidDensity() {
        return this.normalLiquidDensity;
    }

    @Override
    public double getViscosityCorrectionFactor() {
        return this.viscosityCorrectionFactor;
    }

    @Override
    public double getCriticalVolume() {
        return this.criticalVolume;
    }

    @Override
    public final int getLiquidViscosityModel() {
        return this.liquidViscosityModel;
    }

    @Override
    public final double getParachorParameter() {
        return this.parachorParameter;
    }

    @Override
    public final void setParachorParameter(double parachorParameter) {
        this.parachorParameter = parachorParameter;
    }

    @Override
    public final void setLiquidViscosityModel(int modelNumber) {
        this.liquidViscosityModel = modelNumber;
    }

    @Override
    public final void setLiquidViscosityParameter(double number, int i) {
        this.liquidViscosityParameter[i] = number;
    }

    @Override
    public final double getLiquidViscosityParameter(int i) {
        return this.liquidViscosityParameter[i];
    }

    @Override
    public void setLiquidConductivityParameter(double number, int i) {
        this.liquidConductivityParameter[i] = number;
    }

    @Override
    public double getLiquidConductivityParameter(int i) {
        return this.liquidConductivityParameter[i];
    }

    @Override
    public double getLennardJonesMolecularDiameter() {
        return this.lennardJonesMolecularDiameter;
    }

    @Override
    public double getLennardJonesEnergyParameter() {
        return this.lennardJonesEnergyParameter;
    }

    @Override
    public double getHsub() {
        return this.Hsub;
    }

    @Override
    public double getCCsolidVaporPressure(double temperature) {
        return this.triplePointPressure * Math.exp(this.Hsub / 8.3144621 * (1.0 / this.getTriplePointTemperature() - 1.0 / temperature));
    }

    @Override
    public double getCCsolidVaporPressuredT(double temperature) {
        return this.triplePointPressure * this.Hsub / 8.3144621 * (1.0 / (temperature * temperature)) * Math.exp(this.Hsub / 8.3144621 * (1.0 / this.getTriplePointTemperature() - 1.0 / temperature));
    }

    @Override
    public double getPureComponentSolidDensity(double temperature) {
        return this.molarMass * 1000.0 * (this.solidDensityCoefs[0] + this.solidDensityCoefs[1] * Math.pow(temperature, 1.0) + this.solidDensityCoefs[2] * Math.pow(temperature, 2.0) + this.solidDensityCoefs[3] * Math.pow(temperature, 3.0) + this.solidDensityCoefs[4] * Math.pow(temperature, 4.0));
    }

    @Override
    public double getPureComponentLiquidDensity(double temperature) {
        return this.molarMass * 1000.0 * (this.liquidDensityCoefs[0] + this.liquidDensityCoefs[1] * Math.pow(temperature, 1.0) + this.liquidDensityCoefs[2] * Math.pow(temperature, 2.0) + this.liquidDensityCoefs[3] * Math.pow(temperature, 3.0) + this.liquidDensityCoefs[4] * Math.pow(temperature, 4.0));
    }

    @Override
    public double getPureComponentHeatOfVaporization(double temperature) {
        return 0.001 * this.heatOfVaporizationCoefs[0] * Math.pow(1.0 - temperature / this.criticalTemperature, this.heatOfVaporizationCoefs[1] + this.heatOfVaporizationCoefs[2] * temperature / this.criticalTemperature + this.heatOfVaporizationCoefs[3] * Math.pow(temperature / this.criticalTemperature, 2.0));
    }

    @Override
    public final void setx(double newx) {
        if (Double.isNaN(newx) || Double.isInfinite(newx)) {
            return;
        }
        if (newx < 0.0) {
            this.x = 1.0E-50;
        }
        if (newx > 0.0) {
            this.x = newx;
        }
        if (newx > 5.0) {
            this.x = 5.0;
        }
    }

    @Override
    public final void setNumberOfmoles(double newmoles) {
        this.numberOfMoles = newmoles;
    }

    @Override
    public final void setNumberOfMolesInPhase(double totmoles) {
        this.numberOfMolesInPhase = totmoles * this.x;
    }

    @Override
    public final double getNumberOfmoles() {
        return this.numberOfMoles;
    }

    @Override
    public final double getMolarMass() {
        return this.molarMass;
    }

    @Override
    public final double getNumberOfMolesInPhase() {
        return this.numberOfMolesInPhase;
    }

    @Override
    public double getRate(String unitName) {
        RateUnit unit = new RateUnit(this.numberOfMolesInPhase, "mol/sec", this.molarMass, this.normalLiquidDensity, this.normalBoilingPoint);
        double val = unit.getValue(unitName);
        return val;
    }

    @Override
    public final void setK(double newK) {
        this.K = newK;
    }

    @Override
    public final double getFugacityCoefficient() {
        return this.fugacityCoefficient;
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        this.fugacityCoefficient = 1.0;
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        return this.fugacityCoefficient;
    }

    @Override
    public double logfugcoefdT(PhaseInterface phase) {
        this.dfugdt = 0.0;
        return this.dfugdt;
    }

    @Override
    public double logfugcoefdP(PhaseInterface phase) {
        this.dfugdp = 0.0;
        return this.dfugdp;
    }

    @Override
    public double[] logfugcoefdN(PhaseInterface phase) {
        return new double[2];
    }

    @Override
    public double logfugcoefdNi(PhaseInterface phase, int k) {
        return 0.0;
    }

    @Override
    public double getdfugdt() {
        return this.dfugdt;
    }

    @Override
    public double getdfugdp() {
        return this.dfugdp;
    }

    @Override
    public void setdfugdt(double val) {
        this.dfugdt = val;
    }

    @Override
    public void setdfugdp(double val) {
        this.dfugdp = val;
    }

    @Override
    public void setdfugdn(int i, double val) {
        this.dfugdn[i] = val;
    }

    @Override
    public void setdfugdx(int i, double val) {
        this.dfugdx[i] = val;
    }

    @Override
    public double getAcentricFactor() {
        return this.acentricFactor;
    }

    @Override
    public double getdfugdx(int i) {
        return this.dfugdx[i];
    }

    @Override
    public double getdfugdn(int i) {
        return this.dfugdn[i];
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getComponentNumber() {
        return this.componentNumber;
    }

    @Override
    public final double getGibbsEnergy(double temperature, double pressure) {
        return this.getEnthalpy(temperature) - temperature * this.getEntropy(temperature, pressure);
    }

    @Override
    public final double getChemicalPotentialIdealReference(PhaseInterface phase) {
        return this.getHID(phase.getTemperature()) - phase.getTemperature() * this.getIdEntropy(phase.getTemperature());
    }

    @Override
    public final double getChemicalPotential(double temperature, double pressure) {
        return this.getGibbsEnergy(temperature, pressure) / this.numberOfMolesInPhase;
    }

    @Override
    public double getChemicalPotential(PhaseInterface phase) {
        return this.getGibbsEnergy(phase.getTemperature(), phase.getPressure()) / this.numberOfMolesInPhase;
    }

    public final double getFugacitydN(int i, PhaseInterface phase) {
        double tempFug = 0.0;
        if (i == this.componentNumber) {
            tempFug = 1.0 / this.getNumberOfMolesInPhase();
        }
        return this.getdfugdn(i) + tempFug - 1.0 / phase.getNumberOfMolesInPhase();
    }

    @Override
    public final double getChemicalPotentialdNTV(int i, PhaseInterface phase) {
        return this.getChemicalPotentialdN(i, phase) - this.getVoli() * phase.getComponent(i).getVoli() * phase.getdPdVTn();
    }

    @Override
    public final double getChemicalPotentialdN(int i, PhaseInterface phase) {
        return 8.3144621 * phase.getTemperature() * this.getFugacitydN(i, phase);
    }

    @Override
    public final double getChemicalPotentialdP() {
        return this.voli;
    }

    @Override
    public final double getChemicalPotentialdT(PhaseInterface phase) {
        return -this.getEntropy(phase.getTemperature(), phase.getPressure()) / this.numberOfMolesInPhase;
    }

    @Override
    public final double getChemicalPotentialdV(PhaseInterface phase) {
        return this.getChemicalPotentialdP() * phase.getdPdVTn();
    }

    public final double getChemicalPotentialdP(int i, PhaseInterface phase) {
        return 8.3144621 * phase.getTemperature() * this.getFugacitydN(i, phase);
    }

    @Override
    public void setComponentNumber(int numb) {
        this.componentNumber = numb;
    }

    @Override
    public double getAntoineVaporPressure(double temp) {
        if (this.antoineLiqVapPresType.equals("pow10")) {
            return Math.pow(10.0, this.AntoineA - this.AntoineB / (temp + this.AntoineC - 273.15));
        }
        if (this.antoineLiqVapPresType.equals("exp") || this.antoineLiqVapPresType.equals("log")) {
            return Math.exp(this.AntoineA - this.AntoineB / (temp + this.AntoineC));
        }
        if (Math.abs(this.AntoineE) > 1.0E-12) {
            return Math.exp(this.AntoineA + this.AntoineB / temp + this.AntoineC * Math.log(temp) + this.AntoineD * Math.pow(temp, this.AntoineE)) / 100000.0;
        }
        double x = 1.0 - temp / this.criticalTemperature;
        return Math.exp(Math.pow(1.0 - x, -1.0) * (this.AntoineA * x + this.AntoineB * Math.pow(x, 1.5) + this.AntoineC * Math.pow(x, 3.0) + this.AntoineD * Math.pow(x, 6.0))) * this.criticalPressure;
    }

    @Override
    public double getAntoineVaporPressuredT(double temp) {
        if (this.antoineLiqVapPresType.equals("pow10")) {
            double ans = Math.pow(this.AntoineA - this.AntoineB / (this.AntoineC + temp - 273.15), 10.0) * this.AntoineB * Math.log(10.0) / Math.pow(this.AntoineC + temp - 273.15, 2.0);
            return ans;
        }
        if (this.antoineLiqVapPresType.equals("exp") || this.antoineLiqVapPresType.equals("log")) {
            double ans = this.AntoineB * Math.exp(this.AntoineA - this.AntoineB / (this.AntoineC + temp)) / Math.pow(this.AntoineC + temp, 2.0);
            return ans;
        }
        return 0.0;
    }

    @Override
    public double getAntoineVaporTemperature(double pres) {
        double nyPres = 0.0;
        double nyTemp = this.criticalTemperature * 0.7;
        int iter = 0;
        do {
            nyPres = this.getAntoineVaporPressure(nyTemp);
            nyTemp -= nyPres - pres;
        } while (Math.abs((nyPres - pres) / pres) > 1.0E-5 && ++iter < 1000);
        return nyTemp;
    }

    @Override
    public final double getHresTP(double temperature) {
        return 8.3144621 * temperature * (-temperature * this.getdfugdt());
    }

    @Override
    public final double getGresTP(double temperature) {
        return 8.3144621 * temperature * Math.log(this.getFugacityCoefficient());
    }

    @Override
    public final double getSresTP(double temperature) {
        return (this.getHresTP(temperature) - this.getGresTP(temperature)) / temperature;
    }

    @Override
    public final double getCp0(double temperature) {
        return this.getCpA() + this.getCpB() * temperature + this.getCpC() * Math.pow(temperature, 2.0) + this.getCpD() * Math.pow(temperature, 3.0) + this.getCpE() * Math.pow(temperature, 4.0);
    }

    @Override
    public final double getCv0(double temperature) {
        return this.getCpA() + this.getCpB() * temperature + this.getCpC() * Math.pow(temperature, 2.0) + this.getCpD() * Math.pow(temperature, 3.0) + this.getCpE() * Math.pow(temperature, 4.0) - 8.3144621;
    }

    @Override
    public final double getHID(double T) {
        return 0.0 * this.getIdealGasEnthalpyOfFormation() + (this.getCpA() * T + 0.5 * this.getCpB() * T * T + 0.3333333333333333 * this.getCpC() * T * T * T + 0.25 * this.getCpD() * T * T * T * T) + 0.2 * this.getCpE() * T * T * T * T * T - (this.getCpA() * 273.15 + 0.5 * this.getCpB() * 273.15 * 273.15 + 0.3333333333333333 * this.getCpC() * 273.15 * 273.15 * 273.15 + 0.25 * this.getCpD() * 273.15 * 273.15 * 273.15 * 273.15 + 0.2 * this.getCpE() * 273.15 * 273.15 * 273.15 * 273.15 * 273.15);
    }

    @Override
    public final double getEnthalpy(double temperature) {
        return this.getHID(temperature) * this.numberOfMolesInPhase + this.getHresTP(temperature) * this.numberOfMolesInPhase;
    }

    @Override
    public double getIdEntropy(double temperature) {
        return this.getCpE() * temperature * temperature * temperature * temperature / 4.0 + this.getCpD() * temperature * temperature * temperature / 3.0 + this.getCpC() * temperature * temperature / 2.0 + this.getCpB() * temperature + this.getCpA() * Math.log(temperature) - this.getCpE() * 273.15 * 273.15 * 273.15 * 273.15 / 4.0 - this.getCpD() * 273.15 * 273.15 * 273.15 / 3.0 - this.getCpC() * 273.15 * 273.15 / 2.0 - this.getCpB() * 273.15 - this.getCpA() * Math.log(273.15);
    }

    @Override
    public double getEntropy(double temperature, double pressure) {
        if (this.x < 1.0E-100) {
            return 0.0;
        }
        return this.numberOfMolesInPhase * (this.getIdEntropy(temperature) - 8.3144621 * Math.log(pressure / 1.01325) - 8.3144621 * Math.log(this.x)) + this.getSresTP(temperature) * this.numberOfMolesInPhase;
    }

    @Override
    public final String getName() {
        return this.componentName;
    }

    @Override
    public void setAcentricFactor(double val) {
        this.acentricFactor = val;
        this.getAttractiveTerm().init();
    }

    @Override
    public void setRacketZ(double val) {
        this.racketZ = val;
    }

    @Override
    public void setAttractiveTerm(int i) {
        this.attractiveTermNumber = i;
    }

    @Override
    public AttractiveTermInterface getAttractiveTerm() {
        return null;
    }

    @Override
    public final double[] getSchwartzentruberParams() {
        return this.schwartzentruberParams;
    }

    @Override
    public final void setSchwartzentruberParams(int i, double param) {
        this.schwartzentruberParams[i] = param;
    }

    @Override
    public final double[] getTwuCoonParams() {
        return this.TwuCoonParams;
    }

    @Override
    public final void setTwuCoonParams(int i, double param) {
        this.TwuCoonParams[i] = param;
    }

    @Override
    public double fugcoefDiffPresNumeric(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double temp1 = 0.0;
        double temp2 = 0.0;
        double dp = phase.getPressure() / 100000.0;
        temp1 = phase.getComponents()[this.componentNumber].getFugacityCoefficient();
        phase.setPressure(phase.getPressure() - dp);
        phase.init(this.numberOfMolesInPhase, numberOfComponents, 1, phase.getPhaseType(), phase.getBeta());
        phase.getComponents()[this.componentNumber].fugcoef(phase);
        temp2 = phase.getComponents()[this.componentNumber].getFugacityCoefficient();
        phase.setPressure(phase.getPressure() + dp);
        phase.init(this.numberOfMolesInPhase, numberOfComponents, 1, phase.getPhaseType(), phase.getBeta());
        phase.getComponents()[this.componentNumber].fugcoef(phase);
        this.dfugdp = (Math.log(temp1) - Math.log(temp2)) / dp;
        return this.dfugdp;
    }

    @Override
    public double fugcoefDiffTempNumeric(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double temp1 = 0.0;
        double temp2 = 0.0;
        double dt = phase.getTemperature() / 1000000.0;
        temp1 = phase.getComponents()[this.componentNumber].getFugacityCoefficient();
        phase.setTemperature(phase.getTemperature() - dt);
        phase.init(this.numberOfMolesInPhase, numberOfComponents, 1, phase.getPhaseType(), phase.getBeta());
        phase.getComponents()[this.componentNumber].fugcoef(phase);
        temp2 = phase.getComponents()[this.componentNumber].getFugacityCoefficient();
        this.dfugdt = (Math.log(temp1) - Math.log(temp2)) / dt;
        return this.dfugdt;
    }

    public final double getIonicDiameter() {
        if (this.ionicCharge < 0) {
            return this.paulingAnionicDiameter;
        }
        if (this.ionicCharge > 0) {
            return this.stokesCationicDiameter;
        }
        return this.lennardJonesMolecularDiameter;
    }

    @Override
    public double getStokesCationicDiameter() {
        return this.stokesCationicDiameter;
    }

    @Override
    public void setStokesCationicDiameter(double stokesCationicDiameter) {
        this.stokesCationicDiameter = stokesCationicDiameter;
    }

    @Override
    public final double getPaulingAnionicDiameter() {
        return this.paulingAnionicDiameter;
    }

    public void setPaulingAnionicDiameter(double paulingAnionicDiameter) {
        this.paulingAnionicDiameter = paulingAnionicDiameter;
    }

    @Override
    public final double getLogFugacityCoefficient() {
        return this.logFugacityCoefficient;
    }

    @Override
    public final int getAttractiveTermNumber() {
        return this.attractiveTermNumber;
    }

    @Override
    public double getVoli() {
        return this.voli;
    }

    public void setVoli(double molarVol) {
        this.voli = molarVol;
    }

    public final double getMatiascopemanParams(int index) {
        return this.matiascopemanParams[index];
    }

    @Override
    public final double[] getMatiascopemanParams() {
        return this.matiascopemanParams;
    }

    public final double[] getMatiascopemanParamsPR() {
        return this.matiascopemanParamsPR;
    }

    public void setMatiascopemanParamsPR(int index, double matiascopemanParams) {
        this.matiascopemanParamsPR[index] = matiascopemanParams;
    }

    @Override
    public void setMatiascopemanParams(int index, double matiascopemanParams) {
        this.matiascopemanParams[index] = matiascopemanParams;
    }

    @Override
    public void setMatiascopemanParams(double[] matiascopemanParams) {
        this.matiascopemanParams = matiascopemanParams;
    }

    @Override
    public void setFugacityCoefficient(double val) {
        this.fugacityCoefficient = val;
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
    }

    @Override
    public final int getNumberOfAssociationSites() {
        return this.numberOfAssociationSites;
    }

    @Override
    public void setNumberOfAssociationSites(int numberOfAssociationSites) {
        this.numberOfAssociationSites = numberOfAssociationSites;
    }

    @Override
    public void seta(double a) {
        logger.error("no method set a");
    }

    @Override
    public void setb(double b) {
        logger.error("no method set b");
    }

    @Override
    public final double getAssociationVolume() {
        return this.associationVolume;
    }

    @Override
    public void setAssociationVolume(double associationVolume) {
        this.associationVolume = associationVolume;
    }

    @Override
    public final double getAssociationEnergy() {
        return this.associationEnergy;
    }

    @Override
    public void setAssociationEnergy(double associationEnergy) {
        this.associationEnergy = associationEnergy;
    }

    @Override
    public double getNormalBoilingPoint() {
        return this.normalBoilingPoint;
    }

    @Override
    public void setNormalBoilingPoint(double normalBoilingPoint) {
        this.normalBoilingPoint = normalBoilingPoint;
    }

    public double getStandardDensity() {
        return this.standardDensity;
    }

    public void setStandardDensity(double standardDensity) {
        this.standardDensity = standardDensity;
    }

    @Override
    public double getAntoineASolid() {
        return this.AntoineASolid;
    }

    @Override
    public void setAntoineASolid(double AntoineASolid) {
        this.AntoineASolid = AntoineASolid;
    }

    @Override
    public double getAntoineBSolid() {
        return this.AntoineBSolid;
    }

    @Override
    public void setAntoineBSolid(double AntoineBSolid) {
        this.AntoineBSolid = AntoineBSolid;
    }

    @Override
    public double getAntoineCSolid() {
        return this.AntoineBSolid;
    }

    @Override
    public void setAntoineCSolid(double AntoineCSolid) {
        this.AntoineCSolid = AntoineCSolid;
    }

    @Override
    public final double getSolidVaporPressure(double temperature) {
        if (Math.abs(this.AntoineCSolid) < 1.0E-10) {
            return Math.exp(this.AntoineASolid + this.AntoineBSolid / temperature);
        }
        return Math.pow(10.0, this.AntoineASolid - this.AntoineBSolid / (temperature + this.AntoineCSolid));
    }

    @Override
    public final double getSolidVaporPressuredT(double temperature) {
        if (Math.abs(this.AntoineCSolid) < 1.0E-10) {
            return -this.AntoineBSolid / (temperature * temperature) * Math.exp(this.AntoineASolid + this.AntoineBSolid / temperature);
        }
        return this.AntoineBSolid * Math.log(10.0) * Math.pow(0.0, this.AntoineASolid - this.AntoineBSolid / (temperature + this.AntoineCSolid)) * Math.pow(10.0, this.AntoineASolid) / Math.pow(temperature + this.AntoineCSolid, 2.0);
    }

    @Override
    public final double getSphericalCoreRadius() {
        return this.sphericalCoreRadius;
    }

    @Override
    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    @Override
    public void setLennardJonesEnergyParameter(double lennardJonesEnergyParameter) {
        this.lennardJonesEnergyParameter = lennardJonesEnergyParameter;
    }

    @Override
    public void setLennardJonesMolecularDiameter(double lennardJonesMolecularDiameter) {
        this.lennardJonesMolecularDiameter = lennardJonesMolecularDiameter;
    }

    @Override
    public void setSphericalCoreRadius(double sphericalCoreRadius) {
        this.sphericalCoreRadius = sphericalCoreRadius;
    }

    @Override
    public boolean calcActivity() {
        return this.calcActivity != 0;
    }

    @Override
    public boolean isIsTBPfraction() {
        return this.isTBPfraction;
    }

    @Override
    public boolean isHydrocarbon() {
        return this.isIsTBPfraction() || this.isPlusFraction || this.componentType.equals("HC");
    }

    @Override
    public void setIsTBPfraction(boolean isTBPfraction) {
        this.setIsAllTypesFalse();
        this.isTBPfraction = isTBPfraction;
    }

    protected void setIsAllTypesFalse() {
        this.isTBPfraction = false;
        this.isPlusFraction = false;
        this.isNormalComponent = false;
        this.isIon = false;
    }

    @Override
    public boolean isIsPlusFraction() {
        return this.isPlusFraction;
    }

    @Override
    public void setIsPlusFraction(boolean isPlusFraction) {
        this.setIsAllTypesFalse();
        this.isPlusFraction = isPlusFraction;
    }

    @Override
    public boolean isIsNormalComponent() {
        return this.isNormalComponent;
    }

    @Override
    public boolean isInert() {
        return this.componentType.equals("inert");
    }

    @Override
    public void setIsNormalComponent(boolean isNormalComponent) {
        this.setIsAllTypesFalse();
        this.isNormalComponent = isNormalComponent;
    }

    @Override
    public boolean isIsIon() {
        if (this.componentType.equals("ion")) {
            this.setIsIon(true);
        }
        return this.isIon;
    }

    @Override
    public void setIsIon(boolean isIon) {
        this.setIsAllTypesFalse();
        this.isIon = isIon;
    }

    @Override
    public void setNormalLiquidDensity(double normalLiquidDensity) {
        this.normalLiquidDensity = normalLiquidDensity;
    }

    @Override
    public void setMolarMass(double molarMass) {
        this.molarMass = molarMass;
    }

    @Override
    public final boolean doSolidCheck() {
        return this.solidCheck;
    }

    @Override
    public void setSolidCheck(boolean solidCheck) {
        this.solidCheck = solidCheck;
    }

    @Override
    public String getAssociationScheme() {
        return this.associationScheme;
    }

    @Override
    public void setAssociationScheme(String associationScheme) {
        this.associationScheme = associationScheme;
    }

    @Override
    public String getComponentType() {
        if (this.isTBPfraction) {
            this.componentType = "TBP";
        } else if (this.isPlusFraction) {
            this.componentType = "plus";
        } else if (this.isNormalComponent) {
            this.componentType = "normal";
        } else if (this.isIon) {
            this.componentType = "ion";
        }
        return this.componentType;
    }

    @Override
    public double getHenryCoef(double temperature) {
        return Math.exp(this.henryCoefParameter[0] + this.henryCoefParameter[1] / temperature + this.henryCoefParameter[2] * Math.log(temperature) + this.henryCoefParameter[3] * temperature) * 0.01802 * 100.0;
    }

    @Override
    public double getHenryCoefdT(double temperature) {
        return this.getHenryCoef(temperature) * (-this.henryCoefParameter[1] / (temperature * temperature) + this.henryCoefParameter[2] / temperature + this.henryCoefParameter[3]);
    }

    @Override
    public double[] getHenryCoefParameter() {
        return this.henryCoefParameter;
    }

    @Override
    public void setHenryCoefParameter(double[] henryCoefParameter) {
        this.henryCoefParameter = henryCoefParameter;
    }

    @Override
    public double[] getMatiascopemanSolidParams() {
        return this.matiascopemanSolidParams;
    }

    public void setMatiascopemanSolidParams(double[] matiascopemanSolidParams) {
        this.matiascopemanSolidParams = matiascopemanSolidParams;
    }

    @Override
    public double getPureComponentCpSolid(double temperature) {
        return 0.001 * (this.CpSolid[0] + this.CpSolid[1] * temperature + this.CpSolid[2] * Math.pow(temperature, 2.0) + this.CpSolid[3] * Math.pow(temperature, 3.0) + this.CpSolid[4] * Math.pow(temperature, 4.0));
    }

    @Override
    public double getPureComponentCpLiquid(double temperature) {
        return 0.001 * (this.CpLiquid[0] + this.CpLiquid[1] * temperature + this.CpLiquid[2] * Math.pow(temperature, 2.0) + this.CpLiquid[3] * Math.pow(temperature, 3.0) + this.CpLiquid[4] * Math.pow(temperature, 4.0));
    }

    @Override
    public void setCriticalVolume(double criticalVolume) {
        this.criticalVolume = criticalVolume;
    }

    @Override
    public double getCriticalViscosity() {
        return this.criticalViscosity;
    }

    @Override
    public void setCriticalViscosity(double criticalViscosity) {
        this.criticalViscosity = criticalViscosity;
    }

    @Override
    public double getMolarity(PhaseInterface phase) {
        return this.x * 1.0 / (phase.getMolarVolume() * 1.0E-5) / 1000.0;
    }

    @Override
    public double getMolality(PhaseInterface phase) {
        return this.getMolarity(phase) / (phase.getDensity() / 1000.0);
    }

    @Override
    public boolean isHydrateFormer() {
        return this.isIsHydrateFormer();
    }

    @Override
    public void setIsHydrateFormer(boolean isHydrateFormer) {
        this.isHydrateFormer = isHydrateFormer;
    }

    @Override
    public double getmSAFTi() {
        return this.mSAFTi;
    }

    @Override
    public void setmSAFTi(double mSAFTi) {
        this.mSAFTi = mSAFTi;
    }

    @Override
    public double getSigmaSAFTi() {
        return this.sigmaSAFTi;
    }

    @Override
    public void setSigmaSAFTi(double sigmaSAFTi) {
        this.sigmaSAFTi = sigmaSAFTi;
    }

    @Override
    public double getEpsikSAFT() {
        return this.epsikSAFT;
    }

    @Override
    public void setEpsikSAFT(double epsikSAFT) {
        this.epsikSAFT = epsikSAFT;
    }

    @Override
    public double getAssociationVolumeSAFT() {
        return this.associationVolumeSAFT;
    }

    @Override
    public void setAssociationVolumeSAFT(double associationVolumeSAFT) {
        this.associationVolumeSAFT = associationVolumeSAFT;
    }

    @Override
    public double getAssociationEnergySAFT() {
        return this.associationEnergySAFT;
    }

    @Override
    public void setAssociationEnergySAFT(double associationEnergySAFT) {
        this.associationEnergySAFT = associationEnergySAFT;
    }

    @Override
    public double getCriticalCompressibilityFactor() {
        return this.criticalCompressibilityFactor;
    }

    @Override
    public void setCriticalCompressibilityFactor(double criticalCompressibilityFactor) {
        this.criticalCompressibilityFactor = criticalCompressibilityFactor;
    }

    @Override
    public double getSurfaceTenisionInfluenceParameter(double temperature) {
        return 1.0;
    }

    @Override
    public void setSurfTensInfluenceParam(int factNum, double val) {
        this.surfTensInfluenceParam[factNum] = val;
    }

    @Override
    public double getSurfTensInfluenceParam(int factNum) {
        return this.surfTensInfluenceParam[factNum];
    }

    @Override
    public boolean isWaxFormer() {
        return this.waxFormer;
    }

    @Override
    public void setWaxFormer(boolean waxFormer) {
        this.waxFormer = waxFormer;
    }

    @Override
    public void setHeatOfFusion(double heatOfFusion) {
        this.heatOfFusion = heatOfFusion;
    }

    @Override
    public void setTriplePointTemperature(double triplePointTemperature) {
        this.triplePointTemperature = triplePointTemperature;
    }

    @Override
    public void setComponentType(String componentType) {
        this.componentType = componentType;
        if (componentType.equals("TBP")) {
            this.setIsTBPfraction(true);
        }
    }

    public boolean isIsHydrateFormer() {
        return this.isHydrateFormer;
    }

    public double getReferenceEnthalpy() {
        return this.referenceEnthalpy;
    }

    public void setReferenceEnthalpy(double referenceEnthalpy) {
        this.referenceEnthalpy = referenceEnthalpy;
    }

    @Override
    public double getCpA() {
        return this.CpA;
    }

    @Override
    public void setCpA(double CpA) {
        this.CpA = CpA;
    }

    @Override
    public double getCpB() {
        return this.CpB;
    }

    @Override
    public void setCpB(double CpB) {
        this.CpB = CpB;
    }

    @Override
    public double getCpC() {
        return this.CpC;
    }

    @Override
    public void setCpC(double CpC) {
        this.CpC = CpC;
    }

    @Override
    public double getCpD() {
        return this.CpD + 1.0E-10;
    }

    @Override
    public void setCpD(double CpD) {
        this.CpD = CpD;
    }

    @Override
    public String getFormulae() {
        return this.formulae;
    }

    @Override
    public void setFormulae(String formulae) {
        this.formulae = formulae;
    }

    @Override
    public String getCASnumber() {
        return this.CASnumber;
    }

    @Override
    public void setCASnumber(String CASnumber) {
        this.CASnumber = CASnumber;
    }

    @Override
    public int getOrginalNumberOfAssociationSites() {
        return this.orginalNumberOfAssociationSites;
    }

    @Override
    public double getdrhodN() {
        return this.molarMass;
    }

    @Override
    public double getCpE() {
        return this.CpE;
    }

    @Override
    public void setCpE(double CpE) {
        this.CpE = CpE;
    }

    @Override
    public double getRacketZCPA() {
        return this.racketZCPA;
    }

    @Override
    public void setRacketZCPA(double racketZCPA) {
        this.racketZCPA = racketZCPA;
    }

    @Override
    public double getVolumeCorrectionT() {
        return this.volumeCorrectionT;
    }

    @Override
    public double getVolumeCorrection() {
        return 0.0;
    }

    @Override
    public void setVolumeCorrectionConst(double getVolumeCorrectionConst) {
        this.volumeCorrectionConst = getVolumeCorrectionConst;
    }

    @Override
    public void setVolumeCorrectionT(double volumeCorrectionT) {
        this.volumeCorrectionT = volumeCorrectionT;
    }

    @Override
    public double getVolumeCorrectionT_CPA() {
        return this.volumeCorrectionT_CPA;
    }

    @Override
    public void setVolumeCorrectionT_CPA(double volumeCorrectionT_CPA) {
        this.volumeCorrectionT_CPA = volumeCorrectionT_CPA;
    }

    @Override
    public void setIdealGasEnthalpyOfFormation(double idealGasEnthalpyOfFormation) {
        this.idealGasEnthalpyOfFormation = idealGasEnthalpyOfFormation;
    }

    @Override
    public double getFlowRate(String flowunit) {
        if (flowunit.equals("kg/sec")) {
            return this.numberOfMolesInPhase * this.getMolarMass();
        }
        if (flowunit.equals("kg/min")) {
            return this.numberOfMolesInPhase * this.getMolarMass() * 60.0;
        }
        if (flowunit.equals("kg/hr")) {
            return this.numberOfMolesInPhase * this.getMolarMass() * 3600.0;
        }
        if (flowunit.equals("m3/hr")) {
            return this.getVoli() / 100000.0 * 3600.0;
        }
        if (flowunit.equals("m3/min")) {
            return this.getVoli() / 100000.0 * 60.0;
        }
        if (flowunit.equals("m3/sec")) {
            return this.getVoli() / 100000.0;
        }
        if (flowunit.equals("mole/sec")) {
            return this.numberOfMolesInPhase;
        }
        if (flowunit.equals("mole/min")) {
            return this.numberOfMolesInPhase * 60.0;
        }
        if (flowunit.equals("mole/hr")) {
            return this.numberOfMolesInPhase * 3600.0;
        }
        throw new RuntimeException("failed.. unit: " + flowunit + " not suported");
    }

    @Override
    public double getTotalFlowRate(String flowunit) {
        if (flowunit.equals("kg/sec")) {
            return this.numberOfMoles * this.getMolarMass();
        }
        if (flowunit.equals("kg/min")) {
            return this.numberOfMoles * this.getMolarMass() * 60.0;
        }
        if (flowunit.equals("kg/hr")) {
            return this.numberOfMoles * this.getMolarMass() * 3600.0;
        }
        if (flowunit.equals("mole/sec")) {
            return this.numberOfMoles;
        }
        if (flowunit.equals("mole/min")) {
            return this.numberOfMoles * 60.0;
        }
        if (flowunit.equals("mole/hr")) {
            return this.numberOfMoles * 3600.0;
        }
        throw new RuntimeException("failed.. unit: " + flowunit + " not suported");
    }
}

