/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import neqsim.thermo.characterization.NewtonSolveAB;
import neqsim.thermo.characterization.NewtonSolveABCD;
import neqsim.thermo.characterization.PlusCharacterize;
import neqsim.thermo.system.SystemInterface;

public class TBPCharacterize
extends PlusCharacterize {
    private static final long serialVersionUID = 1000L;
    int startPlus = 7;
    int endPlus = 20;
    double[] calcTBPfractions = null;
    double[] TBPdens = null;
    double[] TBPmoles = null;
    double[] TBPdensDenom = null;
    double[] TBP_Mnom = null;
    double[] TBP_M = null;

    public TBPCharacterize() {
    }

    public TBPCharacterize(SystemInterface system) {
        this.system = system;
        this.firstPlusFractionNumber = 7;
        this.lastPlusFractionNumber = 40;
    }

    @Override
    public boolean groupTBPfractions() {
        this.system.init(0);
        double old = 0.0;
        this.TBPfractions = new double[50];
        this.TBP_Mnom = new double[50];
        this.TBPdensDenom = new double[50];
        this.TBPmoles = new double[50];
        int numb = 49;
        int i = 0;
        while (i < this.system.getPhase(0).getNumberOfComponents()) {
            double boilpoint = this.system.getPhase(0).getComponent(i).getNormalBoilingPoint();
            numb = boilpoint >= 331.0 ? 13 : (boilpoint >= 317.0 ? 12 : (boilpoint >= 303.0 ? 11 : (boilpoint >= 287.0 ? 10 : (boilpoint >= 271.1 ? 9 : (boilpoint >= 253.9 ? 8 : (boilpoint >= 235.9 ? 7 : (boilpoint >= 216.8 ? 6 : (boilpoint >= 196.4 ? 5 : (boilpoint >= 174.6 ? 4 : (boilpoint >= 151.3 ? 3 : (boilpoint >= 126.1 ? 2 : (boilpoint >= 98.9 ? 1 : (boilpoint >= 69.2 ? 0 : 49)))))))))))));
            if (boilpoint > old) {
                this.length = numb + 1;
                old = boilpoint;
            }
            int n = numb;
            this.TBPmoles[n] = this.TBPmoles[n] + this.system.getPhase(0).getComponent(i).getNumberOfmoles();
            int n2 = numb;
            this.TBPfractions[n2] = this.TBPfractions[n2] + this.system.getPhase(0).getComponent(i).getz();
            int n3 = numb;
            this.TBP_Mnom[n3] = this.TBP_Mnom[n3] + this.system.getPhase(0).getComponent(i).getz() * this.system.getPhase(0).getComponent(i).getMolarMass();
            int n4 = numb;
            this.TBPdensDenom[n4] = this.TBPdensDenom[n4] + this.system.getPhase(0).getComponent(i).getz() * this.system.getPhase(0).getComponent(i).getMolarMass() / this.system.getPhase(0).getComponent(i).getNormalLiquidDensity();
            ++i;
        }
        this.TBPdens = new double[this.length];
        this.TBP_M = new double[this.length];
        this.carbonNumberVector = new int[this.length];
        i = 0;
        while (i < this.length) {
            this.TBPdens[i] = this.TBP_Mnom[i] / this.TBPdensDenom[i];
            this.TBP_M[i] = this.TBP_Mnom[i] / this.TBPfractions[i];
            this.carbonNumberVector[i] = this.getFirstPlusFractionNumber() + i;
            ++i;
        }
        return this.length > 1;
    }

    @Override
    public void addTBPFractions() {
        int i = 0;
        while (i < this.TBPdens.length) {
            this.system.addTBPfraction("C" + Integer.toString(this.carbonNumberVector[i]), this.TBPmoles[i], this.TBP_M[i], this.TBPdens[i]);
            ++i;
        }
    }

    public boolean saveCharacterizedFluid() {
        int i = 0;
        while (i < this.system.getPhase(0).getNumberOfComponents()) {
            ++i;
        }
        return true;
    }

    public double[] getTBPfractions() {
        return this.TBPfractions;
    }

    @Override
    public void setCoefs(double coef, int i) {
        this.coefs[i] = coef;
    }

    public double getTBPfractions(int i) {
        return this.TBPfractions[i];
    }

    public void setTBPfractions(double[] TBPfractions) {
        this.TBPfractions = TBPfractions;
    }

    @Override
    public void solve() {
        NewtonSolveABCD solver = new NewtonSolveABCD(this.system, this);
        solver.solve();
    }

    public void solveAB() {
        NewtonSolveAB solver = new NewtonSolveAB(this.system, this);
        solver.solve();
    }

    @Override
    public void setCoefs(double[] coefs) {
        this.coefs = coefs;
    }

    public double[] getTBPdens() {
        return this.TBPdens;
    }

    public double getTBPdens(int i) {
        return this.TBPdens[i];
    }

    public void setTBPdens(double[] TBPdens) {
        this.TBPdens = TBPdens;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public double[] getTBP_M() {
        return this.TBP_M;
    }

    public void setTBP_M(double[] TBP_M) {
        this.TBP_M = TBP_M;
    }

    @Override
    public int[] getCarbonNumberVector() {
        return this.carbonNumberVector;
    }

    @Override
    public void setCarbonNumberVector(int[] carbonNumberVector) {
        this.carbonNumberVector = carbonNumberVector;
    }

    public double[] getCalcTBPfractions() {
        return this.calcTBPfractions;
    }

    public void setCalcTBPfractions(double[] calcTBPfractions) {
        this.calcTBPfractions = calcTBPfractions;
    }

    @Override
    public double[] getPlusCoefs() {
        return this.plusCoefs;
    }

    @Override
    public double getPlusCoefs(int i) {
        return this.plusCoefs[i];
    }

    @Override
    public void setPlusCoefs(double[] plusCoefs) {
        this.plusCoefs = plusCoefs;
    }

    @Override
    public double getDensPlus() {
        return this.densPlus;
    }

    @Override
    public void setDensPlus(double densPlus) {
        this.densPlus = densPlus;
    }

    @Override
    public boolean isPseudocomponents() {
        return false;
    }

    public void addPlusFraction() {
    }

    @Override
    public void addHeavyEnd() {
        int old = this.getFirstPlusFractionNumber();
        this.setFirstPlusFractionNumber(this.length + 7);
        this.generateTBPFractions();
        this.setFirstPlusFractionNumber(old);
    }
}

