/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.thermo.characterization.TBPCharacterize;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewtonSolveAB
implements Serializable {
    private static final long serialVersionUID = 1000L;
    int iter = 0;
    Matrix Jac;
    Matrix fvec;
    Matrix sol;
    Matrix dx;
    int numberOfComponents = 0;
    TBPCharacterize characterizeClass;
    static Logger logger = LogManager.getLogger(NewtonSolveAB.class);
    SystemInterface system = null;

    public NewtonSolveAB() {
    }

    public NewtonSolveAB(SystemInterface system, TBPCharacterize characterizeClass) {
        this.system = system;
        this.characterizeClass = characterizeClass;
        this.numberOfComponents = system.getPhase(0).getNumberOfComponents();
        this.Jac = new Matrix(2, 2);
        this.fvec = new Matrix(2, 1);
        this.sol = new Matrix(2, 1);
        this.sol.set(0, 0, characterizeClass.getPlusCoefs(0));
        this.sol.set(1, 0, characterizeClass.getPlusCoefs(1));
    }

    public void setfvec() {
        double f0 = -this.characterizeClass.getZPlus();
        int i = this.characterizeClass.getFirstPlusFractionNumber();
        while (i < this.characterizeClass.getLastPlusFractionNumber()) {
            f0 += Math.exp(this.characterizeClass.getPlusCoefs(0) + this.characterizeClass.getPlusCoefs(1) * (double)i);
            ++i;
        }
        this.fvec.set(0, 0, f0);
        f0 = -this.characterizeClass.getMPlus() * this.characterizeClass.getZPlus();
        i = this.characterizeClass.getFirstPlusFractionNumber();
        while (i < this.characterizeClass.getLastPlusFractionNumber()) {
            f0 += Math.exp(this.characterizeClass.getPlusCoefs(0) + this.characterizeClass.getPlusCoefs(1) * (double)i) * (14.0 * (double)i - 4.0);
            ++i;
        }
        this.fvec.set(1, 0, f0);
    }

    public void setJac() {
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double f0 = 0.0;
        int i = this.characterizeClass.getFirstPlusFractionNumber();
        while (i < this.characterizeClass.getLastPlusFractionNumber()) {
            f0 += Math.exp(this.characterizeClass.getPlusCoefs(0) + this.characterizeClass.getPlusCoefs(1) * (double)i);
            ++i;
        }
        this.Jac.set(0, 0, f0 + 0.0);
        f0 = 0.0;
        i = this.characterizeClass.getFirstPlusFractionNumber();
        while (i < this.characterizeClass.getLastPlusFractionNumber()) {
            f0 += this.characterizeClass.getPlusCoefs(1) * Math.exp(this.characterizeClass.getPlusCoefs(0) + this.characterizeClass.getPlusCoefs(1) * (double)i);
            ++i;
        }
        this.Jac.set(1, 0, f0);
        f0 = 0.0;
        i = this.characterizeClass.getFirstPlusFractionNumber();
        while (i < this.characterizeClass.getLastPlusFractionNumber()) {
            f0 += (14.0 * (double)i - 4.0) * Math.exp(this.characterizeClass.getPlusCoefs(0) + this.characterizeClass.getPlusCoefs(1) * (double)i);
            ++i;
        }
        this.Jac.set(0, 1, f0);
        f0 = 0.0;
        i = this.characterizeClass.getFirstPlusFractionNumber();
        while (i < this.characterizeClass.getLastPlusFractionNumber()) {
            f0 += (14.0 * (double)i - 4.0) * this.characterizeClass.getPlusCoefs(1) * Math.exp(this.characterizeClass.getPlusCoefs(0) + this.characterizeClass.getPlusCoefs(1) * (double)i);
            ++i;
        }
        this.Jac.set(1, 1, f0 + 0.0);
    }

    public void solve() {
        do {
            ++this.iter;
            this.setfvec();
            this.fvec.print(10, 2);
            this.setJac();
            this.Jac.print(10, 2);
            this.dx = this.Jac.solve(this.fvec);
            logger.info("dx: ");
            this.dx.print(10, 3);
            this.sol.minusEquals(this.dx.times((double)this.iter / ((double)this.iter + 100.0)));
            this.characterizeClass.setPlusCoefs(this.sol.transpose().copy().getArray()[0]);
        } while ((this.dx.norm2() / this.sol.norm2() < 1.0E-6 || this.iter < 15000) && this.iter < 50000);
        logger.info("ok char: ");
        this.sol.print(10, 10);
    }
}

