/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo;

import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThermodynamicModelTest
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    SystemInterface system;
    static Logger logger = LogManager.getLogger(ThermodynamicModelTest.class);

    public ThermodynamicModelTest() {
    }

    public ThermodynamicModelTest(SystemInterface system) {
        this.system = system;
    }

    public void runTest() {
        this.system.init(3);
        logger.info("testing fugacitycoefs..." + this.checkFugacityCoefficients());
        logger.info("testing fugacity der composition..." + this.checkFugacityCoefficientsDn());
        logger.info("testing fugacity der composition2..." + this.checkFugacityCoefficientsDn2());
        logger.info("testing fugacity der pressure..." + this.checkFugacityCoefficientsDP());
        logger.info("testing fugacity der temperature..." + this.checkFugacityCoefficientsDT());
        logger.info("comparing to numerical derivatives..." + this.checkNumerically());
    }

    public boolean checkFugacityCoefficients() {
        double temp1 = 0.0;
        double temp2 = 0.0;
        int i = 0;
        while (i < this.system.getPhases()[0].getNumberOfComponents()) {
            temp1 += this.system.getPhases()[0].getComponents()[i].getNumberOfMolesInPhase() * Math.log(this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient());
            temp2 += this.system.getPhases()[1].getComponents()[i].getNumberOfMolesInPhase() * Math.log(this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient());
            ++i;
        }
        logger.info("Testing fugacity coefficients...................");
        logger.info("Total fug gas : " + temp1);
        logger.info("Total fug liq : " + temp2);
        double sum = Math.abs(temp1 -= this.system.getPhases()[0].getGresTP() / (8.3144621 * this.system.getTemperature())) + Math.abs(temp2 -= this.system.getPhases()[1].getGresTP() / (8.3144621 * this.system.getTemperature()));
        logger.info("Diffference fug gas : " + temp1);
        logger.info("Difference fug liq : " + temp2);
        return Math.abs(sum) < 1.0E-10;
    }

    public boolean checkFugacityCoefficientsDn() {
        double temp1 = 0.0;
        double temp2 = 0.0;
        double sum = 0.0;
        int j = 0;
        while (j < this.system.getPhases()[0].getNumberOfComponents()) {
            temp1 = 0.0;
            temp2 = 0.0;
            int i = 0;
            while (i < this.system.getPhases()[0].getNumberOfComponents()) {
                temp1 += this.system.getPhases()[0].getComponents()[i].getNumberOfMolesInPhase() * this.system.getPhases()[0].getComponents()[i].getdfugdn(j);
                temp2 += this.system.getPhases()[1].getComponents()[i].getNumberOfMolesInPhase() * this.system.getPhases()[1].getComponents()[i].getdfugdn(j);
                ++i;
            }
            sum += Math.abs(temp1) + Math.abs(temp2);
            ++j;
        }
        logger.info("Testing composition derivatives of fugacity coefficients...................");
        logger.info("Diffference : " + sum);
        return Math.abs(sum) < 1.0E-10;
    }

    public boolean checkFugacityCoefficientsDn2() {
        double temp1 = 0.0;
        double temp2 = 0.0;
        double sum = 0.0;
        int j = 0;
        while (j < this.system.getPhases()[0].getNumberOfComponents()) {
            temp1 = 0.0;
            temp2 = 0.0;
            int i = 0;
            while (i < this.system.getPhases()[0].getNumberOfComponents()) {
                temp1 += this.system.getPhases()[0].getComponents()[i].getdfugdn(j) - this.system.getPhases()[0].getComponents()[j].getdfugdn(i);
                temp2 += this.system.getPhases()[1].getComponents()[i].getdfugdn(j) - this.system.getPhases()[1].getComponents()[j].getdfugdn(i);
                ++i;
            }
            sum += Math.abs(temp1) + Math.abs(temp2);
            ++j;
        }
        logger.info("Testing composition derivatives2 of fugacity coefficients...................");
        logger.info("Diffference : " + sum);
        return Math.abs(sum) < 1.0E-10;
    }

    public boolean checkFugacityCoefficientsDP() {
        double temp1 = 0.0;
        double temp2 = 0.0;
        double sum = 0.0;
        int i = 0;
        while (i < this.system.getPhases()[0].getNumberOfComponents()) {
            temp1 += this.system.getPhases()[0].getComponents()[i].getNumberOfMolesInPhase() * this.system.getPhases()[0].getComponents()[i].getdfugdp();
            temp2 += this.system.getPhases()[1].getComponents()[i].getNumberOfMolesInPhase() * this.system.getPhases()[1].getComponents()[i].getdfugdp();
            ++i;
        }
        sum = Math.abs(temp1 -= (this.system.getPhases()[0].getZ() - 1.0) * this.system.getPhases()[0].getNumberOfMolesInPhase() / this.system.getPhases()[0].getPressure()) + Math.abs(temp2 -= (this.system.getPhases()[1].getZ() - 1.0) * this.system.getPhases()[1].getNumberOfMolesInPhase() / this.system.getPhases()[1].getPressure());
        logger.info("Testing pressure derivatives of fugacity coefficients...................");
        logger.info("Error : " + sum);
        return Math.abs(sum) < 1.0E-10;
    }

    public boolean checkFugacityCoefficientsDT() {
        double temp1 = 0.0;
        double temp2 = 0.0;
        double sum = 0.0;
        int i = 0;
        while (i < this.system.getPhases()[0].getNumberOfComponents()) {
            temp1 += this.system.getPhases()[0].getComponents()[i].getNumberOfMolesInPhase() * this.system.getPhases()[0].getComponents()[i].getdfugdt();
            temp2 += this.system.getPhases()[1].getComponents()[i].getNumberOfMolesInPhase() * this.system.getPhases()[1].getComponents()[i].getdfugdt();
            ++i;
        }
        sum = Math.abs(temp1 += this.system.getPhases()[0].getHresTP() / (8.3144621 * Math.pow(this.system.getTemperature(), 2.0))) + Math.abs(temp2 += this.system.getPhases()[1].getHresTP() / (8.3144621 * Math.pow(this.system.getTemperature(), 2.0)));
        logger.info("Testing temperature derivatives of fugacity coefficients...................");
        logger.info("Error : " + sum);
        return Math.abs(sum) < 1.0E-10;
    }

    public boolean checkNumerically() {
        double[][] gasfug = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][] liqfug = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][] gasnumericDfugdt = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][] liqnumericDfugdt = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][] gasnumericDfugdp = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][] liqnumericDfugdp = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[][][] gasnumericDfugdn = new double[2][this.system.getPhases()[0].getNumberOfComponents()][this.system.getPhases()[0].getNumberOfComponents()];
        double[][][] liqnumericDfugdn = new double[2][this.system.getPhases()[0].getNumberOfComponents()][this.system.getPhases()[0].getNumberOfComponents()];
        this.system.init(3);
        int i = 0;
        while (i < this.system.getPhases()[0].getNumberOfComponents()) {
            gasnumericDfugdt[0][i] = this.system.getPhases()[0].getComponents()[i].getdfugdt();
            gasnumericDfugdp[0][i] = this.system.getPhases()[0].getComponents()[i].getdfugdp();
            liqnumericDfugdt[0][i] = this.system.getPhases()[1].getComponents()[i].getdfugdt();
            liqnumericDfugdp[0][i] = this.system.getPhases()[1].getComponents()[i].getdfugdp();
            int k = 0;
            while (k < this.system.getPhases()[0].getNumberOfComponents()) {
                gasnumericDfugdn[0][i][k] = this.system.getPhases()[0].getComponents()[i].getdfugdn(k);
                liqnumericDfugdn[0][i][k] = this.system.getPhases()[1].getComponents()[i].getdfugdn(k);
                ++k;
            }
            ++i;
        }
        double dt = this.system.getTemperature() / 100000.0;
        this.system.setTemperature(this.system.getTemperature() + dt);
        this.system.init(3);
        int i2 = 0;
        while (i2 < this.system.getPhases()[0].getNumberOfComponents()) {
            gasfug[0][i2] = Math.log(this.system.getPhases()[0].getComponents()[i2].getFugacityCoefficient());
            liqfug[0][i2] = Math.log(this.system.getPhases()[1].getComponents()[i2].getFugacityCoefficient());
            ++i2;
        }
        this.system.setTemperature(this.system.getTemperature() - 2.0 * dt);
        this.system.init(3);
        i2 = 0;
        while (i2 < this.system.getPhases()[0].getNumberOfComponents()) {
            gasfug[1][i2] = Math.log(this.system.getPhases()[0].getComponents()[i2].getFugacityCoefficient());
            liqfug[1][i2] = Math.log(this.system.getPhases()[1].getComponents()[i2].getFugacityCoefficient());
            ++i2;
        }
        i2 = 0;
        while (i2 < this.system.getPhases()[0].getNumberOfComponents()) {
            logger.info("dt: gas phase comp " + i2 + "  % error " + ((gasfug[0][i2] - gasfug[1][i2]) / (2.0 * dt) - gasnumericDfugdt[0][i2]) / gasnumericDfugdt[0][i2] * 100.0);
            logger.info("dt: liq phase comp " + i2 + "  % error " + ((liqfug[0][i2] - liqfug[1][i2]) / (2.0 * dt) - liqnumericDfugdt[0][i2]) / liqnumericDfugdt[0][i2] * 100.0);
            ++i2;
        }
        this.system.setTemperature(this.system.getTemperature() + dt);
        this.system.init(3);
        double dp = this.system.getPressure() / 100000.0;
        this.system.setPressure(this.system.getPressure() + dp);
        this.system.init(3);
        int i3 = 0;
        while (i3 < this.system.getPhases()[0].getNumberOfComponents()) {
            gasfug[0][i3] = Math.log(this.system.getPhases()[0].getComponents()[i3].getFugacityCoefficient());
            liqfug[0][i3] = Math.log(this.system.getPhases()[1].getComponents()[i3].getFugacityCoefficient());
            ++i3;
        }
        this.system.setPressure(this.system.getPressure() - 2.0 * dp);
        this.system.init(3);
        i3 = 0;
        while (i3 < this.system.getPhases()[0].getNumberOfComponents()) {
            gasfug[1][i3] = Math.log(this.system.getPhases()[0].getComponents()[i3].getFugacityCoefficient());
            liqfug[1][i3] = Math.log(this.system.getPhases()[1].getComponents()[i3].getFugacityCoefficient());
            ++i3;
        }
        i3 = 0;
        while (i3 < this.system.getPhases()[0].getNumberOfComponents()) {
            logger.info("dp: gas phase comp " + i3 + "  % error " + ((gasfug[0][i3] - gasfug[1][i3]) / (2.0 * dp) - gasnumericDfugdp[0][i3]) / gasnumericDfugdp[0][i3] * 100.0);
            logger.info("dp: liq phase comp " + i3 + "  % error " + ((liqfug[0][i3] - liqfug[1][i3]) / (2.0 * dp) - liqnumericDfugdp[0][i3]) / liqnumericDfugdp[0][i3] * 100.0);
            ++i3;
        }
        this.system.setPressure(this.system.getPressure() + dp);
        this.system.init(3);
        int phase = 0;
        while (phase < 2) {
            int k = 0;
            while (k < this.system.getPhases()[0].getNumberOfComponents()) {
                double dn = this.system.getPhases()[phase].getComponents()[k].getNumberOfMolesInPhase() / 100000.0;
                logger.info("component name " + this.system.getPhases()[phase].getComponents()[k].getComponentName());
                logger.info("dn " + dn);
                if (dn < 1.0E-12) {
                    dn = 1.0E-12;
                }
                this.system.addComponent(k, dn, phase);
                this.system.init_x_y();
                this.system.init(3);
                int i4 = 0;
                while (i4 < this.system.getPhases()[0].getNumberOfComponents()) {
                    liqfug[0][i4] = Math.log(this.system.getPhases()[phase].getComponents()[i4].getFugacityCoefficient());
                    ++i4;
                }
                this.system.addComponent(k, -2.0 * dn, phase);
                this.system.init_x_y();
                this.system.init(3);
                i4 = 0;
                while (i4 < this.system.getPhases()[0].getNumberOfComponents()) {
                    liqfug[1][i4] = Math.log(this.system.getPhases()[phase].getComponents()[i4].getFugacityCoefficient());
                    ++i4;
                }
                i4 = 0;
                while (i4 < this.system.getPhases()[0].getNumberOfComponents()) {
                    if (phase == 0) {
                        logger.info("dn: gas phase comp " + i4 + "  % error " + ((liqfug[0][i4] - liqfug[1][i4]) / (2.0 * dn) - gasnumericDfugdn[0][i4][k]) / gasnumericDfugdn[0][i4][k] * 100.0);
                    }
                    if (phase == 1) {
                        logger.info("dn: liq phase comp " + i4 + "  % error " + ((liqfug[0][i4] - liqfug[1][i4]) / (2.0 * dn) - liqnumericDfugdn[0][i4][k]) / liqnumericDfugdn[0][i4][k] * 100.0);
                    }
                    ++i4;
                }
                this.system.addComponent(k, dn, phase);
                this.system.init_x_y();
                this.system.init(3);
                ++k;
            }
            ++phase;
        }
        return true;
    }
}

