/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.standards.StandardInterface;
import neqsim.standards.salesContract.BaseContract;
import neqsim.standards.salesContract.ContractInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public abstract class Standard
implements StandardInterface {
    protected String name = "Base Standard";
    protected String standardDescription = "Base Description";
    protected ContractInterface salesContract = new BaseContract();
    protected String[][] resultTable = null;
    protected SystemInterface thermoSystem;
    protected ThermodynamicOperations thermoOps;
    private String referenceState = "real";

    public Standard() {
    }

    public Standard(SystemInterface thermoSyst) {
        this.thermoSystem = thermoSyst;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    @Override
    public void setThermoSystem(SystemInterface thermoSystem) {
        this.thermoSystem = thermoSystem;
    }

    @Override
    public void setSalesContract(String name) {
        if (name.equals("baseContract")) {
            this.salesContract = new BaseContract();
        }
    }

    @Override
    public void setSalesContract(ContractInterface salesContract) {
        this.salesContract = salesContract;
    }

    @Override
    public ContractInterface getSalesContract() {
        return this.salesContract;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getStandardDescription() {
        return this.standardDescription;
    }

    public void setStandardDescription(String standardDescription) {
        this.standardDescription = standardDescription;
    }

    @Override
    public String[][] createTable(String name) {
        this.thermoSystem.setNumberOfPhases(1);
        this.thermoSystem.createTable(name);
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        String[][] table = new String[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 30][6];
        table[0][0] = "";
        int i = 0;
        while (i < this.thermoSystem.getPhases()[0].getNumberOfComponents() + 30) {
            int j = 0;
            while (j < 6) {
                table[i][j] = "";
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.thermoSystem.getNumberOfPhases()) {
            table[0][i + 1] = this.thermoSystem.getPhase(i).getPhaseTypeName();
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        FieldPosition test2 = new FieldPosition(0);
        int i2 = 0;
        while (i2 < this.thermoSystem.getNumberOfPhases()) {
            int j = 0;
            while (j < this.thermoSystem.getPhases()[0].getNumberOfComponents()) {
                table[j + 1][0] = this.thermoSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i2 + 1] = nf.format(this.thermoSystem.getPhase(this.thermoSystem.getPhaseIndex(i2)).getComponents()[j].getx(), buf, test2).toString();
                table[j + 1][4] = "[-]";
                ++j;
            }
            ++i2;
        }
        this.resultTable = table;
        return table;
    }

    @Override
    public void display(String name) {
        JDialog dialog = new JDialog((Frame)new JFrame(), "Standard-Report");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[]{"", "Phase 1", "Phase 2", "Phase 3", "Unit"};
        Object[][] table = this.createTable(name);
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public String[][] getResultTable() {
        return this.resultTable;
    }

    @Override
    public void setResultTable(String[][] resultTable) {
        this.resultTable = resultTable;
    }

    public String getReferenceState() {
        return this.referenceState;
    }

    public void setReferenceState(String referenceState) {
        this.referenceState = referenceState;
    }
}

